/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.mockfile.FilterPath;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.BackupStatusChecker;
import org.junit.Test;

@LuceneTestCase.SuppressCodecs(value={"SimpleText"})
public abstract class AbstractBasicDistributedZk2TestBase
extends AbstractFullDistribZkTestBase {
    private static final String SHARD2 = "shard2";
    private static final String SHARD1 = "shard1";
    private static final String ONE_NODE_COLLECTION = "onenodecollection";
    private final boolean onlyLeaderIndexes = AbstractBasicDistributedZk2TestBase.random().nextBoolean();

    public AbstractBasicDistributedZk2TestBase() {
        if (Boolean.getBoolean("solr.tests.numeric.points")) {
            System.setProperty("solr.tests.numeric.dv", "true");
        }
        this.sliceCount = 2;
    }

    @Override
    protected boolean useTlogReplicas() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @BaseDistributedSearchTestCase.ShardsFixed(num=4)
    public void test() throws Exception {
        boolean testFinished = false;
        try {
            this.handle.clear();
            this.handle.put("timestamp", 4);
            this.testNodeWithoutCollectionForwarding();
            this.indexr(this.id, 1, this.i1, 100, this.tlong, 100, this.t1, "now is the time for all good men", "foo_f", Float.valueOf(1.414f), "foo_b", "true", "foo_d", 1.414);
            this.commit();
            this.waitForRecoveriesToFinish(false);
            this.assertDocCounts(false);
            this.indexAbunchOfDocs();
            this.waitForRecoveriesToFinish(false);
            this.commit();
            this.assertDocCounts(VERBOSE);
            this.checkQueries();
            this.assertDocCounts(VERBOSE);
            this.query("q", "*:*", "sort", "n_tl1 desc");
            this.bringDownShardIndexSomeDocsAndRecover();
            this.query("q", "*:*", "sort", "n_tl1 desc");
            this.addNewReplica();
            long docId = this.testUpdateAndDelete();
            AbstractBasicDistributedZk2TestBase.expectThrows(SolrException.class, () -> this.indexr(this.t1, "a doc with no id"));
            ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)this.cloudClient);
            Replica leaderProps = zkStateReader.getLeaderRetry("collection1", SHARD2);
            String nodeName = leaderProps.getStr("node_name");
            this.chaosMonkey.stopShardExcept(SHARD2, nodeName);
            SolrClient client = this.getClient(nodeName);
            this.index_specific(client, "id", docId + 1L, this.t1, "what happens here?");
            AbstractFullDistribZkTestBase.CloudJettyRunner cloudJetty = (AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get(SHARD1)).get(0);
            this.chaosMonkey.expireSession(cloudJetty.jetty);
            this.indexr("id", docId + 1L, this.t1, "slip this doc in");
            this.waitForRecoveriesToFinish(false);
            this.checkShardConsistency(SHARD1);
            this.checkShardConsistency(SHARD2);
            testFinished = true;
        }
        finally {
            if (!testFinished) {
                this.printLayoutOnTearDown = true;
            }
        }
    }

    private void testNodeWithoutCollectionForwarding() throws Exception {
        AbstractBasicDistributedZk2TestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)ONE_NODE_COLLECTION, (String)"conf1", (int)1, (int)1).setCreateNodeSet("").process((SolrClient)this.cloudClient)).getStatus());
        AbstractBasicDistributedZk2TestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)ONE_NODE_COLLECTION, (String)SHARD1).setCoreName("onenodecollectioncore").process((SolrClient)this.cloudClient)).isSuccess());
        AbstractBasicDistributedZk2TestBase.waitForCollection(ZkStateReader.from((CloudSolrClient)this.cloudClient), ONE_NODE_COLLECTION, 1);
        this.waitForRecoveriesToFinish(ONE_NODE_COLLECTION, ZkStateReader.from((CloudSolrClient)this.cloudClient), false);
        ZkStateReader.from((CloudSolrClient)this.cloudClient).getLeaderRetry(ONE_NODE_COLLECTION, SHARD1, 30000);
        int docs = 2;
        for (SolrClient client : this.clients) {
            String clientUrl = this.getBaseUrl((HttpSolrClient)client);
            this.addAndQueryDocs(clientUrl, docs);
            docs += 2;
        }
    }

    private void addAndQueryDocs(String baseUrl, int docs) throws Exception {
        SolrQuery query = new SolrQuery("*:*");
        try (HttpSolrClient qclient = AbstractBasicDistributedZk2TestBase.getHttpSolrClient(baseUrl + "/onenodecollectioncore");){
            AbstractBasicDistributedZk2TestBase.waitForNon403or404or503(qclient);
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("id", (Object)docs);
            qclient.add(doc);
            qclient.commit();
            QueryResponse results = qclient.query((SolrParams)query);
            AbstractBasicDistributedZk2TestBase.assertEquals((long)(docs - 1), (long)results.getResults().getNumFound());
        }
        qclient = AbstractBasicDistributedZk2TestBase.getHttpSolrClient(baseUrl + "/onenodecollection");
        try {
            QueryResponse results = qclient.query((SolrParams)query);
            AbstractBasicDistributedZk2TestBase.assertEquals((long)(docs - 1), (long)results.getResults().getNumFound());
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("id", (Object)(docs + 1));
            qclient.add(doc);
            qclient.commit();
            query = new SolrQuery("*:*");
            query.set("rows", 0);
            results = qclient.query((SolrParams)query);
            AbstractBasicDistributedZk2TestBase.assertEquals((long)docs, (long)results.getResults().getNumFound());
        }
        finally {
            if (qclient != null) {
                qclient.close();
            }
        }
    }

    private long testUpdateAndDelete() throws Exception {
        long docId = 99999999L;
        this.indexr("id", docId, this.t1, "originalcontent");
        this.commit();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("q", new String[]{this.t1 + ":originalcontent"});
        QueryResponse results = ((SolrClient)this.clients.get(0)).query((SolrParams)params);
        AbstractBasicDistributedZk2TestBase.assertEquals((long)1L, (long)results.getResults().getNumFound());
        this.indexr("id", docId, this.t1, "updatedcontent");
        this.commit();
        results = ((SolrClient)this.clients.get(0)).query((SolrParams)params);
        AbstractBasicDistributedZk2TestBase.assertEquals((long)0L, (long)results.getResults().getNumFound());
        params.set("q", new String[]{this.t1 + ":updatedcontent"});
        results = ((SolrClient)this.clients.get(0)).query((SolrParams)params);
        AbstractBasicDistributedZk2TestBase.assertEquals((long)1L, (long)results.getResults().getNumFound());
        UpdateRequest uReq = new UpdateRequest();
        uReq.deleteById(Long.toString(docId)).process((SolrClient)this.clients.get(0));
        this.commit();
        results = ((SolrClient)this.clients.get(0)).query((SolrParams)params);
        AbstractBasicDistributedZk2TestBase.assertEquals((long)0L, (long)results.getResults().getNumFound());
        return docId;
    }

    private void bringDownShardIndexSomeDocsAndRecover() throws Exception {
        SolrQuery query = new SolrQuery("*:*");
        query.set("distrib", false);
        this.commit();
        long deadShardCount = ((AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get((Object)SHARD2)).get((int)0)).client.solrClient.query((SolrParams)query).getResults().getNumFound();
        this.query("q", "*:*", "sort", "n_tl1 desc");
        int oldLiveNodes = ZkStateReader.from((CloudSolrClient)this.cloudClient).getZkClient().getChildren("/live_nodes", null, true).size();
        AbstractBasicDistributedZk2TestBase.assertEquals((long)5L, (long)oldLiveNodes);
        AbstractFullDistribZkTestBase.CloudJettyRunner deadShard = this.chaosMonkey.stopShard(SHARD1, 0);
        AbstractBasicDistributedZk2TestBase.expectThrows(SolrServerException.class, (String)"This server should be down and this update should have failed", () -> this.index_specific(deadShard.client.solrClient, this.id, 999, this.i1, 107, this.t1, "specific doc!"));
        this.commit();
        this.query("q", "*:*", "sort", "n_tl1 desc");
        long numFound1 = this.cloudClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        ZkStateReader.from((CloudSolrClient)this.cloudClient).getLeaderRetry("collection1", SHARD1, 60000);
        try {
            this.index_specific(((AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get((Object)SHARD1)).get((int)1)).client.solrClient, this.id, 1000, this.i1, 108, this.t1, "specific doc!");
        }
        catch (Exception e) {
            Thread.sleep(4000L);
            this.index_specific(((AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get((Object)SHARD1)).get((int)1)).client.solrClient, this.id, 1000, this.i1, 108, this.t1, "specific doc!");
        }
        this.commit();
        this.checkShardConsistency(true, false);
        this.query("q", "*:*", "sort", "n_tl1 desc");
        this.cloudClient.setDefaultCollection("collection1");
        long numFound2 = this.cloudClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        AbstractBasicDistributedZk2TestBase.assertEquals((long)(numFound1 + 1L), (long)numFound2);
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("id", (Object)1001);
        this.controlClient.add(doc);
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        try {
            ureq.process((SolrClient)this.cloudClient);
        }
        catch (SolrServerException e) {
            Thread.sleep(3500L);
            ureq.process((SolrClient)this.cloudClient);
        }
        this.commit();
        this.query("q", "*:*", "sort", "n_tl1 desc");
        long numFound3 = this.cloudClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        AbstractBasicDistributedZk2TestBase.assertEquals((long)(numFound2 + 1L), (long)numFound3);
        this.testDebugQueries();
        if (VERBOSE) {
            System.err.println(this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
            for (SolrClient client : this.clients) {
                try {
                    SolrQuery q = new SolrQuery("*:*");
                    q.set("distrib", false);
                    System.err.println(client.query((SolrParams)q).getResults().getNumFound());
                }
                catch (Exception q) {}
            }
        }
        deadShard.jetty.start();
        Thread.sleep(1500L);
        this.waitForRecoveriesToFinish(false);
        deadShardCount = ((AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get((Object)SHARD1)).get((int)0)).client.solrClient.query((SolrParams)query).getResults().getNumFound();
        this.checkShardConsistency(true, false);
        this.chaosMonkey.stopJetty(deadShard);
        for (int i = 0; i < 226; ++i) {
            doc = new SolrInputDocument();
            doc.addField("id", (Object)(2000 + i));
            this.controlClient.add(doc);
            ureq = new UpdateRequest();
            ureq.add(doc);
            ureq.process((SolrClient)this.cloudClient);
        }
        this.commit();
        Thread.sleep(1500L);
        deadShard.jetty.start();
        Thread.sleep(1500L);
        this.waitForThingsToLevelOut(1, TimeUnit.MINUTES);
        Thread.sleep(500L);
        this.waitForRecoveriesToFinish(false);
        this.checkShardConsistency(true, false);
        try (HttpSolrClient client = AbstractBasicDistributedZk2TestBase.getHttpSolrClient((String)((AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get((Object)SHARD2)).get((int)0)).info.get("base_url"));){
            String backupName = "the_backup";
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/replication"});
            params.set("command", new String[]{"backup"});
            params.set("name", new String[]{"the_backup"});
            Path location = FilterPath.unwrap((Path)AbstractBasicDistributedZk2TestBase.createTempDir()).toRealPath(new LinkOption[0]);
            this.jettys.forEach(j -> j.getCoreContainer().getAllowPaths().add(location));
            params.set("location", new String[]{location.toString()});
            QueryRequest request = new QueryRequest((SolrParams)params);
            client.request((SolrRequest)request, "collection1");
            BackupStatusChecker backupStatus = new BackupStatusChecker((SolrClient)client, "/collection1/replication");
            String backupDirName = backupStatus.waitForBackupSuccess("the_backup", 30);
            AbstractBasicDistributedZk2TestBase.assertTrue((String)("Backup dir does not exist: " + backupDirName), (boolean)Files.exists(location.resolve(backupDirName), new LinkOption[0]));
        }
    }

    private void addNewReplica() throws Exception {
        this.waitForRecoveriesToFinish(false);
        for (AbstractFullDistribZkTestBase.CloudJettyRunner cjetty : (List)this.shardToJetty.get(SHARD1)) {
            if (!VERBOSE) continue;
            System.err.println("shard1 total:" + cjetty.client.solrClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
        }
        for (AbstractFullDistribZkTestBase.CloudJettyRunner cjetty : (List)this.shardToJetty.get(SHARD2)) {
            if (!VERBOSE) continue;
            System.err.println("shard2 total:" + cjetty.client.solrClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
        }
        this.checkShardConsistency(SHARD1);
        this.checkShardConsistency(SHARD2);
        this.assertDocCounts(VERBOSE);
    }

    private void testDebugQueries() throws Exception {
        this.handle.put("explain", 4);
        this.handle.put("debug", 8);
        this.handle.put("time", 4);
        this.handle.put("track", 2);
        this.query("q", "now their fox sat had put", "fl", "*,score", "debugQuery", "true");
        this.query("q", "id_i1:[1 TO 5]", "debugQuery", "true");
        this.query("q", "id_i1:[1 TO 5]", "debug", "timing");
        this.query("q", "id_i1:[1 TO 5]", "debug", "results");
        this.query("q", "id_i1:[1 TO 5]", "debug", "query");
    }
}

