/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.FullThrottleStoppableIndexingThread;
import org.apache.solr.cloud.StoppableIndexingThread;
import org.apache.solr.cloud.StoppableSearchThread;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractChaosMonkeyNothingIsSafeTestBase
extends AbstractFullDistribZkTestBase {
    private static final int FAIL_TOLERANCE = 100;
    private static final Integer RUN_LENGTH = Integer.parseInt(System.getProperty("solr.tests.cloud.cm.runlength", "-1"));
    private final boolean onlyLeaderIndexes = AbstractChaosMonkeyNothingIsSafeTestBase.random().nextBoolean();
    protected static final String[] fieldNames = new String[]{"f_i", "f_f", "f_d", "f_l", "f_dt"};
    protected static final BaseDistributedSearchTestCase.RandVal[] randVals = new BaseDistributedSearchTestCase.RandVal[]{rint, rfloat, rdouble, rlong, rdate};
    private int clientSoTimeout = 60000;
    private volatile FullThrottleStoppableIndexingThread ftIndexThread;
    private final boolean runFullThrottle;

    @BeforeClass
    public static void beforeSuperClass() {
        schemaString = "schema15.xml";
        System.setProperty("solr.autoCommit.maxTime", "15000");
        System.clearProperty("solr.httpclient.retries");
        System.clearProperty("solr.retries.on.forward");
        System.clearProperty("solr.retries.to.followers");
        AbstractChaosMonkeyNothingIsSafeTestBase.setErrorHook();
    }

    @AfterClass
    public static void afterSuperClass() {
        System.clearProperty("solr.autoCommit.maxTime");
        AbstractChaosMonkeyNothingIsSafeTestBase.clearErrorHook();
    }

    @Override
    protected void destroyServers() throws Exception {
        super.destroyServers();
    }

    @Override
    public String[] getFieldNames() {
        return fieldNames;
    }

    @Override
    public BaseDistributedSearchTestCase.RandVal[] getRandValues() {
        return randVals;
    }

    @Override
    public void distribSetUp() throws Exception {
        super.distribSetUp();
        AbstractChaosMonkeyNothingIsSafeTestBase.useFactory("solr.StandardDirectoryFactory");
    }

    @Override
    public void distribTearDown() throws Exception {
        try {
            this.ftIndexThread.safeStop();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        super.distribTearDown();
    }

    public AbstractChaosMonkeyNothingIsSafeTestBase() {
        int numShards;
        this.sliceCount = Integer.parseInt(System.getProperty("solr.tests.cloud.cm.slicecount", "-1"));
        if (this.sliceCount == -1) {
            this.sliceCount = AbstractChaosMonkeyNothingIsSafeTestBase.random().nextInt(TEST_NIGHTLY ? 5 : 3) + 1;
        }
        if ((numShards = Integer.parseInt(System.getProperty("solr.tests.cloud.cm.shardcount", "-1"))) == -1) {
            numShards = this.sliceCount + AbstractChaosMonkeyNothingIsSafeTestBase.random().nextInt(TEST_NIGHTLY ? 12 : 2) + 1;
        }
        this.fixShardCount(numShards);
        this.runFullThrottle = AbstractChaosMonkeyNothingIsSafeTestBase.random().nextBoolean();
    }

    @Override
    protected boolean useTlogReplicas() {
        return false;
    }

    @Override
    protected CloudSolrClient createCloudClient(String defaultCollection) {
        return this.createCloudClient(defaultCollection, this.clientSoTimeout);
    }

    protected CloudSolrClient createCloudClient(String defaultCollection, int socketTimeout) {
        CloudSolrClient client = AbstractChaosMonkeyNothingIsSafeTestBase.getCloudSolrClient(this.zkServer.getZkAddress(), AbstractChaosMonkeyNothingIsSafeTestBase.random().nextBoolean(), 30000, socketTimeout);
        if (defaultCollection != null) {
            client.setDefaultCollection(defaultCollection);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        this.clientSoTimeout = 5000;
        boolean testSuccessful = false;
        try (CloudSolrClient ourCloudClient = this.createCloudClient("collection1");){
            this.handle.clear();
            this.handle.put("timestamp", 4);
            ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)this.cloudClient);
            for (int j = 1; j < this.sliceCount; ++j) {
                zkStateReader.getLeaderRetry("collection1", "shard" + j, 10000);
            }
            this.waitForRecoveriesToFinish(false);
            this.del("*:*");
            ArrayList<AbstractFullDistribZkTestBase.StoppableThread> threads = new ArrayList<AbstractFullDistribZkTestBase.StoppableThread>();
            ArrayList<StoppableIndexingThread> indexTreads = new ArrayList<StoppableIndexingThread>();
            int threadCount = TEST_NIGHTLY ? 3 : 1;
            int i = 0;
            for (i = 0; i < threadCount; ++i) {
                StoppableIndexingThread indexThread = new StoppableIndexingThread(this.controlClient, (SolrClient)this.cloudClient, Integer.toString(i), true);
                threads.add(indexThread);
                indexTreads.add(indexThread);
                indexThread.start();
            }
            threadCount = 1;
            i = 0;
            for (i = 0; i < threadCount; ++i) {
                StoppableSearchThread searchThread = new StoppableSearchThread(this.cloudClient);
                threads.add(searchThread);
                searchThread.start();
            }
            if (this.runFullThrottle) {
                this.ftIndexThread = new FullThrottleStoppableIndexingThread(((CloudLegacySolrClient)this.cloudClient).getHttpClient(), this.controlClient, this.cloudClient, this.clients, "ft1", true, this.clientSoTimeout);
                this.ftIndexThread.start();
            }
            this.chaosMonkey.startTheMonkey(true, 10000);
            try {
                long runLength;
                if (RUN_LENGTH != -1) {
                    runLength = RUN_LENGTH.intValue();
                } else {
                    int[] runTimes = TEST_NIGHTLY ? new int[]{5000, 6000, 10000, 15000, 25000, 30000, 30000, 45000, 90000, 120000} : new int[]{5000, 7000, 15000};
                    runLength = runTimes[AbstractChaosMonkeyNothingIsSafeTestBase.random().nextInt(runTimes.length - 1)];
                }
                Thread.sleep(runLength);
            }
            finally {
                this.chaosMonkey.stopTheMonkey();
            }
            this.restartZk(1000 * (5 + AbstractChaosMonkeyNothingIsSafeTestBase.random().nextInt(4)));
            if (this.runFullThrottle) {
                this.ftIndexThread.safeStop();
            }
            for (AbstractFullDistribZkTestBase.StoppableThread indexThread : threads) {
                indexThread.safeStop();
            }
            for (AbstractFullDistribZkTestBase.StoppableThread indexThread : threads) {
                indexThread.join();
            }
            Thread.sleep(2000L);
            this.waitForThingsToLevelOut();
            for (int j = 1; j < this.sliceCount; ++j) {
                zkStateReader.getLeaderRetry("collection1", "shard" + j, 30000);
            }
            this.commit();
            zkStateReader.updateLiveNodes();
            AbstractChaosMonkeyNothingIsSafeTestBase.assertTrue((zkStateReader.getClusterState().getLiveNodes().size() > 0 ? 1 : 0) != 0);
            for (AbstractFullDistribZkTestBase.StoppableThread indexThread : threads) {
                if (!(indexThread instanceof StoppableIndexingThread) || indexThread instanceof FullThrottleStoppableIndexingThread) continue;
                int failCount = ((StoppableIndexingThread)indexThread).getFailCount();
                AbstractChaosMonkeyNothingIsSafeTestBase.assertFalse((String)("There were too many update fails (" + failCount + " > 100) - we expect it can happen, but shouldn't easily"), (failCount > 100 ? 1 : 0) != 0);
            }
            this.waitForThingsToLevelOut(20, TimeUnit.SECONDS);
            this.commit();
            Set<String> addFails = this.getAddFails(indexTreads);
            Set<String> deleteFails = this.getDeleteFails(indexTreads);
            this.checkShardConsistency(!this.runFullThrottle, true, addFails, deleteFails);
            long ctrlDocs = this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
            long cloudClientDocs = this.cloudClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
            AbstractChaosMonkeyNothingIsSafeTestBase.assertTrue((String)("Found " + ctrlDocs + " control docs"), (cloudClientDocs > 0L ? 1 : 0) != 0);
            if (VERBOSE) {
                System.out.println("control docs:" + this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound() + "\n\n");
            }
            if (AbstractChaosMonkeyNothingIsSafeTestBase.random().nextBoolean()) {
                // empty if block
            }
            try (CloudSolrClient client = this.createCloudClient("collection1", 30000);){
                this.createCollection(null, "testcollection", 1, 1, (SolrClient)client, null, "conf1");
            }
            ArrayList<Integer> numShardsNumReplicas = new ArrayList<Integer>(2);
            numShardsNumReplicas.add(1);
            numShardsNumReplicas.add(1);
            this.checkForCollection("testcollection", numShardsNumReplicas, null);
            testSuccessful = true;
        }
        finally {
            if (!testSuccessful) {
                this.printLayout();
            }
        }
    }

    private Set<String> getAddFails(List<StoppableIndexingThread> threads) {
        HashSet<String> addFails = new HashSet<String>();
        for (StoppableIndexingThread thread : threads) {
            addFails.addAll(thread.getAddFails());
        }
        return addFails;
    }

    private Set<String> getDeleteFails(List<StoppableIndexingThread> threads) {
        HashSet<String> deleteFails = new HashSet<String>();
        for (StoppableIndexingThread thread : threads) {
            deleteFails.addAll(thread.getDeleteFails());
        }
        return deleteFails;
    }

    @Override
    protected void indexr(Object ... fields) throws Exception {
        SolrInputDocument doc = AbstractChaosMonkeyNothingIsSafeTestBase.getDoc(fields);
        this.indexDoc(doc);
    }
}

