/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.StoppableIndexingThread;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ZkStateReader;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractRestartWhileUpdatingTestBase
extends AbstractFullDistribZkTestBase {
    private List<StoppableIndexingThread> threads;
    private volatile boolean stopExpire = false;
    public static String[] fieldNames = new String[]{"f_i", "f_f", "f_d", "f_l", "f_dt"};
    public static BaseDistributedSearchTestCase.RandVal[] randVals = new BaseDistributedSearchTestCase.RandVal[]{rint, rfloat, rdouble, rlong, rdate};

    public AbstractRestartWhileUpdatingTestBase() throws Exception {
        this.sliceCount = 1;
        this.fixShardCount(3);
        schemaString = "schema15.xml";
        AbstractRestartWhileUpdatingTestBase.useFactory("solr.StandardDirectoryFactory");
    }

    @Override
    protected String[] getFieldNames() {
        return fieldNames;
    }

    @Override
    protected BaseDistributedSearchTestCase.RandVal[] getRandValues() {
        return randVals;
    }

    @BeforeClass
    public static void beforeRestartWhileUpdatingTest() {
        System.setProperty("leaderVoteWait", "300000");
        System.setProperty("solr.autoCommit.maxTime", "30000");
        System.setProperty("solr.autoSoftCommit.maxTime", "3000");
    }

    @AfterClass
    public static void afterRestartWhileUpdatingTest() {
        System.clearProperty("leaderVoteWait");
        System.clearProperty("solr.autoCommit.maxTime");
        System.clearProperty("solr.autoSoftCommit.maxTime");
    }

    @Test
    public void test() throws Exception {
        this.handle.clear();
        this.handle.put("timestamp", 4);
        int[] maxDocList = new int[]{5000, 10000};
        int maxDoc = maxDocList[AbstractRestartWhileUpdatingTestBase.random().nextInt(maxDocList.length - 1)];
        int numThreads = AbstractRestartWhileUpdatingTestBase.random().nextInt(4) + 1;
        this.threads = new ArrayList<StoppableIndexingThread>(numThreads);
        Thread expireThread = new Thread("expireThread"){

            @Override
            public void run() {
                while (!AbstractRestartWhileUpdatingTestBase.this.stopExpire) {
                    try {
                        Thread.sleep(LuceneTestCase.random().nextInt(15000));
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        for (int i = 0; i < numThreads; ++i) {
            StoppableIndexingThread indexThread = new StoppableIndexingThread(this.controlClient, (SolrClient)this.cloudClient, Integer.toString(i), true, maxDoc, 1, true);
            this.threads.add(indexThread);
            indexThread.start();
        }
        Thread.sleep(2000L);
        int restartTimes = 1;
        for (int i = 0; i < restartTimes; ++i) {
            Thread.sleep(AbstractRestartWhileUpdatingTestBase.random().nextInt(30000));
            this.stopAndStartAllReplicas();
            Thread.sleep(AbstractRestartWhileUpdatingTestBase.random().nextInt(30000));
        }
        Thread.sleep(2000L);
        for (StoppableIndexingThread thread : this.threads) {
            thread.safeStop();
        }
        this.stopExpire = true;
        expireThread.join();
        Thread.sleep(1000L);
        this.waitForThingsToLevelOut(320, TimeUnit.SECONDS);
        Thread.sleep(2000L);
        this.waitForThingsToLevelOut(30, TimeUnit.SECONDS);
        Thread.sleep(5000L);
        this.waitForRecoveriesToFinish("collection1", ZkStateReader.from((CloudSolrClient)this.cloudClient), false, true);
        for (StoppableIndexingThread thread : this.threads) {
            thread.join();
        }
        this.checkShardConsistency(false, false);
    }

    public void stopAndStartAllReplicas() throws Exception, InterruptedException {
        this.chaosMonkey.stopAll(AbstractRestartWhileUpdatingTestBase.random().nextInt(1));
        if (AbstractRestartWhileUpdatingTestBase.random().nextBoolean()) {
            for (StoppableIndexingThread thread : this.threads) {
                thread.safeStop();
            }
        }
        Thread.sleep(1000L);
        this.chaosMonkey.startAll();
    }

    @Override
    protected void indexDoc(SolrInputDocument doc) throws IOException, SolrServerException {
        this.cloudClient.add(doc);
    }

    @Override
    public void distribTearDown() throws Exception {
        if (this.threads != null) {
            for (StoppableIndexingThread thread : this.threads) {
                thread.safeStop();
                thread.safeStop();
            }
        }
        super.distribTearDown();
    }

    @Override
    protected void indexr(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        AbstractRestartWhileUpdatingTestBase.addFields(doc, fields);
        AbstractRestartWhileUpdatingTestBase.addFields(doc, "rnd_b", true);
        this.indexDoc(doc);
    }
}

