/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.cloud.AbstractBasicDistributedZkTestBase;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrPaths;
import org.apache.solr.util.TestInjection;
import org.apache.solr.util.TimeOut;
import org.junit.Test;

public abstract class AbstractUnloadDistributedZkTestBase
extends AbstractBasicDistributedZkTestBase {
    @Override
    protected String getSolrXml() {
        return "solr.xml";
    }

    @Override
    @Test
    public void test() throws Exception {
        this.jettys.forEach(j -> {
            Set allowPath = j.getCoreContainer().getAllowPaths();
            allowPath.clear();
            allowPath.add(SolrPaths.ALL_PATH);
        });
        this.testCoreUnloadAndLeaders();
        this.testUnloadLotsOfCores();
        this.testUnloadShardAndCollection();
    }

    private void checkCoreNamePresenceAndSliceCount(String collectionName, String coreName, boolean shouldBePresent, int expectedSliceCount) throws Exception {
        TimeOut timeout = new TimeOut(45L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        Boolean isPresent = null;
        while (null == isPresent || shouldBePresent != isPresent) {
            Collection<Object> slices;
            this.getCommonCloudSolrClient();
            DocCollection docCollection = this.cloudClient.getClusterState().getCollectionOrNull(collectionName);
            Collection<Object> collection = slices = docCollection != null ? docCollection.getSlices() : Collections.emptyList();
            if (timeout.hasTimedOut()) {
                this.printLayout();
                AbstractUnloadDistributedZkTestBase.fail((String)("checkCoreNamePresenceAndSliceCount failed: collection=" + collectionName + " CoreName=" + coreName + " shouldBePresent=" + shouldBePresent + " isPresent=" + isPresent + " expectedSliceCount=" + expectedSliceCount + " actualSliceCount=" + slices.size()));
            }
            if (expectedSliceCount == slices.size()) {
                isPresent = false;
                for (Slice slice : slices) {
                    for (Replica replica : slice.getReplicas()) {
                        if (!coreName.equals(replica.get("core"))) continue;
                        isPresent = true;
                    }
                }
            }
            Thread.sleep(1000L);
        }
    }

    private void testUnloadShardAndCollection() throws Exception {
        int numShards = 2;
        String collection = "test_unload_shard_and_collection";
        String coreName1 = "test_unload_shard_and_collection_1";
        String coreName2 = "test_unload_shard_and_collection_2";
        AbstractUnloadDistributedZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"test_unload_shard_and_collection", (String)"conf1", (int)2, (int)1).setCreateNodeSet("").process((SolrClient)this.cloudClient)).getStatus());
        AbstractUnloadDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"test_unload_shard_and_collection", (String)"shard1").setCoreName("test_unload_shard_and_collection_1").setNode(((JettySolrRunner)this.jettys.get(0)).getNodeName()).process((SolrClient)this.cloudClient)).isSuccess());
        AbstractUnloadDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"test_unload_shard_and_collection", (String)"shard2").setCoreName("test_unload_shard_and_collection_2").setNode(((JettySolrRunner)this.jettys.get(0)).getNodeName()).process((SolrClient)this.cloudClient)).isSuccess());
        this.waitForRecoveriesToFinish("test_unload_shard_and_collection", false);
        boolean unloadInOrder = AbstractUnloadDistributedZkTestBase.random().nextBoolean();
        String unloadCmdCoreName1 = unloadInOrder ? "test_unload_shard_and_collection_1" : "test_unload_shard_and_collection_2";
        String unloadCmdCoreName2 = unloadInOrder ? "test_unload_shard_and_collection_2" : "test_unload_shard_and_collection_1";
        try (HttpSolrClient adminClient = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(this.buildUrl(((JettySolrRunner)this.jettys.get(0)).getLocalPort()));){
            CoreAdminRequest.Unload unloadCmd = new CoreAdminRequest.Unload(false);
            unloadCmd.setCoreName(unloadCmdCoreName1);
            adminClient.request((SolrRequest)unloadCmd);
            this.checkCoreNamePresenceAndSliceCount("test_unload_shard_and_collection", unloadCmdCoreName1, false, 2);
            unloadCmd = new CoreAdminRequest.Unload(false);
            unloadCmd.setCoreName(unloadCmdCoreName2);
            adminClient.request((SolrRequest)unloadCmd);
            this.checkCoreNamePresenceAndSliceCount("test_unload_shard_and_collection", unloadCmdCoreName2, false, 2);
        }
        this.getCommonCloudSolrClient();
        AbstractUnloadDistributedZkTestBase.assertTrue((String)"No longer found collection test_unload_shard_and_collection", (boolean)this.cloudClient.getClusterState().hasCollection("test_unload_shard_and_collection"));
    }

    protected SolrCore getFirstCore(String collection, JettySolrRunner jetty) {
        SolrCore solrCore = null;
        for (SolrCore core : jetty.getCoreContainer().getCores()) {
            if (!core.getName().startsWith(collection)) continue;
            solrCore = core;
        }
        return solrCore;
    }

    private void testCoreUnloadAndLeaders() throws Exception {
        long found3;
        long found1;
        SolrQuery q;
        HttpSolrClient collectionClient;
        JettySolrRunner jetty1 = (JettySolrRunner)this.jettys.get(0);
        AbstractUnloadDistributedZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"unloadcollection", (String)"conf1", (int)1, (int)1).setCreateNodeSet(jetty1.getNodeName()).process((SolrClient)this.cloudClient)).getStatus());
        this.getCommonCloudSolrClient();
        ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)this.cloudClient);
        zkStateReader.forceUpdateCollection("unloadcollection");
        int slices = zkStateReader.getClusterState().getCollection("unloadcollection").getSlices().size();
        AbstractUnloadDistributedZkTestBase.assertEquals((long)1L, (long)slices);
        SolrCore solrCore = this.getFirstCore("unloadcollection", jetty1);
        String core1DataDir = solrCore.getDataDir();
        AbstractUnloadDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"unloadcollection", (String)"shard1").setCoreName("unloadcollection_shard1_replica2").setNode(((JettySolrRunner)this.jettys.get(1)).getNodeName()).process((SolrClient)this.cloudClient)).isSuccess());
        zkStateReader.forceUpdateCollection("unloadcollection");
        slices = zkStateReader.getClusterState().getCollection("unloadcollection").getSlices().size();
        AbstractUnloadDistributedZkTestBase.assertEquals((long)1L, (long)slices);
        this.waitForRecoveriesToFinish("unloadcollection", zkStateReader, false);
        ZkCoreNodeProps leaderProps = this.getLeaderUrlFromZk("unloadcollection", "shard1");
        Random random = AbstractUnloadDistributedZkTestBase.random();
        if (random.nextBoolean()) {
            collectionClient = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(leaderProps.getCoreUrl());
            try {
                SolrInputDocument doc1 = AbstractUnloadDistributedZkTestBase.getDoc(this.id, 6, this.i1, -600, this.tlong, 600, this.t1, "humpty dumpy sat on a wall");
                SolrInputDocument doc2 = AbstractUnloadDistributedZkTestBase.getDoc(this.id, 7, this.i1, -600, this.tlong, 600, this.t1, "humpty dumpy3 sat on a walls");
                SolrInputDocument doc3 = AbstractUnloadDistributedZkTestBase.getDoc(this.id, 8, this.i1, -600, this.tlong, 600, this.t1, "humpty dumpy2 sat on a walled");
                collectionClient.add(doc1);
                collectionClient.add(doc2);
                collectionClient.add(doc3);
                collectionClient.commit();
            }
            finally {
                if (collectionClient != null) {
                    collectionClient.close();
                }
            }
        }
        AbstractUnloadDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"unloadcollection", (String)"shard1").setCoreName("unloadcollection_shard1_replica3").setNode(((JettySolrRunner)this.jettys.get(2)).getNodeName()).process((SolrClient)this.cloudClient)).isSuccess());
        this.waitForRecoveriesToFinish("unloadcollection", zkStateReader, false);
        TestInjection.skipIndexWriterCommitOnClose = true;
        try (HttpSolrClient addClient = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(((JettySolrRunner)this.jettys.get(2)).getBaseUrl() + "/unloadcollection_shard1_replica3", 30000);){
            for (int x = 20; x < 100; ++x) {
                SolrInputDocument doc1 = AbstractUnloadDistributedZkTestBase.getDoc(this.id, x, this.i1, -600, this.tlong, 600, this.t1, "humpty dumpy sat on a wall");
                addClient.add(doc1);
            }
        }
        collectionClient = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(leaderProps.getBaseUrl(), 15000, 30000);
        try {
            CoreAdminRequest.Unload unloadCmd = new CoreAdminRequest.Unload(false);
            unloadCmd.setCoreName(leaderProps.getCoreName());
            ModifiableSolrParams p = (ModifiableSolrParams)unloadCmd.getParams();
            collectionClient.request((SolrRequest)unloadCmd);
        }
        finally {
            if (collectionClient != null) {
                collectionClient.close();
            }
        }
        int tries = 50;
        while (leaderProps.getCoreUrl().equals(zkStateReader.getLeaderUrl("unloadcollection", "shard1", 15000))) {
            Thread.sleep(100L);
            if (tries-- != 0) continue;
            AbstractUnloadDistributedZkTestBase.fail((String)"Leader never changed");
        }
        zkStateReader.getLeaderRetry("unloadcollection", "shard1", 15000);
        try (HttpSolrClient addClient = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(((JettySolrRunner)this.jettys.get(1)).getBaseUrl() + "/unloadcollection_shard1_replica2", 30000, 90000);){
            for (int x = 101; x < 200; ++x) {
                SolrInputDocument doc1 = AbstractUnloadDistributedZkTestBase.getDoc(this.id, x, this.i1, -600, this.tlong, 600, this.t1, "humpty dumpy sat on a wall");
                addClient.add(doc1);
            }
        }
        AbstractUnloadDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"unloadcollection", (String)"shard1").setCoreName("unloadcollection_shard1_replica4").setNode(((JettySolrRunner)this.jettys.get(3)).getNodeName()).process((SolrClient)this.cloudClient)).isSuccess());
        this.waitForRecoveriesToFinish("unloadcollection", zkStateReader, false);
        leaderProps = this.getLeaderUrlFromZk("unloadcollection", "shard1");
        try (HttpSolrClient collectionClient2 = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(leaderProps.getBaseUrl(), 15000, 30000);){
            CoreAdminRequest.Unload unloadCmd = new CoreAdminRequest.Unload(false);
            unloadCmd.setCoreName(leaderProps.getCoreName());
            collectionClient2.request((SolrRequest)unloadCmd);
        }
        tries = 50;
        while (leaderProps.getCoreUrl().equals(zkStateReader.getLeaderUrl("unloadcollection", "shard1", 15000))) {
            Thread.sleep(100L);
            if (tries-- != 0) continue;
            AbstractUnloadDistributedZkTestBase.fail((String)"Leader never changed");
        }
        zkStateReader.getLeaderRetry("unloadcollection", "shard1", 15000);
        TestInjection.skipIndexWriterCommitOnClose = false;
        AbstractUnloadDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"unloadcollection", (String)"shard1").setCoreName(leaderProps.getCoreName()).setDataDir(core1DataDir).setNode(leaderProps.getNodeName()).process((SolrClient)this.cloudClient)).isSuccess());
        this.waitForRecoveriesToFinish("unloadcollection", zkStateReader, false);
        try (HttpSolrClient adminClient = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(((JettySolrRunner)this.jettys.get(1)).getBaseUrl() + "/unloadcollection_shard1_replica2", 15000, 30000);){
            adminClient.commit();
            q = new SolrQuery("*:*");
            q.set("distrib", false);
            found1 = adminClient.query((SolrParams)q).getResults().getNumFound();
        }
        adminClient = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(((JettySolrRunner)this.jettys.get(2)).getBaseUrl() + "/unloadcollection_shard1_replica3", 15000, 30000);
        try {
            adminClient.commit();
            q = new SolrQuery("*:*");
            q.set("distrib", false);
            found3 = adminClient.query((SolrParams)q).getResults().getNumFound();
        }
        finally {
            if (adminClient != null) {
                adminClient.close();
            }
        }
        adminClient = AbstractUnloadDistributedZkTestBase.getHttpSolrClient(((JettySolrRunner)this.jettys.get(3)).getBaseUrl() + "/unloadcollection_shard1_replica4", 15000, 30000);
        try {
            adminClient.commit();
            q = new SolrQuery("*:*");
            q.set("distrib", false);
            long found4 = adminClient.query((SolrParams)q).getResults().getNumFound();
            AbstractUnloadDistributedZkTestBase.assertEquals((long)found1, (long)found3);
            AbstractUnloadDistributedZkTestBase.assertEquals((long)found3, (long)found4);
        }
        finally {
            if (adminClient != null) {
                adminClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnloadLotsOfCores() throws Exception {
        JettySolrRunner jetty = (JettySolrRunner)this.jettys.get(0);
        try (HttpSolrClient adminClient = (HttpSolrClient)jetty.newClient(15000, 60000);){
            int numReplicas = AbstractUnloadDistributedZkTestBase.atLeast((int)3);
            ExecutorUtil.MDCAwareThreadPoolExecutor executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("testExecutor"));
            try {
                this.createCollectionInOneInstance((SolrClient)adminClient, jetty.getNodeName(), (ThreadPoolExecutor)executor, "multiunload", 2, numReplicas);
            }
            finally {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executor);
            }
            executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("testExecutor"));
            try {
                int j = 0;
                while (j < numReplicas) {
                    int freezeJ = j++;
                    executor.execute(() -> {
                        CoreAdminRequest.Unload unloadCmd = new CoreAdminRequest.Unload(true);
                        unloadCmd.setCoreName("multiunload" + freezeJ);
                        try {
                            adminClient.request((SolrRequest)unloadCmd);
                        }
                        catch (IOException | SolrServerException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    Thread.sleep(AbstractUnloadDistributedZkTestBase.random().nextInt(50));
                }
            }
            finally {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executor);
            }
        }
    }
}

