/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.VMParamsAllAndReadonlyDigestZkACLProvider;
import org.apache.solr.common.cloud.VMParamsSingleSetCredentialsDigestZkCredentialsProvider;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractVMParamsZkACLAndCredentialsProvidersTestBase
extends SolrTestCaseJ4 {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Charset DATA_ENCODING = StandardCharsets.UTF_8;
    protected ZkTestServer zkServer;
    protected Path zkDir;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("solrcloud.skip.autorecovery", "true");
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        System.clearProperty("solrcloud.skip.autorecovery");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (log.isInfoEnabled()) {
            log.info("####SETUP_START {}", (Object)this.getTestName());
        }
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.createTempDir();
        this.zkDir = AbstractVMParamsZkACLAndCredentialsProvidersTestBase.createTempDir().resolve("zookeeper/server1/data");
        log.info("ZooKeeper dataDir:{}", (Object)this.zkDir);
        this.zkServer = new ZkTestServer(this.zkDir);
        this.zkServer.run(false);
        System.setProperty("zkHost", this.zkServer.getZkAddress());
        this.setSecuritySystemProperties();
        SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 45000, 45000, null, null, null);
        zkClient.makePath("/solr", false, true);
        zkClient.close();
        zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);
        zkClient.create("/protectedCreateNode", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.makePath("/protectedMakePathNode", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.create("/security", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.close();
        this.clearSecuritySystemProperties();
        zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);
        zkClient.getSolrZooKeeper().addAuthInfo("digest", "connectAndAllACLUsername:connectAndAllACLPassword".getBytes(StandardCharsets.UTF_8));
        zkClient.create("/unprotectedCreateNode", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.makePath("/unprotectedMakePathNode", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.close();
        if (log.isInfoEnabled()) {
            log.info("####SETUP_END {}", (Object)this.getTestName());
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.zkServer.shutdown();
        this.clearSecuritySystemProperties();
        super.tearDown();
    }

    @Test
    public void testNoCredentials() throws Exception {
        this.useNoCredentials();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, false, false, false, false, false, false, false, false, false, false);
        }
    }

    @Test
    public void testWrongCredentials() throws Exception {
        this.useWrongCredentials();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, false, false, false, false, false, false, false, false, false, false);
        }
    }

    @Test
    public void testAllCredentials() throws Exception {
        this.useAllCredentials();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, true, true, true, true, true, true, true, true, true, true);
        }
    }

    @Test
    public void testReadonlyCredentials() throws Exception {
        this.useReadonlyCredentials();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, true, true, false, false, false, false, false, false, false, false);
        }
    }

    @Test
    public void testReadonlyCredentialsFromFile() throws Exception {
        this.useReadonlyCredentialsFromFile();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, true, true, false, false, false, false, false, false, false, false);
        }
    }

    @Test
    public void testAllCredentialsFromFile() throws Exception {
        this.useAllCredentialsFromFile();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, true, true, true, true, true, true, true, true, true, true);
        }
    }

    @Test
    public void testRepairACL() throws Exception {
        this.clearSecuritySystemProperties();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            zkClient.getSolrZooKeeper().addAuthInfo("digest", "connectAndAllACLUsername:connectAndAllACLPassword".getBytes(StandardCharsets.UTF_8));
            zkClient.create("/security.json", "{}".getBytes(StandardCharsets.UTF_8), CreateMode.PERSISTENT, false);
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)zkClient.getACL("/security.json", null, false));
        }
        this.setSecuritySystemProperties();
        zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);
        try {
            ZkController.createClusterZkNodes((SolrZkClient)zkClient);
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.assertNotEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)zkClient.getACL("/security.json", null, false));
        }
        finally {
            zkClient.close();
        }
        this.useReadonlyCredentials();
        zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);
        try {
            KeeperException.NoAuthException e = (KeeperException.NoAuthException)AbstractVMParamsZkACLAndCredentialsProvidersTestBase.assertThrows(KeeperException.NoAuthException.class, () -> zkClient.getData("/security.json", null, null, false));
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.assertEquals((Object)"/security.json", (Object)e.getPath());
        }
        finally {
            zkClient.close();
        }
    }

    public static void doTest(SolrZkClient zkClient, boolean getData, boolean list, boolean create, boolean setData, boolean delete, boolean secureGet, boolean secureList, boolean secureCreate, boolean secureSet, boolean secureDelete) throws Exception {
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/protectedCreateNode", getData, list, create, setData, delete);
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/protectedMakePathNode", getData, list, create, setData, delete);
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/unprotectedCreateNode", true, true, true, true, delete);
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/unprotectedMakePathNode", true, true, true, true, delete);
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/security", secureGet, secureList, secureCreate, secureSet, secureDelete);
    }

    protected static void doTest(SolrZkClient zkClient, String path, boolean getData, boolean list, boolean create, boolean setData, boolean delete) throws Exception {
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(getData, () -> zkClient.getData(path, null, null, false));
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(list, () -> zkClient.getChildren(path, null, false));
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(create, () -> {
            zkClient.create(path + "/subnode", null, CreateMode.PERSISTENT, false);
            zkClient.delete(path + "/subnode", -1, false);
        });
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(create, () -> {
            zkClient.makePath(path + "/subnode/subsubnode", false);
            zkClient.delete(path + "/subnode/subsubnode", -1, false);
            zkClient.delete(path + "/subnode", -1, false);
        });
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(setData, () -> zkClient.setData(path, (byte[])null, false));
        AbstractVMParamsZkACLAndCredentialsProvidersTestBase.doTest(delete, () -> zkClient.delete(path, -1, false));
    }

    private static void doTest(boolean shouldSucceed, ExceptingRunnable action) throws Exception {
        if (shouldSucceed) {
            action.run();
        } else {
            AbstractVMParamsZkACLAndCredentialsProvidersTestBase.expectThrows(KeeperException.NoAuthException.class, action::run);
        }
    }

    private void useNoCredentials() {
        this.clearSecuritySystemProperties();
    }

    private void useWrongCredentials() {
        this.clearSecuritySystemProperties();
        System.setProperty("zkCredentialsProvider", VMParamsSingleSetCredentialsDigestZkCredentialsProvider.class.getName());
        System.setProperty("zkDigestUsername", "connectAndAllACLUsername");
        System.setProperty("zkDigestPassword", "connectAndAllACLPasswordWrong");
    }

    private void useAllCredentials() {
        this.clearSecuritySystemProperties();
        System.setProperty("zkCredentialsProvider", VMParamsSingleSetCredentialsDigestZkCredentialsProvider.class.getName());
        System.setProperty("zkDigestUsername", "connectAndAllACLUsername");
        System.setProperty("zkDigestPassword", "connectAndAllACLPassword");
    }

    private void useReadonlyCredentials() {
        this.clearSecuritySystemProperties();
        System.setProperty("zkCredentialsProvider", VMParamsSingleSetCredentialsDigestZkCredentialsProvider.class.getName());
        System.setProperty("zkDigestUsername", "readonlyACLUsername");
        System.setProperty("zkDigestPassword", "readonlyACLPassword");
    }

    private void useReadonlyCredentialsFromFile() throws IOException {
        this.useCredentialsFromFile("readonlyACLUsername", "readonlyACLPassword");
    }

    private void useAllCredentialsFromFile() throws IOException {
        this.useCredentialsFromFile("connectAndAllACLUsername", "connectAndAllACLPassword");
    }

    private void useCredentialsFromFile(String username, String password) throws IOException {
        this.clearSecuritySystemProperties();
        System.setProperty("zkCredentialsProvider", VMParamsSingleSetCredentialsDigestZkCredentialsProvider.class.getName());
        Properties props = new Properties();
        props.setProperty("zkDigestUsername", username);
        props.setProperty("zkDigestPassword", password);
        this.saveCredentialsFile(props);
    }

    private void saveCredentialsFile(Properties props) throws IOException {
        Path tmp = AbstractVMParamsZkACLAndCredentialsProvidersTestBase.createTempFile((String)"zk-creds", (String)"properties");
        try (FileWriter w = new FileWriter(tmp.toFile(), StandardCharsets.UTF_8);){
            props.store(w, "test");
        }
        System.setProperty("zkDigestCredentialsFile", tmp.toAbsolutePath().toString());
    }

    private void setSecuritySystemProperties() {
        System.setProperty("zkACLProvider", VMParamsAllAndReadonlyDigestZkACLProvider.class.getName());
        System.setProperty("zkCredentialsProvider", VMParamsSingleSetCredentialsDigestZkCredentialsProvider.class.getName());
        System.setProperty("zkDigestUsername", "connectAndAllACLUsername");
        System.setProperty("zkDigestPassword", "connectAndAllACLPassword");
        System.setProperty("zkDigestReadonlyUsername", "readonlyACLUsername");
        System.setProperty("zkDigestReadonlyPassword", "readonlyACLPassword");
    }

    private void clearSecuritySystemProperties() {
        System.clearProperty("zkACLProvider");
        System.clearProperty("zkCredentialsProvider");
        System.clearProperty("zkDigestUsername");
        System.clearProperty("zkDigestPassword");
        System.clearProperty("zkDigestReadonlyUsername");
        System.clearProperty("zkDigestReadonlyPassword");
        System.clearProperty("zkDigestCredentialsFile");
    }

    static interface ExceptingRunnable {
        public void run() throws Exception;
    }
}

