/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.cloud.ZkTestServer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZkTestCase
extends SolrTestCaseJ4 {
    private static final String ZOOKEEPER_FORCE_SYNC = "zookeeper.forceSync";
    public static final int TIMEOUT = 45000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static Path SOLRHOME;
    protected static volatile ZkTestServer zkServer;
    protected static volatile Path zkDir;

    @BeforeClass
    public static void azt_beforeClass() throws Exception {
        zkDir = AbstractZkTestCase.createTempDir((String)"zkData");
        zkServer = new ZkTestServer(zkDir);
        zkServer.run();
        System.setProperty("solrcloud.skip.autorecovery", "true");
        System.setProperty("zkHost", zkServer.getZkAddress());
        System.setProperty("jetty.port", "0000");
        System.setProperty(ZOOKEEPER_FORCE_SYNC, "false");
        zkServer.buildZooKeeper(SOLRHOME, "solrconfig.xml", "schema.xml");
        AbstractZkTestCase.initCore("solrconfig.xml", "schema.xml");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @AfterClass
    public static void azt_afterClass() throws Exception {
        try {
            AbstractZkTestCase.deleteCore();
        }
        finally {
            System.clearProperty("zkHost");
            System.clearProperty("solr.test.sys.prop1");
            System.clearProperty("solr.test.sys.prop2");
            System.clearProperty("solrcloud.skip.autorecovery");
            System.clearProperty("jetty.port");
            System.clearProperty(ZOOKEEPER_FORCE_SYNC);
            if (zkServer != null) {
                zkServer.shutdown();
                zkServer = null;
            }
            zkDir = null;
        }
    }

    protected void printLayout() throws Exception {
        zkServer.printLayout();
    }

    static {
        try {
            SOLRHOME = SolrTestCaseJ4.TEST_PATH();
        }
        catch (RuntimeException e) {
            log.warn("TEST_PATH() does not exist - solrj test?");
        }
    }
}

