/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.HttpClient;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.StoppableIndexingThread;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FullThrottleStoppableIndexingThread
extends StoppableIndexingThread {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final HttpClient httpClient;
    private volatile boolean stop = false;
    int clientIndex = 0;
    private ConcurrentUpdateSolrClient cusc;
    private List<SolrClient> clients;
    private AtomicInteger fails = new AtomicInteger();

    public FullThrottleStoppableIndexingThread(HttpClient httpClient, SolrClient controlClient, CloudSolrClient cloudClient, List<SolrClient> clients, String id, boolean doDeletes, int clientSoTimeout) {
        super(controlClient, (SolrClient)cloudClient, id, doDeletes);
        this.setName("FullThrottleStopableIndexingThread");
        this.setDaemon(true);
        this.clients = clients;
        this.httpClient = httpClient;
        this.cusc = ((ConcurrentUpdateSolrClient.Builder)((ConcurrentUpdateSolrClient.Builder)((ConcurrentUpdateSolrClient.Builder)new ErrorLoggingConcurrentUpdateSolrClient.Builder(((HttpSolrClient)clients.get(0)).getBaseURL()).withHttpClient(httpClient)).withQueueSize(8).withThreadCount(2).withConnectionTimeout(10000)).withSocketTimeout(clientSoTimeout)).build();
    }

    @Override
    public void run() {
        int i = 0;
        int numDeletes = 0;
        int numAdds = 0;
        while (!this.stop) {
            String id = this.id + "-" + i;
            ++i;
            if (this.doDeletes && LuceneTestCase.random().nextBoolean() && this.deletes.size() > 0) {
                String delete = (String)this.deletes.remove(0);
                try {
                    ++numDeletes;
                    this.cusc.deleteById(delete);
                }
                catch (Exception e) {
                    this.changeUrlOnError(e);
                    this.fails.incrementAndGet();
                }
            }
            try {
                if (++numAdds > (LuceneTestCase.TEST_NIGHTLY ? 4002 : 197)) continue;
                SolrInputDocument doc = AbstractFullDistribZkTestBase.getDoc("id", id, i1, 50, t1, "Saxon heptarchies that used to rip around so in old times and raise Cain.  My, you ought to seen old Henry the Eight when he was in bloom.  He WAS a blossom.  He used to marry a new wife every day, and chop off her head next morning.  And he would do it just as indifferent as if ");
                this.cusc.add(doc);
            }
            catch (Exception e) {
                this.changeUrlOnError(e);
                this.fails.incrementAndGet();
            }
            if (!this.doDeletes || !LuceneTestCase.random().nextBoolean()) continue;
            this.deletes.add(id);
        }
        log.info("FT added docs:{} with {} fails deletes:{}", new Object[]{numAdds, this.fails, numDeletes});
    }

    private void changeUrlOnError(Exception e) {
        if (e instanceof ConnectException) {
            ++this.clientIndex;
            if (this.clientIndex > this.clients.size() - 1) {
                this.clientIndex = 0;
            }
            this.cusc.shutdownNow();
            this.cusc = ((ConcurrentUpdateSolrClient.Builder)new ErrorLoggingConcurrentUpdateSolrClient.Builder(((HttpSolrClient)this.clients.get(this.clientIndex)).getBaseURL()).withHttpClient(this.httpClient)).withQueueSize(30).withThreadCount(3).build();
        }
    }

    @Override
    public void safeStop() {
        this.stop = true;
        try {
            this.cusc.blockUntilFinished();
        }
        catch (IOException e) {
            log.warn("Exception waiting for the indexing client to finish", (Throwable)e);
        }
        finally {
            this.cusc.shutdownNow();
        }
    }

    @Override
    public int getFailCount() {
        return this.fails.get();
    }

    @Override
    public Set<String> getAddFails() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getDeleteFails() {
        throw new UnsupportedOperationException();
    }

    static class ErrorLoggingConcurrentUpdateSolrClient
    extends ConcurrentUpdateSolrClient {
        public ErrorLoggingConcurrentUpdateSolrClient(Builder builder) {
            super((ConcurrentUpdateSolrClient.Builder)builder);
        }

        public void handleError(Throwable ex) {
            log.warn("cusc error", ex);
        }

        static class Builder
        extends ConcurrentUpdateSolrClient.Builder {
            public Builder(String baseSolrUrl) {
                super(baseSolrUrl);
            }

            public ErrorLoggingConcurrentUpdateSolrClient build() {
                return new ErrorLoggingConcurrentUpdateSolrClient(this);
            }
        }
    }
}

