/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.common.SolrInputDocument;

public class StoppableIndexingThread
extends AbstractFullDistribZkTestBase.StoppableThread {
    static String t1 = "a_t";
    static String i1 = "a_i";
    private volatile boolean stop = false;
    protected final String id;
    protected final List<String> deletes = new ArrayList<String>();
    protected Set<String> addFails = new HashSet<String>();
    protected Set<String> deleteFails = new HashSet<String>();
    protected boolean doDeletes;
    private int numCycles;
    private SolrClient controlClient;
    private SolrClient cloudClient;
    private int numDeletes;
    private int numAdds;
    private List<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
    private int batchSize;
    private boolean pauseBetweenUpdates;

    public StoppableIndexingThread(SolrClient controlClient, SolrClient cloudClient, String id, boolean doDeletes) {
        this(controlClient, cloudClient, id, doDeletes, -1, 1, true);
    }

    public StoppableIndexingThread(SolrClient controlClient, SolrClient cloudClient, String id, boolean doDeletes, int numCycles, int batchSize, boolean pauseBetweenUpdates) {
        super("StoppableIndexingThread");
        this.controlClient = controlClient;
        this.cloudClient = cloudClient;
        this.id = id;
        this.doDeletes = doDeletes;
        this.numCycles = numCycles;
        this.batchSize = batchSize;
        this.pauseBetweenUpdates = pauseBetweenUpdates;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        int i = 0;
        int numDone = 0;
        this.numDeletes = 0;
        this.numAdds = 0;
        while (!(this.stop || this.numCycles != -1 && numDone > this.numCycles)) {
            ++numDone;
            String id = this.id + "-" + i;
            ++i;
            boolean addFailed = false;
            if (this.doDeletes && AbstractFullDistribZkTestBase.random().nextBoolean() && this.deletes.size() > 0) {
                String deleteId = this.deletes.remove(0);
                try {
                    ++this.numDeletes;
                    if (this.controlClient != null) {
                        UpdateRequest req = new UpdateRequest();
                        req.deleteById(deleteId);
                        req.setParam("CONTROL", "TRUE");
                        req.process(this.controlClient);
                    }
                    this.cloudClient.deleteById(deleteId);
                }
                catch (Exception e) {
                    System.err.println("REQUEST FAILED for id=" + deleteId);
                    e.printStackTrace();
                    if (e instanceof SolrServerException) {
                        System.err.println("ROOT CAUSE for id=" + deleteId);
                        ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                    }
                    this.deleteFails.add(deleteId);
                }
            }
            try {
                ++this.numAdds;
                SolrInputDocument doc = new SolrInputDocument();
                this.addFields(doc, "id", id, i1, 50, t1, "to come to the aid of their country.");
                this.addFields(doc, "rnd_b", true);
                this.docs.add(doc);
                if (this.docs.size() >= this.batchSize) {
                    this.indexDocs(this.docs);
                    this.docs.clear();
                }
            }
            catch (Exception e) {
                addFailed = true;
                System.err.println("REQUEST FAILED for id=" + id);
                e.printStackTrace();
                if (e instanceof SolrServerException) {
                    System.err.println("ROOT CAUSE for id=" + id);
                    ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                }
                this.addFails.add(id);
            }
            if (!addFailed && this.doDeletes && AbstractFullDistribZkTestBase.random().nextBoolean()) {
                this.deletes.add(id);
            }
            if (this.docs.size() <= 0 || !this.pauseBetweenUpdates) continue;
            try {
                Thread.sleep(AbstractFullDistribZkTestBase.random().nextInt(500) + 50);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        System.err.println("added docs:" + this.numAdds + " with " + (this.addFails.size() + this.deleteFails.size()) + " fails deletes:" + this.numDeletes);
    }

    @Override
    public void safeStop() {
        this.stop = true;
    }

    public Set<String> getAddFails() {
        return this.addFails;
    }

    public Set<String> getDeleteFails() {
        return this.deleteFails;
    }

    public int getFailCount() {
        return this.addFails.size() + this.deleteFails.size();
    }

    protected void addFields(SolrInputDocument doc, Object ... fields) {
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
    }

    protected void indexDocs(List<SolrInputDocument> docs) throws IOException, SolrServerException {
        if (this.controlClient != null) {
            UpdateRequest req = new UpdateRequest();
            req.add(docs);
            req.setParam("CONTROL", "TRUE");
            req.process(this.controlClient);
        }
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(docs);
        ureq.process(this.cloudClient);
    }

    public int getNumDeletes() {
        return this.numDeletes;
    }

    public int getNumAdds() {
        return this.numAdds;
    }
}

