/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.CoreStatus;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.util.TestInjection;
import org.apache.solr.util.TimeOut;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneTestCase.Slow
public abstract class AbstractCollectionsAPIDistributedZkTestBase
extends SolrCloudTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected abstract String getConfigSet();

    @Before
    public void setupCluster() throws Exception {
        System.setProperty("zkClientTimeout", "60000");
        System.setProperty("createCollectionWaitTimeTillActive", "5");
        TestInjection.randomDelayInCoreCreation = "true:5";
        System.setProperty("validateAfterInactivity", "200");
        System.setProperty("solr.allowPaths", "*");
        AbstractCollectionsAPIDistributedZkTestBase.configureCluster(4).addConfig("conf", AbstractCollectionsAPIDistributedZkTestBase.configset(this.getConfigSet())).addConfig("conf2", AbstractCollectionsAPIDistributedZkTestBase.configset(this.getConfigSet())).withSolrXml(AbstractCollectionsAPIDistributedZkTestBase.TEST_PATH().resolve("solr.xml")).configure();
    }

    @After
    public void tearDownCluster() throws Exception {
        try {
            AbstractCollectionsAPIDistributedZkTestBase.shutdownCluster();
        }
        finally {
            System.clearProperty("createCollectionWaitTimeTillActive");
            System.clearProperty("solr.allowPaths");
            super.tearDown();
        }
    }

    @Test
    public void testCreationAndDeletion() throws Exception {
        String collectionName = "created_and_deleted";
        CollectionAdminRequest.createCollection((String)collectionName, (String)"conf", (int)1, (int)1).process((SolrClient)cluster.getSolrClient());
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((boolean)CollectionAdminRequest.listCollections((SolrClient)cluster.getSolrClient()).contains(collectionName));
        CollectionAdminRequest.deleteCollection((String)collectionName).process((SolrClient)cluster.getSolrClient());
        AbstractCollectionsAPIDistributedZkTestBase.assertFalse((boolean)CollectionAdminRequest.listCollections((SolrClient)cluster.getSolrClient()).contains(collectionName));
        AbstractCollectionsAPIDistributedZkTestBase.assertFalse((boolean)cluster.getZkClient().exists("/collections/" + collectionName, true));
    }

    @Test
    public void deleteCollectionRemovesStaleZkCollectionsNode() throws Exception {
        String collectionName = "out_of_sync_collection";
        cluster.getZkClient().makePath("/collections/" + collectionName, true);
        CollectionAdminRequest.deleteCollection((String)collectionName).process((SolrClient)cluster.getSolrClient());
        AbstractCollectionsAPIDistributedZkTestBase.assertFalse((boolean)CollectionAdminRequest.listCollections((SolrClient)cluster.getSolrClient()).contains(collectionName));
        AbstractCollectionsAPIDistributedZkTestBase.assertFalse((boolean)cluster.getZkClient().exists("/collections/" + collectionName, true));
    }

    @Test
    public void deletePartiallyCreatedCollection() throws Exception {
        String collectionName = "halfdeletedcollection";
        AbstractCollectionsAPIDistributedZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"halfdeletedcollection", (String)"conf", (int)2, (int)1).setCreateNodeSet("").process((SolrClient)cluster.getSolrClient())).getStatus());
        String dataDir = AbstractCollectionsAPIDistributedZkTestBase.createTempDir().toFile().getAbsolutePath();
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"halfdeletedcollection", (String)"shard1").setDataDir(dataDir).process((SolrClient)cluster.getSolrClient())).isSuccess());
        CollectionAdminRequest.deleteCollection((String)"halfdeletedcollection").process((SolrClient)cluster.getSolrClient());
        AbstractCollectionsAPIDistributedZkTestBase.assertFalse((boolean)CollectionAdminRequest.listCollections((SolrClient)cluster.getSolrClient()).contains("halfdeletedcollection"));
        CollectionAdminRequest.createCollection((String)"halfdeletedcollection", (String)"conf", (int)2, (int)1).process((SolrClient)cluster.getSolrClient());
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((boolean)CollectionAdminRequest.listCollections((SolrClient)cluster.getSolrClient()).contains("halfdeletedcollection"));
    }

    @Test
    public void deleteCollectionOnlyInZk() throws Exception {
        String collectionName = "onlyinzk";
        cluster.getZkClient().makePath("/collections/onlyinzk", true);
        CollectionAdminRequest.deleteCollection((String)"onlyinzk").process((SolrClient)cluster.getSolrClient());
        AbstractCollectionsAPIDistributedZkTestBase.assertFalse((boolean)CollectionAdminRequest.listCollections((SolrClient)cluster.getSolrClient()).contains("onlyinzk"));
        CollectionAdminRequest.createCollection((String)"onlyinzk", (String)"conf", (int)2, (int)1).process((SolrClient)cluster.getSolrClient());
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((boolean)CollectionAdminRequest.listCollections((SolrClient)cluster.getSolrClient()).contains("onlyinzk"));
    }

    @Test
    public void testBadActionNames() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{"BADACTION"});
        String collectionName = "badactioncollection";
        params.set("name", new String[]{collectionName});
        params.set("numShards", 2);
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        AbstractCollectionsAPIDistributedZkTestBase.expectThrows(Exception.class, () -> cluster.getSolrClient().request((SolrRequest)request));
    }

    @Test
    public void testMissingRequiredParameters() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.toString()});
        params.set("numShards", 2);
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        AbstractCollectionsAPIDistributedZkTestBase.expectThrows(Exception.class, () -> cluster.getSolrClient().request((SolrRequest)request));
    }

    @Test
    public void testMissingNumShards() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.toString()});
        params.set("name", new String[]{"acollection"});
        params.set("replicationFactor", 10);
        params.set("collection.configName", new String[]{"conf"});
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        AbstractCollectionsAPIDistributedZkTestBase.expectThrows(Exception.class, () -> cluster.getSolrClient().request((SolrRequest)request));
    }

    @Test
    public void testZeroNumShards() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.toString()});
        params.set("name", new String[]{"acollection"});
        params.set("replicationFactor", 10);
        params.set("numShards", 0);
        params.set("collection.configName", new String[]{"conf"});
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        AbstractCollectionsAPIDistributedZkTestBase.expectThrows(Exception.class, () -> cluster.getSolrClient().request((SolrRequest)request));
    }

    @Test
    public void testCreateShouldFailOnExistingCore() throws Exception {
        String nn1 = cluster.getJettySolrRunner(0).getNodeName();
        String nn2 = cluster.getJettySolrRunner(1).getNodeName();
        AbstractCollectionsAPIDistributedZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"halfcollectionblocker", (String)"conf", (int)1, (int)1).setCreateNodeSet("").process((SolrClient)cluster.getSolrClient())).getStatus());
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"halfcollectionblocker", (String)"shard1").setNode(cluster.getJettySolrRunner(0).getNodeName()).setCoreName("halfcollection_shard1_replica_n1").process((SolrClient)cluster.getSolrClient())).isSuccess());
        AbstractCollectionsAPIDistributedZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"halfcollectionblocker2", (String)"conf", (int)1, (int)1).setCreateNodeSet("").process((SolrClient)cluster.getSolrClient())).getStatus());
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"halfcollectionblocker2", (String)"shard1").setNode(cluster.getJettySolrRunner(1).getNodeName()).setCoreName("halfcollection_shard1_replica_n1").process((SolrClient)cluster.getSolrClient())).isSuccess());
        AbstractCollectionsAPIDistributedZkTestBase.expectThrows(BaseHttpSolrClient.RemoteSolrException.class, () -> CollectionAdminRequest.createCollection((String)"halfcollection", (String)"conf", (int)1, (int)1).setCreateNodeSet(nn1 + "," + nn2).process((SolrClient)cluster.getSolrClient()));
    }

    @Test
    public void testNoConfigSetExist() throws Exception {
        AbstractCollectionsAPIDistributedZkTestBase.expectThrows(Exception.class, () -> CollectionAdminRequest.createCollection((String)"noconfig", (String)"conf123", (int)1, (int)1).process((SolrClient)cluster.getSolrClient()));
        TimeUnit.MILLISECONDS.sleep(1000L);
        cluster.getZkStateReader().forceUpdateCollection("noconfig");
        AbstractCollectionsAPIDistributedZkTestBase.assertFalse((boolean)CollectionAdminRequest.listCollections((SolrClient)cluster.getSolrClient()).contains("noconfig"));
    }

    @Test
    public void testCoresAreDistributedAcrossNodes() throws Exception {
        CollectionAdminRequest.createCollection((String)"nodes_used_collection", (String)"conf", (int)2, (int)2).process((SolrClient)cluster.getSolrClient());
        Set liveNodes = cluster.getSolrClient().getClusterState().getLiveNodes();
        ArrayList createNodeList = new ArrayList(liveNodes);
        DocCollection collection = AbstractCollectionsAPIDistributedZkTestBase.getCollectionState("nodes_used_collection");
        for (Slice slice : collection.getSlices()) {
            for (Replica replica : slice.getReplicas()) {
                createNodeList.remove(replica.getNodeName());
            }
        }
        AbstractCollectionsAPIDistributedZkTestBase.assertEquals((String)((Object)createNodeList).toString(), (long)0L, (long)createNodeList.size());
    }

    @Test
    public void testDeleteNonExistentCollection() throws Exception {
        AbstractCollectionsAPIDistributedZkTestBase.expectThrows(SolrException.class, () -> CollectionAdminRequest.deleteCollection((String)"unknown_collection").process((SolrClient)cluster.getSolrClient()));
        CollectionAdminRequest.createCollection((String)"acollectionafterbaddelete", (String)"conf", (int)1, (int)2).process((SolrClient)cluster.getSolrClient());
        AbstractCollectionsAPIDistributedZkTestBase.waitForState("Collection creation after a bad delete failed", "acollectionafterbaddelete", (n, c) -> DocCollection.isFullyActive((Set)n, (DocCollection)c, (int)1, (int)2));
    }

    @Test
    public void testSpecificConfigsets() throws Exception {
        CollectionAdminRequest.createCollection((String)"withconfigset2", (String)"conf2", (int)1, (int)1).process((SolrClient)cluster.getSolrClient());
        String configName = cluster.getSolrClient().getClusterStateProvider().getCollection("withconfigset2").getConfigName();
        AbstractCollectionsAPIDistributedZkTestBase.assertEquals((Object)"conf2", (Object)configName);
    }

    @Test
    public void testCreateNodeSet() throws Exception {
        JettySolrRunner jetty1 = cluster.getRandomJetty(AbstractCollectionsAPIDistributedZkTestBase.random());
        JettySolrRunner jetty2 = cluster.getRandomJetty(AbstractCollectionsAPIDistributedZkTestBase.random());
        ImmutableList baseUrls = ImmutableList.of((Object)jetty1.getBaseUrl().toString(), (Object)jetty2.getBaseUrl().toString());
        CollectionAdminRequest.createCollection((String)"nodeset_collection", (String)"conf", (int)2, (int)1).setCreateNodeSet((String)baseUrls.get(0) + "," + (String)baseUrls.get(1)).process((SolrClient)cluster.getSolrClient());
        DocCollection collectionState = AbstractCollectionsAPIDistributedZkTestBase.getCollectionState("nodeset_collection");
        for (Replica replica : collectionState.getReplicas()) {
            String replicaUrl = replica.getCoreUrl();
            boolean matchingJetty = false;
            for (String jettyUrl : baseUrls) {
                if (!replicaUrl.startsWith(jettyUrl)) continue;
                matchingJetty = true;
            }
            if (matchingJetty) continue;
            AbstractCollectionsAPIDistributedZkTestBase.fail((String)("Expected replica to be on " + (List)baseUrls + " but was on " + replicaUrl));
        }
    }

    @Test
    public void testCollectionsAPI() throws Exception {
        int cnt = AbstractCollectionsAPIDistributedZkTestBase.random().nextInt(TEST_NIGHTLY ? 3 : 1) + 1;
        CollectionAdminRequest.Create[] createRequests = new CollectionAdminRequest.Create[cnt];
        class Coll {
            String name;
            int numShards;
            int replicationFactor;

            Coll() {
            }
        }
        ArrayList<Coll> colls = new ArrayList<Coll>();
        for (int i = 0; i < cnt; ++i) {
            int numShards = TestUtil.nextInt((Random)AbstractCollectionsAPIDistributedZkTestBase.random(), (int)0, (int)cluster.getJettySolrRunners().size()) + 1;
            int replicationFactor = TestUtil.nextInt((Random)AbstractCollectionsAPIDistributedZkTestBase.random(), (int)0, (int)3) + 1;
            createRequests[i] = CollectionAdminRequest.createCollection((String)("awhollynewcollection_" + i), (String)"conf2", (int)numShards, (int)replicationFactor);
            createRequests[i].processAsync((SolrClient)cluster.getSolrClient());
            Coll coll = new Coll();
            coll.name = "awhollynewcollection_" + i;
            coll.numShards = numShards;
            coll.replicationFactor = replicationFactor;
            colls.add(coll);
        }
        for (Coll coll : colls) {
            cluster.waitForActiveCollection(coll.name, coll.numShards, coll.numShards * coll.replicationFactor);
        }
        this.waitForStable(cnt, createRequests);
        for (int i = 0; i < cluster.getJettySolrRunners().size(); ++i) {
            this.checkInstanceDirs(cluster.getJettySolrRunner(i));
        }
        String collectionName = createRequests[AbstractCollectionsAPIDistributedZkTestBase.random().nextInt(createRequests.length)].getCollectionName();
        Thread.sleep(1000L);
        cluster.getZkStateReader().forciblyRefreshAllClusterStateSlow();
        new UpdateRequest().add(new String[]{"id", "6"}).add(new String[]{"id", "7"}).add(new String[]{"id", "8"}).commit((SolrClient)cluster.getSolrClient(), collectionName);
        long numFound = 0L;
        TimeOut timeOut = new TimeOut(10L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        while (!timeOut.hasTimedOut() && (numFound = cluster.getSolrClient().query(collectionName, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound()) != 3L) {
            Thread.sleep(500L);
        }
        if (timeOut.hasTimedOut()) {
            AbstractCollectionsAPIDistributedZkTestBase.fail((String)("Timeout waiting to see 3 found, instead saw " + numFound + " for collection " + collectionName));
        }
        this.checkNoTwoShardsUseTheSameIndexDir();
    }

    private void waitForStable(int cnt, CollectionAdminRequest.Create[] createRequests) throws InterruptedException {
        for (int i = 0; i < cnt; ++i) {
            String collectionName = "awhollynewcollection_" + i;
            int j = i;
            AbstractCollectionsAPIDistributedZkTestBase.waitForState("Expected to see collection " + collectionName, collectionName, (n, c) -> {
                CollectionAdminRequest.Create req = createRequests[j];
                return DocCollection.isFullyActive((Set)n, (DocCollection)c, (int)req.getNumShards(), (int)req.getReplicationFactor());
            });
            ZkStateReader zkStateReader = cluster.getZkStateReader();
            for (int z = 1; z < createRequests[j].getNumShards(); ++z) {
                zkStateReader.getLeaderRetry(collectionName, "shard" + z, 10000);
            }
        }
    }

    @Test
    public void testCollectionReload() throws Exception {
        String collectionName = "reloaded_collection";
        CollectionAdminRequest.createCollection((String)"reloaded_collection", (String)"conf", (int)2, (int)2).process((SolrClient)cluster.getSolrClient());
        HashMap<String, Long> urlToTimeBefore = new HashMap<String, Long>();
        this.collectStartTimes("reloaded_collection", urlToTimeBefore);
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((urlToTimeBefore.size() > 0 ? 1 : 0) != 0);
        CollectionAdminRequest.reloadCollection((String)"reloaded_collection").processAsync((SolrClient)cluster.getSolrClient());
        boolean allTimesAreCorrect = this.waitForReloads("reloaded_collection", urlToTimeBefore);
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((String)"some core start times did not change on reload", (boolean)allTimesAreCorrect);
    }

    private void checkInstanceDirs(JettySolrRunner jetty) throws IOException {
        CoreContainer cores = jetty.getCoreContainer();
        List theCores = cores.getCores();
        for (SolrCore core : theCores) {
            Path instancedir = core.getInstancePath();
            AbstractCollectionsAPIDistributedZkTestBase.assertTrue((String)"Could not find expected core.properties file", (boolean)Files.exists(instancedir.resolve("core.properties"), new LinkOption[0]));
            Path expected = Paths.get(jetty.getSolrHome(), new String[0]).toAbsolutePath().resolve(core.getName());
            AbstractCollectionsAPIDistributedZkTestBase.assertTrue((String)("Expected: " + expected + "\nFrom core stats: " + instancedir), (boolean)Files.isSameFile(expected, instancedir));
        }
    }

    private boolean waitForReloads(String collectionName, Map<String, Long> urlToTimeBefore) throws SolrServerException, IOException {
        TimeOut timeout = new TimeOut(45L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        boolean allTimesAreCorrect = false;
        while (!timeout.hasTimedOut()) {
            HashMap<String, Long> urlToTimeAfter = new HashMap<String, Long>();
            this.collectStartTimes(collectionName, urlToTimeAfter);
            boolean retry = false;
            Set<Map.Entry<String, Long>> entries = urlToTimeBefore.entrySet();
            for (Map.Entry<String, Long> entry : entries) {
                Long beforeTime = entry.getValue();
                Long afterTime = (Long)urlToTimeAfter.get(entry.getKey());
                AbstractCollectionsAPIDistributedZkTestBase.assertNotNull((Object)afterTime);
                if (afterTime > beforeTime) continue;
                retry = true;
                break;
            }
            if (retry) continue;
            allTimesAreCorrect = true;
            break;
        }
        return allTimesAreCorrect;
    }

    private void collectStartTimes(String collectionName, Map<String, Long> urlToTime) throws SolrServerException, IOException {
        DocCollection collectionState = AbstractCollectionsAPIDistributedZkTestBase.getCollectionState(collectionName);
        if (collectionState != null) {
            for (Slice shard : collectionState) {
                for (Replica replica : shard) {
                    CoreStatus coreStatus;
                    ZkCoreNodeProps coreProps = new ZkCoreNodeProps((ZkNodeProps)replica);
                    try (HttpSolrClient server = AbstractCollectionsAPIDistributedZkTestBase.getHttpSolrClient(coreProps.getBaseUrl());){
                        coreStatus = CoreAdminRequest.getCoreStatus((String)coreProps.getCoreName(), (boolean)false, (SolrClient)server);
                    }
                    long before = coreStatus.getCoreStartTime().getTime();
                    urlToTime.put(coreProps.getCoreUrl(), before);
                }
            }
        } else {
            throw new IllegalArgumentException("Could not find collection " + collectionName);
        }
    }

    private void checkNoTwoShardsUseTheSameIndexDir() {
        HashMap indexDirToShardNamesMap = new HashMap();
        LinkedList<MBeanServer> servers = new LinkedList<MBeanServer>();
        servers.add(ManagementFactory.getPlatformMBeanServer());
        servers.addAll(MBeanServerFactory.findMBeanServer(null));
        for (MBeanServer mBeanServer : servers) {
            HashSet<ObjectName> mbeans = new HashSet<ObjectName>(mBeanServer.queryNames(null, null));
            for (ObjectName mbean : mbeans) {
                try {
                    Hashtable<String, String> props = mbean.getKeyPropertyList();
                    String category = (String)props.get("category");
                    String name = (String)props.get("name");
                    if (category == null || !category.equals(SolrInfoBean.Category.CORE.toString()) || name == null || !name.equals("indexDir")) continue;
                    String indexDir = mBeanServer.getAttribute(mbean, "Value").toString();
                    String key = (String)props.get("dom2") + "." + (String)props.get("dom3") + "." + (String)props.get("dom4");
                    if (!indexDirToShardNamesMap.containsKey(indexDir)) {
                        indexDirToShardNamesMap.put(indexDir, new HashSet());
                    }
                    ((Set)indexDirToShardNamesMap.get(indexDir)).add(key);
                }
                catch (Exception exception) {}
            }
        }
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((String)("Something is broken in the assert for no shards using the same indexDir - probably something was changed in the attributes published in the MBean of " + SolrCore.class.getSimpleName() + " : " + indexDirToShardNamesMap), (indexDirToShardNamesMap.size() > 0 ? 1 : 0) != 0);
        for (Map.Entry entry : indexDirToShardNamesMap.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            AbstractCollectionsAPIDistributedZkTestBase.fail((String)("We have shards using the same indexDir. E.g. shards " + ((Set)entry.getValue()).toString() + " all use indexDir " + (String)entry.getKey()));
        }
    }

    @Test
    public void addReplicaTest() throws Exception {
        String collectionName = "addReplicaColl";
        CollectionAdminRequest.createCollection((String)collectionName, (String)"conf", (int)2, (int)2).process((SolrClient)cluster.getSolrClient());
        cluster.waitForActiveCollection(collectionName, 2, 4);
        ArrayList nodeList = new ArrayList(cluster.getSolrClient().getClusterState().getLiveNodes());
        Collections.shuffle(nodeList, AbstractCollectionsAPIDistributedZkTestBase.random());
        CollectionAdminResponse response = (CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)collectionName, (String)"shard1").setNode((String)nodeList.get(0)).process((SolrClient)cluster.getSolrClient());
        Replica newReplica = this.grabNewReplica(response, AbstractCollectionsAPIDistributedZkTestBase.getCollectionState(collectionName));
        AbstractCollectionsAPIDistributedZkTestBase.assertEquals((String)"Replica should be created on the right node", (Object)cluster.getZkStateReader().getBaseUrlForNodeName((String)nodeList.get(0)), (Object)newReplica.getBaseUrl());
        Path instancePath = AbstractCollectionsAPIDistributedZkTestBase.createTempDir();
        response = (CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)collectionName, (String)"shard1").withProperty("instanceDir", instancePath.toString()).process((SolrClient)cluster.getSolrClient());
        newReplica = this.grabNewReplica(response, AbstractCollectionsAPIDistributedZkTestBase.getCollectionState(collectionName));
        AbstractCollectionsAPIDistributedZkTestBase.assertNotNull((Object)newReplica);
        try (HttpSolrClient coreclient = AbstractCollectionsAPIDistributedZkTestBase.getHttpSolrClient(newReplica.getBaseUrl());){
            CoreAdminResponse status = CoreAdminRequest.getStatus((String)newReplica.getStr("core"), (SolrClient)coreclient);
            NamedList coreStatus = status.getCoreStatus(newReplica.getStr("core"));
            String instanceDirStr = (String)coreStatus.get("instanceDir");
            AbstractCollectionsAPIDistributedZkTestBase.assertEquals((Object)instanceDirStr, (Object)instancePath.toString());
        }
        String coreName = newReplica.getStr("core");
        SolrException e = (SolrException)AbstractCollectionsAPIDistributedZkTestBase.expectThrows(SolrException.class, () -> {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{"addreplica"});
            params.set("collection", new String[]{collectionName});
            params.set("shard", new String[]{"shard1"});
            params.set("name", new String[]{coreName});
            QueryRequest request = new QueryRequest((SolrParams)params);
            request.setPath("/admin/collections");
            cluster.getSolrClient().request((SolrRequest)request);
        });
        AbstractCollectionsAPIDistributedZkTestBase.assertTrue((boolean)e.getMessage().contains("Another replica with the same core name already exists for this collection"));
        response = (CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)collectionName, (String)"shard1").withProperty("name", "propertyDotName").process((SolrClient)cluster.getSolrClient());
        newReplica = this.grabNewReplica(response, AbstractCollectionsAPIDistributedZkTestBase.getCollectionState(collectionName));
        AbstractCollectionsAPIDistributedZkTestBase.assertEquals((String)"'core' should be 'propertyDotName' ", (Object)"propertyDotName", (Object)newReplica.getStr("core"));
    }

    private Replica grabNewReplica(CollectionAdminResponse response, DocCollection docCollection) {
        String replicaName = (String)response.getCollectionCoresStatus().keySet().iterator().next();
        Optional<Replica> optional = docCollection.getReplicas().stream().filter(replica -> replicaName.equals(replica.getCoreName())).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new AssertionError((Object)("Can not find " + replicaName + " from " + docCollection));
    }
}

