/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.util.TimeOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackupStatusChecker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final SolrClient client;
    final String path;

    public BackupStatusChecker(SolrClient client, String path) {
        this.client = client;
        this.path = path;
    }

    public BackupStatusChecker(SolrClient client) {
        this(client, "/replication");
    }

    public String waitForBackupSuccess(String backupName, int timeLimitInSeconds) throws Exception {
        return this.waitForBackupSuccess(backupName, new TimeOut((long)timeLimitInSeconds, TimeUnit.SECONDS, TimeSource.NANO_TIME));
    }

    public String waitForBackupSuccess(String backupName, TimeOut timeOut) throws Exception {
        String newDirName;
        LuceneTestCase.assertNotNull((String)"backupName must not be null", (Object)backupName);
        while (!timeOut.hasTimedOut()) {
            newDirName = this.checkBackupSuccess(backupName);
            if (null != newDirName) {
                return newDirName;
            }
            timeOut.sleep(50L);
        }
        newDirName = this.checkBackupSuccess(backupName);
        LuceneTestCase.assertNotNull((String)(backupName + " did not succeed before the TimeOut elapsed"), (Object)newDirName);
        return newDirName;
    }

    public String waitForDifferentBackupDir(String directoryName, int timeLimitInSeconds) throws Exception {
        return this.waitForDifferentBackupDir(directoryName, new TimeOut((long)timeLimitInSeconds, TimeUnit.SECONDS, TimeSource.NANO_TIME));
    }

    public String waitForDifferentBackupDir(String directoryName, TimeOut timeOut) throws Exception {
        String newDirName;
        while (!timeOut.hasTimedOut()) {
            newDirName = this.checkBackupSuccess();
            if (null != newDirName && !newDirName.equals(directoryName)) {
                return newDirName;
            }
            timeOut.sleep(50L);
        }
        newDirName = this.checkBackupSuccess();
        LuceneTestCase.assertTrue((String)("No successful backup with different directoryName then " + directoryName + " before TimeOut elapsed"), (null != newDirName && !newDirName.equals(directoryName) ? 1 : 0) != 0);
        return newDirName;
    }

    public String checkBackupSuccess() throws Exception {
        return this._checkBackupSuccess(null);
    }

    public String checkBackupSuccess(String backupName) throws Exception {
        LuceneTestCase.assertNotNull((String)"backupName must not be null", (Object)backupName);
        return this._checkBackupSuccess(backupName);
    }

    private String _checkBackupSuccess(String backupName) throws Exception {
        String label = null == backupName ? "latest backup" : backupName;
        SimpleSolrResponse rsp = (SimpleSolrResponse)new GenericSolrRequest(SolrRequest.METHOD.GET, this.path, (SolrParams)SolrTestCaseJ4.params("command", "details")).process(this.client);
        NamedList data = rsp.getResponse();
        log.info("Checking Status of {}: {}", (Object)label, (Object)data);
        NamedList backupData = (NamedList)data.findRecursive(new String[]{"details", "backup"});
        if (null == backupData) {
            return null;
        }
        Object exception = backupData.get("exception");
        LuceneTestCase.assertNull((String)("Backup failure: " + label), (Object)exception);
        if ("success".equals(backupData.get("status")) && (null == backupName || backupName.equals(backupData.get("snapshotName")))) {
            assert (null != backupData.get("directoryName"));
            return (String)backupData.get("directoryName");
        }
        return null;
    }

    public void waitForBackupDeletionSuccess(String backupName, int timeLimitInSeconds) throws Exception {
        this.waitForBackupDeletionSuccess(backupName, new TimeOut((long)timeLimitInSeconds, TimeUnit.SECONDS, TimeSource.NANO_TIME));
    }

    public void waitForBackupDeletionSuccess(String backupName, TimeOut timeOut) throws Exception {
        LuceneTestCase.assertNotNull((String)"backumpName must not be null", (Object)backupName);
        while (!timeOut.hasTimedOut()) {
            if (this.checkBackupDeletionSuccess(backupName)) {
                return;
            }
            timeOut.sleep(50L);
        }
        LuceneTestCase.assertTrue((String)(backupName + " was not reported as deleted before the TimeOut elapsed"), (boolean)this.checkBackupDeletionSuccess(backupName));
    }

    public boolean checkBackupDeletionSuccess(String backupName) throws Exception {
        LuceneTestCase.assertNotNull((String)"backumpName must not be null", (Object)backupName);
        SimpleSolrResponse rsp = (SimpleSolrResponse)new GenericSolrRequest(SolrRequest.METHOD.GET, this.path, (SolrParams)SolrTestCaseJ4.params("command", "details")).process(this.client);
        NamedList data = rsp.getResponse();
        log.info("Checking Deletion Status of {}: {}", (Object)backupName, (Object)data);
        NamedList backupData = (NamedList)data.findRecursive(new String[]{"details", "backup"});
        if (null == backupData || null == backupData.get("status") || !backupName.equals(backupData.get("snapshotName"))) {
            return false;
        }
        Object status = backupData.get("status");
        if (status.toString().startsWith("Unable to delete")) {
            LuceneTestCase.assertNull((String)("Backup Deleting failure: " + backupName), (Object)status);
        }
        return "success".equals(status) && null != backupData.get("snapshotDeletedAt");
    }
}

