/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.SchemaField;

public class SortableBinaryField
extends BinaryField {
    protected void checkSupportsDocValues() {
    }

    public List<IndexableField> createFields(SchemaField field, Object value) {
        if (field.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            IndexableField storedField = this.createField(field, value);
            fields.add(storedField);
            ByteBuffer byteBuffer = this.toObject(storedField);
            BytesRef bytes = new BytesRef(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            if (field.multiValued()) {
                fields.add((IndexableField)new SortedSetDocValuesField(field.getName(), bytes));
            } else {
                fields.add((IndexableField)new SortedDocValuesField(field.getName(), bytes));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(field, value));
    }

    public SortField getSortField(SchemaField field, boolean reverse) {
        field.checkSortability();
        return new BinarySortField(field.getName(), reverse);
    }

    public Object marshalSortValue(Object value) {
        return SortableBinaryField.marshalBase64SortValue((Object)value);
    }

    public Object unmarshalSortValue(Object value) {
        return SortableBinaryField.unmarshalBase64SortValue((Object)value);
    }

    private static class BinarySortField
    extends SortField {
        public BinarySortField(String field, boolean reverse) {
            super(field, new FieldComparatorSource(){

                public FieldComparator.TermOrdValComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
                    return new FieldComparator.TermOrdValComparator(numHits, fieldname);
                }
            }, reverse);
        }
    }
}

