/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Random;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.util.SSLTestConfig;

@Documented
@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface RandomizeSSL {
    public static final double DEFAULT_ODDS = 0.2;

    public String reason() default "";

    public double ssl() default NaN;

    public double clientAuth() default NaN;

    public double value() default NaN;

    public static final class SSLRandomizer {
        public final double ssl;
        public final double clientAuth;
        public final String debug;

        public SSLRandomizer(double ssl, double clientAuth, String debug) {
            this.ssl = ssl;
            this.clientAuth = clientAuth;
            this.debug = debug;
        }

        public SSLTestConfig createSSLTestConfig() {
            boolean useSSL = TestUtil.nextInt((Random)LuceneTestCase.random(), (int)0, (int)999) < (int)(1000.0 * SSLRandomizer.getEffectiveOdds(this.ssl, LuceneTestCase.TEST_NIGHTLY, LuceneTestCase.RANDOM_MULTIPLIER));
            boolean useClientAuth = TestUtil.nextInt((Random)LuceneTestCase.random(), (int)0, (int)999) < (int)(1000.0 * SSLRandomizer.getEffectiveOdds(this.clientAuth, LuceneTestCase.TEST_NIGHTLY, LuceneTestCase.RANDOM_MULTIPLIER));
            return new SSLTestConfig(useSSL, useClientAuth);
        }

        public static double getEffectiveOdds(double declaredOdds, boolean nightly, int multiplier) {
            assert (declaredOdds <= 1.0);
            assert (0.0 <= declaredOdds);
            if (declaredOdds == 0.0 || declaredOdds == 1.0) {
                return declaredOdds;
            }
            assert (0 < multiplier);
            return 1.0 - (1.0 - declaredOdds) / ((nightly ? 1.1 : 1.0) * (1.0 + Math.log(multiplier)));
        }

        public static final SSLRandomizer getSSLRandomizerForClass(Class<?> clazz) {
            double clientAuth;
            double ssl;
            double def;
            SolrTestCaseJ4.SuppressSSL suppressSSL = clazz.getAnnotation(SolrTestCaseJ4.SuppressSSL.class);
            if (null != suppressSSL) {
                return new SSLRandomizer(0.0, 0.0, suppressSSL.toString());
            }
            RandomizeSSL randomizeSSL = clazz.getAnnotation(RandomizeSSL.class);
            if (null == randomizeSSL) {
                return new SSLRandomizer(0.0, 0.0, RandomizeSSL.class.getName() + " annotation not specified");
            }
            double d = def = Double.isNaN(randomizeSSL.value()) ? 0.2 : randomizeSSL.value();
            if (def < 0.0 || 1.0 < def) {
                throw new IllegalArgumentException(clazz.getName() + ": default value is not a ratio between 0 and 1: " + randomizeSSL.toString());
            }
            double d2 = ssl = Double.isNaN(randomizeSSL.ssl()) ? def : randomizeSSL.ssl();
            if (ssl < 0.0 || 1.0 < ssl) {
                throw new IllegalArgumentException(clazz.getName() + ": ssl value is not a ratio between 0 and 1: " + randomizeSSL.toString());
            }
            double d3 = clientAuth = Double.isNaN(randomizeSSL.clientAuth()) ? ssl : randomizeSSL.clientAuth();
            if (clientAuth < 0.0 || 1.0 < clientAuth) {
                throw new IllegalArgumentException(clazz.getName() + ": clientAuth value is not a ratio between 0 and 1: " + randomizeSSL.toString());
            }
            return new SSLRandomizer(ssl, clientAuth, randomizeSSL.toString());
        }
    }
}

