/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.IdUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMoveReplicaTestBase
extends SolrCloudTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean inPlaceMove = true;
    protected boolean isCollectionApiDistributed = false;

    protected String getConfigSet() {
        return "cloud-dynamic";
    }

    @Before
    public void beforeTest() throws Exception {
        this.inPlaceMove = true;
        AbstractMoveReplicaTestBase.configureCluster(4).addConfig("conf1", AbstractMoveReplicaTestBase.configset(this.getConfigSet())).addConfig("conf2", AbstractMoveReplicaTestBase.configset(this.getConfigSet())).withSolrXml(AbstractMoveReplicaTestBase.TEST_PATH().resolve("solr.xml")).configure();
        this.isCollectionApiDistributed = ((CollectionAdminRequest.RequestApiDistributedProcessingResponse)new CollectionAdminRequest.RequestApiDistributedProcessing().process((SolrClient)cluster.getSolrClient())).getIsCollectionApiDistributed();
        if (this.isCollectionApiDistributed) {
            return;
        }
        NamedList overSeerStatus = cluster.getSolrClient().request((SolrRequest)CollectionAdminRequest.getOverseerStatus());
        JettySolrRunner overseerJetty = null;
        String overseerLeader = (String)overSeerStatus.get("leader");
        for (JettySolrRunner jetty : cluster.getJettySolrRunners()) {
            if (!jetty.getNodeName().equals(overseerLeader)) continue;
            overseerJetty = jetty;
            break;
        }
        if (overseerJetty == null) {
            AbstractMoveReplicaTestBase.fail((String)"no overseer leader!");
        }
    }

    @After
    public void afterTest() throws Exception {
        try {
            AbstractMoveReplicaTestBase.shutdownCluster();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void test() throws Exception {
        boolean hasLeaders;
        boolean allActive;
        Collection replicas;
        DocCollection collState;
        int i;
        String coll = AbstractMoveReplicaTestBase.getTestClass().getSimpleName() + "_coll_" + this.inPlaceMove;
        if (log.isInfoEnabled()) {
            log.info("total_jettys: {}", (Object)cluster.getJettySolrRunners().size());
        }
        int REPLICATION = 2;
        CloudSolrClient cloudClient = cluster.getSolrClient();
        boolean isTlog = AbstractMoveReplicaTestBase.random().nextBoolean();
        CollectionAdminRequest.Create create = CollectionAdminRequest.createCollection((String)coll, (String)"conf1", (Integer)2, (Integer)1, (Integer)(isTlog ? 1 : 0), (Integer)(!isTlog ? 1 : 0));
        cloudClient.request((SolrRequest)create);
        this.addDocs(coll, 100);
        Replica replica = this.getRandomReplica(coll, cloudClient);
        Set liveNodes = cloudClient.getClusterState().getLiveNodes();
        ArrayList l = new ArrayList(liveNodes);
        Collections.shuffle(l, AbstractMoveReplicaTestBase.random());
        String targetNode = null;
        for (Object node : liveNodes) {
            if (replica.getNodeName().equals(node)) continue;
            targetNode = node;
            break;
        }
        AbstractMoveReplicaTestBase.assertNotNull(targetNode);
        String shardId = null;
        for (Slice slice : cloudClient.getClusterState().getCollection(coll).getSlices()) {
            if (!slice.getReplicas().contains(replica)) continue;
            shardId = slice.getName();
        }
        int sourceNumCores = this.getNumOfCores(cloudClient, replica.getNodeName(), coll, replica.getType().name());
        int targetNumCores = this.getNumOfCores(cloudClient, targetNode, coll, replica.getType().name());
        CollectionAdminRequest.MoveReplica moveReplica = this.createMoveReplicaRequest(coll, replica, targetNode);
        moveReplica.setInPlaceMove(this.inPlaceMove);
        String asyncId = IdUtils.randomId();
        moveReplica.processAsync(asyncId, (SolrClient)cloudClient);
        CollectionAdminRequest.RequestStatus requestStatus = CollectionAdminRequest.requestStatus((String)asyncId);
        boolean success = false;
        for (int i2 = 0; i2 < 200; ++i2) {
            CollectionAdminRequest.RequestStatusResponse rsp = (CollectionAdminRequest.RequestStatusResponse)requestStatus.process((SolrClient)cloudClient);
            if (rsp.getRequestStatus() == RequestStatusState.COMPLETED) {
                success = true;
                break;
            }
            AbstractMoveReplicaTestBase.assertNotSame((Object)rsp.getRequestStatus(), (Object)RequestStatusState.FAILED);
            Thread.sleep(500L);
        }
        AbstractMoveReplicaTestBase.assertTrue((boolean)success);
        AbstractMoveReplicaTestBase.assertEquals((String)"should be one less core on the source node!", (long)(sourceNumCores - 1), (long)this.getNumOfCores(cloudClient, replica.getNodeName(), coll, replica.getType().name()));
        AbstractMoveReplicaTestBase.assertEquals((String)"should be one more core on target node!", (long)(targetNumCores + 1), (long)this.getNumOfCores(cloudClient, targetNode, coll, replica.getType().name()));
        boolean recovered = false;
        for (i = 0; i < 300; ++i) {
            collState = AbstractMoveReplicaTestBase.getCollectionState(coll);
            log.debug("###### {}", (Object)collState);
            replicas = collState.getSlice(shardId).getReplicas();
            allActive = true;
            hasLeaders = true;
            if (replicas != null && !replicas.isEmpty()) {
                for (Replica r : replicas) {
                    if (!r.getNodeName().equals(targetNode) || r.isActive(Collections.singleton(targetNode))) continue;
                    log.info("Not active: {}", (Object)r);
                    allActive = false;
                }
            } else {
                allActive = false;
            }
            for (Slice slice : collState.getSlices()) {
                if (slice.getLeader() != null) continue;
                hasLeaders = false;
            }
            if (allActive && hasLeaders) {
                AbstractMoveReplicaTestBase.assertEquals((String)"total number of replicas", (long)REPLICATION, (long)replicas.size());
                recovered = true;
                break;
            }
            log.info("--- waiting, allActive={}, hasLeaders={}", (Object)allActive, (Object)hasLeaders);
            Thread.sleep(1000L);
        }
        AbstractMoveReplicaTestBase.assertTrue((String)"replica never fully recovered", (boolean)recovered);
        AbstractMoveReplicaTestBase.assertEquals((long)100L, (long)cluster.getSolrClient().query(coll, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
        moveReplica = this.createMoveReplicaRequest(coll, replica, targetNode, shardId);
        moveReplica.setInPlaceMove(this.inPlaceMove);
        moveReplica.process((SolrClient)cloudClient);
        this.checkNumOfCores(cloudClient, replica.getNodeName(), coll, sourceNumCores);
        recovered = false;
        for (i = 0; i < 300; ++i) {
            collState = AbstractMoveReplicaTestBase.getCollectionState(coll);
            log.debug("###### {}", (Object)collState);
            replicas = collState.getSlice(shardId).getReplicas();
            allActive = true;
            hasLeaders = true;
            if (replicas != null && !replicas.isEmpty()) {
                for (Replica r : replicas) {
                    if (!r.getNodeName().equals(replica.getNodeName()) || r.isActive(Collections.singleton(replica.getNodeName()))) continue;
                    log.info("Not active yet: {}", (Object)r);
                    allActive = false;
                }
            } else {
                allActive = false;
            }
            for (Slice slice : collState.getSlices()) {
                if (slice.getLeader() != null) continue;
                hasLeaders = false;
            }
            if (allActive && hasLeaders) {
                AbstractMoveReplicaTestBase.assertEquals((String)"total number of replicas", (long)REPLICATION, (long)replicas.size());
                recovered = true;
                break;
            }
            Thread.sleep(1000L);
        }
        AbstractMoveReplicaTestBase.assertTrue((String)"replica never fully recovered", (boolean)recovered);
        AbstractMoveReplicaTestBase.assertEquals((long)100L, (long)cluster.getSolrClient().query(coll, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
    }

    @Test
    public void testFailedMove() throws Exception {
        Replica replica;
        String coll = AbstractMoveReplicaTestBase.getTestClass().getSimpleName() + "_failed_coll_" + this.inPlaceMove;
        int REPLICATION = 2;
        CloudSolrClient cloudClient = cluster.getSolrClient();
        boolean isTlog = AbstractMoveReplicaTestBase.random().nextBoolean();
        CollectionAdminRequest.Create create = CollectionAdminRequest.createCollection((String)coll, (String)"conf1", (Integer)2, (Integer)1, (Integer)(isTlog ? 1 : 0), (Integer)(!isTlog ? 1 : 0));
        cloudClient.request((SolrRequest)create);
        this.addDocs(coll, 100);
        NamedList overSeerStatus = cluster.getSolrClient().request((SolrRequest)CollectionAdminRequest.getOverseerStatus());
        String overseerLeader = (String)overSeerStatus.get("leader");
        int count = 10;
        while (!(replica = this.getRandomReplica(coll, cloudClient)).getNodeName().equals(overseerLeader) && count-- > 0) {
        }
        AbstractMoveReplicaTestBase.assertNotNull((String)"could not find non-overseer replica???", (Object)replica);
        Set liveNodes = cloudClient.getClusterState().getLiveNodes();
        ArrayList l = new ArrayList(liveNodes);
        Collections.shuffle(l, AbstractMoveReplicaTestBase.random());
        String targetNode = null;
        for (String node : liveNodes) {
            if (replica.getNodeName().equals(node) || !this.isCollectionApiDistributed && overseerLeader.equals(node)) continue;
            targetNode = node;
            break;
        }
        AbstractMoveReplicaTestBase.assertNotNull(targetNode);
        CollectionAdminRequest.MoveReplica moveReplica = this.createMoveReplicaRequest(coll, replica, targetNode);
        moveReplica.setInPlaceMove(this.inPlaceMove);
        String asyncId = IdUtils.randomId();
        moveReplica.processAsync(asyncId, (SolrClient)cloudClient);
        for (int i = 0; i < cluster.getJettySolrRunners().size(); ++i) {
            if (!cluster.getJettySolrRunner(i).getNodeName().equals(targetNode)) continue;
            JettySolrRunner j = cluster.stopJettySolrRunner(i);
            cluster.waitForJettyToStop(j);
            break;
        }
        CollectionAdminRequest.RequestStatus requestStatus = CollectionAdminRequest.requestStatus((String)asyncId);
        boolean success = true;
        for (int i = 0; i < 200; ++i) {
            CollectionAdminRequest.RequestStatusResponse rsp = (CollectionAdminRequest.RequestStatusResponse)requestStatus.process((SolrClient)cloudClient);
            AbstractMoveReplicaTestBase.assertNotSame((String)rsp.getRequestStatus().toString(), (Object)rsp.getRequestStatus(), (Object)RequestStatusState.COMPLETED);
            if (rsp.getRequestStatus() == RequestStatusState.FAILED) {
                success = false;
                break;
            }
            Thread.sleep(500L);
        }
        AbstractMoveReplicaTestBase.assertFalse((boolean)success);
        if (log.isInfoEnabled()) {
            log.info("--- current collection state: {}", (Object)cloudClient.getClusterState().getCollection(coll));
        }
        AbstractMoveReplicaTestBase.assertEquals((long)100L, (long)cluster.getSolrClient().query(coll, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
    }

    private CollectionAdminRequest.MoveReplica createMoveReplicaRequest(String coll, Replica replica, String targetNode, String shardId) {
        return new CollectionAdminRequest.MoveReplica(coll, shardId, targetNode, replica.getNodeName());
    }

    private CollectionAdminRequest.MoveReplica createMoveReplicaRequest(String coll, Replica replica, String targetNode) {
        return new CollectionAdminRequest.MoveReplica(coll, replica.getName(), targetNode);
    }

    private Replica getRandomReplica(String coll, CloudSolrClient cloudClient) throws IOException {
        List replicas = cloudClient.getClusterState().getCollection(coll).getReplicas();
        Collections.shuffle(replicas, AbstractMoveReplicaTestBase.random());
        return (Replica)replicas.get(0);
    }

    private void checkNumOfCores(CloudSolrClient cloudClient, String nodeName, String collectionName, int expectedCores) throws IOException, SolrServerException {
        AbstractMoveReplicaTestBase.assertEquals((String)(nodeName + " does not have expected number of cores"), (long)expectedCores, (long)this.getNumOfCores(cloudClient, nodeName, collectionName));
    }

    private int getNumOfCores(CloudSolrClient cloudClient, String nodeName, String collectionName) throws IOException, SolrServerException {
        return this.getNumOfCores(cloudClient, nodeName, collectionName, null);
    }

    private int getNumOfCores(CloudSolrClient cloudClient, String nodeName, String collectionName, String replicaType) throws IOException, SolrServerException {
        try (HttpSolrClient coreclient = AbstractMoveReplicaTestBase.getHttpSolrClient(ZkStateReader.from((CloudSolrClient)cloudClient).getBaseUrlForNodeName(nodeName));){
            CoreAdminResponse status = CoreAdminRequest.getStatus(null, (SolrClient)coreclient);
            if (status.getCoreStatus().size() == 0) {
                int n = 0;
                return n;
            }
            if (collectionName == null && replicaType == null) {
                int n = status.getCoreStatus().size();
                return n;
            }
            int size = 0;
            for (Map.Entry stringNamedListEntry : status.getCoreStatus()) {
                String type;
                String coll;
                if (collectionName != null && !collectionName.equals(coll = (String)((NamedList)stringNamedListEntry.getValue()).findRecursive(new String[]{"cloud", "collection"})) || replicaType != null && !replicaType.equals(type = (String)((NamedList)stringNamedListEntry.getValue()).findRecursive(new String[]{"cloud", "replicaType"}))) continue;
                ++size;
            }
            int n = size;
            return n;
        }
    }

    protected void addDocs(String collection, int numDocs) throws Exception {
        CloudSolrClient solrClient = cluster.getSolrClient();
        for (int docId = 1; docId <= numDocs; ++docId) {
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("id", (Object)docId);
            solrClient.add(collection, doc);
        }
        solrClient.commit(collection);
        Thread.sleep(5000L);
    }
}

