/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.commons.io.file.PathUtils;
import org.apache.http.client.HttpClient;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.embedded.JettyConfig;
import org.apache.solr.embedded.JettySolrRunner;
import org.apache.solr.util.DirectoryUtil;
import org.apache.solr.util.ExternalPaths;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrJettyTestBase
extends SolrTestCaseJ4 {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static JettySolrRunner jetty;
    public static int port;
    public static SolrClient client;
    public static String context;

    @BeforeClass
    public static void beforeSolrJettyTestBase() throws Exception {
    }

    public static JettySolrRunner createAndStartJetty(String solrHome, String configFile, String schemaFile, String context, boolean stopAtShutdown, SortedMap<ServletHolder, String> extraServlets) throws Exception {
        SolrJettyTestBase.context = context = context == null ? "/solr" : context;
        JettyConfig jettyConfig = JettyConfig.builder().setContext(context).stopAtShutdown(stopAtShutdown).withServlets(extraServlets).withSSLConfig(sslConfig.buildServerSSLConfig()).build();
        Properties nodeProps = new Properties();
        if (configFile != null) {
            nodeProps.setProperty("solrconfig", configFile);
        }
        if (schemaFile != null) {
            nodeProps.setProperty("schema", schemaFile);
        }
        if (System.getProperty("solr.data.dir") == null && System.getProperty("solr.hdfs.home") == null) {
            nodeProps.setProperty("solr.data.dir", SolrJettyTestBase.createTempDir().toFile().getCanonicalPath());
        }
        return SolrJettyTestBase.createAndStartJetty(solrHome, nodeProps, jettyConfig);
    }

    public static JettySolrRunner createAndStartJetty(String solrHome, String configFile, String context) throws Exception {
        return SolrJettyTestBase.createAndStartJetty(solrHome, configFile, null, context, true, null);
    }

    public static JettySolrRunner createAndStartJetty(String solrHome, JettyConfig jettyConfig) throws Exception {
        return SolrJettyTestBase.createAndStartJetty(solrHome, new Properties(), jettyConfig);
    }

    public static JettySolrRunner createAndStartJetty(String solrHome) throws Exception {
        return SolrJettyTestBase.createAndStartJetty(solrHome, new Properties(), JettyConfig.builder().withSSLConfig(sslConfig.buildServerSSLConfig()).build());
    }

    public static JettySolrRunner createAndStartJetty(String solrHome, Properties nodeProperties, JettyConfig jettyConfig) throws Exception {
        SolrJettyTestBase.initCore(null, null, solrHome);
        Path coresDir = SolrJettyTestBase.createTempDir().resolve("cores");
        Properties props = new Properties();
        props.setProperty("name", "collection1");
        props.setProperty("configSet", "collection1");
        props.setProperty("config", "${solrconfig:solrconfig.xml}");
        props.setProperty("schema", "${schema:schema.xml}");
        SolrJettyTestBase.writeCoreProperties(coresDir.resolve("core"), props, "RestTestBase");
        Properties nodeProps = new Properties(nodeProperties);
        nodeProps.setProperty("coreRootDirectory", coresDir.toString());
        nodeProps.setProperty("configSetBaseDir", solrHome);
        jetty = new JettySolrRunner(solrHome, nodeProps, jettyConfig);
        jetty.start();
        port = jetty.getLocalPort();
        log.info("Jetty Assigned Port#{}", (Object)port);
        return jetty;
    }

    protected String getServerUrl() {
        return jetty.getBaseUrl().toString() + "/collection1";
    }

    @After
    public synchronized void afterClass() throws Exception {
        if (client != null) {
            client.close();
        }
        client = null;
    }

    @AfterClass
    public static void afterSolrJettyTestBase() throws Exception {
        if (jetty != null) {
            jetty.stop();
            jetty = null;
        }
    }

    public synchronized SolrClient getSolrClient() {
        if (client == null) {
            client = this.createNewSolrClient();
        }
        return client;
    }

    public SolrClient createNewSolrClient() {
        return SolrJettyTestBase.getHttpSolrClient(this.getServerUrl());
    }

    public HttpClient getHttpClient() {
        HttpSolrClient client = (HttpSolrClient)this.getSolrClient();
        return client.getHttpClient();
    }

    public static void setupJettyTestHome(File solrHome, String collection) throws Exception {
        SolrJettyTestBase.copySolrHomeToTemp(solrHome, collection);
    }

    public static void cleanUpJettyHome(File solrHome) throws Exception {
        if (solrHome.exists()) {
            PathUtils.deleteDirectory((Path)solrHome.toPath());
        }
    }

    public static String legacyExampleCollection1SolrHome() {
        String sourceHome = ExternalPaths.SOURCE_HOME;
        if (sourceHome == null) {
            throw new IllegalStateException("No source home! Cannot create the legacy example solr home directory.");
        }
        try {
            Path tempSolrHome = LuceneTestCase.createTempDir();
            Path serverSolr = tempSolrHome.getFileSystem().getPath(sourceHome, "server", "solr");
            Files.copy(serverSolr.resolve("solr.xml"), tempSolrHome.resolve("solr.xml"), new CopyOption[0]);
            Path sourceConfig = serverSolr.resolve("configsets").resolve("sample_techproducts_configs");
            Path collection1Dir = tempSolrHome.resolve("collection1");
            DirectoryUtil.copyDirectoryContents(sourceConfig.resolve("conf"), collection1Dir.resolve("conf"));
            Properties props = new Properties();
            props.setProperty("name", "collection1");
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(collection1Dir.resolve("core.properties"), new OpenOption[0]), StandardCharsets.UTF_8);){
                props.store(writer, null);
            }
            return tempSolrHome.toString();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        client = null;
    }
}

