/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.cloud.StoppableIndexingThread;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.embedded.JettySolrRunner;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecoveryZkTestBase
extends SolrCloudTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<StoppableIndexingThread> threads = new ArrayList<StoppableIndexingThread>();

    @BeforeClass
    public static void setupCluster() throws Exception {
        AbstractRecoveryZkTestBase.configureCluster(2).addConfig("conf", AbstractRecoveryZkTestBase.configset("cloud-minimal")).configure();
    }

    @After
    public void stopThreads() throws InterruptedException {
        for (StoppableIndexingThread t : this.threads) {
            t.safeStop();
        }
        for (StoppableIndexingThread t : this.threads) {
            t.join();
        }
        this.threads.clear();
    }

    @Test
    public void test() throws Exception {
        String collection = "recoverytest";
        CollectionAdminRequest.createCollection((String)"recoverytest", (String)"conf", (int)1, (int)2).process((SolrClient)cluster.getSolrClient());
        AbstractRecoveryZkTestBase.waitForState("Expected a collection with one shard and two replicas", "recoverytest", AbstractRecoveryZkTestBase.clusterShape(1, 2));
        cluster.getSolrClient().setDefaultCollection("recoverytest");
        int[] maxDocList = new int[]{300, 700, 1200, 1350, 3000};
        int[] maxDocNightlyList = new int[]{3000, 7000, 12000, 30000, 45000, 60000};
        int maxDoc = !TEST_NIGHTLY ? maxDocList[AbstractRecoveryZkTestBase.random().nextInt(maxDocList.length - 1)] : maxDocNightlyList[AbstractRecoveryZkTestBase.random().nextInt(maxDocList.length - 1)];
        log.info("Indexing {} documents", (Object)maxDoc);
        StoppableIndexingThread indexThread = new StoppableIndexingThread(null, (SolrClient)cluster.getSolrClient(), "1", true, maxDoc, 1, true);
        this.threads.add(indexThread);
        indexThread.start();
        StoppableIndexingThread indexThread2 = new StoppableIndexingThread(null, (SolrClient)cluster.getSolrClient(), "2", true, maxDoc, 1, true);
        this.threads.add(indexThread2);
        indexThread2.start();
        int[] waitTimes = new int[]{200, 2000, 3000};
        Thread.sleep(waitTimes[AbstractRecoveryZkTestBase.random().nextInt(waitTimes.length - 1)]);
        DocCollection state = AbstractRecoveryZkTestBase.getCollectionState("recoverytest");
        Replica leader = state.getLeader("shard1");
        Replica replica = AbstractRecoveryZkTestBase.getRandomReplica(state.getSlice("shard1"), r -> !leader.equals(r));
        JettySolrRunner jetty = cluster.getReplicaJetty(replica);
        jetty.stop();
        Thread.sleep(waitTimes[AbstractRecoveryZkTestBase.random().nextInt(waitTimes.length - 1)]);
        jetty.start();
        Thread.sleep(3000L);
        indexThread.safeStop();
        indexThread2.safeStop();
        indexThread.join();
        indexThread2.join();
        new UpdateRequest().commit((SolrClient)cluster.getSolrClient(), "recoverytest");
        cluster.getZkStateReader().waitForState("recoverytest", 120L, TimeUnit.SECONDS, AbstractRecoveryZkTestBase.clusterShape(1, 2));
        state = AbstractRecoveryZkTestBase.getCollectionState("recoverytest");
        this.assertShardConsistency(state.getSlice("shard1"), true);
    }

    private void assertShardConsistency(Slice shard, boolean expectDocs) throws Exception {
        List replicas = shard.getReplicas(r -> r.getState() == Replica.State.ACTIVE);
        long[] numCounts = new long[replicas.size()];
        int i = 0;
        for (Replica replica : replicas) {
            HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(replica.getCoreUrl()).withHttpClient(((CloudLegacySolrClient)cluster.getSolrClient()).getHttpClient())).build();
            try {
                numCounts[i] = client.query((SolrParams)new SolrQuery("*:*").add("distrib", new String[]{"false"})).getResults().getNumFound();
                ++i;
            }
            finally {
                if (client == null) continue;
                client.close();
            }
        }
        for (int j = 1; j < replicas.size(); ++j) {
            if (numCounts[j] != numCounts[j - 1]) {
                AbstractRecoveryZkTestBase.fail((String)"Mismatch in counts between replicas");
            }
            if (numCounts[j] != 0L || !expectDocs) continue;
            AbstractRecoveryZkTestBase.fail((String)("Expected docs on shard " + shard.getName() + " but found none"));
        }
    }
}

