/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.util.BaseTestHarness;
import org.apache.solr.util.RESTfulServerProvider;

public class RestTestHarness
extends BaseTestHarness
implements Closeable {
    private RESTfulServerProvider serverProvider;
    private CloseableHttpClient httpClient = HttpClientUtil.createClient((SolrParams)new ModifiableSolrParams());

    public RestTestHarness(RESTfulServerProvider serverProvider) {
        this.serverProvider = serverProvider;
    }

    public String getBaseURL() {
        return this.serverProvider.getBaseURL();
    }

    public void setServerProvider(RESTfulServerProvider serverProvider) {
        this.serverProvider = serverProvider;
    }

    public RESTfulServerProvider getServerProvider() {
        return this.serverProvider;
    }

    public String getAdminURL() {
        return this.getBaseURL().replace("/collection1", "");
    }

    public String validateQuery(String request, String ... tests) throws Exception {
        String res = this.query(request);
        return RestTestHarness.validateXPath(res, tests);
    }

    public String validatePut(String request, String content, String ... tests) throws Exception {
        String res = this.put(request, content);
        return RestTestHarness.validateXPath(res, tests);
    }

    public String query(String request) throws IOException {
        return this.getResponse((HttpUriRequest)new HttpGet(this.getBaseURL() + request));
    }

    public String adminQuery(String request) throws IOException {
        return this.getResponse((HttpUriRequest)new HttpGet(this.getAdminURL() + request));
    }

    public String head(String request) throws IOException {
        HttpHead httpHead = new HttpHead(this.getBaseURL() + request);
        return this.httpClient.execute((HttpUriRequest)httpHead, (HttpContext)HttpClientUtil.createNewHttpClientRequestContext()).toString();
    }

    public String put(String request, String content) throws IOException {
        HttpPut httpPut = new HttpPut(this.getBaseURL() + request);
        httpPut.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)));
        return this.getResponse((HttpUriRequest)httpPut);
    }

    public String delete(String request) throws IOException {
        HttpDelete httpDelete = new HttpDelete(this.getBaseURL() + request);
        return this.getResponse((HttpUriRequest)httpDelete);
    }

    public String post(String request, String content) throws IOException {
        HttpPost httpPost = new HttpPost(this.getBaseURL() + request);
        httpPost.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)));
        return this.getResponse((HttpUriRequest)httpPost);
    }

    public String checkResponseStatus(String xml, String code) throws Exception {
        try {
            String response = this.query(xml);
            String valid = RestTestHarness.validateXPath(response, "//int[@name='status']=" + code);
            return null == valid ? null : response;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("?!? static xpath has bug?", e);
        }
    }

    public String checkAdminResponseStatus(String xml, String code) throws Exception {
        try {
            String response = this.adminQuery(xml);
            String valid = RestTestHarness.validateXPath(response, "//int[@name='status']=" + code);
            return null == valid ? null : response;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("?!? static xpath has bug?", e);
        }
    }

    @Override
    public void reload() throws Exception {
        String coreName = (String)RestTestHarness.evaluateXPath(this.adminQuery("/admin/cores?wt=xml&action=STATUS"), "//lst[@name='status']/lst[1]/str[@name='name']", XPathConstants.STRING);
        String xml = this.checkAdminResponseStatus("/admin/cores?wt=xml&action=RELOAD&core=" + coreName, "0");
        if (null != xml) {
            throw new RuntimeException("RELOAD failed:\n" + xml);
        }
    }

    @Override
    public String update(String xml) {
        try {
            return this.query("/update?stream.body=" + URLEncoder.encode(xml, "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(HttpUriRequest request) throws IOException {
        String string;
        HttpEntity entity = null;
        try {
            entity = this.httpClient.execute(request, (HttpContext)HttpClientUtil.createNewHttpClientRequestContext()).getEntity();
            string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            EntityUtils.consumeQuietly(entity);
            throw throwable;
        }
        EntityUtils.consumeQuietly((HttpEntity)entity);
        return string;
    }

    @Override
    public void close() throws IOException {
        HttpClientUtil.close((HttpClient)this.httpClient);
    }
}

