/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.rules.SystemPropertiesRestoreRule;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;
import org.apache.http.client.HttpClient;
import org.apache.logging.log4j.Level;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.analysis.MockTokenizer;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.Constants;
import org.apache.solr.JSONTestUtil;
import org.apache.solr.SolrTestCase;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.cloud.IpTables;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.cloud.TestConnectionStrategy;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.embedded.JettyConfig;
import org.apache.solr.embedded.JettySolrRunner;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.servlet.DirectSolrConnection;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.DistributedZkUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.BaseTestHarness;
import org.apache.solr.util.ErrorLogMuter;
import org.apache.solr.util.LogLevel;
import org.apache.solr.util.RandomizeSSL;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.SSLTestConfig;
import org.apache.solr.util.StartupLoggingUtils;
import org.apache.solr.util.TestHarness;
import org.apache.solr.util.TestInjection;
import org.apache.zookeeper.KeeperException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.noggit.CharArr;
import org.noggit.JSONUtil;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@LuceneTestCase.SuppressFileSystems(value={"ExtrasFS"})
@RandomizeSSL
public abstract class SolrTestCaseJ4
extends SolrTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_TEST_COLLECTION_NAME = "collection1";
    public static final String DEFAULT_TEST_CORENAME = "collection1";
    protected static final String CORE_PROPERTIES_FILENAME = "core.properties";
    public static final String SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICYFACTORY = "solr.tests.mergePolicyFactory";
    public static final String TEST_URL_ALLOW_LIST = "solr.tests.allowUrls";
    protected static String coreName = "collection1";
    public static int DEFAULT_CONNECTION_TIMEOUT = 60000;
    private static String initialRootLogLevel;
    protected static volatile ExecutorService testExecutor;
    public static volatile SSLTestConfig sslConfig;
    @Rule
    public TestRule solrTestRules = RuleChain.outerRule((TestRule)new SystemPropertiesRestoreRule());
    public static final String DEAD_HOST_1 = "[::1]:4";
    public static final String DEAD_HOST_2 = "[::1]:6";
    public static final String DEAD_HOST_3 = "[::1]:8";
    @SuppressForbidden(reason="Using the Level class from log4j2 directly")
    private static Map<String, Level> savedClassLogLevels;
    private Map<String, Level> savedMethodLogLevels = new HashMap<String, Level>();
    private static boolean changedFactory;
    private static String savedFactory;
    private static final AtomicInteger dataDirCount;
    static long numOpens;
    static long numCloses;
    private static final Map<String, ErrorLogMuter> errorMuters;
    protected static String configString;
    protected static String schemaString;
    protected static Path testSolrHome;
    protected static SolrConfig solrConfig;
    protected static TestHarness h;
    protected static TestHarness.LocalRequestFactory lrf;
    @Deprecated
    protected static volatile File initCoreDataDir;
    protected static String hdfsDataDir;
    private static String factoryProp;
    public static final IRange ZERO_ONE;
    public static final IRange ZERO_TWO;
    public static final IRange ONE_ONE;
    public static final String USE_NUMERIC_POINTS_SYSPROP = "solr.tests.use.numeric.points";
    public static final String NUMERIC_POINTS_SYSPROP = "solr.tests.numeric.points";
    public static final String NUMERIC_DOCVALUES_SYSPROP = "solr.tests.numeric.dv";
    public static final String UPDATELOG_SYSPROP = "solr.tests.ulog";
    private static final Map<Class<?>, String> private_RANDOMIZED_NUMERIC_FIELDTYPES;
    protected static final Map<Class<?>, String> RANDOMIZED_NUMERIC_FIELDTYPES;

    protected void writeCoreProperties(Path coreDirectory, String coreName) throws IOException {
        Properties props = new Properties();
        props.setProperty("name", coreName);
        props.setProperty("configSet", "collection1");
        props.setProperty("config", "${solrconfig:solrconfig.xml}");
        props.setProperty("schema", "${schema:schema.xml}");
        SolrTestCaseJ4.writeCoreProperties(coreDirectory, props, this.getSaferTestName());
    }

    public static void writeCoreProperties(Path coreDirectory, Properties properties, String testname) throws IOException {
        log.info("Writing core.properties file to {}", (Object)coreDirectory);
        Files.createDirectories(coreDirectory, new FileAttribute[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(coreDirectory.resolve(CORE_PROPERTIES_FILENAME), new OpenOption[0]), StandardCharsets.UTF_8);){
            properties.store(writer, testname);
        }
    }

    protected void assertExceptionThrownWithMessageContaining(Class<? extends Throwable> expectedType, List<String> expectedStrings, LuceneTestCase.ThrowingRunnable runnable) {
        Throwable thrown = SolrTestCaseJ4.expectThrows(expectedType, (LuceneTestCase.ThrowingRunnable)runnable);
        if (expectedStrings != null) {
            for (String expectedString : expectedStrings) {
                MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)StringContains.containsString((String)expectedString));
            }
        }
    }

    @BeforeClass
    public static void setupTestCases() {
        initialRootLogLevel = StartupLoggingUtils.getLogLevelString();
        SolrTestCaseJ4.initClassLogLevels();
        SolrTestCaseJ4.resetExceptionIgnores();
        testExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 15L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("testExecutor"), true);
        SolrTestCaseJ4.initAndGetDataDir();
        System.setProperty("solr.zkclienttimeout", "90000");
        System.setProperty("solr.httpclient.retries", "1");
        System.setProperty("solr.retries.on.forward", "1");
        System.setProperty("solr.retries.to.followers", "1");
        System.setProperty("solr.v2RealPath", "true");
        System.setProperty("zookeeper.forceSync", "no");
        System.setProperty("jetty.testMode", "true");
        System.setProperty("solr.zookeeper.connectionStrategy", TestConnectionStrategy.class.getName());
        System.setProperty("enable.update.log", Boolean.toString(SolrTestCaseJ4.usually()));
        System.setProperty("tests.shardhandler.randomSeed", Long.toString(SolrTestCaseJ4.random().nextLong()));
        System.setProperty("solr.clustering.enabled", "false");
        System.setProperty("solr.cloud.wait-for-updates-with-stale-state-pause", "500");
        System.setProperty("solr.filterCache.async", String.valueOf(SolrTestCaseJ4.random().nextBoolean()));
        System.setProperty("solr.http.disableCookies", Boolean.toString(SolrTestCaseJ4.rarely()));
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        SolrTestCaseJ4.startTrackingSearchers();
        SolrTestCaseJ4.ignoreException("ignore_exception");
        SolrTestCaseJ4.newRandomConfig();
        sslConfig = SolrTestCaseJ4.buildSSLConfig();
        HttpClientUtil.setSocketFactoryRegistryProvider((HttpClientUtil.SocketFactoryRegistryProvider)sslConfig.buildClientSocketFactoryRegistryProvider());
        Http2SolrClient.setDefaultSSLConfig((SSLConfig)sslConfig.buildClientSSLConfig());
        if (SolrTestCaseJ4.isSSLMode()) {
            System.setProperty("urlScheme", "https");
        }
        SolrTestCaseJ4.resetGlobalTracer();
        ExecutorUtil.resetThreadLocalProviders();
    }

    @SuppressForbidden(reason="Hack to reset internal state of GlobalTracer")
    public static void resetGlobalTracer() {
        AccessController.doPrivileged(() -> {
            try {
                Class<GlobalTracer> globalTracerClass = GlobalTracer.class;
                Field isRegistered = globalTracerClass.getDeclaredField("isRegistered");
                isRegistered.setAccessible(true);
                isRegistered.setBoolean(null, false);
                Field tracer = globalTracerClass.getDeclaredField("tracer");
                tracer.setAccessible(true);
                tracer.set(null, NoopTracerFactory.create());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
        assert (!GlobalTracer.isRegistered());
    }

    @AfterClass
    public static void teardownTestCases() throws Exception {
        TestInjection.notifyPauseForeverDone();
        try {
            try {
                SolrTestCaseJ4.deleteCore();
            }
            catch (Exception e) {
                log.error("Error deleting SolrCore.");
            }
            if (null != testExecutor) {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)testExecutor);
                testExecutor = null;
            }
            SolrTestCaseJ4.resetExceptionIgnores();
            SolrTestCaseJ4.resetFactory();
            coreName = "collection1";
        }
        finally {
            ObjectReleaseTracker.clear();
            TestInjection.reset();
            initCoreDataDir = null;
            System.clearProperty("solr.v2RealPath");
            System.clearProperty("zookeeper.forceSync");
            System.clearProperty("jetty.testMode");
            System.clearProperty("tests.shardhandler.randomSeed");
            System.clearProperty("enable.update.log");
            System.clearProperty("useCompoundFile");
            System.clearProperty("urlScheme");
            System.clearProperty("solr.cloud.wait-for-updates-with-stale-state-pause");
            System.clearProperty("solr.zkclienttmeout");
            System.clearProperty("zookeeper.4lw.commands.whitelist");
            HttpClientUtil.resetHttpClientBuilder();
            Http2SolrClient.resetSslContextFactory();
            SolrTestCaseJ4.clearNumericTypesProperties();
            sslConfig = null;
            testSolrHome = null;
            IpTables.unblockAllPorts();
            LogLevel.Configurer.restoreLogLevels(savedClassLogLevels);
            savedClassLogLevels.clear();
            StartupLoggingUtils.changeLogLevel((String)initialRootLogLevel);
        }
    }

    public static void assumeWorkingMockito() {
        try {
            Class.forName("net.bytebuddy.ClassFileVersion").getMethod("ofThisVm", new Class[0]).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            RandomizedTest.assumeNoException((String)"SOLR-11606: ByteBuddy used by Mockito is not working with this JVM version.", (Throwable)e.getTargetException());
        }
        catch (ReflectiveOperationException e) {
            SolrTestCaseJ4.fail((String)("ByteBuddy and Mockito are not available on classpath: " + e.toString()));
        }
    }

    public static void initClassLogLevels() {
        Class currentClass = RandomizedContext.current().getTargetClass();
        LogLevel annotation = currentClass.getAnnotation(LogLevel.class);
        if (annotation == null) {
            return;
        }
        Map<String, Level> previousLevels = LogLevel.Configurer.setLevels(annotation.value());
        savedClassLogLevels.putAll(previousLevels);
    }

    @Before
    public void initMethodLogLevels() {
        Method method = RandomizedContext.current().getTargetMethod();
        LogLevel annotation = method.getAnnotation(LogLevel.class);
        if (annotation == null) {
            return;
        }
        Map<String, Level> previousLevels = LogLevel.Configurer.setLevels(annotation.value());
        this.savedMethodLogLevels.putAll(previousLevels);
    }

    @After
    public void restoreMethodLogLevels() {
        LogLevel.Configurer.restoreLogLevels(this.savedMethodLogLevels);
        this.savedMethodLogLevels.clear();
    }

    protected static boolean isSSLMode() {
        return sslConfig != null && sslConfig.isSSLMode();
    }

    public static void useFactory(String factory) throws Exception {
        if (!changedFactory) {
            savedFactory = System.getProperty("solr.DirectoryFactory");
        }
        if (factory == null) {
            factory = SolrTestCaseJ4.random().nextInt(100) < 75 ? "solr.NRTCachingDirectoryFactory" : "solr.StandardDirectoryFactory";
        }
        System.setProperty("solr.directoryFactory", factory);
        changedFactory = true;
    }

    public static void resetFactory() throws Exception {
        if (!changedFactory) {
            return;
        }
        changedFactory = false;
        if (savedFactory != null) {
            System.setProperty("solr.directoryFactory", savedFactory);
            savedFactory = null;
        } else {
            System.clearProperty("solr.directoryFactory");
        }
    }

    private static SSLTestConfig buildSSLConfig() {
        RandomizeSSL.SSLRandomizer sslRandomizer = RandomizeSSL.SSLRandomizer.getSSLRandomizerForClass(RandomizedContext.current().getTargetClass());
        if (Constants.MAC_OS_X) {
            sslRandomizer = new RandomizeSSL.SSLRandomizer(sslRandomizer.ssl, 0.0, sslRandomizer.debug + " w/ MAC_OS_X supressed clientAuth");
        }
        SSLTestConfig result = sslRandomizer.createSSLTestConfig();
        if (log.isInfoEnabled()) {
            log.info("Randomized ssl ({}) and clientAuth ({}) via: {}", new Object[]{result.isSSLMode(), result.isClientAuthMode(), sslRandomizer.debug});
        }
        return result;
    }

    protected static JettyConfig buildJettyConfig(String context) {
        return JettyConfig.builder().setContext(context).withSSLConfig(sslConfig.buildServerSSLConfig()).build();
    }

    protected static String buildUrl(int port, String context) {
        return (SolrTestCaseJ4.isSSLMode() ? "https" : "http") + "://127.0.0.1:" + port + context;
    }

    protected static MockTokenizer whitespaceMockTokenizer(Reader input) throws IOException {
        MockTokenizer mockTokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        mockTokenizer.setReader(input);
        return mockTokenizer;
    }

    protected static MockTokenizer whitespaceMockTokenizer(String input) throws IOException {
        MockTokenizer mockTokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        mockTokenizer.setReader((Reader)new StringReader(input));
        return mockTokenizer;
    }

    public static void setupNoCoreTest(Path solrHome, String xmlStr) throws Exception {
        if (xmlStr == null) {
            xmlStr = "<solr></solr>";
        }
        Files.write(solrHome.resolve("solr.xml"), xmlStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        h = new TestHarness(SolrXmlConfig.fromSolrHome((Path)solrHome, (Properties)new Properties()));
        lrf = h.getRequestFactory("/select", 0, 20, "version", "2.2");
    }

    public static void newRandomConfig() {
        IndexWriterConfig iwc = SolrTestCaseJ4.newIndexWriterConfig((Analyzer)new MockAnalyzer(SolrTestCaseJ4.random()));
        System.setProperty("useCompoundFile", String.valueOf(iwc.getUseCompoundFile()));
        System.setProperty("solr.tests.maxBufferedDocs", String.valueOf(iwc.getMaxBufferedDocs()));
        System.setProperty("solr.tests.ramPerThreadHardLimitMB", String.valueOf(iwc.getRAMPerThreadHardLimitMB()));
        System.setProperty("solr.tests.ramBufferSizeMB", String.valueOf(iwc.getRAMBufferSizeMB()));
        String mergeSchedulerClass = iwc.getMergeScheduler().getClass().getName();
        if (mergeSchedulerClass.contains("$")) {
            mergeSchedulerClass = "org.apache.lucene.index.ConcurrentMergeScheduler";
        }
        System.setProperty("solr.tests.mergeScheduler", mergeSchedulerClass);
        SolrTestCaseJ4.randomizeNumericTypesProperties();
    }

    public static Throwable getWrappedException(Throwable e) {
        while (e != null && e.getCause() != e && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public void setUp() throws Exception {
        super.setUp();
        if (log.isInfoEnabled()) {
            log.info("###Starting {}", (Object)this.getTestName());
        }
    }

    public void tearDown() throws Exception {
        if (log.isInfoEnabled()) {
            log.info("###Ending {}", (Object)this.getTestName());
        }
        super.tearDown();
    }

    protected static File initAndGetDataDir() {
        File dataDir = initCoreDataDir;
        if (null == dataDir) {
            int id = dataDirCount.incrementAndGet();
            dataDir = initCoreDataDir = SolrTestCaseJ4.createTempDir((String)("data-dir-" + id)).toFile();
            SolrTestCaseJ4.assertNotNull((Object)dataDir);
            if (log.isInfoEnabled()) {
                log.info("Created dataDir: {}", (Object)dataDir.getAbsolutePath());
            }
        }
        return dataDir;
    }

    public static void initCore(String config, String schema) throws Exception {
        SolrTestCaseJ4.initCore(config, schema, SolrTestCaseJ4.TEST_HOME());
    }

    public static void initCore(String config, String schema, String solrHome) throws Exception {
        SolrTestCaseJ4.assertNotNull((Object)solrHome);
        configString = config;
        schemaString = schema;
        testSolrHome = Paths.get(solrHome, new String[0]);
        System.setProperty("solr.solr.home", solrHome);
        SolrTestCaseJ4.initCore();
    }

    public static void initCore(String config, String schema, String solrHome, String pCoreName) throws Exception {
        coreName = pCoreName;
        SolrTestCaseJ4.initCore(config, schema, solrHome);
    }

    public static void startTrackingSearchers() {
        numOpens = SolrIndexSearcher.numOpens.getAndSet(0L);
        numCloses = SolrIndexSearcher.numCloses.getAndSet(0L);
        if (numOpens != 0L || numCloses != 0L) {
            log.warn("startTrackingSearchers: numOpens={} numCloses={}", (Object)numOpens, (Object)numCloses);
            numCloses = 0L;
            numOpens = 0L;
        }
    }

    @Deprecated
    public static void ignoreException(String pattern) {
        errorMuters.computeIfAbsent(pattern, pat -> ErrorLogMuter.regex(pat));
    }

    @Deprecated
    public static void unIgnoreException(String pattern) {
        errorMuters.computeIfPresent(pattern, (pat, muter) -> {
            IOUtils.closeQuietly((Closeable)muter);
            return null;
        });
    }

    @Deprecated
    public static void resetExceptionIgnores() {
        errorMuters.forEach((k, muter) -> {
            IOUtils.closeQuietly((Closeable)muter);
            errorMuters.remove(k);
        });
        SolrTestCaseJ4.ignoreException("ignore_exception");
    }

    protected static String getClassName() {
        return SolrTestCaseJ4.getTestClass().getName();
    }

    protected static String getSimpleClassName() {
        return SolrTestCaseJ4.getTestClass().getSimpleName();
    }

    public static String getSchemaFile() {
        return schemaString;
    }

    public static String getSolrConfigFile() {
        return configString;
    }

    public static void initCore() throws Exception {
        log.info("####initCore");
        SolrTestCaseJ4.ignoreException("ignore_exception");
        factoryProp = System.getProperty("solr.directoryFactory");
        if (factoryProp == null) {
            System.setProperty("solr.directoryFactory", "solr.RAMDirectoryFactory");
        }
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        String configFile = SolrTestCaseJ4.getSolrConfigFile();
        if (configFile != null) {
            SolrTestCaseJ4.createCore();
        }
        log.info("####initCore end");
    }

    public static void createCore() {
        SolrTestCaseJ4.assertNotNull((Object)testSolrHome);
        solrConfig = TestHarness.createConfig(testSolrHome, coreName, SolrTestCaseJ4.getSolrConfigFile());
        h = new TestHarness(coreName, hdfsDataDir == null ? SolrTestCaseJ4.initAndGetDataDir().getAbsolutePath() : hdfsDataDir, solrConfig, SolrTestCaseJ4.getSchemaFile());
        lrf = h.getRequestFactory("", 0, 20, "version", "2.2");
    }

    public static CoreContainer createCoreContainer(Path solrHome, String solrXML) {
        testSolrHome = Objects.requireNonNull(solrHome);
        System.setProperty("solr.solr.home", solrHome.toAbsolutePath().toString());
        h = new TestHarness(solrHome, solrXML);
        lrf = h.getRequestFactory("", 0, 20, "version", "2.2");
        return h.getCoreContainer();
    }

    public static CoreContainer createCoreContainer(NodeConfig config, CoresLocator locator) {
        testSolrHome = config.getSolrHome();
        h = new TestHarness(config, locator);
        lrf = h.getRequestFactory("", 0, 20, "version", "2.2");
        return h.getCoreContainer();
    }

    public static CoreContainer createCoreContainer(String coreName, String dataDir, String solrConfig, String schema) {
        NodeConfig nodeConfig = TestHarness.buildTestNodeConfig(SolrTestCaseJ4.TEST_PATH());
        TestHarness.TestCoresLocator locator = new TestHarness.TestCoresLocator(coreName, dataDir, solrConfig, schema);
        CoreContainer cc = SolrTestCaseJ4.createCoreContainer(nodeConfig, locator);
        SolrTestCaseJ4.h.coreName = coreName;
        return cc;
    }

    public static CoreContainer createDefaultCoreContainer(Path solrHome) {
        testSolrHome = Objects.requireNonNull(solrHome);
        System.setProperty("solr.solr.home", solrHome.toAbsolutePath().toString());
        h = new TestHarness("collection1", SolrTestCaseJ4.initAndGetDataDir().getAbsolutePath(), "solrconfig.xml", "schema.xml");
        lrf = h.getRequestFactory("", 0, 20, "version", "2.2");
        return h.getCoreContainer();
    }

    public static boolean hasInitException(String message) {
        for (Map.Entry entry : h.getCoreContainer().getCoreInitFailures().entrySet()) {
            if (!((CoreContainer.CoreLoadFailure)entry.getValue()).exception.getMessage().contains(message)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInitException(Class<? extends Exception> exceptionType) {
        for (Map.Entry entry : h.getCoreContainer().getCoreInitFailures().entrySet()) {
            if (!exceptionType.isAssignableFrom(((CoreContainer.CoreLoadFailure)entry.getValue()).exception.getClass())) continue;
            return true;
        }
        return false;
    }

    public void postSetUp() {
        if (log.isInfoEnabled()) {
            log.info("####POSTSETUP {}", (Object)this.getTestName());
        }
    }

    public void preTearDown() {
        if (log.isInfoEnabled()) {
            log.info("####PRETEARDOWN {}", (Object)this.getTestName());
        }
    }

    public static void deleteCore() {
        if (h != null) {
            log.info("###deleteCore");
            CoreContainer cc = h.getCoreContainer();
            if (cc.getNumAllCores() > 0 && cc.isZooKeeperAware()) {
                try {
                    cc.getZkController().getZkClient().exists("/", false);
                }
                catch (KeeperException e) {
                    log.error("Testing connectivity to ZK by checking for root path failed", (Throwable)e);
                    SolrTestCaseJ4.fail((String)"Trying to tear down a ZK aware core container with ZK not reachable");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            h.close();
        }
        if (factoryProp == null) {
            System.clearProperty("solr.directoryFactory");
        }
        if (System.getProperty(UPDATELOG_SYSPROP) != null) {
            System.clearProperty(UPDATELOG_SYSPROP);
        }
        solrConfig = null;
        h = null;
        lrf = null;
        schemaString = null;
        configString = null;
        initCoreDataDir = null;
        hdfsDataDir = null;
    }

    public static void assertU(String update) {
        SolrTestCaseJ4.assertU(null, update);
    }

    public static void assertU(String message, String update) {
        SolrTestCaseJ4.checkUpdateU(message, update, true);
    }

    public static void assertFailedU(String update) {
        SolrTestCaseJ4.assertFailedU(null, update);
    }

    public static void assertFailedU(String message, String update) {
        SolrTestCaseJ4.checkUpdateU(message, update, false);
    }

    private static void checkUpdateU(String message, String update, boolean shouldSucceed) {
        try {
            Object m;
            Object object = m = null == message ? "" : message + " ";
            if (shouldSucceed) {
                String res = h.validateUpdate(update);
                if (res != null) {
                    SolrTestCaseJ4.fail((String)((String)m + "update was not successful: " + res));
                }
            } else {
                String res = h.validateErrorUpdate(update);
                if (res != null) {
                    SolrTestCaseJ4.fail((String)((String)m + "update succeeded, but should have failed: " + res));
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid XML", e);
        }
    }

    public static void assertQ(SolrQueryRequest req, String ... tests) {
        SolrTestCaseJ4.assertQ(null, req, tests);
    }

    public static void assertQ(String message, SolrQueryRequest req, String ... tests) {
        try {
            String results;
            Object m = null == message ? "" : message + " ";
            ModifiableSolrParams xmlWriterTypeParams = new ModifiableSolrParams(req.getParams());
            xmlWriterTypeParams.set("wt", new String[]{"xml"});
            xmlWriterTypeParams.set("indent", new String[]{xmlWriterTypeParams.get("indent", "off")});
            req.setParams((SolrParams)xmlWriterTypeParams);
            String response = h.query(req);
            if (req.getParams().getBool("facet", false)) {
                String[] allTests = new String[tests.length + 1];
                System.arraycopy(tests, 0, allTests, 1, tests.length);
                allTests[0] = "*[count(//lst[@name='facet_counts']/*[@name='exception'])=0]";
                tests = allTests;
            }
            if (null != (results = BaseTestHarness.validateXPath(response, tests))) {
                String msg = "REQUEST FAILED: xpath=" + results + "\n\txml response was: " + response + "\n\trequest was:" + req.getParamString();
                SolrTestCaseJ4.fail((String)msg);
            }
        }
        catch (XPathExpressionException e1) {
            throw new RuntimeException("XPath is invalid", e1);
        }
        catch (Exception e2) {
            log.error("REQUEST FAILED: {}", (Object)req.getParamString(), (Object)e2);
            throw new RuntimeException("Exception during query", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String JQ(SolrQueryRequest req) throws Exception {
        String response;
        SolrParams params = req.getParams();
        if (!"json".equals(params.get("wt", "xml")) || params.get("indent") == null) {
            ModifiableSolrParams newParams = new ModifiableSolrParams(params);
            newParams.set("wt", new String[]{"json"});
            if (params.get("indent") == null) {
                newParams.set("indent", new String[]{"true"});
            }
            req.setParams((SolrParams)newParams);
        }
        boolean failed = true;
        try {
            response = h.query(req);
            failed = false;
        }
        finally {
            if (failed) {
                log.error("REQUEST FAILED: {}", (Object)req.getParamString());
            }
        }
        return response;
    }

    public static String assertJQ(SolrQueryRequest req, String ... tests) throws Exception {
        return SolrTestCaseJ4.assertJQ(req, 1.0E-5, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String assertJQ(SolrQueryRequest req, double delta, String ... tests) throws Exception {
        SolrParams params = null;
        try {
            String response;
            params = req.getParams();
            if (!"json".equals(params.get("wt", "xml")) || params.get("indent") == null) {
                ModifiableSolrParams newParams = new ModifiableSolrParams(params);
                newParams.set("wt", new String[]{"json"});
                if (params.get("indent") == null) {
                    newParams.set("indent", new String[]{"true"});
                }
                req.setParams((SolrParams)newParams);
            }
            boolean failed = true;
            try {
                response = h.query(req);
                failed = false;
            }
            finally {
                if (failed) {
                    log.error("REQUEST FAILED: {}", (Object)req.getParamString());
                }
            }
            for (String test : tests) {
                if (test == null || test.length() == 0) continue;
                String testJSON = SolrTestCaseJ4.json(test);
                try {
                    failed = true;
                    String err = JSONTestUtil.match(response, testJSON, delta);
                    failed = false;
                    if (err != null) {
                        log.error("query failed JSON validation. error={}\n expected ={}\n response = {}\n request = {}", new Object[]{err, testJSON, response, req.getParamString()});
                        throw new RuntimeException(err);
                    }
                    if (!failed) continue;
                }
                catch (Throwable throwable) {
                    if (failed) {
                        log.error("JSON query validation threw an exception.\n expected ={} \n response = {}\n request = {}", new Object[]{testJSON, response, req.getParamString()});
                    }
                    throw throwable;
                }
                log.error("JSON query validation threw an exception.\n expected ={} \n response = {}\n request = {}", new Object[]{testJSON, response, req.getParamString()});
            }
            String string = response;
            return string;
        }
        finally {
            if (params != null && params != req.getParams()) {
                req.setParams(params);
            }
        }
    }

    public static void assertQEx(String message, SolrQueryRequest req, int code) {
        try {
            SolrTestCaseJ4.ignoreException(".");
            h.query(req);
            SolrTestCaseJ4.fail((String)message);
        }
        catch (SolrException sex) {
            SolrTestCaseJ4.assertEquals((long)code, (long)sex.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
        finally {
            SolrTestCaseJ4.unIgnoreException(".");
        }
    }

    public static void assertQEx(String message, SolrQueryRequest req, SolrException.ErrorCode code) {
        try {
            SolrTestCaseJ4.ignoreException(".");
            h.query(req);
            SolrTestCaseJ4.fail((String)message);
        }
        catch (SolrException e) {
            SolrTestCaseJ4.assertEquals((long)code.code, (long)e.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
        finally {
            SolrTestCaseJ4.unIgnoreException(".");
        }
    }

    public static void assertQEx(String failMessage, String exceptionMessage, SolrQueryRequest req, SolrException.ErrorCode code) {
        try {
            SolrTestCaseJ4.ignoreException(".");
            h.query(req);
            SolrTestCaseJ4.fail((String)failMessage);
        }
        catch (SolrException e) {
            SolrTestCaseJ4.assertEquals((long)code.code, (long)e.code());
            SolrTestCaseJ4.assertTrue((String)("Unexpected error message. Expecting \"" + exceptionMessage + "\" but got \"" + e.getMessage() + "\""), (e.getMessage() != null && e.getMessage().contains(exceptionMessage) ? 1 : 0) != 0);
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
        finally {
            SolrTestCaseJ4.unIgnoreException(".");
        }
    }

    public static String optimize(String ... args) {
        return TestHarness.optimize(args);
    }

    public static String commit(String ... args) {
        return TestHarness.commit(args);
    }

    public static String adoc(String ... fieldsAndValues) {
        XmlDoc d = SolrTestCaseJ4.doc(fieldsAndValues);
        return SolrTestCaseJ4.add(d, new String[0]);
    }

    public static String adoc(SolrInputDocument sdoc) {
        StringWriter out = new StringWriter(512);
        try {
            out.append("<add>");
            ClientUtils.writeXML((SolrInputDocument)sdoc, (Writer)out);
            out.append("</add>");
        }
        catch (IOException e) {
            throw new RuntimeException("Inexplicable IO error from StringWriter", e);
        }
        return out.toString();
    }

    public static void addDoc(String doc, String updateRequestProcessorChain) throws Exception {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        MultiMapSolrParams mmparams = new MultiMapSolrParams(params);
        params.put("update.chain", new String[]{updateRequestProcessorChain});
        SolrQueryRequestBase req = new SolrQueryRequestBase(h.getCore(), (SolrParams)mmparams){};
        UpdateRequestHandler handler = new UpdateRequestHandler();
        handler.init(null);
        ArrayList<ContentStreamBase.StringStream> streams = new ArrayList<ContentStreamBase.StringStream>(2);
        streams.add(new ContentStreamBase.StringStream(doc));
        req.setContentStreams(streams);
        handler.handleRequestBody((SolrQueryRequest)req, new SolrQueryResponse());
        req.close();
    }

    public static String add(XmlDoc doc, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                r.write("<add>");
                r.write(doc.xml);
                r.write("</add>");
            } else {
                XML.writeUnescapedXML((Writer)r, (String)"add", (String)doc.xml, (Object[])args);
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String delI(String id) {
        return TestHarness.deleteById(id, new String[0]);
    }

    public static String delQ(String q) {
        return TestHarness.deleteByQuery(q, new String[0]);
    }

    public static XmlDoc doc(String ... fieldsAndValues) {
        XmlDoc d = new XmlDoc();
        d.xml = TestHarness.makeSimpleDoc(fieldsAndValues);
        return d;
    }

    public static ModifiableSolrParams params(String ... params) {
        if (params.length % 2 != 0) {
            throw new RuntimeException("Params length should be even");
        }
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    public static Map<String, String> map(String ... params) {
        return Utils.makeMap((String[])params);
    }

    public static Map<String, Object> map(Object ... params) {
        return Utils.makeMap((Object[])params);
    }

    public static SolrQueryRequest req(String ... q) {
        return lrf.makeRequest(q);
    }

    public static SolrQueryRequest req(String[] params, String ... moreParams) {
        String[] allParams = moreParams;
        if (params.length != 0) {
            int len = params.length + moreParams.length;
            allParams = new String[len];
            System.arraycopy(params, 0, allParams, 0, params.length);
            System.arraycopy(moreParams, 0, allParams, params.length, moreParams.length);
        }
        return lrf.makeRequest(allParams);
    }

    public static SolrQueryRequest req(SolrParams params, String ... moreParams) {
        ModifiableSolrParams mp = new ModifiableSolrParams(params);
        for (int i = 0; i < moreParams.length; i += 2) {
            mp.add(moreParams[i], new String[]{moreParams[i + 1]});
        }
        return new LocalSolrQueryRequest(h.getCore(), (SolrParams)mp);
    }

    public void clearIndex() {
        if (null == h) {
            return;
        }
        try {
            SolrTestCaseJ4.deleteByQueryAndGetVersion("*:*", (SolrParams)SolrTestCaseJ4.params("_version_", Long.toString(-9223372036854775807L), "update.distrib", DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String updateJ(String json, SolrParams args) throws Exception {
        SolrCore core = h.getCore();
        if (args == null) {
            args = SolrTestCaseJ4.params("wt", "json", "indent", "true");
        } else {
            ModifiableSolrParams newArgs = new ModifiableSolrParams(args);
            if (newArgs.get("wt") == null) {
                newArgs.set("wt", new String[]{"json"});
            }
            if (newArgs.get("indent") == null) {
                newArgs.set("indent", new String[]{"true"});
            }
            args = newArgs;
        }
        DirectSolrConnection connection = new DirectSolrConnection(core);
        SolrRequestHandler handler = core.getRequestHandler("/update/json");
        if (handler == null) {
            handler = new UpdateRequestHandler();
            handler.init(null);
        }
        return connection.request(handler, args, json);
    }

    public static SolrInputDocument sdoc(Object ... fieldsAndValues) {
        SolrInputDocument sd = new SolrInputDocument();
        for (int i = 0; i < fieldsAndValues.length; i += 2) {
            sd.addField((String)fieldsAndValues[i], fieldsAndValues[i + 1]);
        }
        return sd;
    }

    public SolrInputDocument sdocWithChildren(String id, String version) {
        return this.sdocWithChildren(id, version, 2);
    }

    public SolrInputDocument sdocWithChildren(String id, String version, int childCount) {
        SolrInputDocument doc = SolrTestCaseJ4.sdoc("id", id, "_version_", version);
        for (int i = 1; i <= childCount; ++i) {
            doc.addChildDocument(SolrTestCaseJ4.sdoc("id", id + "_child" + i));
        }
        return doc;
    }

    public SolrInputDocument sdocWithChildren(Integer id, String version, int childCount) {
        SolrInputDocument doc = SolrTestCaseJ4.sdoc("id", id, "_version_", version);
        for (int i = 1; i <= childCount; ++i) {
            doc.addChildDocument(SolrTestCaseJ4.sdoc("id", 1000 * id + i));
        }
        return doc;
    }

    public static List<SolrInputDocument> sdocs(SolrInputDocument ... docs) {
        return Arrays.asList(docs);
    }

    public static String json(String testJSON) {
        return testJSON;
    }

    public static String json(SolrInputDocument doc) {
        CharArr out = new CharArr();
        SolrTestCaseJ4.json(doc, out);
        return out.toString();
    }

    public static void json(SolrInputDocument doc, CharArr out) {
        try {
            out.append('{');
            boolean firstField = true;
            for (SolrInputField sfield : doc) {
                if (firstField) {
                    firstField = false;
                } else {
                    out.append(',');
                }
                JSONUtil.writeString((String)sfield.getName(), (int)0, (int)sfield.getName().length(), (CharArr)out);
                out.append(':');
                if (sfield.getValueCount() > 1) {
                    out.append('[');
                    boolean firstVal = true;
                    for (Object val : sfield) {
                        if (firstVal) {
                            firstVal = false;
                        } else {
                            out.append(',');
                        }
                        if (val instanceof SolrInputDocument) {
                            SolrTestCaseJ4.json((SolrInputDocument)val, out);
                        }
                        out.append((CharSequence)JSONUtil.toJSON(val));
                    }
                    out.append(']');
                    continue;
                }
                if (sfield.getValue() instanceof SolrInputDocument) {
                    SolrTestCaseJ4.json((SolrInputDocument)sfield.getValue(), out);
                    continue;
                }
                if (sfield.getValue() instanceof Map) {
                    HashMap valMap = (HashMap)sfield.getValue();
                    Set childDocsKeys = valMap.entrySet().stream().filter(record -> SolrTestCaseJ4.isChildDoc(record.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    if (childDocsKeys.size() > 0) {
                        HashMap newMap = new HashMap();
                        for (Map.Entry entry : valMap.entrySet()) {
                            String keyName = (String)entry.getKey();
                            Object val = entry.getValue();
                            if (childDocsKeys.contains(keyName)) {
                                val = val instanceof Collection ? ((Collection)val).stream().map(e -> SolrTestCaseJ4.toSolrDoc((SolrInputDocument)e)).collect(Collectors.toList()) : SolrTestCaseJ4.toSolrDoc((SolrInputDocument)val);
                            }
                            newMap.put(keyName, val);
                        }
                        valMap = newMap;
                    }
                    out.append((CharSequence)JSONUtil.toJSON((Object)valMap));
                    continue;
                }
                out.append((CharSequence)JSONUtil.toJSON((Object)sfield.getValue()));
            }
            boolean firstChildDoc = true;
            if (doc.hasChildDocuments()) {
                out.append((CharSequence)",\"_childDocuments_\": [");
                List childDocuments = doc.getChildDocuments();
                for (SolrInputDocument childDocument : childDocuments) {
                    if (firstChildDoc) {
                        firstChildDoc = false;
                    } else {
                        out.append(',');
                    }
                    SolrTestCaseJ4.json(childDocument, out);
                }
                out.append(']');
            }
            out.append('}');
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String jsonAdd(SolrInputDocument ... docs) {
        CharArr out = new CharArr();
        try {
            out.append('[');
            boolean firstField = true;
            for (SolrInputDocument doc : docs) {
                if (firstField) {
                    firstField = false;
                } else {
                    out.append(',');
                }
                out.append((CharSequence)SolrTestCaseJ4.json(doc));
            }
            out.append(']');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static String jsonDelId(Object ... ids) {
        CharArr out = new CharArr();
        try {
            out.append('{');
            boolean first = true;
            for (Object id : ids) {
                if (first) {
                    first = false;
                } else {
                    out.append(',');
                }
                out.append((CharSequence)"\"delete\":{\"id\":");
                out.append((CharSequence)JSONUtil.toJSON((Object)id));
                out.append('}');
            }
            out.append('}');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static String jsonDelQ(String ... queries) {
        CharArr out = new CharArr();
        try {
            out.append('{');
            boolean first = true;
            for (String q : queries) {
                if (first) {
                    first = false;
                } else {
                    out.append(',');
                }
                out.append((CharSequence)"\"delete\":{\"query\":");
                out.append((CharSequence)JSONUtil.toJSON((Object)q));
                out.append('}');
            }
            out.append('}');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static Long addAndGetVersion(SolrInputDocument sdoc, SolrParams params) throws Exception {
        String response;
        Map rsp;
        List lst;
        if (params == null || params.get("versions") == null) {
            ModifiableSolrParams mparams = new ModifiableSolrParams(params);
            mparams.set("versions", new String[]{"true"});
            params = mparams;
        }
        if ((lst = (List)(rsp = (Map)ObjectBuilder.fromJSON((String)(response = SolrTestCaseJ4.updateJ(SolrTestCaseJ4.jsonAdd(sdoc), params)))).get("adds")) == null || lst.size() == 0) {
            return null;
        }
        return (Long)lst.get(1);
    }

    public static Long deleteAndGetVersion(String id, SolrParams params) throws Exception {
        String response;
        Map rsp;
        List lst;
        if (params == null || params.get("versions") == null) {
            ModifiableSolrParams mparams = new ModifiableSolrParams(params);
            mparams.set("versions", new String[]{"true"});
            params = mparams;
        }
        if ((lst = (List)(rsp = (Map)ObjectBuilder.fromJSON((String)(response = SolrTestCaseJ4.updateJ(SolrTestCaseJ4.jsonDelId(id), params)))).get("deletes")) == null || lst.size() == 0) {
            return null;
        }
        return (Long)lst.get(1);
    }

    public static Long deleteByQueryAndGetVersion(String q, SolrParams params) throws Exception {
        String response;
        Map rsp;
        List lst;
        if (params == null || params.get("versions") == null) {
            ModifiableSolrParams mparams = new ModifiableSolrParams(params);
            mparams.set("versions", new String[]{"true"});
            params = mparams;
        }
        if ((lst = (List)(rsp = (Map)ObjectBuilder.fromJSON((String)(response = SolrTestCaseJ4.updateJ(SolrTestCaseJ4.jsonDelQ(q), params)))).get("deleteByQuery")) == null || lst.size() == 0) {
            return null;
        }
        return (Long)lst.get(1);
    }

    public static void assertResponseValues(SolrResponseBase rsp, Object ... assertions) {
        Map values = Utils.makeMap((Object[])assertions);
        values.forEach((s, o) -> {
            if (o instanceof String) {
                SolrTestCaseJ4.assertEquals((Object)o, (Object)rsp.getResponse()._getStr(s, null));
            } else {
                SolrTestCaseJ4.assertEquals((Object)o, (Object)rsp.getResponse()._get(s, null));
            }
        });
    }

    public Map<Comparable, Doc> indexDocs(List<FldType> descriptor, Map<Comparable, Doc> model, int nDocs) throws Exception {
        if (model == null) {
            model = new LinkedHashMap<Comparable, Doc>();
        }
        int commitOneOutOf = Math.max(nDocs / 10, 10);
        for (int i = 0; i < nDocs; ++i) {
            Doc doc = SolrTestCaseJ4.createDoc(descriptor);
            SolrTestCaseJ4.updateJ(SolrTestCaseJ4.toJSON(doc), null);
            model.put(doc.id, doc);
            if (SolrTestCaseJ4.random().nextInt(commitOneOutOf) == 0) {
                SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit(new String[0]));
            }
            if (SolrTestCaseJ4.random().nextInt(10) != 0) continue;
            SolrTestCaseJ4.updateJ(SolrTestCaseJ4.toJSON(doc), null);
            model.put(doc.id, doc);
        }
        if (SolrTestCaseJ4.random().nextInt(10) == 0) {
            SolrTestCaseJ4.assertU(SolrTestCaseJ4.optimize(new String[0]));
        } else if (SolrTestCaseJ4.random().nextInt(10) == 0) {
            SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit(new String[0]));
        } else {
            SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit("softCommit", "true"));
        }
        String responseStr = h.query(SolrTestCaseJ4.req("q", "*:*", "fl", "id", "sort", "_docid_ asc", "rows", Integer.toString(model.size() * 2), "wt", "json", "indent", "true"));
        Object response = ObjectBuilder.fromJSON((String)responseStr);
        response = ((Map)response).get("response");
        response = ((Map)response).get("docs");
        List docList = (List)response;
        int order = 0;
        for (Map doc : docList) {
            Object id = doc.get("id");
            Doc modelDoc = model.get(id);
            if (modelDoc == null) continue;
            modelDoc.order = order++;
        }
        SolrTestCaseJ4.assertEquals((long)order, (long)model.size());
        return model;
    }

    public static Doc createDoc(List<FldType> descriptor) {
        Doc doc = new Doc();
        doc.fields = new ArrayList<Fld>();
        for (FldType ftype : descriptor) {
            Fld fld = ftype.createField();
            if (fld == null) continue;
            doc.fields.add(fld);
            if (!"id".equals(ftype.fname)) continue;
            doc.id = fld.vals.get(0);
        }
        return doc;
    }

    public static Comparator<Doc> createSort(IndexSchema schema, List<FldType> fieldTypes, String[] out) {
        StringBuilder sortSpec = new StringBuilder();
        int nSorts = SolrTestCaseJ4.random().nextInt(4);
        ArrayList<Comparator<Doc>> comparators = new ArrayList<Comparator<Doc>>();
        for (int i = 0; i < nSorts; ++i) {
            if (i > 0) {
                sortSpec.append(',');
            }
            int which = SolrTestCaseJ4.random().nextInt(fieldTypes.size() + 2);
            boolean asc = SolrTestCaseJ4.random().nextBoolean();
            if (which == fieldTypes.size()) {
                sortSpec.append("score").append(asc ? " asc" : " desc");
                comparators.add(SolrTestCaseJ4.createComparator("score", asc, false, false, false));
                continue;
            }
            if (which == fieldTypes.size() + 1) {
                sortSpec.append("_docid_").append(asc ? " asc" : " desc");
                comparators.add(SolrTestCaseJ4.createComparator("_docid_", asc, false, false, false));
                continue;
            }
            String field = fieldTypes.get((int)which).fname;
            sortSpec.append(field).append(asc ? " asc" : " desc");
            SchemaField sf = schema.getField(field);
            comparators.add(SolrTestCaseJ4.createComparator(field, asc, sf.sortMissingLast(), sf.sortMissingFirst(), !sf.sortMissingLast() && !sf.sortMissingFirst()));
        }
        String string = out[0] = sortSpec.length() > 0 ? sortSpec.toString() : null;
        if (comparators.size() == 0) {
            comparators.add(SolrTestCaseJ4.createComparator("score", false, false, false, false));
        }
        return SolrTestCaseJ4.createComparator(comparators);
    }

    public static Comparator<Doc> createComparator(final String field, boolean asc, final boolean sortMissingLast, final boolean sortMissingFirst, boolean sortMissingAsZero) {
        int mul;
        int n = mul = asc ? 1 : -1;
        if (field.equals("_docid_")) {
            return (o1, o2) -> (o1.order - o2.order) * mul;
        }
        if (field.equals("score")) {
            return SolrTestCaseJ4.createComparator("score_f", asc, sortMissingLast, sortMissingFirst, sortMissingAsZero);
        }
        return new Comparator<Doc>(){

            private Comparable zeroVal(Comparable template) {
                if (template == null) {
                    return null;
                }
                if (template instanceof String) {
                    return null;
                }
                if (template instanceof Integer) {
                    return Integer.valueOf(0);
                }
                if (template instanceof Long) {
                    return Long.valueOf(0L);
                }
                if (template instanceof Float) {
                    return Float.valueOf(0.0f);
                }
                if (template instanceof Double) {
                    return Double.valueOf(0.0);
                }
                if (template instanceof Short) {
                    return Short.valueOf((short)0);
                }
                if (template instanceof Byte) {
                    return Byte.valueOf((byte)0);
                }
                if (template instanceof Character) {
                    return Character.valueOf('\u0000');
                }
                return null;
            }

            @Override
            public int compare(Doc o1, Doc o2) {
                Comparable v1 = o1.getFirstValue(field);
                Comparable v2 = o2.getFirstValue(field);
                v1 = v1 == null ? this.zeroVal(v2) : v1;
                v2 = v2 == null ? this.zeroVal(v1) : v2;
                int c = 0;
                c = v1 == v2 ? 0 : (v1 == null ? (sortMissingLast ? mul : (sortMissingFirst ? -mul : -1)) : (v2 == null ? (sortMissingLast ? -mul : (sortMissingFirst ? mul : 1)) : v1.compareTo(v2)));
                return c *= mul;
            }
        };
    }

    public static Comparator<Doc> createComparator(List<Comparator<Doc>> comparators) {
        return (o1, o2) -> {
            int c = 0;
            for (Comparator comparator : comparators) {
                c = comparator.compare(o1, o2);
                if (c == 0) continue;
                return c;
            }
            return o1.order - o2.order;
        };
    }

    public static String toJSON(Doc doc) {
        CharArr out = new CharArr();
        try {
            out.append((CharSequence)"{\"add\":{\"doc\":{");
            boolean firstField = true;
            for (Fld fld : doc.fields) {
                if (firstField) {
                    firstField = false;
                } else {
                    out.append(',');
                }
                JSONUtil.writeString((String)fld.ftype.fname, (int)0, (int)fld.ftype.fname.length(), (CharArr)out);
                out.append(':');
                if (fld.vals.size() > 1) {
                    out.append('[');
                }
                boolean firstVal = true;
                for (Comparable val : fld.vals) {
                    if (firstVal) {
                        firstVal = false;
                    } else {
                        out.append(',');
                    }
                    out.append((CharSequence)JSONUtil.toJSON((Object)val));
                }
                if (fld.vals.size() <= 1) continue;
                out.append(']');
            }
            out.append((CharSequence)"}}}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public Map<Comparable, List<Comparable>> invertField(Map<Comparable, Doc> model, String field) {
        HashMap<Comparable, List<Comparable>> value_to_id = new HashMap<Comparable, List<Comparable>>();
        for (Comparable key : model.keySet()) {
            Doc doc = model.get(key);
            List<Comparable> vals = doc.getValues(field);
            if (vals == null) continue;
            for (Comparable val : vals) {
                ArrayList<Comparable> ids = (ArrayList<Comparable>)value_to_id.get(val);
                if (ids == null) {
                    ids = new ArrayList<Comparable>(2);
                    value_to_id.put(val, ids);
                }
                ids.add(key);
            }
        }
        return value_to_id;
    }

    public static File getFile(String name) {
        URL url = SolrTestCaseJ4.class.getClassLoader().getResource(name.replace(File.separatorChar, '/'));
        if (url != null) {
            try {
                return new File(url.toURI());
            }
            catch (Exception e) {
                throw new RuntimeException("Resource was found on classpath, but cannot be resolved to a normal file (maybe it is part of a JAR file): " + name);
            }
        }
        File file = new File(name);
        if (file.exists()) {
            return file;
        }
        throw new RuntimeException("Cannot find resource in classpath or in file-system (relative to CWD): " + name);
    }

    public static String TEST_HOME() {
        return SolrTestCaseJ4.getFile("solr/collection1").getParent();
    }

    public static Path TEST_PATH() {
        return SolrTestCaseJ4.getFile("solr/collection1").getParentFile().toPath();
    }

    public static Path TEST_COLL1_CONF() {
        return SolrTestCaseJ4.TEST_PATH().resolve("collection1").resolve("conf");
    }

    public static Path configset(String name) {
        return SolrTestCaseJ4.TEST_PATH().resolve("configsets").resolve(name).resolve("conf");
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable result = t;
        for (Throwable cause = t; null != cause; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    public static void assertXmlFile(File file, String ... xpath) throws IOException, SAXException {
        try {
            String xml = Files.readString(file.toPath());
            String results = TestHarness.validateXPath(xml, xpath);
            if (null != results) {
                String msg = "File XPath failure: file=" + file.getPath() + " xpath=" + results + "\n\nxml was: " + xml;
                SolrTestCaseJ4.fail((String)msg);
            }
        }
        catch (XPathExpressionException e2) {
            throw new RuntimeException("XPath is invalid", e2);
        }
    }

    public static void assertFieldValues(SolrDocumentList documents, String fieldName, Object ... expectedValues) {
        if (documents.size() != expectedValues.length) {
            SolrTestCaseJ4.fail((String)("Number of documents (" + documents.size() + ") is different from number of expected values (" + expectedValues.length));
        }
        for (int docNum = 1; docNum <= documents.size(); ++docNum) {
            SolrDocument doc = (SolrDocument)documents.get(docNum - 1);
            Object expected = expectedValues[docNum - 1];
            Object actual = doc.get((Object)fieldName);
            if (!(null == expected && null != actual || null != expected && null == actual) && (null == expected || null == actual || expected.equals(actual))) continue;
            SolrTestCaseJ4.fail((String)("Unexpected " + fieldName + " field value in document #" + docNum + ": expected=[" + expected + "], actual=[" + actual + "]"));
        }
    }

    public static void copyMinConf(File dstRoot) throws IOException {
        SolrTestCaseJ4.copyMinConf(dstRoot, null);
    }

    public static void copyMinConf(File dstRoot, String propertiesContent) throws IOException {
        SolrTestCaseJ4.copyMinConf(dstRoot, propertiesContent, "solrconfig-minimal.xml");
    }

    public static void copyMinConf(File dstRoot, String propertiesContent, String solrconfigXmlName) throws IOException {
        Path dstPath = dstRoot.toPath();
        Path subHome = dstPath.resolve("conf");
        Files.createDirectories(subHome, new FileAttribute[0]);
        if (propertiesContent != null) {
            Files.writeString(dstRoot.toPath().resolve(CORE_PROPERTIES_FILENAME), (CharSequence)propertiesContent, new OpenOption[0]);
        }
        Path top = SolrTestCaseJ4.TEST_PATH().resolve("collection1").resolve("conf");
        Files.copy(top.resolve("schema-tiny.xml"), subHome.resolve("schema.xml"), new CopyOption[0]);
        Files.copy(top.resolve(solrconfigXmlName), subHome.resolve("solrconfig.xml"), new CopyOption[0]);
        Files.copy(top.resolve("solrconfig.snippet.randomindexconfig.xml"), subHome.resolve("solrconfig.snippet.randomindexconfig.xml"), new CopyOption[0]);
    }

    public static void copyMinFullSetup(File dstRoot) throws IOException {
        Files.createDirectories(dstRoot.toPath(), new FileAttribute[0]);
        Files.copy(SolrTestCaseJ4.TEST_PATH().resolve("solr.xml"), dstRoot.toPath().resolve("solr.xml"), new CopyOption[0]);
        SolrTestCaseJ4.copyMinConf(dstRoot);
    }

    public static void copyXmlToHome(File dstRoot, String fromFile) throws IOException {
        Files.createDirectories(dstRoot.toPath(), new FileAttribute[0]);
        Files.copy(SolrTestCaseJ4.TEST_PATH().resolve(fromFile), dstRoot.toPath().resolve("solr.xml"), new CopyOption[0]);
    }

    public static void copySolrHomeToTemp(File dstRoot, String collection) throws IOException {
        Path subHome = dstRoot.toPath().resolve(collection).resolve("conf");
        Files.createDirectories(subHome, new FileAttribute[0]);
        Files.copy(SolrTestCaseJ4.TEST_PATH().resolve("solr.xml"), dstRoot.toPath().resolve("solr.xml"), StandardCopyOption.REPLACE_EXISTING);
        Path top = SolrTestCaseJ4.TEST_PATH().resolve("collection1").resolve("conf");
        Files.copy(top.resolve("currency.xml"), subHome.resolve("currency.xml"), new CopyOption[0]);
        Files.copy(top.resolve("mapping-ISOLatin1Accent.txt"), subHome.resolve("mapping-ISOLatin1Accent.txt"), new CopyOption[0]);
        Files.copy(top.resolve("old_synonyms.txt"), subHome.resolve("old_synonyms.txt"), new CopyOption[0]);
        Files.copy(top.resolve("open-exchange-rates.json"), subHome.resolve("open-exchange-rates.json"), new CopyOption[0]);
        Files.copy(top.resolve("protwords.txt"), subHome.resolve("protwords.txt"), new CopyOption[0]);
        Files.copy(top.resolve("schema.xml"), subHome.resolve("schema.xml"), new CopyOption[0]);
        Files.copy(top.resolve("enumsConfig.xml"), subHome.resolve("enumsConfig.xml"), new CopyOption[0]);
        Files.copy(top.resolve("solrconfig.snippet.randomindexconfig.xml"), subHome.resolve("solrconfig.snippet.randomindexconfig.xml"), new CopyOption[0]);
        Files.copy(top.resolve("solrconfig.xml"), subHome.resolve("solrconfig.xml"), new CopyOption[0]);
        Files.copy(top.resolve("stopwords.txt"), subHome.resolve("stopwords.txt"), new CopyOption[0]);
        Files.copy(top.resolve("synonyms.txt"), subHome.resolve("synonyms.txt"), new CopyOption[0]);
    }

    public boolean compareSolrDocument(Object expected, Object actual) {
        if (!(expected instanceof SolrDocument) || !(actual instanceof SolrDocument)) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        SolrDocument solrDocument1 = (SolrDocument)expected;
        SolrDocument solrDocument2 = (SolrDocument)actual;
        if (solrDocument1.getFieldNames().size() != solrDocument2.getFieldNames().size()) {
            return false;
        }
        Iterator iter1 = solrDocument1.getFieldNames().iterator();
        Iterator iter2 = solrDocument2.getFieldNames().iterator();
        if (iter1.hasNext()) {
            String key1 = (String)iter1.next();
            String key2 = (String)iter2.next();
            Collection val1 = solrDocument1.getFieldValues(key1);
            Collection val2 = solrDocument2.getFieldValues(key2);
            if (!key1.equals(key2) || !((Object)val1).equals(val2)) {
                return false;
            }
        }
        if (solrDocument1.getChildDocuments() == null && solrDocument2.getChildDocuments() == null) {
            return true;
        }
        if (solrDocument1.getChildDocuments() == null || solrDocument2.getChildDocuments() == null) {
            return false;
        }
        if (solrDocument1.getChildDocuments().size() != solrDocument2.getChildDocuments().size()) {
            return false;
        }
        Iterator childDocsIter1 = solrDocument1.getChildDocuments().iterator();
        Iterator childDocsIter2 = solrDocument2.getChildDocuments().iterator();
        while (childDocsIter1.hasNext()) {
            if (this.compareSolrDocument(childDocsIter1.next(), childDocsIter2.next())) continue;
            return false;
        }
        return true;
    }

    public boolean compareSolrDocumentList(Object expected, Object actual) {
        if (!(expected instanceof SolrDocumentList) || !(actual instanceof SolrDocumentList)) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        SolrDocumentList list1 = (SolrDocumentList)expected;
        SolrDocumentList list2 = (SolrDocumentList)actual;
        if (list1.getMaxScore() == null) {
            if (list2.getMaxScore() != null) {
                return false;
            }
        } else {
            if (list2.getMaxScore() == null) {
                return false;
            }
            if (Float.compare(list1.getMaxScore().floatValue(), list2.getMaxScore().floatValue()) != 0 || list1.getNumFound() != list2.getNumFound() || list1.getStart() != list2.getStart()) {
                return false;
            }
        }
        int i = 0;
        while ((long)i < list1.getNumFound()) {
            if (!this.compareSolrDocument(list1.get(i), list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean compareSolrInputDocument(Object expected, Object actual) {
        if (!(expected instanceof SolrInputDocument) || !(actual instanceof SolrInputDocument)) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        SolrInputDocument sdoc1 = (SolrInputDocument)expected;
        SolrInputDocument sdoc2 = (SolrInputDocument)actual;
        if (sdoc1.getFieldNames().size() != sdoc2.getFieldNames().size()) {
            return false;
        }
        Iterator iter1 = sdoc1.getFieldNames().iterator();
        Iterator iter2 = sdoc2.getFieldNames().iterator();
        while (iter1.hasNext()) {
            String key1 = (String)iter1.next();
            String key2 = (String)iter2.next();
            Collection val1 = sdoc1.getFieldValues(key1);
            Collection val2 = sdoc2.getFieldValues(key2);
            if (!key1.equals(key2)) {
                return false;
            }
            if (!(sdoc1.get((Object)key1).getFirstValue() instanceof SolrInputDocument)) {
                if (((Object)val1).equals(val2)) continue;
                return false;
            }
            if (!(sdoc2.get((Object)key2).getFirstValue() instanceof SolrInputDocument)) {
                return false;
            }
            Collection col1 = val1;
            Collection col2 = val2;
            if (col1.size() != col2.size()) {
                return false;
            }
            Iterator colIter1 = col1.iterator();
            Iterator colIter2 = col2.iterator();
            while (colIter1.hasNext()) {
                if (this.compareSolrInputDocument(colIter1.next(), colIter2.next())) continue;
                return false;
            }
        }
        if (sdoc1.getChildDocuments() == null && sdoc2.getChildDocuments() == null) {
            return true;
        }
        if (sdoc1.getChildDocuments() == null || sdoc2.getChildDocuments() == null) {
            return false;
        }
        if (sdoc1.getChildDocuments().size() != sdoc2.getChildDocuments().size()) {
            return false;
        }
        Iterator childDocsIter1 = sdoc1.getChildDocuments().iterator();
        Iterator childDocsIter2 = sdoc2.getChildDocuments().iterator();
        while (childDocsIter1.hasNext()) {
            if (this.compareSolrInputDocument(childDocsIter1.next(), childDocsIter2.next())) continue;
            return false;
        }
        return true;
    }

    public boolean assertSolrInputFieldEquals(Object expected, Object actual) {
        if (!(expected instanceof SolrInputField) || !(actual instanceof SolrInputField)) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        SolrInputField sif1 = (SolrInputField)expected;
        SolrInputField sif2 = (SolrInputField)actual;
        if (!sif1.getName().equals(sif2.getName())) {
            return false;
        }
        return sif1.getValue().equals(sif2.getValue());
    }

    public static Object skewed(Object likely, Object unlikely) {
        return 0 == TestUtil.nextInt((Random)SolrTestCaseJ4.random(), (int)0, (int)9) ? unlikely : likely;
    }

    @Deprecated
    public static HttpClient getHttpClient(String url) {
        return new HttpSolrClient.Builder(url).build().getHttpClient();
    }

    public static HttpSolrClient getHttpSolrClient(String url) {
        return new HttpSolrClient.Builder(url).build();
    }

    public static String randomDate() {
        return Instant.ofEpochMilli(SolrTestCaseJ4.random().nextLong()).toString();
    }

    public static String randomSkewedDate() {
        return String.format(Locale.ROOT, "2010-10-31T10:31:%02d.000Z", TestUtil.nextInt((Random)SolrTestCaseJ4.random(), (int)0, (int)59));
    }

    public static String randomXmlUsableUnicodeString() {
        String result = TestUtil.randomRealisticUnicodeString((Random)SolrTestCaseJ4.random());
        if (result.matches(".*\\p{InSpecials}.*")) {
            result = TestUtil.randomSimpleString((Random)SolrTestCaseJ4.random());
        }
        return result;
    }

    protected static void waitForWarming(SolrCore core) throws InterruptedException {
        RefCounted registeredSearcher = core.getRegisteredSearcher();
        RefCounted newestSearcher = core.getNewestSearcher(false);
        while (registeredSearcher == null || registeredSearcher.get() != newestSearcher.get()) {
            if (registeredSearcher != null) {
                registeredSearcher.decref();
            }
            newestSearcher.decref();
            Thread.sleep(50L);
            registeredSearcher = core.getRegisteredSearcher();
            newestSearcher = core.getNewestSearcher(false);
        }
        registeredSearcher.decref();
        newestSearcher.decref();
    }

    protected void waitForWarming() throws InterruptedException {
        SolrTestCaseJ4.waitForWarming(h.getCore());
    }

    protected String getSaferTestName() {
        String testName = this.getTestName();
        int index = testName.indexOf(32);
        if (index > 0) {
            testName = testName.substring(0, index);
        }
        return testName;
    }

    @BeforeClass
    public static void assertNonBlockingRandomGeneratorAvailable() throws InterruptedException {
        String EGD = "java.security.egd";
        String URANDOM = "file:/dev/./urandom";
        String ALLOWED = "test.solr.allowed.securerandom";
        String allowedAlg = System.getProperty("test.solr.allowed.securerandom");
        String actualEGD = System.getProperty("java.security.egd");
        log.info("SecureRandom sanity checks: {}={} & {}={}", new Object[]{"test.solr.allowed.securerandom", allowedAlg, "java.security.egd", actualEGD});
        if (null != allowedAlg) {
            String actualAlg = new SecureRandom().getAlgorithm();
            SolrTestCaseJ4.assertEquals((String)"Algorithm specified using test.solr.allowed.securerandom system property does not match actual algorithm", (Object)allowedAlg, (Object)actualAlg);
            return;
        }
        if (null == actualEGD) {
            System.setProperty("java.security.egd", "file:/dev/./urandom");
            log.warn("System property {} was not set by test runner, forcibly set to expected: {}", (Object)"java.security.egd", (Object)"file:/dev/./urandom");
        } else if (!"file:/dev/./urandom".equals(actualEGD)) {
            log.warn("System property {}={} .. test runner should use expected: {}", new Object[]{"java.security.egd", actualEGD, "file:/dev/./urandom"});
        }
        String algorithm = new SecureRandom().getAlgorithm();
        SolrTestCaseJ4.assertFalse((String)("SecureRandom algorithm '" + algorithm + "' is in use by your JVM, which is a potentially blocking algorithm on some environments. Please report the details of this failure (and your JVM vendor/version) to users@solr.apache.org. You can try to run your tests with -Djava.security.egd=file:/dev/./urandom or bypass this check using -Dtest.solr.allowed.securerandom=" + algorithm + " as a JVM option when running tests."), (algorithm.equals("NativePRNG") || algorithm.equals("NativePRNGBlocking") ? 1 : 0) != 0);
    }

    protected static void systemSetPropertySolrTestsMergePolicyFactory(String value) {
        System.setProperty(SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICYFACTORY, value);
    }

    protected static void systemClearPropertySolrTestsMergePolicyFactory() {
        System.clearProperty(SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICYFACTORY);
    }

    @Deprecated
    protected static void systemSetPropertySolrDisableUrlAllowList(String value) {
        System.setProperty("solr.disable.allowUrls", value);
    }

    @Deprecated
    protected static void systemClearPropertySolrDisableUrlAllowList() {
        System.clearProperty("solr.disable.allowUrls");
    }

    @SafeVarargs
    protected static <T> T pickRandom(T ... options) {
        return options[SolrTestCaseJ4.random().nextInt(options.length)];
    }

    private static void randomizeNumericTypesProperties() {
        boolean usePoints;
        boolean useDV = SolrTestCaseJ4.random().nextBoolean();
        System.setProperty(NUMERIC_DOCVALUES_SYSPROP, "" + useDV);
        boolean randUsePoints = 0 != SolrTestCaseJ4.random().nextInt(5);
        String usePointsStr = System.getProperty(USE_NUMERIC_POINTS_SYSPROP);
        boolean bl = usePoints = null == usePointsStr ? randUsePoints : Boolean.parseBoolean(usePointsStr);
        if (RandomizedContext.current().getTargetClass().isAnnotationPresent(SuppressPointFields.class) || !usePoints) {
            log.info("Using TrieFields (NUMERIC_POINTS_SYSPROP=false) w/NUMERIC_DOCVALUES_SYSPROP={}", (Object)useDV);
            PointField.TEST_HACK_IGNORE_USELESS_TRIEFIELD_ARGS = false;
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Integer.class, "solr.TrieIntField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Float.class, "solr.TrieFloatField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Long.class, "solr.TrieLongField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Double.class, "solr.TrieDoubleField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Date.class, "solr.TrieDateField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Enum.class, "solr.EnumField");
            System.setProperty(NUMERIC_POINTS_SYSPROP, "false");
        } else {
            log.info("Using PointFields (NUMERIC_POINTS_SYSPROP=true) w/NUMERIC_DOCVALUES_SYSPROP={}", (Object)useDV);
            PointField.TEST_HACK_IGNORE_USELESS_TRIEFIELD_ARGS = true;
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Integer.class, "solr.IntPointField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Float.class, "solr.FloatPointField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Long.class, "solr.LongPointField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Double.class, "solr.DoublePointField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Date.class, "solr.DatePointField");
            private_RANDOMIZED_NUMERIC_FIELDTYPES.put(Enum.class, "solr.EnumFieldType");
            System.setProperty(NUMERIC_POINTS_SYSPROP, "true");
        }
        for (Map.Entry<Class<?>, String> entry : RANDOMIZED_NUMERIC_FIELDTYPES.entrySet()) {
            System.setProperty("solr.tests." + entry.getKey().getSimpleName() + "FieldType", entry.getValue());
        }
    }

    public static DistributedUpdateProcessor createDistributedUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        if (h.getCoreContainer().isZooKeeperAware()) {
            return new DistributedZkUpdateProcessor(req, rsp, next);
        }
        return new DistributedUpdateProcessor(req, rsp, next);
    }

    private static void clearNumericTypesProperties() {
        PointField.TEST_HACK_IGNORE_USELESS_TRIEFIELD_ARGS = false;
        System.clearProperty(NUMERIC_POINTS_SYSPROP);
        System.clearProperty("solr.tests.numeric.points.dv");
        for (Class<?> c : RANDOMIZED_NUMERIC_FIELDTYPES.keySet()) {
            System.clearProperty("solr.tests." + c.getSimpleName() + "FieldType");
        }
        private_RANDOMIZED_NUMERIC_FIELDTYPES.clear();
    }

    private static SolrDocument toSolrDoc(SolrInputDocument sid) {
        SolrDocument doc = new SolrDocument();
        for (SolrInputField field : sid) {
            doc.setField(field.getName(), field.getValue());
        }
        return doc;
    }

    private static boolean isChildDoc(Object o) {
        if (o instanceof Collection) {
            Collection col = (Collection)o;
            if (col.size() == 0) {
                return false;
            }
            return col.iterator().next() instanceof SolrInputDocument;
        }
        return o instanceof SolrInputDocument;
    }

    static {
        savedClassLogLevels = new HashMap<String, Level>();
        changedFactory = false;
        dataDirCount = new AtomicInteger(0);
        errorMuters = new ConcurrentHashMap<String, ErrorLogMuter>();
        ZERO_ONE = new IRange(0, 1);
        ZERO_TWO = new IRange(0, 2);
        ONE_ONE = new IRange(1, 1);
        private_RANDOMIZED_NUMERIC_FIELDTYPES = new HashMap();
        RANDOMIZED_NUMERIC_FIELDTYPES = Collections.unmodifiableMap(private_RANDOMIZED_NUMERIC_FIELDTYPES);
    }

    @Deprecated
    public static class RandomizingCloudSolrClientBuilder
    extends CloudLegacySolrClient.Builder {
        public RandomizingCloudSolrClientBuilder(List<String> zkHosts, Optional<String> zkChroot) {
            super(zkHosts, zkChroot);
            this.randomizeCloudSolrClient();
        }

        public RandomizingCloudSolrClientBuilder(ClusterStateProvider stateProvider) {
            this.stateProvider = stateProvider;
            this.randomizeCloudSolrClient();
        }

        public RandomizingCloudSolrClientBuilder(MiniSolrCloudCluster cluster) {
            if (LuceneTestCase.random().nextBoolean()) {
                this.zkHosts.add(cluster.getZkServer().getZkAddress());
            } else {
                this.populateSolrUrls(cluster);
            }
            this.randomizeCloudSolrClient();
        }

        private void populateSolrUrls(MiniSolrCloudCluster cluster) {
            if (LuceneTestCase.random().nextBoolean()) {
                List<JettySolrRunner> solrNodes = cluster.getJettySolrRunners();
                for (JettySolrRunner node : solrNodes) {
                    this.solrUrls.add(node.getBaseUrl().toString());
                }
            } else {
                this.solrUrls.add(cluster.getRandomJetty(LuceneTestCase.random()).getBaseUrl().toString());
            }
        }

        private void randomizeCloudSolrClient() {
            this.directUpdatesToLeadersOnly = LuceneTestCase.random().nextBoolean();
            this.shardLeadersOnly = LuceneTestCase.random().nextBoolean();
            this.parallelUpdates = LuceneTestCase.random().nextBoolean();
        }
    }

    public static class RandomizingCloudHttp2SolrClientBuilder
    extends CloudHttp2SolrClient.Builder {
        public RandomizingCloudHttp2SolrClientBuilder(List<String> zkHosts, Optional<String> zkChroot) {
            super(zkHosts, zkChroot);
            this.randomizeCloudSolrClient();
        }

        public RandomizingCloudHttp2SolrClientBuilder(ClusterStateProvider stateProvider) {
            super(new ArrayList());
            this.stateProvider = stateProvider;
            this.randomizeCloudSolrClient();
        }

        public RandomizingCloudHttp2SolrClientBuilder(MiniSolrCloudCluster cluster) {
            super(new ArrayList());
            if (LuceneTestCase.random().nextBoolean()) {
                this.zkHosts.add(cluster.getZkServer().getZkAddress());
            } else {
                this.populateSolrUrls(cluster);
            }
            this.randomizeCloudSolrClient();
        }

        private void populateSolrUrls(MiniSolrCloudCluster cluster) {
            if (LuceneTestCase.random().nextBoolean()) {
                List<JettySolrRunner> solrNodes = cluster.getJettySolrRunners();
                for (JettySolrRunner node : solrNodes) {
                    this.solrUrls.add(node.getBaseUrl().toString());
                }
            } else {
                this.solrUrls.add(cluster.getRandomJetty(LuceneTestCase.random()).getBaseUrl().toString());
            }
        }

        private void randomizeCloudSolrClient() {
            this.directUpdatesToLeadersOnly = LuceneTestCase.random().nextBoolean();
            this.shardLeadersOnly = LuceneTestCase.random().nextBoolean();
            this.parallelUpdates = LuceneTestCase.random().nextBoolean();
        }
    }

    protected static class FldType {
        public String fname;
        public IVals numValues;
        public Vals vals;

        public FldType(String fname, Vals vals) {
            this(fname, ZERO_ONE, vals);
        }

        public FldType(String fname, IVals numValues, Vals vals) {
            this.fname = fname;
            this.numValues = numValues;
            this.vals = vals;
        }

        public Comparable createValue() {
            return this.vals.get();
        }

        public List<Comparable> createValues() {
            int nVals = this.numValues.getInt();
            if (nVals <= 0) {
                return null;
            }
            ArrayList<Comparable> vals = new ArrayList<Comparable>(nVals);
            for (int i = 0; i < nVals; ++i) {
                vals.add(this.createValue());
            }
            return vals;
        }

        public Fld createField() {
            List<Comparable> vals = this.createValues();
            if (vals == null) {
                return null;
            }
            Fld fld = new Fld();
            fld.ftype = this;
            fld.vals = vals;
            return fld;
        }
    }

    public static class Fld {
        public FldType ftype;
        public List<Comparable> vals;

        public String toString() {
            return this.ftype.fname + "=" + (this.vals.size() == 1 ? this.vals.get(0).toString() : this.vals.toString());
        }
    }

    public static class Doc
    implements Comparable {
        public Comparable id;
        public List<Fld> fields;
        public int order;

        public String toString() {
            return "Doc(" + this.order + "):" + this.fields.toString();
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Doc)) {
                return false;
            }
            Doc other = (Doc)o;
            return this == other || Objects.equals(this.id, other.id);
        }

        public int compareTo(Object o) {
            if (!(o instanceof Doc)) {
                return this.getClass().hashCode() - o.getClass().hashCode();
            }
            Doc other = (Doc)o;
            return this.id.compareTo(other.id);
        }

        public List<Comparable> getValues(String field) {
            for (Fld fld : this.fields) {
                if (!fld.ftype.fname.equals(field)) continue;
                return fld.vals;
            }
            return null;
        }

        public Comparable getFirstValue(String field) {
            List<Comparable> vals = this.getValues(field);
            return vals == null || vals.size() == 0 ? null : vals.get(0);
        }

        public Map<String, Object> toObject(IndexSchema schema) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Fld fld : this.fields) {
                SchemaField sf = schema.getField(fld.ftype.fname);
                if (!sf.multiValued()) {
                    result.put(fld.ftype.fname, fld.vals.get(0));
                    continue;
                }
                result.put(fld.ftype.fname, fld.vals);
            }
            return result;
        }
    }

    public static class SVal
    extends Vals {
        char start;
        char end;
        int minLength;
        int maxLength;

        public SVal() {
            this('a', 'z', 1, 10);
        }

        public SVal(char start, char end, int minLength, int maxLength) {
            this.start = start;
            this.end = end;
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        @Override
        public Comparable get() {
            char[] arr = new char[this.between(this.minLength, this.maxLength)];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (char)this.between(this.start, this.end);
            }
            return new String(arr);
        }
    }

    public static class BVal
    extends Vals {
        @Override
        public Comparable get() {
            return Boolean.valueOf(LuceneTestCase.random().nextBoolean());
        }
    }

    public static class FVal
    extends Vals {
        final float min;
        final float max;

        public FVal(float min, float max) {
            this.min = min;
            this.max = max;
        }

        public float getFloat() {
            if (this.min >= this.max) {
                return this.min;
            }
            return this.min + LuceneTestCase.random().nextFloat() * (this.max - this.min);
        }

        @Override
        public Comparable get() {
            return Float.valueOf(this.getFloat());
        }
    }

    public static class IValsPercent
    extends IVals {
        final int[] percentAndValue;

        public IValsPercent(int ... percentAndValue) {
            this.percentAndValue = percentAndValue;
        }

        @Override
        public int getInt() {
            int r = this.between(0, 99);
            int cumulative = 0;
            for (int i = 0; i < this.percentAndValue.length; i += 2) {
                if (r >= (cumulative += this.percentAndValue[i])) continue;
                return this.percentAndValue[i + 1];
            }
            return this.percentAndValue[this.percentAndValue.length - 1];
        }

        @Override
        public Comparable get() {
            return Integer.valueOf(this.getInt());
        }
    }

    public static class IRange
    extends IVals {
        final int min;
        final int max;

        public IRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public int getInt() {
            return this.between(this.min, this.max);
        }

        @Override
        public Comparable get() {
            return Integer.valueOf(this.getInt());
        }
    }

    public static abstract class IVals
    extends Vals {
        public abstract int getInt();
    }

    public static abstract class Vals {
        public abstract Comparable get();

        public String toJSON(Comparable val) {
            return JSONUtil.toJSON((Object)val);
        }

        protected int between(int min, int max) {
            return min != max ? LuceneTestCase.random().nextInt(max - min + 1) + min : min;
        }
    }

    public static class XmlDoc {
        public String xml;

        public String toString() {
            return this.xml;
        }
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressPointFields {
        public String bugUrl();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressSSL {
        public String bugUrl() default "None";
    }
}

