/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CorePropertiesLocator;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.MetricsConfig;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.logging.MDCSnapshot;
import org.apache.solr.metrics.reporters.SolrJmxReporter;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.servlet.DirectSolrConnection;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.BaseTestHarness;
import org.apache.solr.util.ReadOnlyCoresLocator;

public class TestHarness
extends BaseTestHarness {
    public String coreName;
    protected volatile CoreContainer container;
    public UpdateRequestHandler updater;

    public static SolrConfig createConfig(Path solrHome, String coreName, String confFile) {
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        try {
            return new SolrConfig(solrHome.resolve(coreName), confFile);
        }
        catch (Exception xany) {
            throw new RuntimeException(xany);
        }
    }

    public static SolrConfig createConfig(Path solrHome, String confFile) {
        return TestHarness.createConfig(solrHome, "collection1", confFile);
    }

    public TestHarness(String coreName, String dataDirectory, SolrConfig solrConfig, String schemaFile) {
        this(coreName, dataDirectory, solrConfig, IndexSchemaFactory.buildIndexSchema((String)schemaFile, (SolrConfig)solrConfig));
    }

    public TestHarness(String dataDirectory, SolrConfig solrConfig, String schemaFile) {
        this(dataDirectory, solrConfig, IndexSchemaFactory.buildIndexSchema((String)schemaFile, (SolrConfig)solrConfig));
    }

    public TestHarness(String dataDirectory, SolrConfig solrConfig, IndexSchema indexSchema) {
        this("collection1", dataDirectory, solrConfig, indexSchema);
    }

    private static Path checkAndReturnSolrHomeSysProp() {
        String SOLR_HOME = "solr.solr.home";
        String home = System.getProperty("solr.solr.home");
        if (null == home) {
            throw new IllegalStateException("This TestHarness constructor requires solr.solr.home sys prop to be set by test first");
        }
        return Paths.get(home, new String[0]).toAbsolutePath().normalize();
    }

    public TestHarness(String coreName, String dataDir, String solrConfig, String indexSchema) {
        this(TestHarness.buildTestNodeConfig(TestHarness.checkAndReturnSolrHomeSysProp()), new TestCoresLocator(coreName, dataDir, solrConfig, indexSchema));
        this.coreName = coreName == null ? "collection1" : coreName;
    }

    public TestHarness(String coreName, String dataDir, SolrConfig solrConfig, IndexSchema indexSchema) {
        this(coreName, dataDir, solrConfig.getResourceName(), indexSchema.getResourceName());
    }

    public TestHarness(Path solrHome, String solrXml) {
        this(SolrXmlConfig.fromString((Path)solrHome, (String)solrXml));
    }

    public TestHarness(NodeConfig nodeConfig) {
        this(nodeConfig, (CoresLocator)new CorePropertiesLocator(nodeConfig.getCoreRootDirectory()));
    }

    public TestHarness(NodeConfig config, CoresLocator coresLocator) {
        this.container = new CoreContainer(config, coresLocator);
        this.container.load();
        this.updater = new UpdateRequestHandler();
        this.updater.init(null);
    }

    public static NodeConfig buildTestNodeConfig(Path solrHome) {
        CloudConfig cloudConfig = null == System.getProperty("zkHost") ? null : new CloudConfig.CloudConfigBuilder(System.getProperty("host"), Integer.getInteger("hostPort", 8983).intValue(), System.getProperty("hostContext", "")).setZkClientTimeout(Integer.getInteger("zkClientTimeout", 30000).intValue()).setZkHost(System.getProperty("zkHost")).build();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", "default");
        attributes.put("class", SolrJmxReporter.class.getName());
        PluginInfo defaultPlugin = new PluginInfo("reporter", attributes);
        MetricsConfig metricsConfig = new MetricsConfig.MetricsConfigBuilder().setMetricReporterPlugins(new PluginInfo[]{defaultPlugin}).build();
        return new NodeConfig.NodeConfigBuilder("testNode", solrHome).setUseSchemaCache(Boolean.getBoolean("shareSchema")).setCloudConfig(cloudConfig).setUpdateShardHandlerConfig(UpdateShardHandlerConfig.TEST_DEFAULT).setMetricsConfig(metricsConfig).build();
    }

    public CoreContainer getCoreContainer() {
        return this.container;
    }

    public SolrCore getCore() {
        SolrCore core = this.container.getCore(this.coreName);
        if (core != null) {
            core.close();
        }
        return core;
    }

    public SolrCore getCoreInc() {
        return this.container.getCore(this.coreName);
    }

    @Override
    public void reload() throws Exception {
        this.container.reload(this.coreName);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String update(String xml) {
        try (MDCSnapshot mdcSnap = MDCSnapshot.create();){
            String string;
            block17: {
                SolrCore core = this.getCoreInc();
                try {
                    assert (null != mdcSnap);
                    DirectSolrConnection connection = new DirectSolrConnection(core);
                    SolrRequestHandler handler = core.getRequestHandler("/update");
                    if (handler == null) {
                        handler = this.updater;
                    }
                    string = connection.request(handler, null, xml);
                    if (core == null) break block17;
                }
                catch (Throwable throwable) {
                    if (core != null) {
                        try {
                            core.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                core.close();
            }
            return string;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    public String validateQuery(SolrQueryRequest req, String ... tests) throws Exception {
        String res = this.query(req);
        return TestHarness.validateXPath(res, tests);
    }

    public String query(SolrQueryRequest req) throws Exception {
        return this.query(req.getParams().get("qt"), req);
    }

    public String query(String handler, SolrQueryRequest req) throws Exception {
        try {
            String string;
            block15: {
                QueryResponseWriter responseWriter;
                SolrQueryResponse rsp;
                MDCSnapshot mdcSnap;
                block13: {
                    String string2;
                    block14: {
                        mdcSnap = MDCSnapshot.create();
                        try {
                            assert (null != mdcSnap);
                            SolrCore core = req.getCore();
                            rsp = new SolrQueryResponse();
                            SolrRequestInfo.setRequestInfo((SolrRequestInfo)new SolrRequestInfo(req, rsp));
                            core.execute(core.getRequestHandler(handler), req, rsp);
                            if (rsp.getException() != null) {
                                throw rsp.getException();
                            }
                            responseWriter = core.getQueryResponseWriter(req);
                            if (!(responseWriter instanceof BinaryQueryResponseWriter)) break block13;
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32000);
                            BinaryQueryResponseWriter writer = (BinaryQueryResponseWriter)responseWriter;
                            writer.write((OutputStream)byteArrayOutputStream, req, rsp);
                            string2 = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                            if (mdcSnap == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (mdcSnap != null) {
                                try {
                                    mdcSnap.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        mdcSnap.close();
                    }
                    return string2;
                }
                StringWriter sw = new StringWriter(32000);
                responseWriter.write((Writer)sw, req, rsp);
                string = sw.toString();
                if (mdcSnap == null) break block15;
                mdcSnap.close();
            }
            return string;
        }
        finally {
            req.close();
            SolrRequestInfo.clearRequestInfo();
        }
    }

    public SolrQueryResponse queryAndResponse(String handler, SolrQueryRequest req) throws Exception {
        try (MDCSnapshot mdcSnap = MDCSnapshot.create();){
            SolrQueryResponse solrQueryResponse;
            block14: {
                SolrCore core = this.getCoreInc();
                try {
                    assert (null != mdcSnap);
                    SolrQueryResponse rsp = new SolrQueryResponse();
                    core.execute(core.getRequestHandler(handler), req, rsp);
                    if (rsp.getException() != null) {
                        throw rsp.getException();
                    }
                    solrQueryResponse = rsp;
                    if (core == null) break block14;
                }
                catch (Throwable throwable) {
                    if (core != null) {
                        try {
                            core.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                core.close();
            }
            return solrQueryResponse;
        }
    }

    public void close() {
        if (this.container != null) {
            this.container.shutdown();
            this.container = null;
        }
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit) {
        LocalRequestFactory f = new LocalRequestFactory();
        f.qtype = qtype;
        f.start = start;
        f.limit = limit;
        return f;
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit, String ... args) {
        LocalRequestFactory f = this.getRequestFactory(qtype, start, limit);
        for (int i = 0; i < args.length; i += 2) {
            f.args.put(args[i], args[i + 1]);
        }
        return f;
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit, Map<String, String> args) {
        LocalRequestFactory f = this.getRequestFactory(qtype, start, limit);
        f.args.putAll(args);
        return f;
    }

    public class LocalRequestFactory {
        public String qtype = null;
        public int start = 0;
        public int limit = 1000;
        public Map<String, String> args = new HashMap<String, String>();

        public LocalSolrQueryRequest makeRequest(String ... q) {
            if (q.length == 1) {
                return new LocalSolrQueryRequest(TestHarness.this.getCore(), q[0], this.qtype, this.start, this.limit, this.args);
            }
            if (q.length % 2 != 0) {
                throw new RuntimeException("The length of the string array (query arguments) needs to be even");
            }
            NamedList.NamedListEntry[] entries = new NamedList.NamedListEntry[q.length / 2];
            for (int i = 0; i < q.length; i += 2) {
                entries[i / 2] = new NamedList.NamedListEntry(q[i], (Object)q[i + 1]);
            }
            NamedList nl = new NamedList((Map.Entry[])entries);
            if (nl.get("wt") == null) {
                nl.add("wt", (Object)"xml");
            }
            return new LocalSolrQueryRequest(TestHarness.this.getCore(), nl);
        }
    }

    public static class TestCoresLocator
    extends ReadOnlyCoresLocator {
        final String coreName;
        final String dataDir;
        final String solrConfig;
        final String schema;

        public TestCoresLocator(String coreName, String dataDir, String solrConfig, String schema) {
            this.coreName = coreName == null ? "collection1" : coreName;
            this.dataDir = dataDir;
            this.schema = schema;
            this.solrConfig = solrConfig;
        }

        public List<CoreDescriptor> discover(CoreContainer cc) {
            return List.of(new CoreDescriptor(this.coreName, cc.getCoreRootDirectory().resolve(this.coreName), cc, new String[]{"dataDir", this.dataDir, "config", this.solrConfig, "schema", this.schema, "collection", System.getProperty("collection", "collection1"), "shard", System.getProperty("shard", "shard1")}));
        }
    }
}

