/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstallShardTest
extends SolrCloudTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String BACKUP_REPO_NAME = "trackingBackupRepository";
    private static long docsSeed;
    private static int singleShardNumDocs;
    private static int replicasPerShard;
    private static int multiShardNumDocs;
    private static URI singleShard1Uri;
    private static URI[] multiShardUris;
    private List<String> collectionsToDelete;

    @BeforeClass
    public static void seedDocGenerator() {
        docsSeed = AbstractInstallShardTest.random().nextLong();
        System.setProperty("solr.directoryFactory", "solr.StandardDirectoryFactory");
    }

    @Before
    public void clearCollsToDelete() {
        this.collectionsToDelete = new ArrayList<String>();
    }

    @After
    public void deleteTestCollections() throws Exception {
        for (String collName : this.collectionsToDelete) {
            CollectionAdminRequest.deleteCollection((String)collName).process((SolrClient)cluster.getSolrClient());
        }
    }

    private String deleteAfterTest(String collName) {
        this.collectionsToDelete.add(collName);
        return collName;
    }

    public static void bootstrapBackupRepositoryData(String baseRepositoryLocation) throws Exception {
        int numShards = 4;
        multiShardUris = new URI[4];
        replicasPerShard = 3;
        CloudSolrClient solrClient = cluster.getSolrClient();
        String singleShardCollName = AbstractInstallShardTest.createAndAwaitEmptyCollection(1, replicasPerShard);
        singleShardNumDocs = AbstractInstallShardTest.indexDocs(singleShardCollName, true);
        AbstractInstallShardTest.assertCollectionHasNumDocs(singleShardCollName, singleShardNumDocs);
        String multiShardCollName = AbstractInstallShardTest.createAndAwaitEmptyCollection(4, replicasPerShard);
        multiShardNumDocs = AbstractInstallShardTest.indexDocs(multiShardCollName, true);
        AbstractInstallShardTest.assertCollectionHasNumDocs(multiShardCollName, multiShardNumDocs);
        singleShard1Uri = AbstractInstallShardTest.createBackupRepoDirectoryForShardData(baseRepositoryLocation, singleShardCollName, "shard1");
        AbstractInstallShardTest.copyShardDataToBackupRepository(singleShardCollName, "shard1", singleShard1Uri);
        for (int i = 0; i < multiShardUris.length; ++i) {
            String shardName = "shard" + (i + 1);
            AbstractInstallShardTest.multiShardUris[i] = AbstractInstallShardTest.createBackupRepoDirectoryForShardData(baseRepositoryLocation, multiShardCollName, shardName);
            AbstractInstallShardTest.copyShardDataToBackupRepository(multiShardCollName, shardName, multiShardUris[i]);
        }
        CollectionAdminRequest.deleteCollection((String)singleShardCollName).process((SolrClient)solrClient);
        CollectionAdminRequest.deleteCollection((String)multiShardCollName).process((SolrClient)solrClient);
    }

    @Test
    public void testInstallFailsIfCollectionIsNotInReadOnlyMode() throws Exception {
        String collectionName = AbstractInstallShardTest.createAndAwaitEmptyCollection(1, replicasPerShard);
        this.deleteAfterTest(collectionName);
        String singleShardLocation = singleShard1Uri.toString();
        BaseHttpSolrClient.RemoteSolrException rse = (BaseHttpSolrClient.RemoteSolrException)AbstractInstallShardTest.expectThrows(BaseHttpSolrClient.RemoteSolrException.class, () -> CollectionAdminRequest.installDataToShard((String)collectionName, (String)"shard1", (String)singleShardLocation, (String)BACKUP_REPO_NAME).process((SolrClient)cluster.getSolrClient()));
        AbstractInstallShardTest.assertEquals((long)400L, (long)rse.code());
        AbstractInstallShardTest.assertTrue((boolean)rse.getMessage().contains("Collection must be in readOnly mode"));
        AbstractInstallShardTest.assertCollectionHasNumDocs(collectionName, 0);
    }

    @Test
    public void testInstallToSingleShardCollection() throws Exception {
        String collectionName = AbstractInstallShardTest.createAndAwaitEmptyCollection(1, replicasPerShard);
        this.deleteAfterTest(collectionName);
        AbstractInstallShardTest.enableReadOnly(collectionName);
        String singleShardLocation = singleShard1Uri.toString();
        CollectionAdminRequest.installDataToShard((String)collectionName, (String)"shard1", (String)singleShardLocation, (String)BACKUP_REPO_NAME).process((SolrClient)cluster.getSolrClient());
        AbstractInstallShardTest.assertCollectionHasNumDocs(collectionName, singleShardNumDocs);
    }

    @Test
    public void testSerialInstallToMultiShardCollection() throws Exception {
        String collectionName = AbstractInstallShardTest.createAndAwaitEmptyCollection(multiShardUris.length, replicasPerShard);
        this.deleteAfterTest(collectionName);
        AbstractInstallShardTest.enableReadOnly(collectionName);
        for (int i = 1; i <= multiShardUris.length; ++i) {
            CollectionAdminRequest.installDataToShard((String)collectionName, (String)("shard" + i), (String)multiShardUris[i - 1].toString(), (String)BACKUP_REPO_NAME).process((SolrClient)cluster.getSolrClient());
        }
        AbstractInstallShardTest.assertCollectionHasNumDocs(collectionName, multiShardNumDocs);
    }

    @Test
    public void testParallelInstallToMultiShardCollection() throws Exception {
        String collectionName = AbstractInstallShardTest.createAndAwaitEmptyCollection(multiShardUris.length, replicasPerShard);
        this.deleteAfterTest(collectionName);
        AbstractInstallShardTest.enableReadOnly(collectionName);
        this.runParallelShardInstalls(collectionName, multiShardUris);
        AbstractInstallShardTest.assertCollectionHasNumDocs(collectionName, multiShardNumDocs);
    }

    public static String defaultSolrXmlTextWithBackupRepository(String backupRepositoryText) {
        return "<solr>\n\n  <str name=\"shareSchema\">${shareSchema:false}</str>\n  <str name=\"configSetBaseDir\">${configSetBaseDir:configsets}</str>\n  <str name=\"coreRootDirectory\">${coreRootDirectory:.}</str>\n\n  <shardHandlerFactory name=\"shardHandlerFactory\" class=\"HttpShardHandlerFactory\">\n    <str name=\"urlScheme\">${urlScheme:}</str>\n    <int name=\"socketTimeout\">${socketTimeout:90000}</int>\n    <int name=\"connTimeout\">${connTimeout:15000}</int>\n  </shardHandlerFactory>\n\n  <solrcloud>\n    <str name=\"host\">127.0.0.1</str>\n    <int name=\"hostPort\">${hostPort:8983}</int>\n    <str name=\"hostContext\">${hostContext:solr}</str>\n    <int name=\"zkClientTimeout\">${solr.zkclienttimeout:30000}</int>\n    <bool name=\"genericCoreNodeNames\">${genericCoreNodeNames:true}</bool>\n    <int name=\"leaderVoteWait\">10000</int>\n    <int name=\"distribUpdateConnTimeout\">${distribUpdateConnTimeout:45000}</int>\n    <int name=\"distribUpdateSoTimeout\">${distribUpdateSoTimeout:340000}</int>\n  </solrcloud>\n  \n" + backupRepositoryText + "  \n</solr>\n";
    }

    private static void assertCollectionHasNumDocs(String collection, int expectedNumDocs) throws Exception {
        CloudSolrClient solrClient = cluster.getSolrClient();
        AbstractInstallShardTest.assertEquals((long)expectedNumDocs, (long)solrClient.query(collection, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyShardDataToBackupRepository(String collectionName, String shardName, URI destinationUri) throws Exception {
        CoreContainer cc = cluster.getJettySolrRunner(0).getCoreContainer();
        List coreNames = cc.getAllCoreNames();
        String coreName = coreNames.stream().filter(name -> name.contains(collectionName) && name.contains(shardName)).findFirst().get();
        CoreDescriptor cd = cc.getCoreDescriptor(coreName);
        Path coreInstanceDir = cd.getInstanceDir();
        assert (coreInstanceDir.toFile().exists());
        assert (coreInstanceDir.toFile().isDirectory());
        Path coreIndexDir = coreInstanceDir.resolve("data").resolve("index");
        assert (coreIndexDir.toFile().exists());
        assert (coreIndexDir.toFile().isDirectory());
        try (BackupRepository backupRepository = cc.newBackupRepository(BACKUP_REPO_NAME);
             SolrCore core = cc.getCore(coreName);){
            Directory dir = core.getDirectoryFactory().get(coreIndexDir.toString(), DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
            try {
                for (String dirContent : dir.listAll()) {
                    if (dirContent.contains("write.lock")) continue;
                    backupRepository.copyFileFrom(dir, dirContent, destinationUri);
                }
            }
            finally {
                core.getDirectoryFactory().release(dir);
            }
        }
    }

    private static URI createBackupRepoDirectoryForShardData(String baseLocation, String collectionName, String shardName) throws Exception {
        CoreContainer cc = cluster.getJettySolrRunner(0).getCoreContainer();
        try (BackupRepository backupRepository = cc.newBackupRepository(BACKUP_REPO_NAME);){
            URI baseLocationUri = backupRepository.createURI(baseLocation);
            URI collectionLocation = backupRepository.resolve(baseLocationUri, new String[]{collectionName});
            backupRepository.createDirectory(collectionLocation);
            URI shardLocation = backupRepository.resolve(collectionLocation, new String[]{shardName});
            backupRepository.createDirectory(shardLocation);
            URI uRI = shardLocation;
            return uRI;
        }
    }

    private static int indexDocs(String collectionName, boolean useUUID) throws Exception {
        Random random = new Random(docsSeed);
        int numDocs = random.nextInt(100) + 5;
        AbstractInstallShardTest.indexDocs(collectionName, numDocs, useUUID);
        return numDocs;
    }

    private static void indexDocs(String collectionName, int numDocs, boolean useUUID) throws Exception {
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(numDocs);
        for (int i = 0; i < numDocs; ++i) {
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("id", useUUID ? UUID.randomUUID().toString() : Integer.valueOf(i));
            doc.addField("val_s", (Object)"some value");
            docs.add(doc);
        }
        CloudSolrClient client = cluster.getSolrClient();
        client.add(collectionName, docs);
        client.commit(collectionName);
        log.info("Indexed {} docs to collection: {}", (Object)numDocs, (Object)collectionName);
    }

    private static String createAndAwaitEmptyCollection(int numShards, int replicasPerShard) throws Exception {
        CloudSolrClient solrClient = cluster.getSolrClient();
        String collectionName = UUID.randomUUID().toString().replace("-", "_");
        CollectionAdminRequest.createCollection((String)collectionName, (String)"conf1", (int)numShards, (int)replicasPerShard).process((SolrClient)solrClient);
        cluster.waitForActiveCollection(collectionName, numShards, numShards * replicasPerShard);
        AbstractInstallShardTest.assertCollectionHasNumDocs(collectionName, 0);
        return collectionName;
    }

    private static void enableReadOnly(String collectionName) throws Exception {
        CollectionAdminRequest.modifyCollection((String)collectionName, Map.of("readOnly", true)).process((SolrClient)cluster.getSolrClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runParallelShardInstalls(String collectionName, URI[] dataLocations) throws Exception {
        CloudSolrClient solrClient = cluster.getSolrClient();
        ArrayList<Callable<Exception>> tasks = new ArrayList<Callable<Exception>>();
        for (int i = 0; i < multiShardUris.length; ++i) {
            String shardName = "shard" + (i + 1);
            String dataLocation = multiShardUris[i].toString();
            tasks.add(() -> AbstractInstallShardTest.lambda$runParallelShardInstalls$2(collectionName, shardName, dataLocation, (SolrClient)solrClient));
        }
        ExecutorService executor = ExecutorUtil.newMDCAwareFixedThreadPool((int)multiShardUris.length, (ThreadFactory)new SolrNamedThreadFactory("shardinstall"));
        List futures = executor.invokeAll(tasks, 30L, TimeUnit.SECONDS);
        try {
            futures.stream().forEach(future -> {
                AbstractInstallShardTest.assertTrue((String)"Shard installation exceeded the test timeout", (boolean)future.isDone());
                try {
                    AbstractInstallShardTest.assertFalse((String)"Shard installation was cancelled after timing out.", (boolean)future.isCancelled());
                    Exception e = (Exception)future.get();
                    AbstractInstallShardTest.assertNull((String)("Shard installation failed with exception " + e), (Object)e);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static /* synthetic */ Exception lambda$runParallelShardInstalls$2(String collectionName, String shardName, String dataLocation, SolrClient solrClient) throws Exception {
        try {
            CollectionAdminRequest.installDataToShard((String)collectionName, (String)shardName, (String)dataLocation, (String)BACKUP_REPO_NAME).process(solrClient);
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    static {
        singleShardNumDocs = -1;
        replicasPerShard = -1;
        multiShardNumDocs = -1;
        singleShard1Uri = null;
        multiShardUris = null;
    }
}

