/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.backup.Checksum;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.backup.repository.BackupRepositoryFactory;

public class TrackingBackupRepository
implements BackupRepository {
    private static final List<URI> COPIED_FILES = Collections.synchronizedList(new ArrayList());
    private static final List<URI> DIRECTORIES_CREATED = Collections.synchronizedList(new ArrayList());
    private static final List<URI> OUTPUTS_CREATED = Collections.synchronizedList(new ArrayList());
    private BackupRepository delegate;

    public <T> T getConfigProperty(String name) {
        return (T)this.delegate.getConfigProperty(name);
    }

    public URI createURI(String path) {
        return this.delegate.createURI(path);
    }

    public URI createDirectoryURI(String path) {
        return this.delegate.createDirectoryURI(path);
    }

    public URI resolve(URI baseUri, String ... pathComponents) {
        return this.delegate.resolve(baseUri, pathComponents);
    }

    public URI resolveDirectory(URI baseUri, String ... pathComponents) {
        return this.delegate.resolveDirectory(baseUri, pathComponents);
    }

    public boolean exists(URI path) throws IOException {
        return this.delegate.exists(path);
    }

    public BackupRepository.PathType getPathType(URI path) throws IOException {
        return this.delegate.getPathType(path);
    }

    public String[] listAll(URI path) throws IOException {
        return this.delegate.listAll(path);
    }

    public IndexInput openInput(URI dirPath, String fileName, IOContext ctx) throws IOException {
        return this.delegate.openInput(dirPath, fileName, ctx);
    }

    public OutputStream createOutput(URI path) throws IOException {
        OUTPUTS_CREATED.add(path);
        return this.delegate.createOutput(path);
    }

    public void createDirectory(URI path) throws IOException {
        DIRECTORIES_CREATED.add(path);
        this.delegate.createDirectory(path);
    }

    public void deleteDirectory(URI path) throws IOException {
        this.delegate.deleteDirectory(path);
    }

    public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, URI destDir, String destFileName) throws IOException {
        COPIED_FILES.add(this.delegate.resolve(destDir, new String[]{destFileName}));
        this.delegate.copyIndexFileFrom(sourceDir, sourceFileName, destDir, destFileName);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void delete(URI path, Collection<String> files) throws IOException {
        this.delegate.delete(path, files);
    }

    public Checksum checksum(Directory dir, String fileName) throws IOException {
        return this.delegate.checksum(dir, fileName);
    }

    public void init(NamedList<?> args) {
        BackupRepositoryFactory factory = (BackupRepositoryFactory)args.get("factory");
        SolrResourceLoader loader = (SolrResourceLoader)args.get("loader");
        String repoName = (String)args.get("delegateRepoName");
        this.delegate = factory.newInstance(loader, repoName);
    }

    public static List<URI> copiedFiles() {
        return new ArrayList<URI>(COPIED_FILES);
    }

    public static List<URI> directoriesCreated() {
        return new ArrayList<URI>(DIRECTORIES_CREATED);
    }

    public static List<URI> outputsCreated() {
        return new ArrayList<URI>(OUTPUTS_CREATED);
    }

    public static void clear() {
        COPIED_FILES.clear();
        DIRECTORIES_CREATED.clear();
        OUTPUTS_CREATED.clear();
    }

    public void copyIndexFileTo(URI sourceRepo, String sourceFileName, Directory dest, String destFileName) throws IOException {
        this.delegate.copyIndexFileTo(sourceRepo, sourceFileName, dest, destFileName);
    }
}

