/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.SolrClientTestRule;

public class EmbeddedSolrServerTestRule
extends SolrClientTestRule {
    private static final String CORE_DIR_PROP = "coreRootDirectory";
    private EmbeddedSolrServer adminClient = null;

    protected void after() {
        if (this.adminClient != null) {
            this.adminClient.getCoreContainer().shutdown();
        }
    }

    @Override
    public void startSolr(Path solrHome) {
        NodeConfig nodeConfig;
        if (Files.exists(solrHome.resolve("solr.xml"), new LinkOption[0])) {
            Properties props = new Properties();
            if (System.getProperty(CORE_DIR_PROP) == null) {
                props.setProperty(CORE_DIR_PROP, LuceneTestCase.createTempDir((String)"cores").toString());
            }
            nodeConfig = SolrXmlConfig.fromSolrHome((Path)solrHome, (Properties)props);
        } else {
            nodeConfig = this.newNodeConfigBuilder(solrHome).build();
        }
        this.startSolr(nodeConfig);
    }

    public void startSolr(NodeConfig nodeConfig) {
        CoreContainer container = new CoreContainer(nodeConfig);
        this.adminClient = new EmbeddedSolrServer(container, null);
        container.load();
    }

    public NodeConfig.NodeConfigBuilder newNodeConfigBuilder(Path solrHome) {
        return new NodeConfig.NodeConfigBuilder("testNode", solrHome).setUpdateShardHandlerConfig(UpdateShardHandlerConfig.TEST_DEFAULT).setCoreRootDirectory(LuceneTestCase.createTempDir((String)"cores").toString());
    }

    public EmbeddedSolrServer getAdminClient() {
        if (this.adminClient == null) {
            throw new RuntimeException("Solr must be started first");
        }
        return this.adminClient;
    }

    public EmbeddedSolrServer getSolrClient(String collection) {
        return new EmbeddedSolrServer(this.getCoreContainer(), collection);
    }

    public CoreContainer getCoreContainer() {
        return this.getAdminClient().getCoreContainer();
    }
}

