/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.CollectionTester;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class JSONTestUtil {
    public static final double DEFAULT_DELTA = 1.0E-5;
    public static boolean failRepeatedKeys = false;

    public static String match(String input, String pathAndExpected) throws IOException {
        return JSONTestUtil.match(input, pathAndExpected, 1.0E-5);
    }

    public static String match(String path, String input, String expected) throws IOException {
        return JSONTestUtil.match(path, input, expected, 1.0E-5);
    }

    public static String matchObj(String path, Object input, Object expected) throws IOException {
        return JSONTestUtil.matchObj(path, input, expected, 1.0E-5);
    }

    public static String match(String input, String pathAndExpected, double delta) throws IOException {
        int pos = pathAndExpected.indexOf("==");
        String path = pos >= 0 ? pathAndExpected.substring(0, pos) : null;
        String expected = pos >= 0 ? pathAndExpected.substring(pos + 2) : pathAndExpected;
        return JSONTestUtil.match(path, input, expected, delta);
    }

    public static String matchObj(Object input, String pathAndExpected, double delta) throws IOException {
        int pos = pathAndExpected.indexOf("==");
        String path = pos >= 0 ? pathAndExpected.substring(0, pos) : null;
        String expected = pos >= 0 ? pathAndExpected.substring(pos + 2) : pathAndExpected;
        Object expectObj = failRepeatedKeys ? new NoDupsObjectBuilder(new JSONParser(expected)).getVal() : ObjectBuilder.fromJSON((String)expected);
        return JSONTestUtil.matchObj(path, input, expectObj, delta);
    }

    public static String match(String path, String input, String expected, double delta) throws IOException {
        Object inputObj = failRepeatedKeys ? new NoDupsObjectBuilder(new JSONParser(input)).getVal() : ObjectBuilder.fromJSON((String)input);
        Object expectObj = failRepeatedKeys ? new NoDupsObjectBuilder(new JSONParser(expected)).getVal() : ObjectBuilder.fromJSON((String)expected);
        return JSONTestUtil.matchObj(path, inputObj, expectObj, delta);
    }

    public static String matchObj(String path, Object input, Object expected, double delta) {
        CollectionTester tester = new CollectionTester(input, delta);
        boolean reversed = path.startsWith("!");
        String positivePath = reversed ? path.substring(1) : path;
        if (!tester.seek(positivePath) ^ reversed) {
            return "Path " + (reversed ? "" : "not ") + "found: " + path;
        }
        if (expected != null && !tester.match(expected) ^ reversed) {
            return tester.err + " @ " + tester.getPath();
        }
        return null;
    }

    static class NoDupsObjectBuilder
    extends ObjectBuilder {
        public NoDupsObjectBuilder(JSONParser parser) throws IOException {
            super(parser);
        }

        public void addKeyVal(Object map, Object key, Object val) throws IOException {
            Object prev = ((Map)map).put(key, val);
            if (prev != null) {
                throw new RuntimeException("REPEATED JSON OBJECT KEY: key=" + key + " prevValue=" + prev + " thisValue" + val);
            }
        }
    }
}

