/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.metrics.jetty10.InstrumentedHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.servlet.Filter;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.cloud.ChaosMonkey;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.cloud.ZkConfigSetService;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.TracerConfigurator;
import org.apache.solr.embedded.JettyConfig;
import org.apache.solr.embedded.JettySolrRunner;
import org.apache.solr.util.TimeOut;
import org.apache.solr.util.tracing.SimplePropagator;
import org.apache.solr.util.tracing.TraceUtils;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniSolrCloudCluster {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final URL PRE_GENERATED_PRIVATE_KEY_URL = MiniSolrCloudCluster.class.getClassLoader().getResource("cryptokeys/priv_key512_pkcs8.pem");
    private static final URL PRE_GENERATED_PUBLIC_KEY_URL = MiniSolrCloudCluster.class.getClassLoader().getResource("cryptokeys/pub_key512.der");
    public static final String TEST_URL_ALLOW_LIST = "solr.tests.allowUrls";
    public static final int DEFAULT_TIMEOUT = 30;
    public static final String DEFAULT_CLOUD_SOLR_XML = "<solr>\n\n  <str name=\"shareSchema\">${shareSchema:false}</str>\n  <str name=\"allowPaths\">${solr.allowPaths:}</str>\n  <str name=\"configSetBaseDir\">${configSetBaseDir:configsets}</str>\n  <str name=\"coreRootDirectory\">${coreRootDirectory:.}</str>\n  <str name=\"collectionsHandler\">${collectionsHandler:solr.CollectionsHandler}</str>\n  <str name=\"allowUrls\">${solr.tests.allowUrls:}</str>\n\n  <shardHandlerFactory name=\"shardHandlerFactory\" class=\"HttpShardHandlerFactory\">\n    <str name=\"urlScheme\">${urlScheme:}</str>\n    <int name=\"socketTimeout\">${socketTimeout:90000}</int>\n    <int name=\"connTimeout\">${connTimeout:15000}</int>\n  </shardHandlerFactory>\n\n  <solrcloud>\n    <str name=\"host\">127.0.0.1</str>\n    <int name=\"hostPort\">${hostPort:8983}</int>\n    <str name=\"hostContext\">${hostContext:solr}</str>\n    <int name=\"zkClientTimeout\">${solr.zkclienttimeout:30000}</int>\n    <bool name=\"genericCoreNodeNames\">${genericCoreNodeNames:true}</bool>\n    <int name=\"leaderVoteWait\">${leaderVoteWait:10000}</int>\n    <int name=\"distribUpdateConnTimeout\">${distribUpdateConnTimeout:45000}</int>\n    <int name=\"distribUpdateSoTimeout\">${distribUpdateSoTimeout:340000}</int>\n    <str name=\"zkCredentialsInjector\">${zkCredentialsInjector:org.apache.solr.common.cloud.DefaultZkCredentialsInjector}</str> \n    <str name=\"zkCredentialsProvider\">${zkCredentialsProvider:org.apache.solr.common.cloud.DefaultZkCredentialsProvider}</str> \n    <str name=\"zkACLProvider\">${zkACLProvider:org.apache.solr.common.cloud.DefaultZkACLProvider}</str> \n    <str name=\"pkiHandlerPrivateKeyPath\">${pkiHandlerPrivateKeyPath:" + (PRE_GENERATED_PRIVATE_KEY_URL != null ? PRE_GENERATED_PRIVATE_KEY_URL.toExternalForm() : "") + "}</str> \n    <str name=\"pkiHandlerPublicKeyPath\">${pkiHandlerPublicKeyPath:" + (PRE_GENERATED_PUBLIC_KEY_URL != null ? PRE_GENERATED_PUBLIC_KEY_URL.toExternalForm() : "") + "}</str> \n    <str name=\"distributedClusterStateUpdates\">${solr.distributedClusterStateUpdates:false}</str> \n    <str name=\"distributedCollectionConfigSetExecution\">${solr.distributedCollectionConfigSetExecution:false}</str> \n  </solrcloud>\n  <metrics enabled=\"${metricsEnabled:false}\">\n    <reporter name=\"default\" class=\"org.apache.solr.metrics.reporters.SolrJmxReporter\">\n      <str name=\"rootName\">solr_${hostPort:8983}</str>\n    </reporter>\n  </metrics>\n  \n</solr>\n";
    private final Object startupWait = new Object();
    private volatile ZkTestServer zkServer;
    private final boolean externalZkServer;
    private final List<JettySolrRunner> jettys = new CopyOnWriteArrayList<JettySolrRunner>();
    private final Path baseDir;
    private CloudSolrClient solrClient;
    private final JettyConfig jettyConfig;
    private final boolean trackJettyMetrics;
    private final AtomicInteger nodeIds = new AtomicInteger();
    private final Map<String, CloudSolrClient> solrClientByCollection = new ConcurrentHashMap<String, CloudSolrClient>();

    public MiniSolrCloudCluster(int numServers, Path baseDir, JettyConfig jettyConfig) throws Exception {
        this(numServers, baseDir, DEFAULT_CLOUD_SOLR_XML, jettyConfig, null, false);
    }

    public MiniSolrCloudCluster(int numServers, String hostContext, Path baseDir, String solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters) throws Exception {
        this(numServers, hostContext, baseDir, solrXml, extraServlets, extraRequestFilters, null);
    }

    public MiniSolrCloudCluster(int numServers, String hostContext, Path baseDir, String solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters, SSLConfig sslConfig) throws Exception {
        this(numServers, baseDir, solrXml, JettyConfig.builder().setContext(hostContext).withSSLConfig(sslConfig).withFilters(extraRequestFilters).withServlets(extraServlets).build());
    }

    public MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig) throws Exception {
        this(numServers, baseDir, solrXml, jettyConfig, null, false);
    }

    public MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig, ZkTestServer zkTestServer, boolean formatZkServer) throws Exception {
        this(numServers, baseDir, solrXml, jettyConfig, zkTestServer, Optional.empty(), formatZkServer);
    }

    MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig, ZkTestServer zkTestServer, Optional<String> securityJson, boolean formatZkServer) throws Exception {
        this(numServers, baseDir, solrXml, jettyConfig, zkTestServer, securityJson, false, formatZkServer);
    }

    MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig, ZkTestServer zkTestServer, Optional<String> securityJson, boolean trackJettyMetrics, boolean formatZkServer) throws Exception {
        Objects.requireNonNull(securityJson);
        this.baseDir = Objects.requireNonNull(baseDir);
        this.jettyConfig = Objects.requireNonNull(jettyConfig);
        this.trackJettyMetrics = trackJettyMetrics;
        log.info("Starting cluster of {} servers in {}", (Object)numServers, (Object)baseDir);
        Files.createDirectories(baseDir, new FileAttribute[0]);
        boolean bl = this.externalZkServer = zkTestServer != null;
        if (!this.externalZkServer) {
            Path zkDir = baseDir.resolve("zookeeper/server1/data");
            zkTestServer = new ZkTestServer(zkDir);
            try {
                zkTestServer.run(formatZkServer);
            }
            catch (Exception e) {
                log.error("Error starting Zk Test Server, trying again ...");
                zkTestServer.shutdown();
                zkTestServer = new ZkTestServer(zkDir);
                zkTestServer.run();
            }
        }
        this.zkServer = zkTestServer;
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(this.zkServer.getZkHost()).withTimeout(45000, TimeUnit.MILLISECONDS).build();){
            if (!zkClient.exists("/solr/solr.xml", true).booleanValue()) {
                zkClient.makePath("/solr/solr.xml", solrXml.getBytes(Charset.defaultCharset()), true);
                if (jettyConfig.sslConfig != null && jettyConfig.sslConfig.isSSLMode()) {
                    zkClient.makePath("/solr/clusterprops.json", "{'urlScheme':'https'}".getBytes(StandardCharsets.UTF_8), true);
                }
                if (securityJson.isPresent()) {
                    zkClient.makePath("/solr/security.json", securityJson.get().getBytes(Charset.defaultCharset()), true);
                }
            }
        }
        ArrayList<Callable<JettySolrRunner>> startups = new ArrayList<Callable<JettySolrRunner>>(numServers);
        for (int i = 0; i < numServers; ++i) {
            startups.add(() -> this.startJettySolrRunner(this.newNodeName(), jettyConfig.context, jettyConfig));
        }
        ExecutorService executorLauncher = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("jetty-launcher"));
        List<Future<JettySolrRunner>> futures = executorLauncher.invokeAll(startups);
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executorLauncher);
        Exception startupError = this.checkForExceptions("Error starting up MiniSolrCloudCluster", futures);
        if (startupError != null) {
            try {
                this.shutdown();
            }
            catch (Throwable t) {
                startupError.addSuppressed(t);
            }
            throw startupError;
        }
        this.solrClient = this.buildSolrClient();
        if (numServers > 0) {
            this.waitForAllNodes(numServers, 60);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAllNodes(int numServers, int timeoutSeconds) throws IOException, InterruptedException, TimeoutException {
        log.info("waitForAllNodes: numServers={}", (Object)numServers);
        if (timeoutSeconds == 0) {
            timeoutSeconds = 30;
        }
        TimeOut timeout = new TimeOut((long)timeoutSeconds, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        Iterator<JettySolrRunner> iterator = this.startupWait;
        synchronized (iterator) {
            int numRunning;
            while (numServers != (numRunning = this.numRunningJetty(this.getJettySolrRunners()))) {
                if (timeout.hasTimedOut()) {
                    throw new IllegalStateException("giving up waiting for all jetty instances to be running. numServers=" + numServers + " numRunning=" + numRunning);
                }
                this.startupWait.wait(500L);
            }
        }
        for (JettySolrRunner runner : this.getJettySolrRunners()) {
            this.waitForNode(runner, (int)timeout.timeLeft(TimeUnit.SECONDS));
        }
    }

    private int numRunningJetty(List<JettySolrRunner> runners) {
        int numRunning = 0;
        for (JettySolrRunner jsr : runners) {
            if (!jsr.isRunning()) continue;
            ++numRunning;
        }
        return numRunning;
    }

    public void waitForNode(JettySolrRunner jetty, int timeoutSeconds) throws InterruptedException, TimeoutException {
        String nodeName = jetty.getNodeName();
        if (nodeName == null) {
            throw new IllegalArgumentException("Cannot wait for Jetty with null node name");
        }
        log.info("waitForNode: {}", (Object)nodeName);
        this.getZkStateReader().waitForLiveNodes((long)timeoutSeconds, TimeUnit.SECONDS, (o, n) -> n != null && n.contains(nodeName));
    }

    public void waitForAllNodes(int timeout) throws IOException, InterruptedException, TimeoutException {
        this.waitForAllNodes(this.jettys.size(), timeout);
    }

    private String newNodeName() {
        return "node" + this.nodeIds.incrementAndGet();
    }

    private Path createInstancePath(String name) throws IOException {
        Path instancePath = this.baseDir.resolve(name);
        Files.createDirectory(instancePath, new FileAttribute[0]);
        return instancePath;
    }

    public ZkTestServer getZkServer() {
        return this.zkServer;
    }

    public ZkStateReader getZkStateReader() {
        return ZkStateReader.from((CloudSolrClient)this.getSolrClient());
    }

    public List<JettySolrRunner> getJettySolrRunners() {
        return Collections.unmodifiableList(this.jettys);
    }

    public JettySolrRunner getRandomJetty(Random random) {
        int index = random.nextInt(this.jettys.size());
        return this.jettys.get(index);
    }

    public JettySolrRunner startJettySolrRunner(String name, String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters) throws Exception {
        return this.startJettySolrRunner(name, hostContext, extraServlets, extraRequestFilters, null);
    }

    public JettySolrRunner startJettySolrRunner(String name, String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters, SSLConfig sslConfig) throws Exception {
        return this.startJettySolrRunner(name, hostContext, JettyConfig.builder().withServlets(extraServlets).withFilters(extraRequestFilters).withSSLConfig(sslConfig).build());
    }

    public JettySolrRunner getJettySolrRunner(int index) {
        return this.jettys.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JettySolrRunner startJettySolrRunner(String name, String hostContext, JettyConfig config) throws Exception {
        Properties nodeProps = new Properties();
        nodeProps.setProperty("zkHost", this.zkServer.getZkAddress());
        Path runnerPath = this.createInstancePath(name);
        String context = MiniSolrCloudCluster.getHostContextSuitableForServletContext(hostContext);
        JettyConfig newConfig = JettyConfig.builder(config).setContext(context).build();
        JettySolrRunner jetty = !this.trackJettyMetrics ? new JettySolrRunner(runnerPath.toString(), nodeProps, newConfig) : new JettySolrRunnerWithMetrics(runnerPath.toString(), nodeProps, newConfig);
        jetty.start();
        this.jettys.add(jetty);
        Object object = this.startupWait;
        synchronized (object) {
            this.startupWait.notifyAll();
        }
        return jetty;
    }

    public JettySolrRunner startJettySolrRunner() throws Exception {
        return this.startJettySolrRunner(this.newNodeName(), this.jettyConfig.context, this.jettyConfig);
    }

    public JettySolrRunner stopJettySolrRunner(int index) throws Exception {
        JettySolrRunner jetty = this.jettys.get(index);
        jetty.stop();
        this.jettys.remove(index);
        return jetty;
    }

    public JettySolrRunner startJettySolrRunner(JettySolrRunner jetty) throws Exception {
        jetty.start(false);
        if (!this.jettys.contains(jetty)) {
            this.jettys.add(jetty);
        }
        return jetty;
    }

    public JettySolrRunner stopJettySolrRunner(JettySolrRunner jetty) throws Exception {
        jetty.stop();
        this.jettys.remove(jetty);
        return jetty;
    }

    public void uploadConfigSet(Path configDir, String configName) throws IOException {
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(this.zkServer.getZkAddress()).withTimeout(45000, TimeUnit.MILLISECONDS).withConnTimeOut(45000, TimeUnit.MILLISECONDS).build();){
            new ZkConfigSetService(zkClient).uploadConfig(configName, configDir, true);
        }
    }

    public void deleteAllCollections() throws Exception {
        boolean allContainersEmpty;
        try (ZkStateReader reader = new ZkStateReader(this.getZkClient());){
            CountDownLatch latch = new CountDownLatch(1);
            reader.registerCloudCollectionsListener((oldCollections, newCollections) -> {
                if (newCollections != null && newCollections.size() == 0) {
                    latch.countDown();
                }
            });
            reader.createClusterStateWatchersAndUpdate();
            reader.aliasesManager.applyModificationAndExportToZk(aliases -> Aliases.EMPTY);
            for (Object collection : reader.getClusterState().getCollectionNames()) {
                CollectionAdminRequest.deleteCollection((String)collection).process((SolrClient)this.solrClient);
            }
            boolean success = latch.await(60L, TimeUnit.SECONDS);
            if (!success) {
                throw new IllegalStateException("Still waiting to see all collections removed from clusterstate.");
            }
            for (String collection : reader.getClusterState().getCollectionNames()) {
                reader.waitForState(collection, 15L, TimeUnit.SECONDS, Objects::isNull);
            }
        }
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        do {
            if (timeout.hasTimedOut()) {
                throw new TimeoutException("Timed out waiting for all collections to be fully removed.");
            }
            allContainersEmpty = true;
            for (JettySolrRunner jetty : this.jettys) {
                CoreContainer cc = jetty.getCoreContainer();
                if (cc == null || cc.getCores().size() == 0) continue;
                allContainersEmpty = false;
            }
        } while (!allContainersEmpty);
    }

    public void deleteAllConfigSets() throws Exception {
        List configSetNames = ((ConfigSetAdminResponse.List)new ConfigSetAdminRequest.List().process((SolrClient)this.solrClient)).getConfigSets();
        for (String configSet : configSetNames) {
            if (configSet.equals("_default")) continue;
            try {
                this.getZkClient().delete("/configs/" + configSet + "/configsetprops.json", -1, true);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            ((ConfigSetAdminRequest.Delete)new ConfigSetAdminRequest.Delete().setConfigSetName(configSet)).process((SolrClient)this.solrClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        try {
            IOUtils.closeQuietly((AutoCloseable)this.solrClient);
            this.solrClientByCollection.values().parallelStream().forEach(c -> IOUtils.closeQuietly((AutoCloseable)c));
            this.solrClientByCollection.clear();
            ArrayList<Callable<JettySolrRunner>> shutdowns = new ArrayList<Callable<JettySolrRunner>>(this.jettys.size());
            for (JettySolrRunner jetty : this.jettys) {
                shutdowns.add(() -> this.stopJettySolrRunner(jetty));
            }
            this.jettys.clear();
            ExecutorService executorCloser = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("jetty-closer"));
            List<Future<JettySolrRunner>> futures = executorCloser.invokeAll(shutdowns);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executorCloser);
            Exception shutdownError = this.checkForExceptions("Error shutting down MiniSolrCloudCluster", futures);
            if (shutdownError != null) {
                throw shutdownError;
            }
        }
        finally {
            if (!this.externalZkServer) {
                this.zkServer.shutdown();
            }
            MiniSolrCloudCluster.resetRecordingFlag();
        }
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public CloudSolrClient getSolrClient() {
        return this.solrClient;
    }

    public CloudSolrClient getSolrClient(String collectionName) {
        return this.solrClientByCollection.computeIfAbsent(collectionName, k -> {
            CloudLegacySolrClient solrClient = ((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)new CloudLegacySolrClient.Builder(Collections.singletonList(this.zkServer.getZkAddress()), Optional.empty()).withDefaultCollection(collectionName)).withSocketTimeout(90000)).withConnectionTimeout(15000)).build();
            solrClient.connect();
            if (log.isInfoEnabled()) {
                log.info("Created solrClient for collection {} with updatesToLeaders={} and parallelUpdates={}", new Object[]{collectionName, solrClient.isUpdatesToLeaders(), solrClient.isParallelUpdates()});
            }
            return solrClient;
        });
    }

    public SolrZkClient getZkClient() {
        return this.getZkStateReader().getZkClient();
    }

    public void zkSetData(String path, byte[] data, boolean retryOnConnLoss) throws InterruptedException {
        try {
            this.getZkClient().setData(path, data, -1, retryOnConnLoss);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Failed writing to Zookeeper", (Throwable)e);
        }
    }

    protected CloudSolrClient buildSolrClient() {
        return ((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)new CloudLegacySolrClient.Builder(Collections.singletonList(this.getZkServer().getZkAddress()), Optional.empty()).withSocketTimeout(90000, TimeUnit.MILLISECONDS)).withConnectionTimeout(15000, TimeUnit.MILLISECONDS)).build();
    }

    public CloudLegacySolrClient.Builder basicSolrClientBuilder() {
        return (CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)new CloudLegacySolrClient.Builder(Collections.singletonList(this.getZkServer().getZkAddress()), Optional.empty()).withSocketTimeout(90000)).withConnectionTimeout(15000);
    }

    private static String getHostContextSuitableForServletContext(String ctx) {
        if (ctx == null || ((String)ctx).isEmpty()) {
            ctx = "/solr";
        }
        if (((String)ctx).endsWith("/")) {
            ctx = ((String)ctx).substring(0, ((String)ctx).length() - 1);
        }
        if (!((String)ctx).startsWith("/")) {
            ctx = "/" + (String)ctx;
        }
        return ctx;
    }

    private Exception checkForExceptions(String message, Collection<Future<JettySolrRunner>> futures) throws InterruptedException {
        Exception parsed = new Exception(message);
        boolean ok = true;
        for (Future<JettySolrRunner> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                parsed.addSuppressed(e.getCause());
                ok = false;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw e;
            }
        }
        return ok ? null : parsed;
    }

    public JettySolrRunner getReplicaJetty(Replica replica) {
        for (JettySolrRunner jetty : this.jettys) {
            if (jetty.isStopped() || !replica.getCoreUrl().startsWith(jetty.getBaseUrl().toString())) continue;
            return jetty;
        }
        throw new IllegalArgumentException("Cannot find Jetty for a replica with core url " + replica.getCoreUrl());
    }

    public void expireZkSession(JettySolrRunner jetty) {
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null) {
            ChaosMonkey.causeConnectionLoss(jetty);
            this.zkServer.expire(cores.getZkController().getZkClient().getZooKeeper().getSessionId());
            if (log.isInfoEnabled()) {
                log.info("Expired zookeeper session from node {}", (Object)jetty.getBaseUrl());
            }
        }
    }

    public synchronized void injectChaos(Random random) throws Exception {
        JettySolrRunner jetty;
        if (random.nextBoolean()) {
            jetty = this.jettys.get(random.nextInt(this.jettys.size()));
            jetty.stop();
            log.info("============ Restarting jetty");
            jetty.start();
        }
        if (random.nextBoolean()) {
            this.zkServer.shutdown();
            log.info("============ Restarting zookeeper");
            this.zkServer = new ZkTestServer(this.zkServer.getZkDir(), this.zkServer.getPort());
            this.zkServer.run(false);
        }
        if (random.nextBoolean()) {
            jetty = this.jettys.get(random.nextInt(this.jettys.size()));
            ChaosMonkey.causeConnectionLoss(jetty);
        }
    }

    public Overseer getOpenOverseer() {
        ArrayList<Overseer> overseers = new ArrayList<Overseer>();
        for (int i = 0; i < this.jettys.size(); ++i) {
            JettySolrRunner runner = this.getJettySolrRunner(i);
            if (runner.getCoreContainer() == null) continue;
            overseers.add(runner.getCoreContainer().getZkController().getOverseer());
        }
        return MiniSolrCloudCluster.getOpenOverseer(overseers);
    }

    public static Overseer getOpenOverseer(List<Overseer> overseers) {
        ArrayList<Overseer> shuffledOverseers = new ArrayList<Overseer>(overseers);
        Collections.shuffle(shuffledOverseers, LuceneTestCase.random());
        for (Overseer overseer : shuffledOverseers) {
            if (overseer.isClosed()) continue;
            return overseer;
        }
        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No open Overseer found");
    }

    public void waitForActiveCollection(String collection, long wait, TimeUnit unit, int shards, int totalReplicas) {
        log.info("waitForActiveCollection: {}", (Object)collection);
        CollectionStatePredicate predicate = MiniSolrCloudCluster.expectedShardsAndActiveReplicas(shards, totalReplicas);
        AtomicReference state = new AtomicReference();
        AtomicReference liveNodesLastSeen = new AtomicReference();
        try {
            this.getZkStateReader().waitForState(collection, wait, unit, (n, c) -> {
                state.set(c);
                liveNodesLastSeen.set(n);
                return predicate.matches(n, c);
            });
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed while waiting for active collection\n" + e.getMessage() + "\nLive Nodes: " + Arrays.toString(((Set)liveNodesLastSeen.get()).toArray()) + "\nLast available state: " + state.get());
        }
    }

    public void waitForActiveCollection(String collection, int shards, int totalReplicas) {
        this.waitForActiveCollection(collection, 30L, TimeUnit.SECONDS, shards, totalReplicas);
    }

    public void waitForActiveCollection(String collection, long wait, TimeUnit unit) {
        log.info("waitForActiveCollection: {}", (Object)collection);
        CollectionStatePredicate predicate = MiniSolrCloudCluster.expectedActive();
        AtomicReference state = new AtomicReference();
        AtomicReference liveNodesLastSeen = new AtomicReference();
        try {
            this.getZkStateReader().waitForState(collection, wait, unit, (n, c) -> {
                state.set(c);
                liveNodesLastSeen.set(n);
                return predicate.matches(n, c);
            });
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed while waiting for active collection\n" + e.getMessage() + "\nLive Nodes: " + Arrays.toString(((Set)liveNodesLastSeen.get()).toArray()) + "\nLast available state: " + state.get());
        }
    }

    public static CollectionStatePredicate expectedShardsAndActiveReplicas(int expectedShards, int expectedReplicas) {
        return (liveNodes, collectionState) -> {
            if (collectionState == null) {
                return false;
            }
            if (collectionState.getSlices().size() != expectedShards) {
                return false;
            }
            int activeReplicas = 0;
            for (Slice slice : collectionState) {
                for (Replica replica : slice) {
                    if (!replica.isActive(liveNodes)) continue;
                    ++activeReplicas;
                }
            }
            return activeReplicas == expectedReplicas;
        };
    }

    public static CollectionStatePredicate expectedActive() {
        return (liveNodes, collectionState) -> {
            if (collectionState == null) {
                return false;
            }
            for (Slice slice : collectionState) {
                for (Replica replica : slice) {
                    if (replica.isActive(liveNodes)) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public void waitForJettyToStop(JettySolrRunner runner) throws TimeoutException {
        String nodeName = runner.getNodeName();
        if (nodeName == null) {
            log.info("Cannot wait for Jetty with null node name");
            return;
        }
        log.info("waitForJettyToStop: {}", (Object)nodeName);
        try {
            this.getZkStateReader().waitForLiveNodes(15L, TimeUnit.SECONDS, (o, n) -> !n.contains(nodeName));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "interrupted", (Throwable)e);
        }
    }

    public void dumpMetrics(File outputDirectory, String fileName) throws IOException {
        for (JettySolrRunner jetty : this.jettys) {
            jetty.outputMetrics(outputDirectory, fileName);
        }
    }

    public void dumpCoreInfo(PrintStream pw) throws IOException {
        for (JettySolrRunner jetty : this.jettys) {
            jetty.dumpCoresInfo(pw);
        }
    }

    private static void injectRandomRecordingFlag() {
        try {
            boolean isRecording = LuceneTestCase.rarely();
            TraceUtils.IS_RECORDING = ignored -> isRecording;
        }
        catch (IllegalStateException e) {
            log.warn("Unable to inject random recording flag due to outside randomized context", (Throwable)e);
        }
    }

    private static void resetRecordingFlag() {
        TraceUtils.IS_RECORDING = TraceUtils.DEFAULT_IS_RECORDING;
    }

    public static class Builder {
        private final int nodeCount;
        private final Path baseDir;
        private String solrXml = DEFAULT_CLOUD_SOLR_XML;
        private JettyConfig.Builder jettyConfigBuilder;
        private Optional<String> securityJson = Optional.empty();
        private List<Config> configs = new ArrayList<Config>();
        private Map<String, Object> clusterProperties = new HashMap<String, Object>();
        private boolean trackJettyMetrics;
        private boolean useDistributedCollectionConfigSetExecution;
        private boolean useDistributedClusterStateUpdate;
        private boolean formatZkServer = true;
        private boolean disableTraceIdGeneration = false;

        public Builder(int nodeCount, Path baseDir) {
            this.nodeCount = nodeCount;
            this.baseDir = baseDir;
            this.jettyConfigBuilder = JettyConfig.builder();
        }

        public Builder withJettyConfig(Consumer<JettyConfig.Builder> fun) {
            fun.accept(this.jettyConfigBuilder);
            return this;
        }

        public Builder withSolrXml(String solrXml) {
            this.solrXml = solrXml;
            return this;
        }

        public Builder withSolrXml(Path solrXml) {
            try {
                this.solrXml = new String(Files.readAllBytes(solrXml), Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withSecurityJson(Path securityJson) {
            try {
                this.securityJson = Optional.of(new String(Files.readAllBytes(securityJson), Charset.defaultCharset()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withSecurityJson(String securityJson) {
            this.securityJson = Optional.of(securityJson);
            return this;
        }

        public Builder addConfig(String configName, Path configPath) {
            this.configs.add(new Config(configName, configPath));
            return this;
        }

        public Builder useOtherCollectionConfigSetExecution() {
            this.useDistributedCollectionConfigSetExecution = !this.useDistributedCollectionConfigSetExecution;
            this.useDistributedClusterStateUpdate = !this.useDistributedClusterStateUpdate || this.useDistributedCollectionConfigSetExecution;
            return this;
        }

        public Builder withDistributedClusterStateUpdates(boolean distributedCollectionConfigSetApi, boolean distributedClusterStateUpdates) {
            this.useDistributedCollectionConfigSetExecution = distributedCollectionConfigSetApi;
            this.useDistributedClusterStateUpdate = distributedClusterStateUpdates;
            return this;
        }

        public Builder withProperty(String propertyName, String propertyValue) {
            this.clusterProperties.put(propertyName, propertyValue);
            return this;
        }

        public Builder withMetrics(boolean trackJettyMetrics) {
            this.trackJettyMetrics = trackJettyMetrics;
            return this;
        }

        public Builder formatZkServer(boolean formatZkServer) {
            this.formatZkServer = formatZkServer;
            return this;
        }

        public MiniSolrCloudCluster configure() throws Exception {
            SolrCloudTestCase.cluster = this.build();
            return SolrCloudTestCase.cluster;
        }

        public MiniSolrCloudCluster build() throws Exception {
            System.setProperty("solr.distributedCollectionConfigSetExecution", Boolean.toString(this.useDistributedCollectionConfigSetExecution));
            System.setProperty("solr.distributedClusterStateUpdates", Boolean.toString(this.useDistributedClusterStateUpdate));
            if (!this.disableTraceIdGeneration && TracerConfigurator.TRACE_ID_GEN_ENABLED) {
                SimplePropagator.load();
                MiniSolrCloudCluster.injectRandomRecordingFlag();
            }
            JettyConfig jettyConfig = this.jettyConfigBuilder.build();
            MiniSolrCloudCluster cluster = new MiniSolrCloudCluster(this.nodeCount, this.baseDir, this.solrXml, jettyConfig, null, this.securityJson, this.trackJettyMetrics, this.formatZkServer);
            for (Config config : this.configs) {
                cluster.uploadConfigSet(config.path, config.name);
            }
            if (this.clusterProperties.size() > 0) {
                ClusterProperties props = new ClusterProperties(cluster.getZkClient());
                for (Map.Entry<String, Object> entry : this.clusterProperties.entrySet()) {
                    props.setClusterProperty(entry.getKey(), entry.getValue());
                }
            }
            return cluster;
        }

        public Builder withDefaultClusterProperty(String key, String value) {
            HashMap<String, String> cluster;
            HashMap<String, HashMap<String, String>> defaults = (HashMap<String, HashMap<String, String>>)this.clusterProperties.get("defaults");
            if (defaults == null) {
                defaults = new HashMap<String, HashMap<String, String>>();
                this.clusterProperties.put("defaults", defaults);
            }
            if ((cluster = (HashMap<String, String>)defaults.get("cluster")) == null) {
                cluster = new HashMap<String, String>();
                defaults.put("cluster", cluster);
            }
            cluster.put(key, value);
            return this;
        }

        public Builder withTraceIdGenerationDisabled() {
            this.disableTraceIdGeneration = true;
            return this;
        }
    }

    private static class Config {
        final String name;
        final Path path;

        private Config(String name, Path path) {
            this.name = name;
            this.path = path;
        }
    }

    public static final class JettySolrRunnerWithMetrics
    extends JettySolrRunner {
        private volatile MetricRegistry metricRegistry;

        public JettySolrRunnerWithMetrics(String solrHome, Properties nodeProps, JettyConfig config) {
            super(solrHome, nodeProps, config);
        }

        @Override
        protected HandlerWrapper injectJettyHandlers(HandlerWrapper chain) {
            this.metricRegistry = new MetricRegistry();
            InstrumentedHandler metrics = new InstrumentedHandler(this.metricRegistry);
            metrics.setHandler((Handler)chain);
            return metrics;
        }

        public MetricRegistry getMetricRegistry() {
            return this.metricRegistry;
        }
    }
}

