/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.CoreStatus;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.LiveNodesPredicate;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.embedded.JettySolrRunner;
import org.junit.AfterClass;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCloudTestCase
extends SolrTestCaseJ4 {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Boolean USE_PER_REPLICA_STATE = Boolean.parseBoolean(System.getProperty("use.per-replica", "false"));
    public static final int DEFAULT_TIMEOUT = 45;
    protected static volatile MiniSolrCloudCluster cluster;

    protected static SolrZkClient zkClient() {
        ZkStateReader reader = cluster.getZkStateReader();
        if (reader == null) {
            cluster.getSolrClient().connect();
        }
        return cluster.getZkStateReader().getZkClient();
    }

    protected static MiniSolrCloudCluster.Builder configureCluster(int nodeCount) {
        boolean useDistributedCollectionConfigSetExecution = LuceneTestCase.random().nextInt(2) == 0;
        boolean useDistributedClusterStateUpdate = useDistributedCollectionConfigSetExecution || LuceneTestCase.random().nextInt(2) == 0;
        return new MiniSolrCloudCluster.Builder(nodeCount, SolrCloudTestCase.createTempDir()).withDistributedClusterStateUpdates(useDistributedCollectionConfigSetExecution, useDistributedClusterStateUpdate);
    }

    @AfterClass
    public static void shutdownCluster() throws Exception {
        if (cluster != null) {
            try {
                cluster.shutdown();
            }
            finally {
                cluster = null;
            }
        }
    }

    @Before
    public void checkClusterConfiguration() {
    }

    protected static DocCollection getCollectionState(String collectionName) {
        return cluster.getSolrClient().getClusterState().getCollection(collectionName);
    }

    protected static void waitForState(String message, String collection, CollectionStatePredicate predicate) {
        SolrCloudTestCase.waitForState(message, collection, 45, TimeUnit.SECONDS, predicate);
    }

    protected static void waitForState(String message, String collection, int timeout, TimeUnit timeUnit, CollectionStatePredicate predicate) {
        log.info("waitForState ({}): {}", (Object)collection, (Object)message);
        AtomicReference state = new AtomicReference();
        AtomicReference liveNodesLastSeen = new AtomicReference();
        try {
            cluster.getZkStateReader().waitForState(collection, (long)timeout, timeUnit, (n, c) -> {
                state.set(c);
                liveNodesLastSeen.set(n);
                return predicate.matches(n, c);
            });
        }
        catch (Exception e) {
            SolrCloudTestCase.fail((String)(message + "\n" + e.getMessage() + "\nLive Nodes: " + Arrays.toString(((Set)liveNodesLastSeen.get()).toArray()) + "\nLast available state: " + state.get()));
        }
    }

    protected static void waitForState(String message, String collection, Predicate<DocCollection> predicate) {
        SolrCloudTestCase.waitForState(message, collection, 45, TimeUnit.SECONDS, predicate);
    }

    protected static void waitForState(String message, String collection, int timeout, TimeUnit timeUnit, Predicate<DocCollection> predicate) {
        log.info("waitForState ({}): {}", (Object)collection, (Object)message);
        AtomicReference state = new AtomicReference();
        try {
            cluster.getZkStateReader().waitForState(collection, (long)timeout, timeUnit, c -> {
                state.set(c);
                return predicate.test((DocCollection)c);
            });
        }
        catch (Exception e) {
            SolrCloudTestCase.fail((String)(message + "\n" + e.getMessage() + "\nLast available state: " + state.get()));
        }
    }

    public static CollectionStatePredicate clusterShape(int expectedShards, int expectedReplicas) {
        return (liveNodes, collectionState) -> {
            if (collectionState == null) {
                return false;
            }
            if (collectionState.getSlices().size() != expectedShards) {
                return false;
            }
            return SolrCloudTestCase.compareActiveReplicaCountsForShards(expectedReplicas, liveNodes, collectionState);
        };
    }

    public static CollectionStatePredicate activeClusterShape(int expectedShards, int expectedReplicas) {
        return (liveNodes, collectionState) -> {
            if (collectionState == null) {
                return false;
            }
            if (log.isInfoEnabled()) {
                log.info("active slice count: {} expected: {}", (Object)collectionState.getActiveSlices().size(), (Object)expectedShards);
            }
            if (collectionState.getActiveSlices().size() != expectedShards) {
                return false;
            }
            return SolrCloudTestCase.compareActiveReplicaCountsForShards(expectedReplicas, liveNodes, collectionState);
        };
    }

    public static LiveNodesPredicate containsLiveNode(String node) {
        return (oldNodes, newNodes) -> newNodes.contains(node);
    }

    public static LiveNodesPredicate missingLiveNode(String node) {
        return (oldNodes, newNodes) -> !newNodes.contains(node);
    }

    public static LiveNodesPredicate missingLiveNodes(List<String> nodes) {
        return (oldNodes, newNodes) -> {
            boolean success = true;
            for (String lostNodeName : nodes) {
                if (!newNodes.contains(lostNodeName)) continue;
                success = false;
                break;
            }
            return success;
        };
    }

    private static boolean compareActiveReplicaCountsForShards(int expectedReplicas, Set<String> liveNodes, DocCollection collectionState) {
        int activeReplicas = 0;
        for (Slice slice : collectionState) {
            for (Replica replica : slice) {
                if (!replica.isActive(liveNodes)) continue;
                ++activeReplicas;
            }
        }
        log.info("active replica count: {} expected replica count: {}", (Object)activeReplicas, (Object)expectedReplicas);
        return activeReplicas == expectedReplicas;
    }

    protected static Slice getRandomShard(DocCollection collection) {
        ArrayList shards = new ArrayList(collection.getActiveSlices());
        if (shards.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random shard for collection as it has no shards!\n" + collection.toString()));
        }
        Collections.shuffle(shards, SolrCloudTestCase.random());
        return (Slice)shards.get(0);
    }

    protected static Replica getRandomReplica(Slice slice) {
        ArrayList replicas = new ArrayList(slice.getReplicas());
        if (replicas.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random replica from shard as it has no replicas!\n" + slice.toString()));
        }
        Collections.shuffle(replicas, SolrCloudTestCase.random());
        return (Replica)replicas.get(0);
    }

    protected static Replica getRandomReplica(Slice slice, Predicate<Replica> matchPredicate) {
        ArrayList replicas = new ArrayList(slice.getReplicas());
        if (replicas.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random replica from shard as it has no replicas!\n" + slice.toString()));
        }
        Collections.shuffle(replicas, SolrCloudTestCase.random());
        for (Replica replica : replicas) {
            if (!matchPredicate.test(replica)) continue;
            return replica;
        }
        SolrCloudTestCase.fail((String)("Couldn't get random replica that matched conditions\n" + slice.toString()));
        return null;
    }

    protected static CoreStatus getCoreStatus(Replica replica) throws IOException, SolrServerException {
        JettySolrRunner jetty = cluster.getReplicaJetty(replica);
        try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(jetty.getBaseUrl().toString()).withHttpClient(((CloudLegacySolrClient)cluster.getSolrClient()).getHttpClient())).build();){
            CoreStatus coreStatus = CoreAdminRequest.getCoreStatus((String)replica.getCoreName(), (SolrClient)client);
            return coreStatus;
        }
    }

    protected NamedList waitForResponse(Predicate<NamedList> predicate, SolrRequest request, int intervalInMillis, int numRetries, String messageOnFail) {
        int i;
        log.info("waitForResponse: {}", (Object)request);
        for (i = 0; i < numRetries; ++i) {
            try {
                NamedList response = cluster.getSolrClient().request(request);
                if (predicate.test(response)) {
                    return response;
                }
                Thread.sleep(intervalInMillis);
                continue;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new RuntimeException("error executing request", e);
            }
        }
        SolrCloudTestCase.fail((String)("Tried " + i + " times , could not succeed. " + messageOnFail));
        return null;
    }

    public static void ensureRunningJettys(int nodeCount, int timeoutSeconds) throws Exception {
        int i;
        List<JettySolrRunner> jettys = cluster.getJettySolrRunners();
        ArrayList<JettySolrRunner> copyOfJettys = new ArrayList<JettySolrRunner>(jettys);
        int numJetties = copyOfJettys.size();
        for (i = nodeCount; i < numJetties; ++i) {
            cluster.stopJettySolrRunner((JettySolrRunner)copyOfJettys.get(i));
        }
        for (i = copyOfJettys.size(); i < nodeCount; ++i) {
            cluster.startJettySolrRunner();
        }
        jettys = cluster.getJettySolrRunners();
        numJetties = jettys.size();
        for (i = 0; i < numJetties; ++i) {
            if (jettys.get(i).isRunning()) continue;
            cluster.startJettySolrRunner(jettys.get(i));
        }
        cluster.waitForAllNodes(timeoutSeconds);
    }

    public static Map<String, String> mapReplicasToReplicaType(DocCollection collection) {
        HashMap<String, String> replicaTypeMap = new HashMap<String, String>();
        for (Slice slice : collection.getSlices()) {
            for (Replica replica : slice.getReplicas()) {
                String coreUrl = replica.getCoreUrl();
                replicaTypeMap.put(coreUrl, replica.getType().toString());
                if (coreUrl.endsWith("/")) {
                    replicaTypeMap.put(coreUrl.substring(0, coreUrl.length() - 1), replica.getType().toString());
                    continue;
                }
                replicaTypeMap.put(coreUrl + "/", replica.getType().toString());
            }
        }
        return replicaTypeMap;
    }
}

