/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URI;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.avro.AvroFileFormat$;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOutputWriterFactory;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf!B\u0001\u0003\u0001\ta!AD!we>4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u0007\u0011\tA!\u0019<s_*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\r\u0001i1cG\u0011(!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#G\u0007\u0002+)\u0011acF\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0019\t\u0005IQ\r_3dkRLwN\\\u0005\u00035U\u0011!BR5mK\u001a{'/\\1u!\tar$D\u0001\u001e\u0015\tqB!A\u0004t_V\u00148-Z:\n\u0005\u0001j\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\u0004\u0002\u0011%tG/\u001a:oC2L!AJ\u0012\u0003\u000f1{wmZ5oOB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0003S>T\u0011\u0001L\u0001\u0005U\u00064\u0018-\u0003\u0002/S\ta1+\u001a:jC2L'0\u00192mK\")\u0001\u0007\u0001C\u0001e\u00051A(\u001b8jiz\u001a\u0001\u0001F\u00014!\t!\u0004!D\u0001\u0003\u0011\u00151\u0004\u0001\"\u00118\u0003\u0019)\u0017/^1mgR\u0011\u0001h\u000f\t\u0003\u001deJ!AO\b\u0003\u000f\t{w\u000e\\3b]\")A(\u000ea\u0001{\u0005)q\u000e\u001e5feB\u0011aBP\u0005\u0003\u007f=\u00111!\u00118z\u0011\u0015\t\u0005\u0001\"\u0011C\u0003!A\u0017m\u001d5D_\u0012,G#A\"\u0011\u00059!\u0015BA#\u0010\u0005\rIe\u000e\u001e\u0005\u0006\u000f\u0002!\t\u0005S\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003J%^;\u0007c\u0001\bK\u0019&\u00111j\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055\u0003V\"\u0001(\u000b\u0005=#\u0011!\u0002;za\u0016\u001c\u0018BA)O\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u000f\u0019\u0003\ra\u0015\t\u0003)Vk\u0011\u0001B\u0005\u0003-\u0012\u0011Ab\u00159be.\u001cVm]:j_:DQ\u0001\u0017$A\u0002e\u000bqa\u001c9uS>t7\u000f\u0005\u0003[C\u0012$gBA.`!\tav\"D\u0001^\u0015\tq\u0016'\u0001\u0004=e>|GOP\u0005\u0003A>\ta\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\ri\u0015\r\u001d\u0006\u0003A>\u0001\"AW3\n\u0005\u0019\u001c'AB*ue&tw\rC\u0003i\r\u0002\u0007\u0011.A\u0003gS2,7\u000fE\u0002k_Jt!a[7\u000f\u0005qc\u0017\"\u0001\t\n\u00059|\u0011a\u00029bG.\fw-Z\u0005\u0003aF\u00141aU3r\u0015\tqw\u0002\u0005\u0002tq6\tAO\u0003\u0002vm\u0006\u0011am\u001d\u0006\u0003o\"\ta\u0001[1e_>\u0004\u0018BA=u\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006w\u0002!\t\u0005`\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\u001a\u0005\u0006}\u0002!\te`\u0001\fSN\u001c\u0006\u000f\\5uC\ndW\rF\u00049\u0003\u0003\t)!a\u0002\t\r\u0005\rQ\u00101\u0001T\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o\u0011\u0015AV\u00101\u0001Z\u0011\u001d\tI! a\u0001\u0003\u0017\tA\u0001]1uQB\u00191/!\u0004\n\u0007\u0005=AO\u0001\u0003QCRD\u0007bBA\n\u0001\u0011\u0005\u0013QC\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u000b\u0003/\ti\"a\b\u00020\u0005E\u0002c\u0001\u000b\u0002\u001a%\u0019\u00111D\u000b\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\r\u001d\t\t\u00021\u0001T\u0011!\t\t#!\u0005A\u0002\u0005\r\u0012a\u00016pEB!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*Y\f\u0011\"\\1qe\u0016$WoY3\n\t\u00055\u0012q\u0005\u0002\u0004\u0015>\u0014\u0007B\u0002-\u0002\u0012\u0001\u0007\u0011\fC\u0004\u00024\u0005E\u0001\u0019\u0001'\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\rC\u0004\u00028\u0001!\t%!\u000f\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003w\tI&a\u0017\u0002^\u0005\u0005\u0014QMA9\u0003g\u0002rADA\u001f\u0003\u0003\n9%C\u0002\u0002@=\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007Q\t\u0019%C\u0002\u0002FU\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006U\u0006%\u0013QJ\u0005\u0004\u0003\u0017\n(\u0001C%uKJ\fGo\u001c:\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u0005\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA,\u0003#\u00121\"\u00138uKJt\u0017\r\u001c*po\"1q!!\u000eA\u0002MCq!a\r\u00026\u0001\u0007A\nC\u0004\u0002`\u0005U\u0002\u0019\u0001'\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006Dq!a\u0019\u00026\u0001\u0007A*\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u0011\u0005\u001d\u0014Q\u0007a\u0001\u0003S\nqAZ5mi\u0016\u00148\u000f\u0005\u0003k_\u0006-\u0004c\u0001\u000f\u0002n%\u0019\u0011qN\u000f\u0003\r\u0019KG\u000e^3s\u0011\u0019A\u0016Q\u0007a\u00013\"A\u0011QOA\u001b\u0001\u0004\t9(\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{2\u0018\u0001B2p]\u001aLA!!!\u0002|\ti1i\u001c8gS\u001e,(/\u0019;j_:<\u0001\"!\"\u0003\u0011\u0003\u0011\u0011qQ\u0001\u000f\u0003Z\u0014xNR5mK\u001a{'/\\1u!\r!\u0014\u0011\u0012\u0004\b\u0003\tA\tAAAF'\u0015\tI)DAG!\rq\u0011qR\u0005\u0003]=Aq\u0001MAE\t\u0003\t\u0019\n\u0006\u0002\u0002\b\"Q\u0011qSAE\u0005\u0004%\t!!'\u0002G%;gn\u001c:f\r&dWm],ji\"|W\u000f^#yi\u0016t7/[8o!J|\u0007/\u001a:usV\u0011\u00111\u0014\t\u0005\u0003;\u000b\u0019+\u0004\u0002\u0002 *\u0019\u0011\u0011U\u0016\u0002\t1\fgnZ\u0005\u0004M\u0006}\u0005\"CAT\u0003\u0013\u0003\u000b\u0011BAN\u0003\u0011JuM\\8sK\u001aKG.Z:XSRDw.\u001e;FqR,gn]5p]B\u0013x\u000e]3sif\u0004\u0003BCAV\u0003\u0013\u000b\t\u0011\"\u0003\u0002.\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u000b\u0005\u0003\u0002\u001e\u0006E\u0016\u0002BAZ\u0003?\u0013aa\u00142kK\u000e$\b")
public class AvroFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String IgnoreFilesWithoutExtensionProperty() {
        return AvroFileFormat$.MODULE$.IgnoreFilesWithoutExtensionProperty();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType, (boolean)isReadPath);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean equals(Object other) {
        Object object = other;
        boolean bl = object instanceof AvroFileFormat;
        return bl;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Option<StructType> inferSchema(SparkSession spark, Map<String, String> options, Seq<FileStatus> files) {
        Configuration conf = spark.sessionState().newHadoopConf();
        AvroOptions parsedOptions = new AvroOptions(options, conf);
        FileStatus sampleFile = parsedOptions.ignoreExtension() ? (FileStatus)files.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException("Files for schema inferring have been not found.");
        }) : (FileStatus)files.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AvroFileFormat.$anonfun$inferSchema$2(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException("No Avro files found. If files don't have .avro extension, set ignoreExtension to true");
        });
        Schema.Parser parser = new Schema.Parser();
        Schema avroSchema = (Schema)parsedOptions.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Schema schema;
            try (FsInput in = new FsInput(sampleFile.getPath(), conf);
                 FileReader reader = DataFileReader.openReader((SeekableInput)in, (DatumReader)new GenericDatumReader());){
                schema = reader.getSchema();
            }
            return schema;
        });
        DataType dataType = SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
        if (!(dataType instanceof StructType)) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(97).append("Avro schema cannot be converted to a Spark SQL StructType:\n           |\n           |").append(avroSchema.toString(true)).append("\n           |").toString())).stripMargin());
        }
        StructType structType = (StructType)dataType;
        Some some = new Some((Object)structType);
        return some;
    }

    public String shortName() {
        return "avro";
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public OutputWriterFactory prepareWrite(SparkSession spark, Job job, Map<String, String> options, StructType dataSchema) {
        AvroOptions parsedOptions = new AvroOptions(options, spark.sessionState().newHadoopConf());
        Schema.Parser parser = new Schema.Parser();
        Schema outputAvroSchema = (Schema)parsedOptions.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, parsedOptions.recordName(), parsedOptions.recordNamespace()));
        AvroJob.setOutputKeySchema((Job)job, (Schema)outputAvroSchema);
        String string = parsedOptions.compression();
        String string2 = "uncompressed";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            job.getConfiguration().setBoolean("mapred.output.compress", false);
        } else {
            String string3;
            job.getConfiguration().setBoolean("mapred.output.compress", true);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(40).append("Compressing Avro output using the ").append(parsedOptions.compression()).append(" codec").toString());
            String string4 = parsedOptions.compression();
            if ("deflate".equals(string4)) {
                int deflateLevel = spark.sessionState().conf().avroDeflateLevel();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(55).append("Avro compression level ").append(deflateLevel).append(" will be used for ").append("deflate").append(" codec.").toString());
                job.getConfiguration().setInt("avro.mapred.deflate.level", deflateLevel);
                string3 = "deflate";
            } else {
                boolean bl = "snappy".equals(string4) ? true : ("bzip2".equals(string4) ? true : "xz".equals(string4));
                if (bl) {
                    string3 = string4;
                } else {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(27).append("Invalid compression codec: ").append(string4).toString());
                }
            }
            String codec = string3;
            job.getConfiguration().set("avro.output.codec", codec);
        }
        return new AvroOutputWriterFactory(dataSchema, outputAvroSchema.toString());
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession spark, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        AvroOptions parsedOptions = new AvroOptions(options, hadoopConf);
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            Configuration conf = ((SerializableConfiguration)broadcastedConf.value()).value();
            Schema.Parser parser = new Schema.Parser();
            Option userProvidedSchema = parsedOptions.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1));
            if (parsedOptions.ignoreExtension() || file.filePath().endsWith(".avro")) {
                FileReader fileReader;
                FsInput in = new FsInput(new Path(new URI(file.filePath())), conf);
                try {
                    GenericDatumReader genericDatumReader;
                    Option option = userProvidedSchema;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Schema userSchema = (Schema)some.value();
                        genericDatumReader = new GenericDatumReader(userSchema);
                    } else {
                        genericDatumReader = new GenericDatumReader();
                    }
                    GenericDatumReader datumReader = genericDatumReader;
                    fileReader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while opening DataFileReader", e);
                        in.close();
                        throw e;
                    }
                    throw throwable;
                }
                FileReader reader = fileReader;
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)taskContext -> taskContext.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
                    reader.close();
                    return BoxedUnit.UNIT;
                }));
                reader.sync(file.start());
                long stop = file.start() + file.length();
                AvroDeserializer deserializer = new AvroDeserializer((Schema)userProvidedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> reader.getSchema()), (DataType)requiredSchema);
                iterator = new Iterator<InternalRow>(null, reader, stop, deserializer){
                    private boolean completed;
                    private final FileReader reader$1;
                    private final long stop$1;
                    private final AvroDeserializer deserializer$1;

                    public Iterator<InternalRow> seq() {
                        return Iterator.seq$((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.isEmpty$((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.isTraversableAgain$((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.hasDefiniteSize$((Iterator)this);
                    }

                    public Iterator<InternalRow> take(int n) {
                        return Iterator.take$((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> drop(int n) {
                        return Iterator.drop$((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> slice(int from, int until) {
                        return Iterator.slice$((Iterator)this, (int)from, (int)until);
                    }

                    public Iterator<InternalRow> sliceIterator(int from, int until) {
                        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                        return Iterator.map$((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.$plus$plus$((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
                        return Iterator.flatMap$((Iterator)this, f);
                    }

                    public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                        return Iterator.filter$((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
                        return Iterator.corresponds$((Iterator)this, that, p);
                    }

                    public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                        return Iterator.withFilter$((Iterator)this, p);
                    }

                    public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                        return Iterator.filterNot$((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                        return Iterator.collect$((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                        return Iterator.scanLeft$((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                        return Iterator.scanRight$((Iterator)this, z, op);
                    }

                    public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                        return Iterator.takeWhile$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                        return Iterator.partition$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                        return Iterator.span$((Iterator)this, p);
                    }

                    public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                        return Iterator.dropWhile$((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
                        return Iterator.zip$((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.padTo$((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                        return Iterator.zipWithIndex$((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<InternalRow, U> f) {
                        Iterator.foreach$((Iterator)this, f);
                    }

                    public boolean forall(Function1<InternalRow, Object> p) {
                        return Iterator.forall$((Iterator)this, p);
                    }

                    public boolean exists(Function1<InternalRow, Object> p) {
                        return Iterator.exists$((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.contains$((Iterator)this, (Object)elem);
                    }

                    public Option<InternalRow> find(Function1<InternalRow, Object> p) {
                        return Iterator.find$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<InternalRow, Object> p) {
                        return Iterator.indexWhere$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<InternalRow, Object> p, int from) {
                        return Iterator.indexWhere$((Iterator)this, p, (int)from);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.indexOf$((Iterator)this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return Iterator.indexOf$((Iterator)this, elem, (int)from);
                    }

                    public BufferedIterator<InternalRow> buffered() {
                        return Iterator.buffered$((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.grouped$((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                    }

                    public int length() {
                        return Iterator.length$((Iterator)this);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                        return Iterator.duplicate$((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.sameElements$((Iterator)this, that);
                    }

                    public Traversable<InternalRow> toTraversable() {
                        return Iterator.toTraversable$((Iterator)this);
                    }

                    public Iterator<InternalRow> toIterator() {
                        return Iterator.toIterator$((Iterator)this);
                    }

                    public Stream<InternalRow> toStream() {
                        return Iterator.toStream$((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.toString$((Iterator)this);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.sliding$default$2$((Iterator)this);
                    }

                    public List<InternalRow> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.size$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<InternalRow, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<InternalRow> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Iterable<InternalRow> toIterable() {
                        return TraversableOnce.toIterable$((TraversableOnce)this);
                    }

                    public Seq<InternalRow> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<InternalRow> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<InternalRow> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
                        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<InternalRow, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public boolean hasNext() {
                        boolean bl;
                        if (this.completed) {
                            bl = false;
                        } else {
                            void var1_1;
                            boolean r;
                            boolean bl2 = r = this.reader$1.hasNext() && !this.reader$1.pastSync(this.stop$1);
                            if (!r) {
                                this.reader$1.close();
                                this.completed = true;
                            }
                            bl = var1_1;
                        }
                        return bl;
                    }

                    public InternalRow next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("next on empty iterator");
                        }
                        GenericRecord record = (GenericRecord)this.reader$1.next();
                        return (InternalRow)this.deserializer$1.deserialize(record);
                    }
                    {
                        this.reader$1 = reader$1;
                        this.stop$1 = stop$1;
                        this.deserializer$1 = deserializer$1;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Iterator.$init$((Iterator)this);
                        this.completed = false;
                    }
                };
            } else {
                iterator = package$.MODULE$.Iterator().empty();
            }
            return iterator;
        };
    }

    public static final /* synthetic */ boolean $anonfun$inferSchema$2(FileStatus x$1) {
        return x$1.getPath().getName().endsWith(".avro");
    }

    public AvroFileFormat() {
        FileFormat.$init$((FileFormat)this);
        Logging.$init$((Logging)this);
    }
}

