/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.avro.AvroSerializer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e4Q!\u0001\u0002\u0001\u00051\u0011\u0001#\u0011<s_>+H\u000f];u/JLG/\u001a:\u000b\u0005\r!\u0011\u0001B1we>T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\t\u0001Q\u0002\u0005\u0002\u000f'5\tqB\u0003\u0002\u0011#\u0005YA-\u0019;bg>,(oY3t\u0015\t\u0011B!A\u0005fq\u0016\u001cW\u000f^5p]&\u0011Ac\u0004\u0002\r\u001fV$\b/\u001e;Xe&$XM\u001d\u0005\t-\u0001\u0011\t\u0011)A\u00051\u0005!\u0001/\u0019;i\u0007\u0001\u0001\"!\u0007\u0012\u000f\u0005i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0018\u0003\u0019a$o\\8u})\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\rM#(/\u001b8h\u0015\t\tc\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u00135\f\u0007O]3ek\u000e,'B\u0001\u0017\t\u0003\u0019A\u0017\rZ8pa&\u0011a&\u000b\u0002\u0013)\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003\u0019\u00198\r[3nCB\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\u0006if\u0004Xm]\u0005\u0003mM\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011!A\u0004A!A!\u0002\u0013I\u0014AC1we>\u001c6\r[3nCB\u0011!\bP\u0007\u0002w)\u00111\u0001C\u0005\u0003{m\u0012aaU2iK6\f\u0007\"B \u0001\t\u0003\u0001\u0015A\u0002\u001fj]&$h\bF\u0003B\u0007\u0012+e\t\u0005\u0002C\u00015\t!\u0001C\u0003\u0017}\u0001\u0007\u0001\u0004C\u0003'}\u0001\u0007q\u0005C\u00031}\u0001\u0007\u0011\u0007C\u00039}\u0001\u0007\u0011\b\u0003\u0005I\u0001!\u0015\r\u0011\"\u0003J\u0003)\u0019XM]5bY&TXM]\u000b\u0002\u0015B\u0011!iS\u0005\u0003\u0019\n\u0011a\"\u0011<s_N+'/[1mSj,'\u000fC\u0004O\u0001\t\u0007I\u0011B(\u0002\u0019I,7m\u001c:e/JLG/\u001a:\u0016\u0003A\u0003B\u0001K)T?&\u0011!+\u000b\u0002\r%\u0016\u001cwN\u001d3Xe&$XM\u001d\t\u0004)^KV\"A+\u000b\u0005Y[\u0014AB7baJ,G-\u0003\u0002Y+\n9\u0011I\u001e:p\u0017\u0016L\bC\u0001.^\u001b\u0005Y&B\u0001/<\u0003\u001d9WM\\3sS\u000eL!AX.\u0003\u001b\u001d+g.\u001a:jGJ+7m\u001c:e!\t\u00017-D\u0001b\u0015\t\u00117&\u0001\u0002j_&\u0011A-\u0019\u0002\r\u001dVdGn\u0016:ji\u0006\u0014G.\u001a\u0005\u0007M\u0002\u0001\u000b\u0011\u0002)\u0002\u001bI,7m\u001c:e/JLG/\u001a:!\u0011\u0015A\u0007\u0001\"\u0011j\u0003\u00159(/\u001b;f)\tQg\u000e\u0005\u0002lY6\ta$\u0003\u0002n=\t!QK\\5u\u0011\u0015yw\r1\u0001q\u0003\r\u0011xn\u001e\t\u0003cRl\u0011A\u001d\u0006\u0003g\u0012\t\u0001bY1uC2L8\u000f^\u0005\u0003kJ\u00141\"\u00138uKJt\u0017\r\u001c*po\")q\u000f\u0001C!q\u0006)1\r\\8tKR\t!\u000e")
public class AvroOutputWriter
extends OutputWriter {
    private AvroSerializer serializer;
    public final String org$apache$spark$sql$avro$AvroOutputWriter$$path;
    public final TaskAttemptContext org$apache$spark$sql$avro$AvroOutputWriter$$context;
    private final StructType schema;
    private final Schema avroSchema;
    private final RecordWriter<AvroKey<GenericRecord>, NullWritable> recordWriter;
    private volatile boolean bitmap$0;

    private AvroSerializer serializer$lzycompute() {
        AvroOutputWriter avroOutputWriter = this;
        synchronized (avroOutputWriter) {
            if (!this.bitmap$0) {
                this.serializer = new AvroSerializer((DataType)this.schema, this.avroSchema, false);
                this.bitmap$0 = true;
            }
        }
        this.schema = null;
        this.avroSchema = null;
        return this.serializer;
    }

    private AvroSerializer serializer() {
        return !this.bitmap$0 ? this.serializer$lzycompute() : this.serializer;
    }

    private RecordWriter<AvroKey<GenericRecord>, NullWritable> recordWriter() {
        return this.recordWriter;
    }

    public void write(InternalRow row) {
        AvroKey key = new AvroKey((Object)((GenericRecord)this.serializer().serialize(row)));
        this.recordWriter().write((Object)key, (Object)NullWritable.get());
    }

    public void close() {
        this.recordWriter().close(this.org$apache$spark$sql$avro$AvroOutputWriter$$context);
    }

    public AvroOutputWriter(String path, TaskAttemptContext context, StructType schema, Schema avroSchema) {
        this.org$apache$spark$sql$avro$AvroOutputWriter$$path = path;
        this.org$apache$spark$sql$avro$AvroOutputWriter$$context = context;
        this.schema = schema;
        this.avroSchema = avroSchema;
        this.recordWriter = new AvroKeyOutputFormat<GenericRecord>(this){
            private final /* synthetic */ AvroOutputWriter $outer;

            public Path getDefaultWorkFile(TaskAttemptContext context, String extension) {
                return new Path(this.$outer.org$apache$spark$sql$avro$AvroOutputWriter$$path);
            }

            public OutputStream getAvroFileOutputStream(TaskAttemptContext c) throws IOException {
                Path path = this.getDefaultWorkFile(this.$outer.org$apache$spark$sql$avro$AvroOutputWriter$$context, ".avro");
                return path.getFileSystem(this.$outer.org$apache$spark$sql$avro$AvroOutputWriter$$context.getConfiguration()).create(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.getRecordWriter(context);
    }
}

