/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011a\"\u0011<s_N+'/[1mSj,'O\u0003\u0002\u0004\t\u0005!\u0011M\u001e:p\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005\u0001\"o\\8u\u0007\u0006$\u0018\r\\=tiRK\b/\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\tQ\u0001^=qKNL!a\u0007\r\u0003\u0011\u0011\u000bG/\u0019+za\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\re>|G/\u0011<s_RK\b/\u001a\t\u0003?\u0005j\u0011\u0001\t\u0006\u0003\u0007!I!A\t\u0011\u0003\rM\u001b\u0007.Z7b\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001\u00038vY2\f'\r\\3\u0011\u0005=1\u0013BA\u0014\u0011\u0005\u001d\u0011un\u001c7fC:DQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtD\u0003B\u0016.]=\u0002\"\u0001\f\u0001\u000e\u0003\tAQ!\u0006\u0015A\u0002YAQ!\b\u0015A\u0002yAQ\u0001\n\u0015A\u0002\u0015BQ!\r\u0001\u0005\u0002I\n\u0011b]3sS\u0006d\u0017N_3\u0015\u0005M2\u0004CA\b5\u0013\t)\u0004CA\u0002B]fDQa\u000e\u0019A\u0002M\nAbY1uC2L8\u000f\u001e#bi\u0006Dq!\u000f\u0001C\u0002\u0013%!(A\u0005d_:4XM\u001d;feV\t1\b\u0005\u0003\u0010yM\u001a\u0014BA\u001f\u0011\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004@\u0001\u0001\u0006IaO\u0001\u000bG>tg/\u001a:uKJ\u0004S\u0001B!\u0001\t\t\u0013\u0011bQ8om\u0016\u0014H/\u001a:\u0011\u000b=\u0019U)T\u001a\n\u0005\u0011\u0003\"!\u0003$v]\u000e$\u0018n\u001c83!\t15*D\u0001H\u0015\tA\u0015*A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001&\u0005\u0003!\u0019\u0017\r^1msN$\u0018B\u0001'H\u0005I\u0019\u0006/Z2jC2L'0\u001a3HKR$XM]:\u0011\u0005=q\u0015BA(\u0011\u0005\rIe\u000e\u001e\u0005\t#\u0002A)\u0019!C\u0005%\u0006\u0011B-Z2j[\u0006d7i\u001c8wKJ\u001c\u0018n\u001c8t+\u0005\u0019\u0006C\u0001+a\u001d\t)fL\u0004\u0002W;:\u0011q\u000b\u0018\b\u00031nk\u0011!\u0017\u0006\u000352\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0002\t\u0013\ty\u0006%A\u0006D_:4XM]:j_:\u001c\u0018BA1c\u0005E!UmY5nC2\u001cuN\u001c<feNLwN\u001c\u0006\u0003?\u0002BQ\u0001\u001a\u0001\u0005\n\u0015\fAB\\3x\u0007>tg/\u001a:uKJ$2A\u001a5k!\t9\u0007)D\u0001\u0001\u0011\u0015I7\r1\u0001\u0017\u00031\u0019\u0017\r^1msN$H+\u001f9f\u0011\u0015Y7\r1\u0001\u001f\u0003!\tgO]8UsB,\u0007\"B7\u0001\t\u0013q\u0017A\u00058foN#(/^2u\u0007>tg/\u001a:uKJ$Ba\\@\u0002\nA!q\u0002\u00109u!\t\t(/D\u0001J\u0013\t\u0019\u0018JA\u0006J]R,'O\\1m%><\bCA;}\u001d\t1\u0018P\u0004\u0002Vo&\u0011\u0001\u0010I\u0001\bO\u0016tWM]5d\u0013\tQ80A\u0006HK:,'/[2ECR\f'B\u0001=!\u0013\tihP\u0001\u0004SK\u000e|'\u000f\u001a\u0006\u0003unDq!!\u0001m\u0001\u0004\t\u0019!\u0001\bdCR\fG._:u'R\u0014Xo\u0019;\u0011\u0007]\t)!C\u0002\u0002\ba\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011\u0019\tY\u0001\u001ca\u0001=\u0005Q\u0011M\u001e:p'R\u0014Xo\u0019;\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012\u0005\u0019\"/Z:pYZ,g*\u001e7mC\ndW\rV=qKR)a$a\u0005\u0002\u0016!11.!\u0004A\u0002yAa\u0001JA\u0007\u0001\u0004)\u0003")
public class AvroSerializer {
    private Conversions.DecimalConversion decimalConversions;
    private final Function1<Object, Object> converter;
    private volatile boolean bitmap$0;

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroSerializer avroSerializer = this;
        synchronized (avroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        return !this.bitmap$0 ? this.decimalConversions$lzycompute() : this.decimalConversions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType) {
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, avroType, decimalType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, avroType, decimalType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, avroType, decimalType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, avroType, decimalType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getEnumSymbols()).asScala()).toSet();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$11(avroType, enumSymbols, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$13(avroType, size, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                Function2 & Serializable & scala.Serializable intersect;
                LogicalType logicalType = avroType.getLogicalType();
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$16(getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                    return intersect;
                } else if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                    return intersect;
                } else {
                    if (logicalType != null) throw new IncompatibleSchemaException(new StringBuilder(60).append("Cannot convert Catalyst Timestamp type to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$18(getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                return intersect;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), containsNull));
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$19(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$20(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 == null) throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType = (DataType)tuple2._1();
        Schema.Type type = (Schema.Type)tuple2._2();
        if (!(dataType instanceof MapType)) throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        MapType mapType = (MapType)dataType;
        DataType kt = mapType.keyType();
        DataType vt = mapType.valueType();
        boolean valueContainsNull = mapType.valueContainsNull();
        if (!Schema.Type.MAP.equals(type)) throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType2 = kt;
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType2 == null) {
            if (stringType$ != null) {
                throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        } else if (!dataType2.equals(stringType$)) throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), valueContainsNull));
        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$21(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct) {
        Schema.Type type = avroStruct.getType();
        Schema.Type type2 = Schema.Type.RECORD;
        if ((type != null ? !type.equals(type2) : type2 != null) || avroStruct.getFields().size() != catalystStruct.length()) {
            throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystStruct).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroStruct).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        Seq fieldConverters = (Seq)((TraversableLike)catalystStruct.zip((GenIterable)JavaConverters$.MODULE$.asScalaBufferConverter(avroStruct.getFields()).asScala(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f1 = (StructField)tuple2._1();
            Schema.Field f2 = (Schema.Field)tuple2._2();
            Function2<SpecializedGetters, Object, Object> function2 = this.newConverter(f1.dataType(), this.resolveNullableType(f2.schema(), f1.nullable()));
            return function2;
        }, Seq$.MODULE$.canBuildFrom());
        int numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(i, null);
                    continue;
                }
                result.put(i, ((Function2)fieldConverters.apply(i)).apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private Schema resolveNullableType(Schema avroType, boolean nullable) {
        Schema schema;
        if (nullable) {
            Schema.Type type = avroType.getType();
            Schema.Type type2 = Schema.Type.NULL;
            if (type == null ? type2 != null : !type.equals(type2)) {
                Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
                Predef$.MODULE$.assert(fields.length() == 2);
                Buffer actualType = (Buffer)fields.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSerializer.$anonfun$resolveNullableType$1(x$1)));
                Predef$.MODULE$.assert(actualType.length() == 1);
                schema = (Schema)actualType.head();
                return schema;
            }
        }
        schema = avroType;
        return schema;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(AvroSerializer $this, Schema avroType$1, DecimalType x55$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x55$1.precision(), x55$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x55$1.precision(), (int)x55$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(AvroSerializer $this, Schema avroType$1, DecimalType x57$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x57$1.precision(), x57$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x57$1.precision(), (int)x57$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Schema avroType$1, Set enumSymbols$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(49).append("Cannot write \"").append(data).append("\" since it's not defined in enum \"").append(enumSymbols$1.mkString("\", \"")).append("\"").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(Schema avroType$1, int size$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(59).append("Cannot write ").append(data.length).append(" ").append((Object)(data.length > 1 ? "bytes" : "byte")).append(" of ").append("binary data into FIXED Type with size of ").append(new StringBuilder(1).append(size$1).append(" ").append((Object)(size$1 > 1 ? "bytes" : "byte")).toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$16(SpecializedGetters getter, int ordinal) {
        return getter.getLong(ordinal) / 1000L;
    }

    public static final /* synthetic */ long $anonfun$newConverter$18(SpecializedGetters getter, int ordinal) {
        return getter.getLong(ordinal) / 1000L;
    }

    public static final /* synthetic */ List $anonfun$newConverter$19(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$20(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$21(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$resolveNullableType$1(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        Function1 & Serializable & scala.Serializable intersect;
        Schema actualAvroType = this.resolveNullableType(rootAvroType, nullable);
        DataType dataType = rootCatalystType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            intersect = this.newStructConverter(structType, actualAvroType);
        } else {
            SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{rootCatalystType})));
            Function2<SpecializedGetters, Object, Object> converter = this.newConverter(rootCatalystType, actualAvroType);
            intersect = (Function1 & Serializable & scala.Serializable)data -> {
                tmpRow.update(0, data);
                return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
            };
        }
        Function1 & Serializable & scala.Serializable baseConverter = intersect;
        this.converter = nullable ? (Function1 & Serializable & scala.Serializable)data -> data == null ? null : baseConverter.apply(data) : baseConverter;
    }
}

