/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.avro.AvroUtils;
import org.apache.spark.sql.avro.AvroUtils$;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005mh!\u0002\r\u001a\u0001m\u0019\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u007f!A1\t\u0001B\u0001B\u0003%A\tC\u0003_\u0001\u0011\u0005q\fC\u0003_\u0001\u0011\u0005q\rC\u0003l\u0001\u0011\u0005A\u000eC\u0004s\u0001\t\u0007I\u0011B:\t\ri\u0004\u0001\u0015!\u0003u\u0011\u001dY\bA1A\u0005\nqDq!a\u0001\u0001A\u0003%Q\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u00111\u0002\u0001!\u0002\u0013\tI!\u0002\u0004\u0002\u000e\u0001!\u0011q\u0002\u0005\u000b\u0003K\u0001\u0001R1A\u0005\n\u0005\u001d\u0002bBA\u001e\u0001\u0011%\u0011Q\b\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!a/\u0001\t\u0013\ti\fC\u0004\u0002D\u0002!I!!2\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r(AD!we>\u001cVM]5bY&TXM\u001d\u0006\u00035m\tA!\u0019<s_*\u0011A$H\u0001\u0004gFd'B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0014\u0007\u0001!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[u\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003_1\u0012q\u0001T8hO&tw-\u0001\ts_>$8)\u0019;bYf\u001cH\u000fV=qK\u000e\u0001\u0001CA\u001a7\u001b\u0005!$BA\u001b\u001c\u0003\u0015!\u0018\u0010]3t\u0013\t9DG\u0001\u0005ECR\fG+\u001f9f\u00031\u0011xn\u001c;BmJ|G+\u001f9f!\tQD(D\u0001<\u0015\tQr$\u0003\u0002>w\t11k\u00195f[\u0006\f\u0001B\\;mY\u0006\u0014G.\u001a\t\u0003K\u0001K!!\u0011\u0014\u0003\u000f\t{w\u000e\\3b]\u0006!\u0002o\\:ji&|g.\u00197GS\u0016dG-T1uG\"\f!\u0003Z1uKRLW.\u001a*fE\u0006\u001cX-T8eKB\u0011QI\u0017\b\u0003\r^s!a\u0012+\u000f\u0005!\u001bfBA%S\u001d\tQ\u0015K\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011a*M\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001I\u0011\n\u0005yy\u0012B\u0001\u000f\u001e\u0013\ti3$\u0003\u0002V-\u000691+\u0015'D_:4'BA\u0017\u001c\u0013\tA\u0016,\u0001\u000bMK\u001e\f7-\u001f\"fQ\u00064\u0018n\u001c:Q_2L7-\u001f\u0006\u0003+ZK!a\u0017/\u0003\u000bY\u000bG.^3\n\u0005u3#aC#ok6,'/\u0019;j_:\fa\u0001P5oSRtDC\u00021cG\u0012,g\r\u0005\u0002b\u00015\t\u0011\u0004C\u00031\r\u0001\u0007!\u0007C\u00039\r\u0001\u0007\u0011\bC\u0003?\r\u0001\u0007q\bC\u0003C\r\u0001\u0007q\bC\u0003D\r\u0001\u0007A\t\u0006\u0003aQ&T\u0007\"\u0002\u0019\b\u0001\u0004\u0011\u0004\"\u0002\u001d\b\u0001\u0004I\u0004\"\u0002 \b\u0001\u0004y\u0014!C:fe&\fG.\u001b>f)\ti\u0007\u000f\u0005\u0002&]&\u0011qN\n\u0002\u0004\u0003:L\b\"B9\t\u0001\u0004i\u0017\u0001D2bi\u0006d\u0017p\u001d;ECR\f\u0017A\u00043bi\u0016\u0014VMY1tK\u001a+hnY\u000b\u0002iB!Q%^<x\u0013\t1hEA\u0005Gk:\u001cG/[8ocA\u0011Q\u0005_\u0005\u0003s\u001a\u00121!\u00138u\u0003=!\u0017\r^3SK\n\f7/\u001a$v]\u000e\u0004\u0013a\u0005;j[\u0016\u001cH/Y7q%\u0016\u0014\u0017m]3Gk:\u001cW#A?\u0011\t\u0015*hP \t\u0003K}L1!!\u0001'\u0005\u0011auN\\4\u0002)QLW.Z:uC6\u0004(+\u001a2bg\u00164UO\\2!\u0003%\u0019wN\u001c<feR,'/\u0006\u0002\u0002\nA!Q%^7n\u0003)\u0019wN\u001c<feR,'\u000f\t\u0002\n\u0007>tg/\u001a:uKJ\u0004r!JA\t\u0003+9X.C\u0002\u0002\u0014\u0019\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\tybG\u0001\tG\u0006$\u0018\r\\=ti&!\u00111EA\r\u0005I\u0019\u0006/Z2jC2L'0\u001a3HKR$XM]:\u0002%\u0011,7-[7bY\u000e{gN^3sg&|gn]\u000b\u0003\u0003S\u0001B!a\u000b\u000269!\u0011QFA\u0019\u001d\rQ\u0015qF\u0005\u00035}I1!a\r<\u0003-\u0019uN\u001c<feNLwN\\:\n\t\u0005]\u0012\u0011\b\u0002\u0012\t\u0016\u001c\u0017.\\1m\u0007>tg/\u001a:tS>t'bAA\u001aw\u0005aa.Z<D_:4XM\u001d;feRQ\u0011qHA\"\u0003\u000f\nY%!\u001d\u0011\u0007\u0005\u0005s\"D\u0001\u0001\u0011\u0019\t)%\u0005a\u0001e\u0005a1-\u0019;bYf\u001cH\u000fV=qK\"1\u0011\u0011J\tA\u0002e\n\u0001\"\u0019<s_RK\b/\u001a\u0005\b\u0003\u001b\n\u0002\u0019AA(\u00031\u0019\u0017\r^1msN$\b+\u0019;i!\u0019\t\t&a\u0017\u0002b9!\u00111KA,\u001d\ra\u0015QK\u0005\u0002O%\u0019\u0011\u0011\f\u0014\u0002\u000fA\f7m[1hK&!\u0011QLA0\u0005\r\u0019V-\u001d\u0006\u0004\u000332\u0003\u0003BA2\u0003WrA!!\u001a\u0002hA\u0011AJJ\u0005\u0004\u0003S2\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002n\u0005=$AB*ue&twMC\u0002\u0002j\u0019Bq!a\u001d\u0012\u0001\u0004\ty%\u0001\u0005bmJ|\u0007+\u0019;i\u0003IqWm^*ueV\u001cGoQ8om\u0016\u0014H/\u001a:\u0015\u0015\u0005e\u0014\u0011TAR\u0003O\u000bI\u000b\u0005\u0004&k\u0006m\u00141\u0011\t\u0005\u0003{\ny(\u0004\u0002\u0002\u001e%!\u0011\u0011QA\u000f\u0005-Ie\u000e^3s]\u0006d'k\\<\u0011\t\u0005\u0015\u00151\u0013\b\u0005\u0003\u000f\u000biI\u0004\u0003\u0002.\u0005%\u0015bAAFw\u00059q-\u001a8fe&\u001c\u0017\u0002BAH\u0003#\u000b1bR3oKJL7\rR1uC*\u0019\u00111R\u001e\n\t\u0005U\u0015q\u0013\u0002\u0007%\u0016\u001cwN\u001d3\u000b\t\u0005=\u0015\u0011\u0013\u0005\b\u00037\u0013\u0002\u0019AAO\u00039\u0019\u0017\r^1msN$8\u000b\u001e:vGR\u00042aMAP\u0013\r\t\t\u000b\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BBAS%\u0001\u0007\u0011(\u0001\u0006bmJ|7\u000b\u001e:vGRDq!!\u0014\u0013\u0001\u0004\ty\u0005C\u0004\u0002tI\u0001\r!a\u0014\u000219,woQ8na2,\u00070\u00168j_:\u001cuN\u001c<feR,'\u000f\u0006\u0006\u00020\u0006E\u00161WA\\\u0003s\u0003R!J;\u0002|5Dq!a'\u0014\u0001\u0004\ti\n\u0003\u0004\u00026N\u0001\r!O\u0001\nk:LwN\u001c+za\u0016Dq!!\u0014\u0014\u0001\u0004\ty\u0005C\u0004\u0002tM\u0001\r!a\u0014\u0002'I,7o\u001c7wK:+H\u000e\\1cY\u0016$\u0016\u0010]3\u0015\u000be\ny,!1\t\r\u0005%C\u00031\u0001:\u0011\u0015qD\u00031\u0001@\u0003=\u0011Xm]8mm\u0016\feO]8UsB,G\u0003BAd\u0003\u001b\u0004R!JAe\u007feJ1!a3'\u0005\u0019!V\u000f\u001d7fe!1\u0011\u0011J\u000bA\u0002e\n\u0011d^1s]:+H\u000e\\1cS2LG/\u001f#jM\u001a,'/\u001a8dKR1\u00111[Am\u0003;\u00042!JAk\u0013\r\t9N\n\u0002\u0005+:LG\u000f\u0003\u0004\u0002\\Z\u0001\raP\u0001\rCZ\u0014xNT;mY\u0006\u0014G.\u001a\u0005\u0007\u0003?4\u0002\u0019A \u0002!\r\fG/\u00197zgRtU\u000f\u001c7bE2,\u0017!\u00058p]:+H\u000e\\+oS>tG+\u001f9fgR!\u0011Q]A}!\u0019\t\u0019'a:\u0002l&!\u0011\u0011^A8\u0005\r\u0019V\r\u001e\t\u0005\u0003[\f\u0019P\u0004\u0003\u0002.\u0005=\u0018bAAyw\u000511k\u00195f[\u0006LA!!>\u0002x\n!A+\u001f9f\u0015\r\t\tp\u000f\u0005\u0007\u0003\u0013:\u0002\u0019A\u001d")
public class AvroSerializer
implements Logging {
    private Conversions.DecimalConversion decimalConversions;
    private final DataType rootCatalystType;
    private final Schema rootAvroType;
    private final boolean positionalFieldMatch;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Function1<Object, Object> converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroSerializer avroSerializer = this;
        synchronized (avroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        if (!this.bitmap$0) {
            return this.decimalConversions$lzycompute();
        }
        return this.decimalConversions;
    }

    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType, Seq<String> catalystPath, Seq<String> avroPath) {
        String errorPrefix = new StringBuilder(37).append("Cannot convert SQL ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(" ").append("to Avro ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" because ").toString();
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (!(logicalType != null ? !logicalType.equals(decimal) : decimal != null)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (!(logicalType != null ? !logicalType.equals(decimal) : decimal != null)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getEnumSymbols()).asScala()).toSet();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$11(enumSymbols, errorPrefix, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$13(size, errorPrefix, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)AvroSerializer.$anonfun$newConverter$15(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                LogicalType logicalType = avroType.getLogicalType();
                if (logicalType == null ? true : logicalType instanceof LogicalTypes.TimestampMillis) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)))));
                }
                if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$17(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                throw new IncompatibleSchemaException(new StringBuilder(51).append(errorPrefix).append("SQL type ").append(TimestampType$.MODULE$.sql()).append(" cannot be converted to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampNTZType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                LogicalType logicalType = avroType.getLogicalType();
                if (logicalType == null ? true : logicalType instanceof LogicalTypes.LocalTimestampMillis) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal))));
                }
                if (logicalType instanceof LogicalTypes.LocalTimestampMicros) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                throw new IncompatibleSchemaException(new StringBuilder(51).append(errorPrefix).append("SQL type ").append(TimestampNTZType$.MODULE$.sql()).append(" cannot be converted to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), containsNull), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom())));
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$20(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType, catalystPath, avroPath);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$21(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.UNION.equals(type)) {
                    Function1<InternalRow, Object> unionConvertor = this.newComplexUnionConverter(structType, avroType, catalystPath, avroPath);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> unionConvertor.apply((Object)getter.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), numFields));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.UNION.equals(type)) {
                Set<Schema.Type> set = this.nonNullUnionTypes(avroType);
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE}));
                if (!(set != null ? !set.equals((Object)genTraversable) : genTraversable != null)) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.UNION.equals(type)) {
                Set<Schema.Type> set = this.nonNullUnionTypes(avroType);
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG}));
                if (!(set != null ? !set.equals((Object)genTraversable) : genTraversable != null)) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                if (Schema.Type.MAP.equals(type)) {
                    DataType dataType2 = kt;
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null)) {
                        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), valueContainsNull), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())));
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$25(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            Schema.Type type = (Schema.Type)tuple2._2();
            if (tuple2._1() instanceof YearMonthIntervalType && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            Schema.Type type = (Schema.Type)tuple2._2();
            if (tuple2._1() instanceof DayTimeIntervalType && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        throw new IncompatibleSchemaException(new StringBuilder(48).append(errorPrefix).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct, Seq<String> catalystPath, Seq<String> avroPath) {
        AvroUtils.AvroSchemaHelper avroSchemaHelper = new AvroUtils.AvroSchemaHelper(avroStruct, catalystStruct, avroPath, catalystPath, this.positionalFieldMatch);
        avroSchemaHelper.validateNoExtraCatalystFields(false);
        avroSchemaHelper.validateNoExtraRequiredAvroFields();
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)avroSchemaHelper.matchedFields().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AvroUtils.AvroMatchedField avroMatchedField = x0$1;
            if (avroMatchedField != null) {
                StructField catalystField = avroMatchedField.catalystField();
                Schema.Field avroField = avroMatchedField.avroField();
                Function2<SpecializedGetters, Object, Object> converter = this.newConverter(catalystField.dataType(), this.resolveNullableType(avroField.schema(), catalystField.nullable()), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)catalystField.name(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)avroField.name(), Seq$.MODULE$.canBuildFrom())));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)avroField.pos()), converter);
            }
            throw new MatchError((Object)avroMatchedField);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Function2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] avroIndices = (int[])tuple2._1();
        Function2[] fieldConverters = (Function2[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)avroIndices, (Object)fieldConverters);
        int[] avroIndices2 = (int[])tuple22._1();
        Function2[] fieldConverters2 = (Function2[])tuple22._2();
        int numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(avroIndices2[i], null);
                    continue;
                }
                result.put(avroIndices2[i], fieldConverters2[i].apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    private Function1<InternalRow, Object> newComplexUnionConverter(StructType catalystStruct, Schema unionType, Seq<String> catalystPath, Seq<String> avroPath) {
        Seq<Schema> nonNullTypes = AvroUtils$.MODULE$.nonNullUnionBranches(unionType);
        IndexedSeq expectedFieldNames = (IndexedSeq)nonNullTypes.indices().map((Function1 & Serializable & scala.Serializable)i -> AvroSerializer.$anonfun$newComplexUnionConverter$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Seq catalystFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalystStruct.fieldNames())).toSeq();
        if (this.positionalFieldMatch) {
            if (expectedFieldNames.length() != catalystFieldNames.length()) {
                throw new IncompatibleSchemaException(new StringBuilder(92).append("Generic Avro union at ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" ").append("does not match the SQL schema at ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(".  It expected the ").append(expectedFieldNames.length()).append(" members but got ").append(catalystFieldNames.length()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        } else {
            Seq seq = catalystFieldNames;
            IndexedSeq indexedSeq = expectedFieldNames;
            if (seq == null ? indexedSeq != null : !seq.equals(indexedSeq)) {
                throw new IncompatibleSchemaException(new StringBuilder(102).append("Generic Avro union at ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" ").append("does not match the SQL schema at ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(".  It expected the ").append("following members ").append(expectedFieldNames.mkString("(", ", ", ")")).append(" but got ").append(catalystFieldNames.mkString("(", ", ", ")")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        Function2[] unionBranchConverters = (Function2[])((TraversableOnce)((TraversableLike)nonNullTypes.zip((GenIterable)catalystStruct, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Schema unionBranch = (Schema)tuple2._1();
                StructField cf = (StructField)tuple2._2();
                return this.newConverter(cf.dataType(), unionBranch, (Seq<String>)((Seq)catalystPath.$colon$plus((Object)cf.name(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)cf.name(), Seq$.MODULE$.canBuildFrom())));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
        int numBranches = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)row -> {
            Object retVal = null;
            for (int idx = 0; idx < numBranches && retVal == null; ++idx) {
                if (row.isNullAt(idx)) continue;
                retVal = unionBranchConverters[idx].apply(row, (Object)BoxesRunTime.boxToInteger((int)idx));
            }
            return retVal;
        };
    }

    private Schema resolveNullableType(Schema avroType, boolean nullable) {
        Tuple2<Object, Schema> tuple2 = this.resolveAvroType(avroType);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean avroNullable = tuple2._1$mcZ$sp();
        Schema resolvedAvroType = (Schema)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)avroNullable), (Object)resolvedAvroType);
        boolean avroNullable2 = tuple22._1$mcZ$sp();
        Schema resolvedAvroType2 = (Schema)tuple22._2();
        this.warnNullabilityDifference(avroNullable2, nullable);
        return resolvedAvroType2;
    }

    private Tuple2<Object, Schema> resolveAvroType(Schema avroType) {
        Schema.Type type = avroType.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            boolean containsNull = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AvroSerializer.$anonfun$resolveAvroType$1(x$3)));
            Seq<Schema> seq = AvroUtils$.MODULE$.nonNullUnionBranches(avroType);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Schema.create((Schema.Type)Schema.Type.NULL));
            }
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                Schema singleType = (Schema)((SeqLike)some2.get()).apply(0);
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)containsNull), (Object)singleType);
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)containsNull), (Object)avroType);
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)avroType);
    }

    private void warnNullabilityDifference(boolean avroNullable, boolean catalystNullable) {
        if (avroNullable && !catalystNullable) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing Avro files with nullable Avro schema and non-nullable catalyst schema.");
        }
        if (!avroNullable && catalystNullable) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing Avro files with non-nullable Avro schema and nullable catalyst schema will throw runtime exception if there is a record with null value.");
            return;
        }
    }

    private Set<Schema.Type> nonNullUnionTypes(Schema avroType) {
        return ((TraversableOnce)AvroUtils$.MODULE$.nonNullUnionBranches(avroType).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getType(), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    private final /* synthetic */ Function1 liftedTree1$1(Schema actualAvroType$1) {
        Function1 & Serializable & scala.Serializable intersect;
        try {
            DataType dataType = this.rootCatalystType;
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                intersect = this.newStructConverter(structType, actualAvroType$1, (Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$);
            } else {
                SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)new .colon.colon((Object)this.rootCatalystType, (List)Nil$.MODULE$));
                Function2<SpecializedGetters, Object, Object> converter = this.newConverter(this.rootCatalystType, actualAvroType$1, (Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$);
                intersect = (Function1 & Serializable & scala.Serializable)data -> {
                    tmpRow.update(0, data);
                    return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
                };
            }
        }
        catch (IncompatibleSchemaException ise) {
            throw new IncompatibleSchemaException(new StringBuilder(39).append("Cannot convert SQL type ").append(this.rootCatalystType.sql()).append(" to Avro type ").append(this.rootAvroType).append(".").toString(), ise);
        }
        return intersect;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(AvroSerializer $this, DecimalType x66$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x66$1.precision(), x66$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x66$1.precision(), (int)x66$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(AvroSerializer $this, DecimalType x68$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x68$1.precision(), x68$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x68$1.precision(), (int)x68$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Set enumSymbols$1, String errorPrefix$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(52).append(errorPrefix$1).append("\"").append(data).append("\" cannot be written since it's not defined in enum ").append(enumSymbols$1.mkString("\"", "\", \"", "\"")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    private static final String len2str$1(int len) {
        return new StringBuilder(1).append(len).append(" ").append((Object)(len > 1 ? "bytes" : "byte")).toString();
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(int size$1, String errorPrefix$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(63).append(errorPrefix$1).append(AvroSerializer.len2str$1(data.length)).append(" of binary data cannot be written into FIXED type with size of ").append(AvroSerializer.len2str$1(size$1)).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ int $anonfun$newConverter$15(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.dateRebaseFunc().apply$mcII$sp(getter.getInt(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$17(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(ordinal));
    }

    public static final /* synthetic */ java.util.List $anonfun$newConverter$20(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$21(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$25(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$newComplexUnionConverter$1(int i) {
        return new StringBuilder(6).append("member").append(i).toString();
    }

    public static final /* synthetic */ boolean $anonfun$resolveAvroType$1(Schema x$3) {
        Schema.Type type = x$3.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable, boolean positionalFieldMatch, Enumeration.Value datetimeRebaseMode) {
        this.rootCatalystType = rootCatalystType;
        this.rootAvroType = rootAvroType;
        this.positionalFieldMatch = positionalFieldMatch;
        Logging.$init$((Logging)this);
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.createDateRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        Schema actualAvroType = this.resolveNullableType(rootAvroType, nullable);
        Function1 & Serializable & scala.Serializable baseConverter = this.liftedTree1$1(actualAvroType);
        this.converter = nullable ? (Function1 & Serializable & scala.Serializable)data -> {
            if (data == null) {
                return null;
            }
            return baseConverter.apply(data);
        } : baseConverter;
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        this(rootCatalystType, rootAvroType, nullable, false, SQLConf.LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE())));
    }
}

