/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.avro.AvroFileFormat$;
import org.apache.spark.sql.avro.AvroOptions$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.ParseMode$;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]d!\u0002\u0011\"\u0001\rZ\u0003\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0001$\t\u0011]\u0003!\u0011!Q\u0001\n\u001dC\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t!\u0018\u0005\tK\u0002\u0011\t\u0011)A\u0005=\")q\r\u0001C\u0001Q\")q\r\u0001C\u0001[\"91\u000f\u0001b\u0001\n\u0003!\bBB?\u0001A\u0003%Q\u000fC\u0004\u007f\u0001\t\u0007I\u0011A@\t\u0011\u0005\u001d\u0001\u0001)A\u0005\u0003\u0003A\u0011\"!\u0003\u0001\u0005\u0004%\t!a\u0003\t\u000f\u00055\u0001\u0001)A\u0005\u001f\"I\u0011q\u0002\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\b\u0003#\u0001\u0001\u0015!\u0003P\u0011!\t\u0019\u0002\u0001b\u0001\n\u0003y\b\u0002CA\u0013\u0001\u0001\u0006I!!\u0001\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005-\u0001bBA\u0016\u0001\u0001\u0006Ia\u0014\u0005\n\u0003[\u0001!\u0019!C\u0001\u0003_A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003s\u0001!\u0019!C\u0001\u0003\u0017Aq!a\u000f\u0001A\u0003%qj\u0002\u0005\u0002>\u0005B\taIA \r\u001d\u0001\u0013\u0005#\u0001$\u0003\u0003Baa\u001a\r\u0005\u0002\u0005E\u0003bBA*1\u0011\u0005\u0011Q\u000b\u0005\n\u00033B\"\u0019!C\u0001\u00037B\u0001\"a\u001a\u0019A\u0003%\u0011Q\f\u0005\n\u0003SB\"\u0019!C\u0001\u00037B\u0001\"a\u001b\u0019A\u0003%\u0011Q\f\u0005\n\u0003[B\u0012\u0011!C\u0005\u0003_\u00121\"\u0011<s_>\u0003H/[8og*\u0011!eI\u0001\u0005CZ\u0014xN\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001cB\u0001\u0001\u00173qA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"a\r\u001c\u000e\u0003QR!!N\u0013\u0002\u0011%tG/\u001a:oC2L!a\u000e\u001b\u0003\u000f1{wmZ5oOB\u0011\u0011H\u0011\b\u0003u\u0001s!aO \u000e\u0003qR!!\u0010 \u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011aL\u0005\u0003\u0003:\nq\u0001]1dW\u0006<W-\u0003\u0002D\t\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011IL\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cX#A$\u0011\u0007!ku*D\u0001J\u0015\tQ5*\u0001\u0003vi&d'B\u0001'$\u0003!\u0019\u0017\r^1msN$\u0018B\u0001(J\u0005I\u0019\u0015m]3J]N,gn]5uSZ,W*\u00199\u0011\u0005A#fBA)S!\tYd&\u0003\u0002T]\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019f&A\u0006qCJ\fW.\u001a;feN\u0004\u0003F\u0001\u0002Z!\ti#,\u0003\u0002\\]\tIAO]1og&,g\u000e^\u0001\u0005G>tg-F\u0001_!\ty6-D\u0001a\u0015\ta\u0016M\u0003\u0002cO\u00051\u0001.\u00193p_BL!\u0001\u001a1\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0015\u0019wN\u001c4!Q\t!\u0011,\u0001\u0004=S:LGO\u0010\u000b\u0004S.d\u0007C\u00016\u0001\u001b\u0005\t\u0003\"B#\u0006\u0001\u00049\u0005\"\u0002/\u0006\u0001\u0004qFcA5oe\")QI\u0002a\u0001_B!\u0001\u000b](P\u0013\t\thKA\u0002NCBDQ\u0001\u0018\u0004A\u0002y\u000baa]2iK6\fW#A;\u0011\u000752\b0\u0003\u0002x]\t1q\n\u001d;j_:\u0004\"!_>\u000e\u0003iT!AI\u0014\n\u0005qT(AB*dQ\u0016l\u0017-A\u0004tG\",W.\u0019\u0011\u0002/A|7/\u001b;j_:\fGNR5fY\u0012l\u0015\r^2iS:<WCAA\u0001!\ri\u00131A\u0005\u0004\u0003\u000bq#a\u0002\"p_2,\u0017M\\\u0001\u0019a>\u001c\u0018\u000e^5p]\u0006dg)[3mI6\u000bGo\u00195j]\u001e\u0004\u0013A\u0003:fG>\u0014HMT1nKV\tq*A\u0006sK\u000e|'\u000f\u001a(b[\u0016\u0004\u0013a\u0004:fG>\u0014HMT1nKN\u0004\u0018mY3\u0002!I,7m\u001c:e\u001d\u0006lWm\u001d9bG\u0016\u0004\u0013aD5h]>\u0014X-\u0012=uK:\u001c\u0018n\u001c8)\u000f=\t9\"!\b\u0002\"A\u0019Q&!\u0007\n\u0007\u0005maF\u0001\u0006eKB\u0014XmY1uK\u0012\f#!a\b\u0002\u0015V\u001bX\r\t;iK\u0002:WM\\3sC2\u0004C-\u0019;bAM|WO]2fA=\u0004H/[8oAA\fG\u000f[$m_\n4\u0015\u000e\u001c;fe\u00022wN\u001d\u0011gS2$XM]5oO\u00022\u0017\u000e\\3!]\u0006lWm]\u0011\u0003\u0003G\t1a\r\u00181\u0003AIwM\\8sK\u0016CH/\u001a8tS>t\u0007\u0005K\u0004\u0011\u0003/\ti\"!\t\u0002\u0017\r|W\u000e\u001d:fgNLwN\\\u0001\rG>l\u0007O]3tg&|g\u000eI\u0001\na\u0006\u00148/Z'pI\u0016,\"!!\r\u0011\u0007!\u000b\u0019$C\u0002\u00026%\u0013\u0011\u0002U1sg\u0016lu\u000eZ3\u0002\u0015A\f'o]3N_\u0012,\u0007%\u0001\reCR,G/[7f%\u0016\u0014\u0017m]3N_\u0012,\u0017J\u001c*fC\u0012\f\u0011\u0004Z1uKRLW.\u001a*fE\u0006\u001cX-T8eK&s'+Z1eA\u0005Y\u0011I\u001e:p\u001fB$\u0018n\u001c8t!\tQ\u0007d\u0005\u0003\u0019Y\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0003S>T!!!\u0014\u0002\t)\fg/Y\u0005\u0004\u0007\u0006\u001dCCAA \u0003\u0015\t\u0007\u000f\u001d7z)\rI\u0017q\u000b\u0005\u0006\u000bj\u0001\ra\\\u0001\u0013S\u001etwN]3FqR,gn]5p].+\u00170\u0006\u0002\u0002^A!\u0011qLA3\u001b\t\t\tG\u0003\u0003\u0002d\u0005-\u0013\u0001\u00027b]\u001eL1!VA1\u0003MIwM\\8sK\u0016CH/\u001a8tS>t7*Z=!\u0003Q!\u0015\tV#U\u00136+uLU#C\u0003N+u,T(E\u000b\u0006)B)\u0011+F)&kUi\u0018*F\u0005\u0006\u001bViX'P\t\u0016\u0003\u0013\u0001D<sSR,'+\u001a9mC\u000e,GCAA9!\u0011\ty&a\u001d\n\t\u0005U\u0014\u0011\r\u0002\u0007\u001f\nTWm\u0019;")
public class AvroOptions
implements Logging,
Serializable {
    private final transient CaseInsensitiveMap<String> parameters;
    private final transient Configuration conf;
    private final Option<Schema> schema;
    private final boolean positionalFieldMatching;
    private final String recordName;
    private final String recordNamespace;
    private final boolean ignoreExtension;
    private final String compression;
    private final ParseMode parseMode;
    private final String datetimeRebaseModeInRead;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DATETIME_REBASE_MODE() {
        return AvroOptions$.MODULE$.DATETIME_REBASE_MODE();
    }

    public static String ignoreExtensionKey() {
        return AvroOptions$.MODULE$.ignoreExtensionKey();
    }

    public static AvroOptions apply(Map<String, String> map) {
        return AvroOptions$.MODULE$.apply(map);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CaseInsensitiveMap<String> parameters() {
        return this.parameters;
    }

    public Configuration conf() {
        return this.conf;
    }

    public Option<Schema> schema() {
        return this.schema;
    }

    public boolean positionalFieldMatching() {
        return this.positionalFieldMatching;
    }

    public String recordName() {
        return this.recordName;
    }

    public String recordNamespace() {
        return this.recordNamespace;
    }

    public boolean ignoreExtension() {
        return this.ignoreExtension;
    }

    public String compression() {
        return this.compression;
    }

    public ParseMode parseMode() {
        return this.parseMode;
    }

    public String datetimeRebaseModeInRead() {
        return this.datetimeRebaseModeInRead;
    }

    public AvroOptions(CaseInsensitiveMap<String> parameters, Configuration conf) {
        this.parameters = parameters;
        this.conf = conf;
        Logging.$init$((Logging)this);
        Schema.Parser parser = new Schema.Parser().setValidateDefaults(false);
        this.schema = parameters.get("avroSchema").map((Function1 & Serializable)s -> parser.parse(s)).orElse((Function0 & Serializable)() -> {
            void var1_1;
            Option avroUrlSchema = this.parameters().get("avroSchemaUrl").map((Function1 & Serializable)url -> {
                Schema schema;
                this.log().debug(new StringBuilder(30).append("loading avro schema from url: ").append((String)url).toString());
                FileSystem fs = FileSystem.get((URI)new URI((String)url), (Configuration)this.conf());
                try (FSDataInputStream in = fs.open(new Path(url));){
                    schema = new Schema.Parser().setValidateDefaults(false).parse((InputStream)in);
                }
                return schema;
            });
            return var1_1;
        });
        this.positionalFieldMatching = parameters.get("positionalFieldMatching").exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$1))));
        this.recordName = (String)parameters.getOrElse((Object)"recordName", (Function0 & Serializable)() -> "topLevelRecord");
        this.recordNamespace = (String)parameters.getOrElse((Object)"recordNamespace", (Function0 & Serializable)() -> "");
        boolean ignoreFilesWithoutExtensionByDefault = false;
        boolean ignoreFilesWithoutExtension = conf.getBoolean(AvroFileFormat$.MODULE$.IgnoreFilesWithoutExtensionProperty(), ignoreFilesWithoutExtensionByDefault);
        this.ignoreExtension = BoxesRunTime.unboxToBoolean((Object)parameters.get(AvroOptions$.MODULE$.ignoreExtensionKey()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> !ignoreFilesWithoutExtension));
        this.compression = (String)parameters.get("compression").getOrElse((Function0 & Serializable)() -> SQLConf$.MODULE$.get().avroCompressionCodec());
        this.parseMode = (ParseMode)parameters.get("mode").map((Function1 & Serializable)mode -> ParseMode$.MODULE$.fromString(mode)).getOrElse((Function0 & Serializable)() -> FailFastMode$.MODULE$);
        this.datetimeRebaseModeInRead = (String)parameters.get(AvroOptions$.MODULE$.DATETIME_REBASE_MODE()).getOrElse((Function0 & Serializable)() -> (String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ()));
    }

    public AvroOptions(Map<String, String> parameters, Configuration conf) {
        this((CaseInsensitiveMap<String>)CaseInsensitiveMap$.MODULE$.apply(parameters), conf);
    }
}

