/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOptions$;
import org.apache.spark.sql.avro.AvroOutputWriterFactory;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.FileSourceOptions;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class AvroUtils$
implements Logging {
    public static final AvroUtils$ MODULE$ = new AvroUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<StructType> inferSchema(SparkSession spark, Map<String, String> options, Seq<FileStatus> files) {
        Schema avroSchema;
        DataType dataType;
        Configuration conf = spark.sessionState().newHadoopConfWithOptions(options);
        AvroOptions parsedOptions = new AvroOptions(options, conf);
        if (parsedOptions.parameters().contains(AvroOptions$.MODULE$.IGNORE_EXTENSION())) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append(new StringBuilder(38).append("Option ").append(AvroOptions$.MODULE$.IGNORE_EXTENSION()).append(" is deprecated. Please use the ").toString()).append("general data source option pathGlobFilter for filtering file names.").toString());
        }
        if (!((dataType = SchemaConverters$.MODULE$.toSqlType(avroSchema = (Schema)parsedOptions.schema().getOrElse((Function0 & Serializable)() -> MODULE$.inferAvroSchemaFromFiles(files, conf, parsedOptions.ignoreExtension(), new FileSourceOptions(CaseInsensitiveMap$.MODULE$.apply(options)).ignoreCorruptFiles()))).dataType()) instanceof StructType)) {
            throw new RuntimeException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(97).append("Avro schema cannot be converted to a Spark SQL StructType:\n           |\n           |").append(avroSchema.toString(true)).append("\n           |").toString())));
        }
        StructType structType = (StructType)dataType;
        Some some = new Some((Object)structType);
        return some;
    }

    public boolean supportsDataType(DataType dataType) {
        boolean bl;
        block6: {
            DataType dataType2;
            while (true) {
                if ((dataType2 = dataType) instanceof AtomicType) {
                    bl = true;
                    break block6;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    bl = structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.MODULE$.supportsDataType(f.dataType())));
                    break block6;
                }
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                    continue;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    DataType keyType = mapType.keyType();
                    DataType valueType = mapType.valueType();
                    if (this.supportsDataType(keyType)) {
                        dataType = valueType;
                        continue;
                    }
                    bl = false;
                    break block6;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            bl = dataType2 instanceof NullType;
        }
        return bl;
    }

    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        Schema outputAvroSchema;
        AvroOptions parsedOptions;
        block12: {
            String string;
            block14: {
                String string2;
                block13: {
                    block11: {
                        parsedOptions = new AvroOptions(options, job.getConfiguration());
                        outputAvroSchema = (Schema)parsedOptions.schema().getOrElse((Function0 & Serializable)() -> SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, parsedOptions.recordName(), parsedOptions.recordNamespace()));
                        AvroJob.setOutputKeySchema((Job)job, (Schema)outputAvroSchema);
                        String string3 = parsedOptions.compression();
                        String string4 = "uncompressed";
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block11;
                        job.getConfiguration().setBoolean("mapred.output.compress", false);
                        break block12;
                    }
                    job.getConfiguration().setBoolean("mapred.output.compress", true);
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Compressing Avro output using the ").append(parsedOptions.compression()).append(" codec").toString());
                    string2 = parsedOptions.compression();
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case -898026669: {
                            if ("snappy".equals(string2)) {
                                break;
                            }
                            break block13;
                        }
                        case -153483977: {
                            if ("zstandard".equals(string2)) {
                                break;
                            }
                            break block13;
                        }
                        case 3842: {
                            if ("xz".equals(string2)) {
                                break;
                            }
                            break block13;
                        }
                        case 94243987: {
                            if ("bzip2".equals(string2)) {
                                break;
                            }
                            break block13;
                        }
                        case 1545112619: {
                            if (!"deflate".equals(string2)) break block13;
                            int deflateLevel = sqlConf.avroDeflateLevel();
                            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Avro compression level ").append(deflateLevel).append(" will be used for ").append("deflate").append(" codec.").toString());
                            job.getConfiguration().setInt("avro.mapred.deflate.level", deflateLevel);
                            string = "deflate";
                            break block14;
                        }
                        default: {
                            break block13;
                        }
                    }
                    string = string2;
                    break block14;
                }
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid compression codec: ").append(string2).toString());
            }
            String codec = string;
            job.getConfiguration().set("avro.output.codec", codec);
        }
        return new AvroOutputWriterFactory(dataSchema, outputAvroSchema.toString(), parsedOptions.positionalFieldMatching());
    }

    private Schema inferAvroSchemaFromFiles(Seq<FileStatus> files, Configuration conf, boolean ignoreExtension, boolean ignoreCorruptFiles) {
        Schema schema;
        Option avroReader = files.iterator().map((Function1 & Serializable)f -> {
            Path path = f.getPath();
            return !ignoreExtension && !path.getName().endsWith(".avro") ? None$.MODULE$ : (Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new FsInput(path, conf), (Function1 & Serializable)in -> {
                Some some;
                try {
                    some = new Some((Object)DataFileReader.openReader((SeekableInput)in, (DatumReader)new GenericDatumReader()));
                }
                catch (IOException e) {
                    if (ignoreCorruptFiles) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(path).toString(), e);
                        some = None$.MODULE$;
                    }
                    throw new SparkException(new StringBuilder(21).append("Could not read file: ").append(path).toString(), (Throwable)e);
                }
                return some;
            });
        }).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Option<FileReader<GenericRecord>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    FileReader reader = (FileReader)some.value();
                    object = reader;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<FileReader<GenericRecord>> x1) {
                Option<FileReader<GenericRecord>> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        });
        Option option = avroReader;
        if (option instanceof Some) {
            Some some = (Some)option;
            try (FileReader reader = (FileReader)some.value();){
                schema = reader.getSchema();
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new FileNotFoundException("No Avro files found. If files don't have .avro extension, set ignoreExtension to true");
            }
            throw new MatchError((Object)option);
        }
        Schema schema2 = schema;
        return schema2;
    }

    public String toFieldStr(Seq<String> names) {
        SeqOps seqOps;
        Seq<String> seq = names;
        String string = seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0 ? "top-level record" : new StringBuilder(8).append("field '").append(seq.mkString(".")).append("'").toString();
        return string;
    }

    public boolean isNullable(Schema.Field avroField) {
        Schema.Type type = avroField.schema().getType();
        Schema.Type type2 = Schema.Type.UNION;
        return !(type != null ? !type.equals(type2) : type2 != null) && ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(avroField.schema().getTypes()).asScala()).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.$anonfun$isNullable$1(x$6)));
    }

    public Seq<Schema> nonNullUnionBranches(Schema avroType) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala()).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.$anonfun$nonNullUnionBranches$1(x$7)))).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$isNullable$1(Schema x$6) {
        Schema.Type type = x$6.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$nonNullUnionBranches$1(Schema x$7) {
        Schema.Type type = x$7.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    private AvroUtils$() {
    }
}

