/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.avro.AvroUtils;
import org.apache.spark.sql.avro.AvroUtils$;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%h!\u0002\r\u001a\u0001m\u0019\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u007f!A1\t\u0001B\u0001B\u0003%A\tC\u0003O\u0001\u0011\u0005q\nC\u0003O\u0001\u0011\u0005q\u000bC\u0003\\\u0001\u0011\u0005A\fC\u0004c\u0001\t\u0007I\u0011B2\t\r)\u0004\u0001\u0015!\u0003e\u0011\u001dY\u0007A1A\u0005\n1Da!\u001d\u0001!\u0002\u0013i\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007k\u0002\u0001\u000b\u0011\u0002;\u0006\tY\u0004Aa\u001e\u0005\u000b\u0003\u000b\u0001\u0001R1A\u0005\n\u0005\u001d\u0001bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\tI\n\u0001C\u0005\u00037Cq!!+\u0001\t\u0013\tY\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011q\u001a\u0001\u0005\n\u0005E'AD!we>\u001cVM]5bY&TXM\u001d\u0006\u00035m\tA!\u0019<s_*\u0011A$H\u0001\u0004gFd'B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0014\u0007\u0001!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[u\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003_1\u0012q\u0001T8hO&tw-\u0001\ts_>$8)\u0019;bYf\u001cH\u000fV=qK\u000e\u0001\u0001CA\u001a7\u001b\u0005!$BA\u001b\u001c\u0003\u0015!\u0018\u0010]3t\u0013\t9DG\u0001\u0005ECR\fG+\u001f9f\u00031\u0011xn\u001c;BmJ|G+\u001f9f!\tQD(D\u0001<\u0015\tQr$\u0003\u0002>w\t11k\u00195f[\u0006\f\u0001B\\;mY\u0006\u0014G.\u001a\t\u0003K\u0001K!!\u0011\u0014\u0003\u000f\t{w\u000e\\3b]\u0006!\u0002o\\:ji&|g.\u00197GS\u0016dG-T1uG\"\f!\u0003Z1uKRLW.\u001a*fE\u0006\u001cX-T8eKB\u0011QI\u0013\b\u0003\r\"k\u0011a\u0012\u0006\u0003[mI!!S$\u0002)1+w-Y2z\u0005\u0016D\u0017M^5peB{G.[2z\u0013\tYEJA\u0003WC2,X-\u0003\u0002NM\tYQI\\;nKJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q1\u0001KU*U+Z\u0003\"!\u0015\u0001\u000e\u0003eAQ\u0001\r\u0004A\u0002IBQ\u0001\u000f\u0004A\u0002eBQA\u0010\u0004A\u0002}BQA\u0011\u0004A\u0002}BQa\u0011\u0004A\u0002\u0011#B\u0001\u0015-Z5\")\u0001g\u0002a\u0001e!)\u0001h\u0002a\u0001s!)ah\u0002a\u0001\u007f\u0005I1/\u001a:jC2L'0\u001a\u000b\u0003;\u0002\u0004\"!\n0\n\u0005}3#aA!os\")\u0011\r\u0003a\u0001;\u0006a1-\u0019;bYf\u001cH\u000fR1uC\u0006qA-\u0019;f%\u0016\u0014\u0017m]3Gk:\u001cW#\u00013\u0011\t\u0015*wmZ\u0005\u0003M\u001a\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0015B\u0017BA5'\u0005\rIe\u000e^\u0001\u0010I\u0006$XMU3cCN,g)\u001e8dA\u0005\u0019B/[7fgR\fW\u000e\u001d*fE\u0006\u001cXMR;oGV\tQ\u000e\u0005\u0003&K:t\u0007CA\u0013p\u0013\t\u0001hE\u0001\u0003M_:<\u0017\u0001\u0006;j[\u0016\u001cH/Y7q%\u0016\u0014\u0017m]3Gk:\u001c\u0007%A\u0005d_:4XM\u001d;feV\tA\u000f\u0005\u0003&Kvk\u0016AC2p]Z,'\u000f^3sA\tI1i\u001c8wKJ$XM\u001d\t\u0006KaTx-X\u0005\u0003s\u001a\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0006fqB\u0014Xm]:j_:\u001c(BA@\u001c\u0003!\u0019\u0017\r^1msN$\u0018bAA\u0002y\n\u00112\u000b]3dS\u0006d\u0017N_3e\u000f\u0016$H/\u001a:t\u0003I!WmY5nC2\u001cuN\u001c<feNLwN\\:\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003GqA!!\u0004\u0002 9!\u0011qBA\u000f\u001d\u0011\t\t\"a\u0007\u000f\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u00062\u0003\u0019a$o\\8u}%\t!%\u0003\u0002!C%\u0011!dH\u0005\u0004\u0003CY\u0014aC\"p]Z,'o]5p]NLA!!\n\u0002(\t\tB)Z2j[\u0006d7i\u001c8wKJ\u001c\u0018n\u001c8\u000b\u0007\u0005\u00052(\u0001\u0007oK^\u001cuN\u001c<feR,'\u000f\u0006\u0006\u0002.\u0005E\u0012QGA\u001d\u0003?\u00022!a\f\u0010\u001b\u0005\u0001\u0001BBA\u001a#\u0001\u0007!'\u0001\u0007dCR\fG._:u)f\u0004X\r\u0003\u0004\u00028E\u0001\r!O\u0001\tCZ\u0014x\u000eV=qK\"9\u00111H\tA\u0002\u0005u\u0012\u0001D2bi\u0006d\u0017p\u001d;QCRD\u0007CBA \u0003\u0013\nyE\u0004\u0003\u0002B\u0005\u0015c\u0002BA\n\u0003\u0007J\u0011aJ\u0005\u0004\u0003\u000f2\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\niEA\u0002TKFT1!a\u0012'!\u0011\t\t&!\u0017\u000f\t\u0005M\u0013Q\u000b\t\u0004\u0003'1\u0013bAA,M\u00051\u0001K]3eK\u001aLA!a\u0017\u0002^\t11\u000b\u001e:j]\u001eT1!a\u0016'\u0011\u001d\t\t'\u0005a\u0001\u0003{\t\u0001\"\u0019<s_B\u000bG\u000f[\u0001\u0013]\u0016<8\u000b\u001e:vGR\u001cuN\u001c<feR,'\u000f\u0006\u0006\u0002h\u0005\u001d\u0015\u0011SAK\u0003/\u0003b!J3\u0002j\u0005E\u0004\u0003BA6\u0003[j\u0011A`\u0005\u0004\u0003_r(aC%oi\u0016\u0014h.\u00197S_^\u0004B!a\u001d\u0002\u0002:!\u0011QOA>\u001d\u0011\ti!a\u001e\n\u0007\u0005e4(A\u0004hK:,'/[2\n\t\u0005u\u0014qP\u0001\f\u000f\u0016tWM]5d\t\u0006$\u0018MC\u0002\u0002zmJA!a!\u0002\u0006\n1!+Z2pe\u0012TA!! \u0002\u0000!9\u0011\u0011\u0012\nA\u0002\u0005-\u0015AD2bi\u0006d\u0017p\u001d;TiJ,8\r\u001e\t\u0004g\u00055\u0015bAAHi\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\r\u0005M%\u00031\u0001:\u0003)\tgO]8TiJ,8\r\u001e\u0005\b\u0003w\u0011\u0002\u0019AA\u001f\u0011\u001d\t\tG\u0005a\u0001\u0003{\t\u0001D\\3x\u0007>l\u0007\u000f\\3y+:LwN\\\"p]Z,'\u000f^3s))\ti*a(\u0002\"\u0006\u0015\u0016q\u0015\t\u0006K\u0015\fI'\u0018\u0005\b\u0003\u0013\u001b\u0002\u0019AAF\u0011\u0019\t\u0019k\u0005a\u0001s\u0005IQO\\5p]RK\b/\u001a\u0005\b\u0003w\u0019\u0002\u0019AA\u001f\u0011\u001d\t\tg\u0005a\u0001\u0003{\t1C]3t_24XMT;mY\u0006\u0014G.\u001a+za\u0016$R!OAW\u0003_Ca!a\u000e\u0015\u0001\u0004I\u0004\"\u0002 \u0015\u0001\u0004y\u0014a\u0004:fg>dg/Z!we>$\u0016\u0010]3\u0015\t\u0005U\u00161\u0018\t\u0006K\u0005]v(O\u0005\u0004\u0003s3#A\u0002+va2,'\u0007\u0003\u0004\u00028U\u0001\r!O\u0001\u001ao\u0006\u0014hNT;mY\u0006\u0014\u0017\u000e\\5us\u0012KgMZ3sK:\u001cW\r\u0006\u0004\u0002B\u0006\u001d\u00171\u001a\t\u0004K\u0005\r\u0017bAAcM\t!QK\\5u\u0011\u0019\tIM\u0006a\u0001\u007f\u0005a\u0011M\u001e:p\u001dVdG.\u00192mK\"1\u0011Q\u001a\fA\u0002}\n\u0001cY1uC2L8\u000f\u001e(vY2\f'\r\\3\u0002#9|gNT;mYVs\u0017n\u001c8UsB,7\u000f\u0006\u0003\u0002T\u0006\u001d\bCBA)\u0003+\fI.\u0003\u0003\u0002X\u0006u#aA*fiB!\u00111\\Aq\u001d\u0011\ti!!8\n\u0007\u0005}7(\u0001\u0004TG\",W.Y\u0005\u0005\u0003G\f)O\u0001\u0003UsB,'bAApw!1\u0011qG\fA\u0002e\u0002")
public class AvroSerializer
implements Logging {
    private Conversions.DecimalConversion decimalConversions;
    private final DataType rootCatalystType;
    private final Schema rootAvroType;
    private final boolean positionalFieldMatch;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Function1<Object, Object> converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroSerializer avroSerializer = this;
        synchronized (avroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        return !this.bitmap$0 ? this.decimalConversions$lzycompute() : this.decimalConversions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType, Seq<String> catalystPath, Seq<String> avroPath) {
        String errorPrefix = new StringBuilder(0).append(new StringBuilder(20).append("Cannot convert SQL ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(" ").toString()).append(new StringBuilder(17).append("to Avro ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" because ").toString()).toString();
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getEnumSymbols()).asScala()).toSet();
                return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$11(enumSymbols, errorPrefix, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$13(size, errorPrefix, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)AvroSerializer.$anonfun$newConverter$15(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                Function2 & Serializable intersect;
                LogicalType logicalType = avroType.getLogicalType();
                boolean bl = logicalType == null ? true : logicalType instanceof LogicalTypes.TimestampMillis;
                if (bl) {
                    intersect = (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)))));
                    return intersect;
                } else {
                    if (!(logicalType instanceof LogicalTypes.TimestampMicros)) throw new IncompatibleSchemaException(new StringBuilder(0).append(errorPrefix).append(new StringBuilder(51).append("SQL type ").append(TimestampType$.MODULE$.sql()).append(" cannot be converted to Avro logical type ").append(logicalType).toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    intersect = (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$17(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                return intersect;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampNTZType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                Function2 & Serializable intersect;
                LogicalType logicalType = avroType.getLogicalType();
                boolean bl = logicalType == null ? true : logicalType instanceof LogicalTypes.LocalTimestampMillis;
                if (bl) {
                    intersect = (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal))));
                    return intersect;
                } else {
                    if (!(logicalType instanceof LogicalTypes.LocalTimestampMicros)) throw new IncompatibleSchemaException(new StringBuilder(0).append(errorPrefix).append(new StringBuilder(51).append("SQL type ").append(TimestampNTZType$.MODULE$.sql()).append(" cannot be converted to Avro logical type ").append(logicalType).toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    intersect = (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                return intersect;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), containsNull), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"element")), (Seq<String>)((Seq)avroPath.$colon$plus((Object)"element")));
                    return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$20(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType, catalystPath, avroPath);
                    int numFields = structType.length();
                    return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$21(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.UNION.equals(type)) {
                    Function1<InternalRow, Object> unionConvertor = this.newComplexUnionConverter(structType, avroType, catalystPath, avroPath);
                    int numFields = structType.length();
                    return (Function2 & Serializable)(getter, ordinal) -> unionConvertor.apply((Object)getter.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), numFields));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.UNION.equals(type)) {
                Set<Schema.Type> set = this.nonNullUnionTypes(avroType);
                Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE}));
                if (set == null) {
                    if (object == null) return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
                } else if (set.equals(object)) {
                    return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.UNION.equals(type)) {
                Set<Schema.Type> set = this.nonNullUnionTypes(avroType);
                Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG}));
                if (set == null) {
                    if (object == null) return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                } else if (set.equals(object)) {
                    return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                if (Schema.Type.MAP.equals(type)) {
                    DataType dataType2 = kt;
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null)) {
                        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), valueContainsNull), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"value")), (Seq<String>)((Seq)avroPath.$colon$plus((Object)"value")));
                        return (Function2 & Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$25(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            Schema.Type type = (Schema.Type)tuple2._2();
            if (tuple2._1() instanceof YearMonthIntervalType && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 == null) throw new IncompatibleSchemaException(new StringBuilder(0).append(errorPrefix).append(new StringBuilder(48).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        Schema.Type type = (Schema.Type)tuple2._2();
        if (!(tuple2._1() instanceof DayTimeIntervalType)) throw new IncompatibleSchemaException(new StringBuilder(0).append(errorPrefix).append(new StringBuilder(48).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        if (!Schema.Type.LONG.equals(type)) throw new IncompatibleSchemaException(new StringBuilder(0).append(errorPrefix).append(new StringBuilder(48).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct, Seq<String> catalystPath, Seq<String> avroPath) {
        AvroUtils.AvroSchemaHelper avroSchemaHelper = new AvroUtils.AvroSchemaHelper(avroStruct, catalystStruct, avroPath, catalystPath, this.positionalFieldMatch);
        avroSchemaHelper.validateNoExtraCatalystFields(false);
        avroSchemaHelper.validateNoExtraRequiredAvroFields();
        Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)avroSchemaHelper.matchedFields().map((Function1 & Serializable)x0$1 -> {
            AvroUtils.AvroMatchedField avroMatchedField = x0$1;
            if (avroMatchedField == null) {
                throw new MatchError((Object)avroMatchedField);
            }
            StructField catalystField = avroMatchedField.catalystField();
            Schema.Field avroField = avroMatchedField.avroField();
            Function2<SpecializedGetters, Object, Object> converter = this.newConverter(catalystField.dataType(), this.resolveNullableType(avroField.schema(), catalystField.nullable()), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)catalystField.name())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)avroField.name())));
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)avroField.pos()), converter);
            return tuple2;
        })).toArray(ClassTag$.MODULE$.apply(Tuple2.class))), Predef$.MODULE$.$conforms(), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Function2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] avroIndices = (int[])tuple2._1();
        Function2[] fieldConverters = (Function2[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)avroIndices, (Object)fieldConverters);
        Tuple2 tuple23 = tuple22;
        int[] avroIndices2 = (int[])tuple23._1();
        Function2[] fieldConverters2 = (Function2[])tuple23._2();
        int numFields = catalystStruct.length();
        return (Function1 & Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(avroIndices2[i], null);
                    continue;
                }
                result.put(avroIndices2[i], fieldConverters2[i].apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    private Function1<InternalRow, Object> newComplexUnionConverter(StructType catalystStruct, Schema unionType, Seq<String> catalystPath, Seq<String> avroPath) {
        Seq<Schema> nonNullTypes = AvroUtils$.MODULE$.nonNullUnionBranches(unionType);
        IndexedSeq expectedFieldNames = nonNullTypes.indices().map((Function1 & Serializable)i -> AvroSerializer.$anonfun$newComplexUnionConverter$1(BoxesRunTime.unboxToInt((Object)i)));
        Seq catalystFieldNames = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])catalystStruct.fieldNames()));
        if (this.positionalFieldMatch) {
            if (expectedFieldNames.length() != catalystFieldNames.length()) {
                throw new IncompatibleSchemaException(new StringBuilder(0).append(new StringBuilder(23).append("Generic Avro union at ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" ").toString()).append(new StringBuilder(52).append("does not match the SQL schema at ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(".  It expected the ").toString()).append(new StringBuilder(17).append(expectedFieldNames.length()).append(" members but got ").append(catalystFieldNames.length()).toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        } else {
            Seq seq = catalystFieldNames;
            IndexedSeq indexedSeq = expectedFieldNames;
            if (seq == null ? indexedSeq != null : !seq.equals(indexedSeq)) {
                throw new IncompatibleSchemaException(new StringBuilder(0).append(new StringBuilder(23).append("Generic Avro union at ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" ").toString()).append(new StringBuilder(52).append("does not match the SQL schema at ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(".  It expected the ").toString()).append(new StringBuilder(27).append("following members ").append(expectedFieldNames.mkString("(", ", ", ")")).append(" but got ").toString()).append(String.valueOf(catalystFieldNames.mkString("(", ", ", ")"))).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        Function2[] unionBranchConverters = (Function2[])((IterableOnceOps)((IterableOps)nonNullTypes.zip((IterableOnce)catalystStruct)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Schema unionBranch = (Schema)tuple2._1();
            StructField cf = (StructField)tuple2._2();
            Function2<SpecializedGetters, Object, Object> function2 = this.newConverter(cf.dataType(), unionBranch, (Seq<String>)((Seq)catalystPath.$colon$plus((Object)cf.name())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)cf.name())));
            return function2;
        })).toArray(ClassTag$.MODULE$.apply(Function2.class));
        int numBranches = catalystStruct.length();
        return (Function1 & Serializable)row -> {
            Object retVal = null;
            for (int idx = 0; idx < numBranches && retVal == null; ++idx) {
                if (row.isNullAt(idx)) continue;
                retVal = unionBranchConverters[idx].apply(row, (Object)BoxesRunTime.boxToInteger((int)idx));
            }
            return retVal;
        };
    }

    private Schema resolveNullableType(Schema avroType, boolean nullable) {
        Tuple2<Object, Schema> tuple2 = this.resolveAvroType(avroType);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean avroNullable = tuple2._1$mcZ$sp();
        Schema resolvedAvroType = (Schema)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)avroNullable), (Object)resolvedAvroType);
        Tuple2 tuple23 = tuple22;
        boolean avroNullable2 = tuple23._1$mcZ$sp();
        Schema resolvedAvroType2 = (Schema)tuple23._2();
        this.warnNullabilityDifference(avroNullable2, nullable);
        return resolvedAvroType2;
    }

    private Tuple2<Object, Schema> resolveAvroType(Schema avroType) {
        Tuple2 tuple2;
        Schema.Type type = avroType.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            SeqOps seqOps;
            Tuple2 tuple22;
            SeqOps seqOps2;
            boolean containsNull = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala()).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AvroSerializer.$anonfun$resolveAvroType$1(x$3)));
            Seq<Schema> seq = AvroUtils$.MODULE$.nonNullUnionBranches(avroType);
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Schema.create((Schema.Type)Schema.Type.NULL));
            } else if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                Schema singleType = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)containsNull), (Object)singleType);
            } else {
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)containsNull), (Object)avroType);
            }
            tuple2 = tuple22;
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)avroType);
        }
        return tuple2;
    }

    private void warnNullabilityDifference(boolean avroNullable, boolean catalystNullable) {
        block1: {
            if (avroNullable && !catalystNullable) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Writing Avro files with nullable Avro schema and non-nullable catalyst schema.");
            }
            if (avroNullable || !catalystNullable) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Writing Avro files with non-nullable Avro schema and nullable catalyst schema will throw runtime exception if there is a record with null value.");
        }
    }

    private Set<Schema.Type> nonNullUnionTypes(Schema avroType) {
        return ((IterableOnceOps)AvroUtils$.MODULE$.nonNullUnionBranches(avroType).map((Function1 & Serializable)x$4 -> x$4.getType())).toSet();
    }

    private final /* synthetic */ Function1 liftedTree1$1(Schema actualAvroType$1) {
        Function1 & Serializable intersect;
        try {
            Function1 & Serializable intersect2;
            DataType dataType = this.rootCatalystType;
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                intersect2 = this.newStructConverter(structType, actualAvroType$1, (Seq<String>)package$.MODULE$.Nil(), (Seq<String>)package$.MODULE$.Nil());
            } else {
                SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{this.rootCatalystType})));
                Function2<SpecializedGetters, Object, Object> converter = this.newConverter(this.rootCatalystType, actualAvroType$1, (Seq<String>)package$.MODULE$.Nil(), (Seq<String>)package$.MODULE$.Nil());
                intersect2 = (Function1 & Serializable)data -> {
                    tmpRow.update(0, data);
                    return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
                };
            }
            intersect = intersect2;
        }
        catch (IncompatibleSchemaException ise) {
            throw new IncompatibleSchemaException(new StringBuilder(39).append("Cannot convert SQL type ").append(this.rootCatalystType.sql()).append(" to Avro type ").append(this.rootAvroType).append(".").toString(), ise);
        }
        return intersect;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(AvroSerializer $this, DecimalType x35$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x35$1.precision(), x35$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x35$1.precision(), (int)x35$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(AvroSerializer $this, DecimalType x38$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x38$1.precision(), x38$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x38$1.precision(), (int)x38$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Set enumSymbols$1, String errorPrefix$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(0).append(errorPrefix$1).append(new StringBuilder(52).append("\"").append(data).append("\" cannot be written since it's not defined in enum ").toString()).append(enumSymbols$1.mkString("\"", "\", \"", "\"")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    private static final String len2str$1(int len) {
        return new StringBuilder(1).append(len).append(" ").append((Object)(len > 1 ? "bytes" : "byte")).toString();
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(int size$1, String errorPrefix$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(63).append(errorPrefix$1).append(AvroSerializer.len2str$1(data.length)).append(" of binary data cannot be written into FIXED type with size of ").append(AvroSerializer.len2str$1(size$1)).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ int $anonfun$newConverter$15(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.dateRebaseFunc().apply$mcII$sp(getter.getInt(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$17(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(ordinal));
    }

    public static final /* synthetic */ List $anonfun$newConverter$20(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$21(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$25(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$newComplexUnionConverter$1(int i) {
        return new StringBuilder(6).append("member").append(i).toString();
    }

    public static final /* synthetic */ boolean $anonfun$resolveAvroType$1(Schema x$3) {
        Schema.Type type = x$3.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable, boolean positionalFieldMatch, Enumeration.Value datetimeRebaseMode) {
        this.rootCatalystType = rootCatalystType;
        this.rootAvroType = rootAvroType;
        this.positionalFieldMatch = positionalFieldMatch;
        Logging.$init$((Logging)this);
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.createDateRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        Schema actualAvroType = this.resolveNullableType(rootAvroType, nullable);
        Function1 & Serializable baseConverter = this.liftedTree1$1(actualAvroType);
        this.converter = nullable ? (Function1 & Serializable)data -> data == null ? null : baseConverter.apply(data) : baseConverter;
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        this(rootCatalystType, rootAvroType, nullable, false, LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE())));
    }
}

