/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum AvroCompressionCodec {
    UNCOMPRESSED("null", false, -1),
    DEFLATE("deflate", true, -1),
    SNAPPY("snappy", false, -1),
    BZIP2("bzip2", false, -1),
    XZ("xz", true, 6),
    ZSTANDARD("zstandard", true, 3);

    private final String codecName;
    private final boolean supportCompressionLevel;
    private final int defaultCompressionLevel;
    private static final Map<String, String> codecNameMap;

    private AvroCompressionCodec(String codecName, boolean supportCompressionLevel, int defaultCompressionLevel) {
        this.codecName = codecName;
        this.supportCompressionLevel = supportCompressionLevel;
        this.defaultCompressionLevel = defaultCompressionLevel;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public boolean getSupportCompressionLevel() {
        return this.supportCompressionLevel;
    }

    public int getDefaultCompressionLevel() {
        return this.defaultCompressionLevel;
    }

    public String lowerCaseName() {
        return codecNameMap.get(this.name());
    }

    public static AvroCompressionCodec fromString(String s) {
        return AvroCompressionCodec.valueOf(s.toUpperCase(Locale.ROOT));
    }

    static {
        codecNameMap = Arrays.stream(AvroCompressionCodec.values()).collect(Collectors.toMap(codec -> codec.name(), codec -> codec.name().toLowerCase(Locale.ROOT)));
    }
}

