/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Locale;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOptions$;
import org.apache.spark.sql.avro.AvroUtils$;
import org.apache.spark.sql.avro.CustomDecimal;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.avro.SchemaConverters;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
public final class SchemaConverters$ {
    public static final SchemaConverters$ MODULE$ = new SchemaConverters$();
    private static Schema nullSchema;
    private static final String CATALYST_TYPE_PROP_NAME;
    private static volatile boolean bitmap$0;

    static {
        CATALYST_TYPE_PROP_NAME = "spark.sql.catalyst.type";
    }

    private Schema nullSchema$lzycompute() {
        SchemaConverters$ schemaConverters$ = this;
        synchronized (schemaConverters$) {
            if (!bitmap$0) {
                nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
                bitmap$0 = true;
            }
        }
        return nullSchema;
    }

    private Schema nullSchema() {
        if (!bitmap$0) {
            return this.nullSchema$lzycompute();
        }
        return nullSchema;
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema, boolean useStableIdForUnionType, String stableIdPrefixForUnionType) {
        return this.toSqlTypeHelper(avroSchema, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), useStableIdForUnionType, stableIdPrefixForUnionType);
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema) {
        return this.toSqlType(avroSchema, false, "");
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema, Map<String, String> options) {
        AvroOptions avroOptions = AvroOptions$.MODULE$.apply(options);
        return this.toSqlTypeHelper(avroSchema, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), avroOptions.useStableIdForUnionType(), avroOptions.stableIdPrefixForUnionType());
    }

    private String CATALYST_TYPE_PROP_NAME() {
        return CATALYST_TYPE_PROP_NAME;
    }

    private SchemaConverters.SchemaType toSqlTypeHelper(Schema avroSchema, scala.collection.immutable.Set<String> existingRecordNames, boolean useStableIdForUnionType, String stableIdPrefixForUnionType) {
        Schema.Type type;
        block25: {
            SeqOps seqOps;
            SeqOps seqOps2;
            Seq seq;
            while (true) {
                SeqOps seqOps3;
                if (Schema.Type.INT.equals(type = avroSchema.getType())) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Date) {
                        return new SchemaConverters.SchemaType((DataType)DateType$.MODULE$, false);
                    }
                    String catalystTypeAttrValue = avroSchema.getProp(this.CATALYST_TYPE_PROP_NAME());
                    IntegerType$ catalystType = catalystTypeAttrValue == null ? IntegerType$.MODULE$ : CatalystSqlParser$.MODULE$.parseDataType(catalystTypeAttrValue);
                    return new SchemaConverters.SchemaType((DataType)catalystType, false);
                }
                if (Schema.Type.STRING.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.BOOLEAN.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)BooleanType$.MODULE$, false);
                }
                if (Schema.Type.BYTES.equals(type) ? true : Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Decimal) {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return new SchemaConverters.SchemaType((DataType)new DecimalType(decimal.getPrecision(), decimal.getScale()), false);
                    }
                    return new SchemaConverters.SchemaType((DataType)BinaryType$.MODULE$, false);
                }
                if (Schema.Type.DOUBLE.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
                if (Schema.Type.FLOAT.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)FloatType$.MODULE$, false);
                }
                if (Schema.Type.LONG.equals(type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof CustomDecimal) {
                        CustomDecimal customDecimal = (CustomDecimal)logicalType;
                        return new SchemaConverters.SchemaType((DataType)new DecimalType(customDecimal.precision(), customDecimal.scale()), false);
                    }
                    if (logicalType instanceof LogicalTypes.TimestampMillis ? true : logicalType instanceof LogicalTypes.TimestampMicros) {
                        return new SchemaConverters.SchemaType((DataType)TimestampType$.MODULE$, false);
                    }
                    if (logicalType instanceof LogicalTypes.LocalTimestampMillis ? true : logicalType instanceof LogicalTypes.LocalTimestampMicros) {
                        return new SchemaConverters.SchemaType((DataType)TimestampNTZType$.MODULE$, false);
                    }
                    String catalystTypeAttrValue = avroSchema.getProp(this.CATALYST_TYPE_PROP_NAME());
                    LongType$ catalystType = catalystTypeAttrValue == null ? LongType$.MODULE$ : CatalystSqlParser$.MODULE$.parseDataType(catalystTypeAttrValue);
                    return new SchemaConverters.SchemaType((DataType)catalystType, false);
                }
                if (Schema.Type.ENUM.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.NULL.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)NullType$.MODULE$, true);
                }
                if (Schema.Type.RECORD.equals(type)) {
                    if (existingRecordNames.contains((Object)avroSchema.getFullName())) {
                        throw new IncompatibleSchemaException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |Found recursive reference in Avro schema, which can not be processed by Spark:\n            |" + avroSchema.toString(true) + "\n          ")), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    }
                    scala.collection.immutable.Set newRecordNames = (scala.collection.immutable.Set)existingRecordNames.$plus((Object)avroSchema.getFullName());
                    Buffer fields = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().map((Function1 & Serializable)f -> {
                        SchemaConverters.SchemaType schemaType = MODULE$.toSqlTypeHelper(f.schema(), (scala.collection.immutable.Set<String>)newRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType);
                        return new StructField(f.name(), schemaType.dataType(), schemaType.nullable(), StructField$.MODULE$.apply$default$4());
                    });
                    return new SchemaConverters.SchemaType((DataType)new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class))), false);
                }
                if (Schema.Type.ARRAY.equals(type)) {
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getElementType(), existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType);
                    return new SchemaConverters.SchemaType((DataType)new ArrayType(schemaType.dataType(), schemaType.nullable()), false);
                }
                if (Schema.Type.MAP.equals(type)) {
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getValueType(), existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType);
                    return new SchemaConverters.SchemaType((DataType)new MapType((DataType)StringType$.MODULE$, schemaType.dataType(), schemaType.nullable()), false);
                }
                if (!Schema.Type.UNION.equals(type)) break block25;
                if (CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverters$.$anonfun$toSqlTypeHelper$2(x$1)))) {
                    Seq<Schema> remainingUnionTypes = AvroUtils$.MODULE$.nonNullUnionBranches(avroSchema);
                    if (remainingUnionTypes.size() == 1) {
                        SchemaConverters.SchemaType qual$1 = this.toSqlTypeHelper((Schema)remainingUnionTypes.head(), existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType);
                        boolean x$12 = true;
                        DataType x$22 = qual$1.copy$default$1();
                        return qual$1.copy(x$22, true);
                    }
                    SchemaConverters.SchemaType qual$2 = this.toSqlTypeHelper(Schema.createUnion((List)CollectionConverters$.MODULE$.SeqHasAsJava(remainingUnionTypes).asJava()), existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType);
                    boolean x$3 = true;
                    DataType x$4 = qual$2.copy$default$1();
                    return qual$2.copy(x$4, true);
                }
                seq = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().map((Function1 & Serializable)x$2 -> x$2.getType())).toSeq();
                if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) != 0) break;
                avroSchema = (Schema)avroSchema.getTypes().get(0);
            }
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                Schema.Type t1 = (Schema.Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Schema.Type t2 = (Schema.Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                if (BoxesRunTime.equals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2})), (Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG})))) {
                    return new SchemaConverters.SchemaType((DataType)LongType$.MODULE$, false);
                }
            }
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Schema.Type t1 = (Schema.Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Schema.Type t2 = (Schema.Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (BoxesRunTime.equals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2})), (Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE})))) {
                    return new SchemaConverters.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
            }
            Set fieldNameSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            Buffer fields = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String string;
                    Schema s = (Schema)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    SchemaConverters.SchemaType schemaType = MODULE$.toSqlTypeHelper(s, existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType);
                    if (useStableIdForUnionType) {
                        String tempFieldName = stableIdPrefixForUnionType + s.getName();
                        if (!fieldNameSet.add((Object)tempFieldName.toLowerCase(Locale.ROOT))) {
                            throw new IncompatibleSchemaException("Cannot generate stable identifier for Avro union type due to name conflict of type name " + s.getName(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                        }
                        string = tempFieldName;
                    } else {
                        string = "member" + i;
                    }
                    String fieldName = string;
                    return new StructField(fieldName, schemaType.dataType(), true, StructField$.MODULE$.apply$default$4());
                }
                throw new MatchError((Object)tuple2);
            });
            return new SchemaConverters.SchemaType((DataType)new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class))), false);
        }
        throw new IncompatibleSchemaException("Unsupported type " + type, IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    /*
     * Unable to fully structure code
     */
    public Schema toAvroType(DataType catalystType, boolean nullable, String recordName, String nameSpace) {
        block14: {
            block27: {
                block26: {
                    block24: {
                        block25: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                block18: {
                                                    block17: {
                                                        block16: {
                                                            block15: {
                                                                block13: {
                                                                    builder = SchemaBuilder.builder();
                                                                    var10_6 = catalystType;
                                                                    if (!BooleanType$.MODULE$.equals(var10_6)) break block13;
                                                                    v0 = (Schema)builder.booleanType();
                                                                    break block14;
                                                                }
                                                                if (!(ByteType$.MODULE$.equals(var10_6) != false ? true : (ShortType$.MODULE$.equals(var10_6) != false ? true : IntegerType$.MODULE$.equals(var10_6) != false))) break block15;
                                                                v0 = (Schema)builder.intType();
                                                                break block14;
                                                            }
                                                            if (!LongType$.MODULE$.equals(var10_6)) break block16;
                                                            v0 = (Schema)builder.longType();
                                                            break block14;
                                                        }
                                                        if (!DateType$.MODULE$.equals(var10_6)) break block17;
                                                        v0 = LogicalTypes.date().addToSchema((Schema)builder.intType());
                                                        break block14;
                                                    }
                                                    if (!TimestampType$.MODULE$.equals(var10_6)) break block18;
                                                    v0 = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                                                    break block14;
                                                }
                                                if (!TimestampNTZType$.MODULE$.equals(var10_6)) break block19;
                                                v0 = LogicalTypes.localTimestampMicros().addToSchema((Schema)builder.longType());
                                                break block14;
                                            }
                                            if (!FloatType$.MODULE$.equals(var10_6)) break block20;
                                            v0 = (Schema)builder.floatType();
                                            break block14;
                                        }
                                        if (!DoubleType$.MODULE$.equals(var10_6)) break block21;
                                        v0 = (Schema)builder.doubleType();
                                        break block14;
                                    }
                                    if (!StringType$.MODULE$.equals(var10_6)) break block22;
                                    v0 = (Schema)builder.stringType();
                                    break block14;
                                }
                                if (!NullType$.MODULE$.equals(var10_6)) break block23;
                                v0 = (Schema)builder.nullType();
                                break block14;
                            }
                            if (!(var10_6 instanceof DecimalType)) break block24;
                            var11_7 = (DecimalType)var10_6;
                            avroType = LogicalTypes.decimal((int)var11_7.precision(), (int)var11_7.scale());
                            fixedSize = Decimal$.MODULE$.minBytesForPrecision()[var11_7.precision()];
                            var15_10 = nameSpace;
                            switch (var15_10 == null ? 0 : var15_10.hashCode()) {
                                case 0: {
                                    if (!"".equals(var15_10)) break;
                                    v1 = recordName + ".fixed";
                                    break block25;
                                }
                            }
                            v1 = nameSpace + "." + recordName + ".fixed";
                        }
                        name = v1;
                        v0 = avroType.addToSchema((Schema)SchemaBuilder.fixed((String)name).size(fixedSize));
                        break block14;
                    }
                    if (!BinaryType$.MODULE$.equals(var10_6)) break block26;
                    v0 = (Schema)builder.bytesType();
                    break block14;
                }
                if (!(var10_6 instanceof ArrayType)) break block27;
                var16_12 = (ArrayType)var10_6;
                et = var16_12.elementType();
                containsNull = var16_12.containsNull();
                v0 = (Schema)builder.array().items(this.toAvroType(et, containsNull, recordName, nameSpace));
                break block14;
            }
            if (!(var10_6 instanceof MapType)) ** GOTO lbl-1000
            var19_15 = (MapType)var10_6;
            var20_16 = var19_15.keyType();
            vt = var19_15.valueType();
            valueContainsNull = var19_15.valueContainsNull();
            if (StringType$.MODULE$.equals(var20_16)) {
                v0 = (Schema)builder.map().values(this.toAvroType(vt, valueContainsNull, recordName, nameSpace));
            } else if (var10_6 instanceof StructType) {
                var23_19 = (StructType)var10_6;
                v2 = nameSpace;
                var25_20 = "";
                childNameSpace = (v2 == null ? var25_20 != null : v2.equals(var25_20) == false) ? nameSpace + "." + recordName : recordName;
                fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(nameSpace)).fields();
                var23_19.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toAvroType$1(java.lang.String org.apache.avro.SchemaBuilder$FieldAssembler org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lorg/apache/avro/SchemaBuilder$FieldAssembler;)((String)childNameSpace, (SchemaBuilder.FieldAssembler)fieldsAssembler));
                v0 = (Schema)fieldsAssembler.endRecord();
            } else if (var10_6 instanceof YearMonthIntervalType) {
                var27_23 = (YearMonthIntervalType)var10_6;
                ymIntervalType = (Schema)builder.intType();
                ymIntervalType.addProp(this.CATALYST_TYPE_PROP_NAME(), var27_23.typeName());
                v0 = ymIntervalType;
            } else if (var10_6 instanceof DayTimeIntervalType) {
                var29_25 = (DayTimeIntervalType)var10_6;
                dtIntervalType = (Schema)builder.longType();
                dtIntervalType.addProp(this.CATALYST_TYPE_PROP_NAME(), var29_25.typeName());
                v0 = dtIntervalType;
            } else {
                throw new IncompatibleSchemaException("Unexpected type " + var10_6 + ".", IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        schema = v0;
        if (nullable) {
            v3 = catalystType;
            var31_28 = NullType$.MODULE$;
            if (v3 == null ? var31_28 != null : v3.equals(var31_28) == false) {
                return Schema.createUnion((Schema[])new Schema[]{schema, this.nullSchema()});
            }
        }
        return schema;
    }

    public boolean toAvroType$default$2() {
        return false;
    }

    public String toAvroType$default$3() {
        return "topLevelRecord";
    }

    public String toAvroType$default$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$2(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ SchemaBuilder.FieldAssembler $anonfun$toAvroType$1(String childNameSpace$1, SchemaBuilder.FieldAssembler fieldsAssembler$1, StructField f) {
        Schema fieldAvroType = MODULE$.toAvroType(f.dataType(), f.nullable(), f.name(), childNameSpace$1);
        return fieldsAssembler$1.name(f.name()).type(fieldAvroType).noDefault();
    }

    private SchemaConverters$() {
    }
}

