/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="a _FUNC_ b - Returns same result with EQUAL(=) operator for non-null operands,\n    but returns TRUE if both are NULL, FALSE if one of the them is NULL.")
@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001>\u0011Q\"R9vC2tU\u000f\u001c7TC\u001a,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u0007\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJL8i\\7qCJL7o\u001c8\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u000fA\u0013x\u000eZ;diB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0016\u0004%\taH\u0001\u0005Y\u00164G/F\u0001!!\t\t\u0012%\u0003\u0002#\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0011\u0002!\u0011#Q\u0001\n\u0001\nQ\u0001\\3gi\u0002B\u0001B\n\u0001\u0003\u0016\u0004%\taH\u0001\u0006e&<\u0007\u000e\u001e\u0005\tQ\u0001\u0011\t\u0012)A\u0005A\u00051!/[4ii\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017.]A\u0011\u0011\u0003\u0001\u0005\u0006=%\u0002\r\u0001\t\u0005\u0006M%\u0002\r\u0001\t\u0005\u0006a\u0001!\t%M\u0001\nS:\u0004X\u000f\u001e+za\u0016,\u0012A\r\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tQ\u0001^=qKNL!a\u000e\u001b\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007\"B\u001d\u0001\t\u0003R\u0014AB:z[\n|G.F\u0001<!\tatH\u0004\u0002\u0016{%\u0011aHF\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?-!)1\t\u0001C!\t\u0006Aa.\u001e7mC\ndW-F\u0001F!\t)b)\u0003\u0002H-\t9!i\\8mK\u0006t\u0007\"B%\u0001\t\u0003R\u0015\u0001B3wC2$\"a\u0013(\u0011\u0005Ua\u0015BA'\u0017\u0005\r\te.\u001f\u0005\b\u001f\"\u0003\n\u00111\u0001Q\u0003\u0015Ig\u000e];u!\t\t&+D\u0001\u0005\u0013\t\u0019FAA\u0006J]R,'O\\1m%><\b\"B+\u0001\t\u00032\u0016!\u00033p\u000f\u0016t7i\u001c3f)\r9VL\u0019\t\u00031nk\u0011!\u0017\u0006\u00035\n\tqaY8eK\u001e,g.\u0003\u0002]3\nAQ\t\u001f9s\u0007>$W\rC\u0003_)\u0002\u0007q,A\u0002dib\u0004\"\u0001\u00171\n\u0005\u0005L&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006GR\u0003\raV\u0001\u0003KZDq!\u001a\u0001\u0002\u0002\u0013\u0005a-\u0001\u0003d_BLHc\u0001\u0017hQ\"9a\u0004\u001aI\u0001\u0002\u0004\u0001\u0003b\u0002\u0014e!\u0003\u0005\r\u0001\t\u0005\bU\u0002\t\n\u0011\"\u0001l\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001c\u0016\u0003A5\\\u0013A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005M4\u0012AC1o]>$\u0018\r^5p]&\u0011Q\u000f\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB<\u0001#\u0003%\ta[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001dI\b!!A\u0005Bi\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A>\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0003mC:<'BAA\u0001\u0003\u0011Q\u0017M^1\n\u0005\u0001k\b\"CA\u0004\u0001\u0005\u0005I\u0011AA\u0005\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0001E\u0002\u0016\u0003\u001bI1!a\u0004\u0017\u0005\rIe\u000e\u001e\u0005\n\u0003'\u0001\u0011\u0011!C\u0001\u0003+\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002L\u0003/A!\"!\u0007\u0002\u0012\u0005\u0005\t\u0019AA\u0006\u0003\rAH%\r\u0005\n\u0003;\u0001\u0011\u0011!C!\u0003?\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0001R!a\t\u0002*-k!!!\n\u000b\u0007\u0005\u001db#\u0001\u0006d_2dWm\u0019;j_:LA!a\u000b\u0002&\tA\u0011\n^3sCR|'\u000fC\u0005\u00020\u0001\t\t\u0011\"\u0001\u00022\u0005A1-\u00198FcV\fG\u000eF\u0002F\u0003gA\u0011\"!\u0007\u0002.\u0005\u0005\t\u0019A&\t\u0013\u0005]\u0002!!A\u0005B\u0005e\u0012AB3rk\u0006d7\u000fF\u0002F\u0003wA\u0011\"!\u0007\u00026\u0005\u0005\t\u0019A&)\u000f\u0001\ty$!\u0012\u0002HA\u0019\u0011#!\u0011\n\u0007\u0005\r#AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005%\u0013!a\fbA}3UKT\"`A\t\u0004S\u0006\t*fiV\u0014hn\u001d\u0011tC6,\u0007E]3tk2$\be^5uQ\u0002*\u0015+V!MQuJ\u0003e\u001c9fe\u0006$xN\u001d\u0011g_J\u0004cn\u001c8.]VdG\u000eI8qKJ\fg\u000eZ:-\u0015\u0001\u0002\u0003\u0005\t2vi\u0002\u0012X\r^;s]N\u0004CKU+FA%4\u0007EY8uQ\u0002\n'/\u001a\u0011O+2cE\u0006\t$B\u0019N+\u0005%\u001b4!_:,\u0007e\u001c4!i\",\u0007\u0005\u001e5f[\u0002J7\u000f\t(V\u00192ss!CA'\u0005\u0005\u0005\t\u0012AA(\u00035)\u0015/^1m\u001dVdGnU1gKB\u0019\u0011#!\u0015\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003'\u001aR!!\u0015\u0002Vi\u0001r!a\u0016\u0002^\u0001\u0002C&\u0004\u0002\u0002Z)\u0019\u00111\f\f\u0002\u000fI,h\u000e^5nK&!\u0011qLA-\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bU\u0005EC\u0011AA2)\t\ty\u0005\u0003\u0006\u0002h\u0005E\u0013\u0011!C#\u0003S\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002w\"Q\u0011QNA)\u0003\u0003%\t)a\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b1\n\t(a\u001d\t\ry\tY\u00071\u0001!\u0011\u00191\u00131\u000ea\u0001A!Q\u0011qOA)\u0003\u0003%\t)!\u001f\u0002\u000fUt\u0017\r\u001d9msR!\u00111PAD!\u0015)\u0012QPAA\u0013\r\tyH\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bU\t\u0019\t\t\u0011\n\u0007\u0005\u0015eC\u0001\u0004UkBdWM\r\u0005\n\u0003\u0013\u000b)(!AA\u00021\n1\u0001\u001f\u00131\u0011)\ti)!\u0015\u0002\u0002\u0013%\u0011qR\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0012B\u0019A0a%\n\u0007\u0005UUP\u0001\u0004PE*,7\r\u001e")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public AbstractDataType inputType() {
        return AnyDataType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Boolean bl;
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        if (input1 == null && input2 == null) {
            bl = BoxesRunTime.boxToBoolean((boolean)true);
        } else if (input1 == null || input2 == null) {
            bl = BoxesRunTime.boxToBoolean((boolean)false);
        } else {
            DataType dataType2 = this.left().dataType();
            FloatType$ floatType$ = FloatType$.MODULE$;
            if (!(dataType2 != null ? !dataType2.equals(floatType$) : floatType$ != null)) {
                bl = BoxesRunTime.boxToBoolean((Utils$.MODULE$.nanSafeCompareFloats(BoxesRunTime.unboxToFloat((Object)input1), BoxesRunTime.unboxToFloat((Object)input2)) == 0 ? 1 : 0) != 0);
            } else {
                DataType dataType3 = this.left().dataType();
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                if (!(dataType3 != null ? !dataType3.equals(doubleType$) : doubleType$ != null)) {
                    bl = BoxesRunTime.boxToBoolean((Utils$.MODULE$.nanSafeCompareDoubles(BoxesRunTime.unboxToDouble((Object)input1), BoxesRunTime.unboxToDouble((Object)input2)) == 0 ? 1 : 0) != 0);
                } else {
                    DataType dataType4 = this.left().dataType();
                    BinaryType$ binaryType$ = BinaryType$.MODULE$;
                    bl = !(dataType4 != null ? !dataType4.equals(binaryType$) : binaryType$ != null) ? BoxesRunTime.boxToBoolean((boolean)Arrays.equals((byte[])input1, (byte[])input2)) : BoxesRunTime.boxToBoolean((BoxesRunTime.equals((Object)input1, (Object)input2) ? 1 : 0) != 0);
                }
            }
        }
        return bl;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), eval1.value(), eval2.value());
        return ev.copy(new StringBuilder().append((Object)eval1.code()).append((Object)eval2.code()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))).toString(), "false", ev.copy$default$3());
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

