/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RLike$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression$class;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ regexp - Returns true if str matches regexp and false otherwise.")
@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001>\u0011QA\u0015'jW\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E)\u0012B\u0001\f\u0003\u0005U\u0019FO]5oOJ+w-\u001a=FqB\u0014Xm]:j_:\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!A.\u001a4u+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006Y\u00164G\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001E\u0005)!/[4ii\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!i\u00051Qm]2ba\u0016$\"!\u000e\u001f\u0011\u0005YJdB\u0001\r8\u0013\tA\u0014$\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u001a\u0011\u0015i$\u00071\u00016\u0003\u00051\b\"B \u0001\t\u0003\u0002\u0015aB7bi\u000eDWm\u001d\u000b\u0004\u0003\u0012{\u0005C\u0001\rC\u0013\t\u0019\u0015DA\u0004C_>dW-\u00198\t\u000b\u0015s\u0004\u0019\u0001$\u0002\u000bI,w-\u001a=\u0011\u0005\u001dkU\"\u0001%\u000b\u0005\u0015K%B\u0001&L\u0003\u0011)H/\u001b7\u000b\u00031\u000bAA[1wC&\u0011a\n\u0013\u0002\b!\u0006$H/\u001a:o\u0011\u0015\u0001f\b1\u00016\u0003\r\u0019HO\u001d\u0005\u0006%\u0002!\teU\u0001\ti>\u001cFO]5oOR\tQ\u0007C\u0003V\u0001\u0011Ec+A\u0005e_\u001e+gnQ8eKR\u0019q+\u00182\u0011\u0005a[V\"A-\u000b\u0005i\u0013\u0011aB2pI\u0016<WM\\\u0005\u00039f\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006=R\u0003\raX\u0001\u0004GRD\bC\u0001-a\u0013\t\t\u0017L\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000b\r$\u0006\u0019A,\u0002\u0005\u00154\bbB3\u0001\u0003\u0003%\tAZ\u0001\u0005G>\u0004\u0018\u0010F\u00020O\"Dq!\t3\u0011\u0002\u0003\u00071\u0005C\u0004*IB\u0005\t\u0019A\u0012\t\u000f)\u0004\u0011\u0013!C\u0001W\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00017+\u0005\rj7&\u00018\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018!C;oG\",7m[3e\u0015\t\u0019\u0018$\u0001\u0006b]:|G/\u0019;j_:L!!\u001e9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004x\u0001E\u0005I\u0011A6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!9\u0011\u0010AA\u0001\n\u0003R\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001|!\tax0D\u0001~\u0015\tq8*\u0001\u0003mC:<\u0017B\u0001\u001e~\u0011%\t\u0019\u0001AA\u0001\n\u0003\t)!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\bA\u0019\u0001$!\u0003\n\u0007\u0005-\u0011DA\u0002J]RD\u0011\"a\u0004\u0001\u0003\u0003%\t!!\u0005\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111CA\r!\rA\u0012QC\u0005\u0004\u0003/I\"aA!os\"Q\u00111DA\u0007\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0013\u0007C\u0005\u0002 \u0001\t\t\u0011\"\u0011\u0002\"\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002$A1\u0011QEA\u0016\u0003'i!!a\n\u000b\u0007\u0005%\u0012$\u0001\u0006d_2dWm\u0019;j_:LA!!\f\u0002(\tA\u0011\n^3sCR|'\u000fC\u0005\u00022\u0001\t\t\u0011\"\u0001\u00024\u0005A1-\u00198FcV\fG\u000eF\u0002B\u0003kA!\"a\u0007\u00020\u0005\u0005\t\u0019AA\n\u0011%\tI\u0004AA\u0001\n\u0003\nY$\u0001\u0004fcV\fGn\u001d\u000b\u0004\u0003\u0006u\u0002BCA\u000e\u0003o\t\t\u00111\u0001\u0002\u0014!:\u0001!!\u0011\u0002H\u0005%\u0003cA\t\u0002D%\u0019\u0011Q\t\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111J\u0001LgR\u0014\be\u0018$V\u001d\u000e{\u0006E]3hKb\u0004\b%\f\u0011SKR,(O\\:!iJ,X\rI5gAM$(\u000fI7bi\u000eDWm\u001d\u0011sK\u001e,\u0007\u0010\u001d\u0011b]\u0012\u0004c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0004\n\u0003\u001f\u0012\u0011\u0011!E\u0001\u0003#\nQA\u0015'jW\u0016\u00042!EA*\r!\t!!!A\t\u0002\u0005U3#BA*\u0003/j\u0002cBA-\u0003?\u001a3eL\u0007\u0003\u00037R1!!\u0018\u001a\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u0019\u0002\\\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f5\n\u0019\u0006\"\u0001\u0002fQ\u0011\u0011\u0011\u000b\u0005\n%\u0006M\u0013\u0011!C#\u0003S\"\u0012a\u001f\u0005\u000b\u0003[\n\u0019&!A\u0005\u0002\u0006=\u0014!B1qa2LH#B\u0018\u0002r\u0005M\u0004BB\u0011\u0002l\u0001\u00071\u0005\u0003\u0004*\u0003W\u0002\ra\t\u0005\u000b\u0003o\n\u0019&!A\u0005\u0002\u0006e\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003w\n9\tE\u0003\u0019\u0003{\n\t)C\u0002\u0002\u0000e\u0011aa\u00149uS>t\u0007#\u0002\r\u0002\u0004\u000e\u001a\u0013bAAC3\t1A+\u001e9mKJB\u0011\"!#\u0002v\u0005\u0005\t\u0019A\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002\u000e\u0006M\u0013\u0011!C\u0005\u0003\u001f\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0013\t\u0004y\u0006M\u0015bAAK{\n1qJ\u00196fGR\u0004")
public class RLike
extends BinaryExpression
implements StringRegexExpression,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Pattern org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache;
    private volatile boolean bitmap$0;

    public static Function1<Tuple2<Expression, Expression>, RLike> tupled() {
        return RLike$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RLike>> curried() {
        return RLike$.MODULE$.curried();
    }

    private Pattern org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache$lzycompute() {
        RLike rLike = this;
        synchronized (rLike) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache = StringRegexExpression$class.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache(this);
                this.bitmap$0 = true;
            }
            return this.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache;
        }
    }

    @Override
    public Pattern org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache() {
        return this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache : this.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache$lzycompute();
    }

    @Override
    public DataType dataType() {
        return StringRegexExpression$class.dataType(this);
    }

    @Override
    public Seq<DataType> inputTypes() {
        return StringRegexExpression$class.inputTypes(this);
    }

    @Override
    public Pattern compile(String str) {
        return StringRegexExpression$class.compile(this, str);
    }

    @Override
    public Pattern pattern(String str) {
        return StringRegexExpression$class.pattern(this, str);
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return StringRegexExpression$class.nullSafeEval(this, input1, input2);
    }

    @Override
    public String sql() {
        return StringRegexExpression$class.sql(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return v;
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).find(0);
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " RLIKE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left(), this.right()}));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String pattern = ctx.freshName("pattern");
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal == null) {
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType())})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String regexStr = StringEscapeUtils.escapeJava((String)((UTF8String)rVal).toString());
                ctx.addMutableState(patternClass, pattern, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".compile(\"", "\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern, patternClass, regexStr})));
                ExprCode eval2 = this.left().genCode(ctx);
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).find(0);\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), eval2.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType()), ev.isNull(), ev.value(), pattern, eval2.value()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, patternClass, pattern, rightStr){
                public static final long serialVersionUID = 0L;
                private final ExprCode ev$2;
                private final String patternClass$2;
                private final String pattern$2;
                private final String rightStr$2;

                public final String apply(String eval1, String eval2) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          String ", " = ", ".toString();\n          ", " ", " = ", ".compile(", ");\n          ", " = ", ".matcher(", ".toString()).find(0);\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rightStr$2, eval2, this.patternClass$2, this.pattern$2, this.patternClass$2, this.rightStr$2, this.ev$2.value(), this.pattern$2, eval1}));
                }
                {
                    this.ev$2 = ev$2;
                    this.patternClass$2 = patternClass$2;
                    this.pattern$2 = pattern$2;
                    this.rightStr$2 = rightStr$2;
                }
            });
        }
        return exprCode;
    }

    public RLike copy(Expression left, Expression right) {
        return new RLike(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RLike";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RLike;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RLike)) return false;
        boolean bl = true;
        if (!bl) return false;
        RLike rLike = (RLike)x$1;
        Expression expression = this.left();
        Expression expression2 = rLike.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = rLike.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!rLike.canEqual(this)) return false;
        return true;
    }

    public RLike(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
        StringRegexExpression$class.$init$(this);
    }
}

