/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathString$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns the text contents of the first xml node that matches the xpath expression", extended="> SELECT _FUNC_('<a><b>b</b><c>cc</c></a>','a/c');\ncc")
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001F\u00111\u0002\u0017)bi\"\u001cFO]5oO*\u00111\u0001B\u0001\u0004q6d'BA\u0003\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011b\u0003\b\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011A\u0002\u0017)bi\",\u0005\u0010\u001e:bGR\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t\u0007\u0001\u0011)\u001a!C\u0001AU\t\u0011\u0005\u0005\u0002#G5\tA!\u0003\u0002%\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0019\u0002!\u0011#Q\u0001\n\u0005\nA\u0001_7mA!A\u0001\u0006\u0001BK\u0002\u0013\u0005\u0001%\u0001\u0003qCRD\u0007\u0002\u0003\u0016\u0001\u0005#\u0005\u000b\u0011B\u0011\u0002\u000bA\fG\u000f\u001b\u0011\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\rqs\u0006\r\t\u0003'\u0001AQaA\u0016A\u0002\u0005BQ\u0001K\u0016A\u0002\u0005BQA\r\u0001\u0005BM\n!\u0002\u001d:fiRLh*Y7f+\u0005!\u0004CA\u001b9\u001d\t9b'\u0003\u000281\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9\u0004\u0004C\u0003=\u0001\u0011\u0005S(\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0004CA C\u001b\u0005\u0001%BA!\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0005I\u0001\u0005ECR\fG+\u001f9f\u0011\u0015)\u0005\u0001\"\u0011G\u00031qW\u000f\u001c7TC\u001a,WI^1m)\r9%j\u0013\t\u0003/!K!!\u0013\r\u0003\u0007\u0005s\u0017\u0010C\u0003\u0004\t\u0002\u0007q\tC\u0003)\t\u0002\u0007q\tC\u0004N\u0001\u0005\u0005I\u0011\u0001(\u0002\t\r|\u0007/\u001f\u000b\u0004]=\u0003\u0006bB\u0002M!\u0003\u0005\r!\t\u0005\bQ1\u0003\n\u00111\u0001\"\u0011\u001d\u0011\u0006!%A\u0005\u0002M\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001UU\t\tSkK\u0001W!\t9F,D\u0001Y\u0015\tI&,A\u0005v]\u000eDWmY6fI*\u00111\fG\u0001\u000bC:tw\u000e^1uS>t\u0017BA/Y\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b?\u0002\t\n\u0011\"\u0001T\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBq!\u0019\u0001\u0002\u0002\u0013\u0005#-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002GB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0005Y\u0006twMC\u0001i\u0003\u0011Q\u0017M^1\n\u0005e*\u0007bB6\u0001\u0003\u0003%\t\u0001\\\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002[B\u0011qC\\\u0005\u0003_b\u00111!\u00138u\u0011\u001d\t\b!!A\u0005\u0002I\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002Hg\"9A\u000f]A\u0001\u0002\u0004i\u0017a\u0001=%c!9a\u000fAA\u0001\n\u0003:\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003a\u00042!\u001f?H\u001b\u0005Q(BA>\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{j\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\t\u007f\u0002\t\t\u0011\"\u0001\u0002\u0002\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0004\u0005%\u0001cA\f\u0002\u0006%\u0019\u0011q\u0001\r\u0003\u000f\t{w\u000e\\3b]\"9AO`A\u0001\u0002\u00049\u0005\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u0003\u0019)\u0017/^1mgR!\u00111AA\t\u0011!!\u00181BA\u0001\u0002\u00049\u0005f\u0003\u0001\u0002\u0016\u0005m\u0011QDA\u0011\u0003G\u00012AIA\f\u0013\r\tI\u0002\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty\"\u00014`\rVs5i\u0018\u0015y[2d\u0003\u0005\u001f9bi\"L\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005^3yi\u0002\u001awN\u001c;f]R\u001c\be\u001c4!i\",\u0007EZ5sgR\u0004\u00030\u001c7!]>$W\r\t;iCR\u0004S.\u0019;dQ\u0016\u001c\b\u0005\u001e5fAa\u0004\u0018\r\u001e5!Kb\u0004(/Z:tS>t\u0017\u0001C3yi\u0016tG-\u001a3\"\u0005\u0005\u0015\u0012!\u000e !'\u0016cUi\u0011+!?\u001a+fjQ0)Oq\ng\b\u00102?Erz#M\u0010\u001fd}\r\u001cGhL2?y=\ngh\n\u0017(C>\u001aw%K\u001e\u000bG\u000e<\u0011\"!\u000b\u0003\u0003\u0003E\t!a\u000b\u0002\u0017a\u0003\u0016\r\u001e5TiJLgn\u001a\t\u0004'\u00055b\u0001C\u0001\u0003\u0003\u0003E\t!a\f\u0014\u000b\u00055\u0012\u0011\u0007\u000f\u0011\u000f\u0005M\u0012\u0011H\u0011\"]5\u0011\u0011Q\u0007\u0006\u0004\u0003oA\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003w\t)DA\tBEN$(/Y2u\rVt7\r^5p]JBq\u0001LA\u0017\t\u0003\ty\u0004\u0006\u0002\u0002,!Q\u00111IA\u0017\u0003\u0003%)%!\u0012\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0019\u0005\u000b\u0003\u0013\ni#!A\u0005\u0002\u0006-\u0013!B1qa2LH#\u0002\u0018\u0002N\u0005=\u0003BB\u0002\u0002H\u0001\u0007\u0011\u0005\u0003\u0004)\u0003\u000f\u0002\r!\t\u0005\u000b\u0003'\ni#!A\u0005\u0002\u0006U\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003/\n\u0019\u0007E\u0003\u0018\u00033\ni&C\u0002\u0002\\a\u0011aa\u00149uS>t\u0007#B\f\u0002`\u0005\n\u0013bAA11\t1A+\u001e9mKJB\u0011\"!\u001a\u0002R\u0005\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002j\u00055\u0012\u0011!C\u0005\u0003W\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u000e\t\u0004I\u0006=\u0014bAA9K\n1qJ\u00196fGR\u0004")
public class XPathString
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Function1<Tuple2<Expression, Expression>, XPathString> tupled() {
        return XPathString$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathString>> curried() {
        return XPathString$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_string";
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        String ret = this.xpathUtil().evalString(((UTF8String)xml).toString(), this.pathString());
        return UTF8String.fromString((String)ret);
    }

    public XPathString copy(Expression xml, Expression path) {
        return new XPathString(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathString";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.path();
                break;
            }
            case 0: {
                expression = this.xml();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathString)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathString xPathString = (XPathString)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathString.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathString.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathString.canEqual(this)) return false;
        return true;
    }

    public XPathString(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

