/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathList$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.w3c.dom.NodeList;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a string array of values within xml nodes that match the xpath expression", extended="> SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>','a/b/text()');\n['b1','b2','b3']")
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001F\u0011\u0011\u0002\u0017)bi\"d\u0015n\u001d;\u000b\u0005\r!\u0011a\u0001=nY*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%Ya\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00051A\u0006+\u0019;i\u000bb$(/Y2u!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u001d\u0001&o\u001c3vGR\u0004\"aF\u000f\n\u0005yA\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0002\u0001\u0005+\u0007I\u0011\u0001\u0011\u0016\u0003\u0005\u0002\"AI\u0012\u000e\u0003\u0011I!\u0001\n\u0003\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005'\u0001\tE\t\u0015!\u0003\"\u0003\u0011AX\u000e\u001c\u0011\t\u0011!\u0002!Q3A\u0005\u0002\u0001\nA\u0001]1uQ\"A!\u0006\u0001B\tB\u0003%\u0011%A\u0003qCRD\u0007\u0005C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004CA\n\u0001\u0011\u0015\u00191\u00061\u0001\"\u0011\u0015A3\u00061\u0001\"\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002iA\u0011Q\u0007\u000f\b\u0003/YJ!a\u000e\r\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003oaAQ\u0001\u0010\u0001\u0005Bu\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tC\u0001\u0006if\u0004Xm]\u0005\u0003\u0007\u0002\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006\u000b\u0002!\tER\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004\u000f*[\u0005CA\fI\u0013\tI\u0005DA\u0002B]fDQa\u0001#A\u0002\u001dCQ\u0001\u000b#A\u0002\u001dCq!\u0014\u0001\u0002\u0002\u0013\u0005a*\u0001\u0003d_BLHc\u0001\u0018P!\"91\u0001\u0014I\u0001\u0002\u0004\t\u0003b\u0002\u0015M!\u0003\u0005\r!\t\u0005\b%\u0002\t\n\u0011\"\u0001T\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u0016\u0016\u0003CU[\u0013A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005mC\u0012AC1o]>$\u0018\r^5p]&\u0011Q\f\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB0\u0001#\u0003%\taU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001d\t\u0007!!A\u0005B\t\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017\u0001\u00027b]\u001eT\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002:K\"91\u000eAA\u0001\n\u0003a\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A7\u0011\u0005]q\u0017BA8\u0019\u0005\rIe\u000e\u001e\u0005\bc\u0002\t\t\u0011\"\u0001s\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"aR:\t\u000fQ\u0004\u0018\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\t\u000fY\u0004\u0011\u0011!C!o\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001y!\rIHpR\u0007\u0002u*\u00111\u0010G\u0001\u000bG>dG.Z2uS>t\u0017BA?{\u0005!IE/\u001a:bi>\u0014\b\u0002C@\u0001\u0003\u0003%\t!!\u0001\u0002\u0011\r\fg.R9vC2$B!a\u0001\u0002\nA\u0019q#!\u0002\n\u0007\u0005\u001d\u0001DA\u0004C_>dW-\u00198\t\u000fQt\u0018\u0011!a\u0001\u000f\"I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0013qB\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0011\u0011\u0003\u0005\ti\u0006-\u0011\u0011!a\u0001\u000f\"Z\u0001!!\u0006\u0002\u001c\u0005u\u0011\u0011EA\u0012!\r\u0011\u0013qC\u0005\u0004\u00033!!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003?\tam\u0018$V\u001d\u000e{\u0006\u0006_7mY\u0001B\b/\u0019;iS\u0001j\u0003EU3ukJt7\u000fI1!gR\u0014\u0018N\\4!CJ\u0014\u0018-\u001f\u0011pM\u00022\u0018\r\\;fg\u0002:\u0018\u000e\u001e5j]\u0002BX\u000e\u001c\u0011o_\u0012,7\u000f\t;iCR\u0004S.\u0019;dQ\u0002\"\b.\u001a\u0011ya\u0006$\b\u000eI3yaJ,7o]5p]\u0006AQ\r\u001f;f]\u0012,G-\t\u0002\u0002&\u00051g\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014=Czb$M\u001022y=\u0012g\b\u00102?EJbtF\u0019 =Ez\u00127\u0007P\u0018c}q\u001aghY\u0019=_\rtDh\u0019 deqz3M\u0010\u001f0Cz:CfJ10E>\"X\r\u001f;)S\u001dJ3HC.(EF:Cf\n23O1:#mM\u0014^\u000f%\tICAA\u0001\u0012\u0003\tY#A\u0005Y!\u0006$\b\u000eT5tiB\u00191#!\f\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003_\u0019R!!\f\u00022q\u0001r!a\r\u0002:\u0005\nc&\u0004\u0002\u00026)\u0019\u0011q\u0007\r\u0002\u000fI,h\u000e^5nK&!\u00111HA\u001b\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bY\u00055B\u0011AA )\t\tY\u0003\u0003\u0006\u0002D\u00055\u0012\u0011!C#\u0003\u000b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002G\"Q\u0011\u0011JA\u0017\u0003\u0003%\t)a\u0013\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b9\ni%a\u0014\t\r\r\t9\u00051\u0001\"\u0011\u0019A\u0013q\ta\u0001C!Q\u00111KA\u0017\u0003\u0003%\t)!\u0016\u0002\u000fUt\u0017\r\u001d9msR!\u0011qKA2!\u00159\u0012\u0011LA/\u0013\r\tY\u0006\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b]\ty&I\u0011\n\u0007\u0005\u0005\u0004D\u0001\u0004UkBdWM\r\u0005\n\u0003K\n\t&!AA\u00029\n1\u0001\u001f\u00131\u0011)\tI'!\f\u0002\u0002\u0013%\u00111N\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002nA\u0019A-a\u001c\n\u0007\u0005ETM\u0001\u0004PE*,7\r\u001e")
public class XPathList
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Function1<Tuple2<Expression, Expression>, XPathList> tupled() {
        return XPathList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathList>> curried() {
        return XPathList$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath";
    }

    @Override
    public DataType dataType() {
        return new ArrayType(StringType$.MODULE$, false);
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        GenericArrayData genericArrayData;
        NodeList nodeList = this.xpathUtil().evalNodeList(((UTF8String)xml).toString(), this.pathString());
        if (nodeList != null) {
            UTF8String[] ret = new UTF8String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ret[i] = UTF8String.fromString((String)nodeList.item(i).getNodeValue());
            }
            genericArrayData = new GenericArrayData((Object)ret);
        } else {
            genericArrayData = null;
        }
        return genericArrayData;
    }

    public XPathList copy(Expression xml, Expression path) {
        return new XPathList(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathList";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.path();
                break;
            }
            case 0: {
                expression = this.xml();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathList)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathList xPathList = (XPathList)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathList.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathList.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathList.canEqual(this)) return false;
        return true;
    }

    public XPathList(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

