/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.nio.ByteBuffer;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate percentile value of numeric\n      column `col` at the given percentage. The value of percentage must be between 0.0\n      and 1.0. The `accuracy` parameter (default: 10000) is a positive numeric literal which\n      controls approximation accuracy at the cost of memory. Higher value of `accuracy` yields\n      better accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", extended="\n    Examples:\n      > SELECT percentile_approx(10.0, array(0.5, 0.4, 0.1), 100);\n       [10.0,10.0,10.0]\n      > SELECT percentile_approx(10.0, 0.5, 100);\n       10.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001B\u0001\u0003\u0001F\u0011Q#\u00119qe>D\u0018.\\1uKB+'oY3oi&dWM\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0001C\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M)\u0001AEAPiA\u00191\u0003\u0006\f\u000e\u0003\tI!!\u0006\u0002\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002\u0018\u0005:\u0011\u0001$\u000b\b\u00033!r!AG\u0014\u000f\u0005m1cB\u0001\u000f&\u001d\tiBE\u0004\u0002\u001fG9\u0011qDI\u0007\u0002A)\u0011\u0011\u0005E\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0004\u0006U\tA\taK\u0001\u0016\u0003B\u0004(o\u001c=j[\u0006$X\rU3sG\u0016tG/\u001b7f!\t\u0019BFB\u0003\u0002\u0005!\u0005QfE\u0002-]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u00186\u0013\t1\u0004G\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u00039Y\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\u0002W!91\b\fb\u0001\n\u0003a\u0014a\u0007#F\r\u0006+F\nV0Q\u000bJ\u001bUI\u0014+J\u0019\u0016{\u0016iQ\"V%\u0006\u001b\u0015,F\u0001>!\tyc(\u0003\u0002@a\t\u0019\u0011J\u001c;\t\r\u0005c\u0003\u0015!\u0003>\u0003q!UIR!V\u0019R{\u0006+\u0012*D\u000b:#\u0016\nT#`\u0003\u000e\u001bUKU!D3\u00022Aa\u0011\u0017\u0001\t\n\u0001\u0002+\u001a:dK:$\u0018\u000e\\3ES\u001e,7\u000f^\n\u0003\u0005:B\u0001B\u0012\"\u0003\u0002\u0004%IaR\u0001\ngVlW.\u0019:jKN,\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\u001a\tA!\u001e;jY&\u0011QJ\u0013\u0002\u0012#V\fg\u000e^5mKN+X.\\1sS\u0016\u001c\b\u0002C(C\u0005\u0003\u0007I\u0011\u0002)\u0002\u001bM,X.\\1sS\u0016\u001cx\fJ3r)\t\tF\u000b\u0005\u00020%&\u00111\u000b\r\u0002\u0005+:LG\u000fC\u0004V\u001d\u0006\u0005\t\u0019\u0001%\u0002\u0007a$\u0013\u0007\u0003\u0005X\u0005\n\u0005\t\u0015)\u0003I\u0003)\u0019X/\\7be&,7\u000f\t\u0005\t3\n\u0013\t\u0019!C\u00055\u0006a\u0011n]\"p[B\u0014Xm]:fIV\t1\f\u0005\u000209&\u0011Q\f\r\u0002\b\u0005>|G.Z1o\u0011!y&I!a\u0001\n\u0013\u0001\u0017\u0001E5t\u0007>l\u0007O]3tg\u0016$w\fJ3r)\t\t\u0016\rC\u0004V=\u0006\u0005\t\u0019A.\t\u0011\r\u0014%\u0011!Q!\nm\u000bQ\"[:D_6\u0004(/Z:tK\u0012\u0004\u0003\"\u0002\u001dC\t\u0003)Gc\u00014iSB\u0011qMQ\u0007\u0002Y!)a\t\u001aa\u0001\u0011\")\u0011\f\u001aa\u00017\"11N\u0011Q\u0001\u000eu\nQdY8naJ,7o\u001d+ie\u0016\u001c\bj\u001c7e\u0005V4g-\u001a:MK:<G\u000f\u001b\u0005\u0006q\t#\t!\u001c\u000b\u0003M:DQa\u001c7A\u0002A\fQB]3mCRLg/Z#se>\u0014\bCA\u0018r\u0013\t\u0011\bG\u0001\u0004E_V\u0014G.\u001a\u0005\u0006i\n#\taR\u0001\u0012cV\fg\u000e^5mKN+X.\\1sS\u0016\u001c\b\"\u0002<C\t\u00039\u0018aA1eIR\u0011\u0011\u000b\u001f\u0005\u0006sV\u0004\r\u0001]\u0001\u0006m\u0006dW/\u001a\u0005\u0006w\n#\t\u0001`\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0003#vDQA >A\u0002\u0019\fQa\u001c;iKJDq!!\u0001C\t\u0003\t\u0019!\u0001\bhKR\u0004VM]2f]RLG.Z:\u0015\t\u0005\u0015\u00111\u0002\t\u0005_\u0005\u001d\u0001/C\u0002\u0002\nA\u0012Q!\u0011:sCfDq!!\u0004\u0000\u0001\u0004\t)!A\u0006qKJ\u001cWM\u001c;bO\u0016\u001c\bbBA\t\u0005\u00125\u00111C\u0001\tG>l\u0007O]3tgR\t\u0011K\u0002\u0004\u0002\u00181\u0002\u0011\u0011\u0004\u0002\u001b!\u0016\u00148-\u001a8uS2,G)[4fgR\u001cVM]5bY&TXM]\n\u0004\u0003+q\u0003b\u0002\u001d\u0002\u0016\u0011\u0005\u0011Q\u0004\u000b\u0003\u0003?\u00012aZA\u000b\u0011!\t\u0019#!\u0006\u0005\u000e\u0005\u0015\u0012A\u00027f]\u001e$\b\u000eF\u0002>\u0003OAaARA\u0011\u0001\u0004A\u0005\u0002CA\u0016\u0003+!)!!\f\u0002\u0013M,'/[1mSj,G\u0003BA\u0018\u0003o\u0001RaLA\u0004\u0003c\u00012aLA\u001a\u0013\r\t)\u0004\r\u0002\u0005\u0005f$X\rC\u0004\u0002:\u0005%\u0002\u0019\u00014\u0002\u0007=\u0014'\u000e\u0003\u0005\u0002>\u0005UAQAA \u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007\u0019\f\t\u0005\u0003\u0005\u0002D\u0005m\u0002\u0019AA\u0018\u0003\u0015\u0011\u0017\u0010^3t\u0011%\t9\u0005\fb\u0001\n\u0003\tI%\u0001\u0006tKJL\u0017\r\\5{KJ,\"!a\b\t\u0011\u00055C\u0006)A\u0005\u0003?\t1b]3sS\u0006d\u0017N_3sA!I\u0011\u0011\u000b\u0017\u0002\u0002\u0013\u0005\u00151K\u0001\u0006CB\u0004H.\u001f\u000b\r\u0003+\n9&a\u0019\u0002h\u0005-\u0014q\u000e\t\u0003'\u0001A\u0001\"!\u0017\u0002P\u0001\u0007\u00111L\u0001\u0006G\"LG\u000e\u001a\t\u0005\u0003;\ny&D\u0001\u0005\u0013\r\t\t\u0007\u0002\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002CA3\u0003\u001f\u0002\r!a\u0017\u0002)A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8o\u0011!\tI'a\u0014A\u0002\u0005m\u0013AE1dGV\u0014\u0018mY=FqB\u0014Xm]:j_:Dq!!\u001c\u0002P\u0001\u0007Q(\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u001d\t\t(a\u0014A\u0002u\nA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b\"CA;Y\u0005\u0005I\u0011QA<\u0003\u001d)h.\u00199qYf$B!!\u001f\u0002\u0006B)q&a\u001f\u0002\u0000%\u0019\u0011Q\u0010\u0019\u0003\r=\u0003H/[8o!-y\u0013\u0011QA.\u00037\nY&P\u001f\n\u0007\u0005\r\u0005G\u0001\u0004UkBdW-\u000e\u0005\u000b\u0003\u000f\u000b\u0019(!AA\u0002\u0005U\u0013a\u0001=%a!I\u00111\u0012\u0017\u0002\u0002\u0013%\u0011QR\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0010B!\u0011\u0011SAN\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u00027b]\u001eT!!!'\u0002\t)\fg/Y\u0005\u0005\u0003;\u000b\u0019J\u0001\u0004PE*,7\r\u001e\t\u0004_\u0005\u0005\u0016bAARa\t9\u0001K]8ek\u000e$\bBCA-\u0001\tU\r\u0011\"\u0001\u0002(V\u0011\u00111\f\u0005\u000b\u0003W\u0003!\u0011#Q\u0001\n\u0005m\u0013AB2iS2$\u0007\u0005\u0003\u0006\u0002f\u0001\u0011)\u001a!C\u0001\u0003OC!\"!-\u0001\u0005#\u0005\u000b\u0011BA.\u0003U\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\u0002B!\"!\u001b\u0001\u0005+\u0007I\u0011AAT\u0011)\t9\f\u0001B\tB\u0003%\u00111L\u0001\u0014C\u000e\u001cWO]1ds\u0016C\bO]3tg&|g\u000e\t\u0005\n\u0003[\u0002!Q3A\u0005BqB\u0011\"!0\u0001\u0005#\u0005\u000b\u0011B\u001f\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0003\"CA9\u0001\tU\r\u0011\"\u0011=\u0011%\t\u0019\r\u0001B\tB\u0003%Q(A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\t\ra\u0002A\u0011AAd)1\t)&!3\u0002L\u00065\u0017qZAi\u0011!\tI&!2A\u0002\u0005m\u0003\u0002CA3\u0003\u000b\u0004\r!a\u0017\t\u0011\u0005%\u0014Q\u0019a\u0001\u00037Bq!!\u001c\u0002F\u0002\u0007Q\bC\u0004\u0002r\u0005\u0015\u0007\u0019A\u001f\t\ra\u0002A\u0011AAk)!\t)&a6\u0002Z\u0006m\u0007\u0002CA-\u0003'\u0004\r!a\u0017\t\u0011\u0005\u0015\u00141\u001ba\u0001\u00037B\u0001\"!\u001b\u0002T\u0002\u0007\u00111\f\u0005\u0007q\u0001!\t!a8\u0015\r\u0005U\u0013\u0011]Ar\u0011!\tI&!8A\u0002\u0005m\u0003\u0002CA3\u0003;\u0004\r!a\u0017\t\u0013\u0005\u001d\b\u0001#b\u0001\n\u0013a\u0014\u0001C1dGV\u0014\u0018mY=\t\u0013\u0005-\b\u0001#A!B\u0013i\u0014!C1dGV\u0014\u0018mY=!\u0011\u001d\ty\u000f\u0001C!\u0003c\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\u0019\u0010\u0005\u0004\u0002v\u0006}(Q\u0001\b\u0005\u0003o\fYPD\u0002 \u0003sL\u0011!M\u0005\u0004\u0003{\u0004\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005\u0003\u0011\u0019AA\u0002TKFT1!!@1!\u0011\u00119A!\u0004\u000e\u0005\t%!b\u0001B\u0006\u0011\u0005)A/\u001f9fg&!!q\u0002B\u0005\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0005V\u0001!\u001d\r\u0015\"\u0003\u0003\u0014U\u0011!Q\u0003\t\u0007_\t]1,!\u0002\n\u0007\te\u0001G\u0001\u0004UkBdWM\r\u0005\u000b\u0005;\u0001\u0001\u0012!Q!\n\tU\u0011\u0001\u0002=%c\u0001B\u0011B!\t\u0001\u0011\u000b\u0007I\u0011\u0002.\u0002+I,G/\u001e:o!\u0016\u00148-\u001a8uS2,\u0017I\u001d:bs\"I!Q\u0005\u0001\t\u0002\u0003\u0006KaW\u0001\u0017e\u0016$XO\u001d8QKJ\u001cWM\u001c;jY\u0016\f%O]1zA!Q\u0011Q\u0002\u0001\t\u0006\u0004%IA!\u000b\u0016\u0005\u0005\u0015\u0001B\u0003B\u0017\u0001!\u0005\t\u0015)\u0003\u0002\u0006\u0005a\u0001/\u001a:dK:$\u0018mZ3tA!9!\u0011\u0007\u0001\u0005B\tM\u0012aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHC\u0001B\u001b!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001e\r\u0005A\u0011M\\1msNL7/\u0003\u0003\u0003@\te\"a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000f\t\r\u0003\u0001\"\u0011\u0003F\u000592M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002-!9!\u0011\n\u0001\u0005B\t-\u0013AB;qI\u0006$X\rF\u0003R\u0005\u001b\u0012\t\u0006C\u0004\u0003P\t\u001d\u0003\u0019\u0001\f\u0002\r\t,hMZ3s\u0011!\u0011\u0019Fa\u0012A\u0002\tU\u0013\u0001C5oaV$(k\\<\u0011\t\t]#\u0011L\u0007\u0002\r%\u0019!1\f\u0004\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0007w\u0002!\tEa\u0018\u0015\u000bE\u0013\tGa\u0019\t\u000f\t=#Q\fa\u0001-!1aP!\u0018A\u0002YAqAa\u001a\u0001\t\u0003\u0012I'\u0001\u0003fm\u0006dG\u0003\u0002B6\u0005c\u00022a\fB7\u0013\r\u0011y\u0007\r\u0002\u0004\u0003:L\bb\u0002B(\u0005K\u0002\rA\u0006\u0005\b\u0005k\u0002A\u0011\tB<\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BA+\u0005sBqAa\u001f\u0003t\u0001\u0007Q(A\u0005oK^|eMZ:fi\"9!q\u0010\u0001\u0005B\t\u0005\u0015aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002V\t\r\u0005b\u0002B>\u0005{\u0002\r!\u0010\u0005\b\u0005\u000f\u0003A\u0011\tBE\u0003!\u0019\u0007.\u001b7ee\u0016tWC\u0001BF!\u0019\t)0a@\u0002\\!1!q\u0012\u0001\u0005Bi\u000b\u0001B\\;mY\u0006\u0014G.\u001a\u0005\b\u0005'\u0003A\u0011\tBK\u0003!!\u0017\r^1UsB,WC\u0001BL!\u0011\u00119A!'\n\t\tm%\u0011\u0002\u0002\t\t\u0006$\u0018\rV=qK\"9!q\u0014\u0001\u0005B\t\u0005\u0016A\u00039sKR$\u0018PT1nKV\u0011!1\u0015\t\u0005\u0005K\u0013YKD\u00020\u0005OK1A!+1\u0003\u0019\u0001&/\u001a3fM&!!Q\u0016BX\u0005\u0019\u0019FO]5oO*\u0019!\u0011\u0016\u0019\t\u000f\u0005-\u0002\u0001\"\u0011\u00034R!\u0011q\u0006B[\u0011\u001d\tID!-A\u0002YAq!!\u0010\u0001\t\u0003\u0012I\fF\u0002\u0017\u0005wC\u0001\"a\u0011\u00038\u0002\u0007\u0011q\u0006\u0005\n\u0005\u007f\u0003\u0011\u0011!C\u0001\u0005\u0003\fAaY8qsRa\u0011Q\u000bBb\u0005\u000b\u00149M!3\u0003L\"Q\u0011\u0011\fB_!\u0003\u0005\r!a\u0017\t\u0015\u0005\u0015$Q\u0018I\u0001\u0002\u0004\tY\u0006\u0003\u0006\u0002j\tu\u0006\u0013!a\u0001\u00037B\u0011\"!\u001c\u0003>B\u0005\t\u0019A\u001f\t\u0013\u0005E$Q\u0018I\u0001\u0002\u0004i\u0004\"\u0003Bh\u0001E\u0005I\u0011\u0001Bi\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa5+\t\u0005m#Q[\u0016\u0003\u0005/\u0004BA!7\u0003d6\u0011!1\u001c\u0006\u0005\u0005;\u0014y.A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u001d\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003f\nm'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\u001e\u0001\u0012\u0002\u0013\u0005!\u0011[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\u0011i\u000fAI\u0001\n\u0003\u0011\t.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\tE\b!%A\u0005\u0002\tM\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005kT3!\u0010Bk\u0011%\u0011I\u0010AI\u0001\n\u0003\u0011\u00190\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\t\u0013\tu\b!!A\u0005B\t}\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0004\u0002A!\u0011\u0011SB\u0002\u0013\u0011\u0011i+a%\t\u0011\r\u001d\u0001!!A\u0005\u0002q\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011ba\u0003\u0001\u0003\u0003%\ta!\u0004\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1NB\b\u0011!)6\u0011BA\u0001\u0002\u0004i\u0004\"CB\n\u0001\u0005\u0005I\u0011IB\u000b\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\f!\u0019\u0019Iba\b\u0003l5\u001111\u0004\u0006\u0004\u0007;\u0001\u0014AC2pY2,7\r^5p]&!1\u0011EB\u000e\u0005!IE/\u001a:bi>\u0014\b\"CB\u0013\u0001\u0005\u0005I\u0011AB\u0014\u0003!\u0019\u0017M\\#rk\u0006dGcA.\u0004*!IQka\t\u0002\u0002\u0003\u0007!1\u000e\u0005\n\u0007[\u0001\u0011\u0011!C!\u0007_\ta!Z9vC2\u001cHcA.\u00042!IQka\u000b\u0002\u0002\u0003\u0007!1\u000e\u0015\f\u0001\rU21HB\u001f\u0007\u0003\u001a\u0019\u0005\u0005\u0003\u0002^\r]\u0012bAB\u001d\t\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAB \u0003\u0015}\"\u0002\t\u0011!A}3UKT\"`Q\r|G\u000e\f\u0011qKJ\u001cWM\u001c;bO\u0016\u00043\f\f\u0011bG\u000e,(/Y2z;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013\r\u001d9s_bLW.\u0019;fAA,'oY3oi&dW\r\t<bYV,\u0007e\u001c4!]VlWM]5d\u0015\u0001\u0002\u0003\u0005\t\u0011!G>dW/\u001c8!A\u000e|G\u000e\u0019\u0011bi\u0002\"\b.\u001a\u0011hSZ,g\u000e\t9fe\u000e,g\u000e^1hK:\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u0002\u0002XM]2f]R\fw-\u001a\u0011nkN$\bEY3!E\u0016$x/Z3oAAr\u0003G\u0003\u0011!A\u0001\u0002\u0003%\u00198eAEr\u0003G\f\u0011UQ\u0016\u0004\u0003-Y2dkJ\f7-\u001f1!a\u0006\u0014\u0018-\\3uKJ\u0004\u0003\u0006Z3gCVdGO\u000f\u00112aA\u0002\u0004'\u000b\u0011jg\u0002\n\u0007\u0005]8tSRLg/\u001a\u0011ok6,'/[2!Y&$XM]1mA]D\u0017n\u00195\u000bA\u0001\u0002\u0003\u0005\t\u0011d_:$(o\u001c7tA\u0005\u0004\bO]8yS6\fG/[8oA\u0005\u001c7-\u001e:bGf\u0004\u0013\r\u001e\u0011uQ\u0016\u00043m\\:uA=4\u0007%\\3n_JLh\u0006\t%jO\",'\u000f\t<bYV,\u0007e\u001c4!A\u0006\u001c7-\u001e:bGf\u0004\u0007%_5fY\u0012\u001c(\u0002\t\u0011!A\u0001\u0002#-\u001a;uKJ\u0004\u0013mY2ve\u0006\u001c\u0017\u0010\f\u0011ac9\u0002t&Y2dkJ\f7-\u001f1!SN\u0004C\u000f[3!e\u0016d\u0017\r^5wK\u0002*'O]8sA=4\u0007\u0005\u001e5fA\u0005\u0004\bO]8yS6\fG/[8o])\u0001\u0003\u0005\t\u0011!A]CWM\u001c\u0011aa\u0016\u00148-\u001a8uC\u001e,\u0007\rI5tA\u0005t\u0007%\u0019:sCfd\u0003%Z1dQ\u00022\u0018\r\\;fA=4\u0007\u0005\u001e5fAA,'oY3oi\u0006<W\rI1se\u0006L\b%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002dF\u0003\u0011!A\u0001\u0002\u0003%\u00138!i\"L7\u000fI2bg\u0016d\u0003E]3ukJt7\u000f\t;iK\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^3!a\u0016\u00148-\u001a8uS2,\u0007%\u0019:sCf\u0004sN\u001a\u0011d_2,XN\u001c\u0011aG>d\u0007\rI1uAQDW\rI4jm\u0016t'\u0002\t\u0011!A\u0001\u0002\u0003/\u001a:dK:$\u0018mZ3!CJ\u0014\u0018-\u001f\u0018\u000bA\u0001\n\u0001\"\u001a=uK:$W\rZ\u0011\u0003\u0007\u000b\n\u0011Q\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!a\u0016\u00148-\u001a8uS2,w,\u00199qe>D\b&\r\u0019/a1\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9\"D\u0006\t\u0019/c%b\u0003%\r\u00191SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u0019/a1\n\u0004G\f\u0019-cAr\u0003'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!a\u0016\u00148-\u001a8uS2,w,\u00199qe>D\b&\r\u0019/a1\u0002\u0003GL\u001b-AE\u0002\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cAr\u0003G\u0003\u0011!\u0001")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements Product,
Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private int accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private volatile byte bitmap$0;

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    private int accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = BoxesRunTime.unboxToInt((Object)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.accuracy;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Object num;
                Tuple2 tuple23 = new Tuple2((Object)this.percentageExpression().dataType(), this.percentageExpression().eval(this.percentageExpression().eval$default$1()));
                if (tuple23 != null && (num = tuple23._2()) instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)num);
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else {
                    ArrayType arrayType2;
                    DataType baseType;
                    if (tuple23 == null) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple23._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    DataType dataType2 = (DataType)tuple23._1();
                    Object arrayData = tuple23._2();
                    if (!(dataType2 instanceof ArrayType) || !((baseType = (arrayType2 = (ArrayType)dataType2).elementType()) instanceof NumericType)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple23._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    NumericType numericType = (NumericType)baseType;
                    if (!(arrayData instanceof ArrayData)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple23._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    ArrayData arrayData2 = (ArrayData)arrayData;
                    Object[] numericArray = arrayData2.toObjectArray(numericType);
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), Predef$.MODULE$.refArrayOps(numericArray).map((Function1)new $anonfun$1(this, numericType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                }
                Tuple2 tuple24 = tuple22;
                if (tuple24 == null) throw new MatchError((Object)tuple24);
                boolean returnPercentileArray = tuple24._1$mcZ$sp();
                double[] percentages2 = (double[])tuple24._2();
                boolean bl = returnPercentileArray;
                if (percentages2 == null) throw new MatchError((Object)tuple24);
                double[] dArray = percentages2;
                this.x$1 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)dArray);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.x$1;
        }
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.returnPercentileArray;
        }
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.percentages;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private int accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, ArrayType$.MODULE$})), IntegerType$.MODULE$}));
    }

    private Tuple2<Object, double[]> x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.percentageExpression().foldable() && this.accuracyExpression().foldable() ? (this.accuracy() <= 0 ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The accuracy provided must be a positive integer literal (current value = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.accuracy())}))) : (Predef$.MODULE$.doubleArrayOps(this.percentages()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double percentage) {
                return this.apply$mcZD$sp(percentage);
            }

            public boolean apply$mcZD$sp(double percentage) {
                return percentage < 0.0 || percentage > 1.0;
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All percentage values must be between 0.0 and 1.0 "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(current = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.doubleArrayOps(this.percentages()).mkString(", ")}))).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)) : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The accuracy or percentage provided must be a constant literal"})).s((Seq)Nil$.MODULE$)));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public void update(PercentileDigest buffer, InternalRow inputRow) {
        Object value2 = this.child().eval(inputRow);
        if (value2 != null) {
            buffer.add(BoxesRunTime.unboxToDouble((Object)value2));
        }
    }

    @Override
    public void merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        double[] result = buffer.getPercentiles(this.percentages());
        return result.length == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : BoxesRunTime.boxToDouble((double)result[0]));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$2 = newOffset;
        Expression x$3 = this.copy$default$1();
        Expression x$4 = this.copy$default$2();
        Expression x$5 = this.copy$default$3();
        int x$6 = this.copy$default$5();
        return this.copy(x$3, x$4, x$5, x$2, x$6);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$7 = newOffset;
        Expression x$8 = this.copy$default$1();
        Expression x$9 = this.copy$default$2();
        Expression x$10 = this.copy$default$3();
        int x$11 = this.copy$default$4();
        return this.copy(x$8, x$9, x$10, x$11, x$7);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.percentageExpression(), this.accuracyExpression()}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.returnPercentileArray() ? ArrayType$.MODULE$.apply(DoubleType$.MODULE$) : DoubleType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "percentile_approx";
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;
        private boolean isCompressed;
        private final int compressThresHoldBufferLength;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        private boolean isCompressed() {
            return this.isCompressed;
        }

        private void isCompressed_$eq(boolean x$1) {
            this.isCompressed = x$1;
        }

        public QuantileSummaries quantileSummaries() {
            if (!this.isCompressed()) {
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value2) {
            this.summaries_$eq(this.summaries().insert(value2));
            this.isCompressed_$eq(false);
            if (this.summaries().sampled().length >= this.compressThresHoldBufferLength) {
                this.compress();
            }
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages2) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages2.length == 0) {
                dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            } else {
                void var2_2;
                double[] result = new double[percentages2.length];
                for (int i = 0; i < percentages2.length; ++i) {
                    result[i] = this.summaries().query(percentages2[i]);
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
            this.isCompressed_$eq(true);
        }

        public PercentileDigest(QuantileSummaries summaries, boolean isCompressed) {
            this.summaries = summaries;
            this.isCompressed = isCompressed;
            int maxBufferLengthAfterCompression = (int)(1.0 / this.summaries().relativeError()) * 2;
            this.compressThresHoldBufferLength = maxBufferLengthAfterCompression * 2;
        }

        public PercentileDigest(double relativeError) {
            this(new QuantileSummaries(QuantileSummaries$.MODULE$.defaultCompressThreshold(), relativeError, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4()), true);
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 16;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putInt(stat.g());
                buffer.putInt(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value2 = buffer.getDouble();
                int g = buffer.getInt();
                int delta = buffer.getInt();
                sampled[i] = new QuantileSummaries.Stats(value2, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count);
            return new PercentileDigest(summary, true);
        }
    }
}

