/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage) - Returns the exact percentile value of numeric column `col` at the\n      given percentage. The value of percentage must be between 0.0 and 1.0.\n\n      _FUNC_(col, array(percentage1 [, percentage2]...)) - Returns the exact percentile value array\n      of numeric column `col` at the given percentage(s). Each value of the percentage array must\n      be between 0.0 and 1.0.\n    ")
@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u0001\u0003\u0001F\u0011!\u0002U3sG\u0016tG/\u001b7f\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%1z\u0003cA\n\u0015-5\t!!\u0003\u0002\u0016\u0005\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\t]abDJ\u0007\u00021)\u0011\u0011DG\u0001\u000bG>dG.Z2uS>t'BA\u000e\u000b\u0003\u0011)H/\u001b7\n\u0005uA\"aC(qK:D\u0015m\u001d5NCB\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\t1\fgn\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004Ok6\u0014WM\u001d\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0005\u0019>tw\r\u0005\u0002([%\u0011a\u0006\u000b\u0002\b!J|G-^2u!\t9\u0003'\u0003\u00022Q\ta1+\u001a:jC2L'0\u00192mK\"A1\u0007\u0001BK\u0002\u0013\u0005A'A\u0003dQ&dG-F\u00016!\t1t'D\u0001\u0005\u0013\tADA\u0001\u0006FqB\u0014Xm]:j_:D\u0001B\u000f\u0001\u0003\u0012\u0003\u0006I!N\u0001\u0007G\"LG\u000e\u001a\u0011\t\u0011q\u0002!Q3A\u0005\u0002Q\nA\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003 \u0001\u0005#\u0005\u000b\u0011B\u001b\u0002+A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8oA!A\u0001\t\u0001BK\u0002\u0013\u0005\u0011)\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\u0005\u0011\u0005CA\u0014D\u0013\t!\u0005FA\u0002J]RD\u0001B\u0012\u0001\u0003\u0012\u0003\u0006IAQ\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!Q\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\u0011)\u0003!\u0011#Q\u0001\n\t\u000bQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b\u0005C\u0003M\u0001\u0011\u0005Q*\u0001\u0004=S:LGO\u0010\u000b\u0006\u001d>\u0003\u0016K\u0015\t\u0003'\u0001AQaM&A\u0002UBQ\u0001P&A\u0002UBq\u0001Q&\u0011\u0002\u0003\u0007!\tC\u0004I\u0017B\u0005\t\u0019\u0001\"\t\u000b1\u0003A\u0011\u0001+\u0015\u00079+f\u000bC\u00034'\u0002\u0007Q\u0007C\u0003='\u0002\u0007Q\u0007C\u0003Y\u0001\u0011\u0005\u0013,\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u0017\t\u00037zs!a\n/\n\u0005uC\u0013A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018\u0015\t\u000b\t\u0004A\u0011I2\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$\"A\u00143\t\u000b\u0015\f\u0007\u0019\u0001\"\u000239,w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0005\u0006O\u0002!\t\u0005[\u0001\u001co&$\bNT3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u00059K\u0007\"\u00026g\u0001\u0004\u0011\u0015a\u00068fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011!a\u0007\u0001#b\u0001\n\u0013i\u0017!\u0006:fiV\u0014h\u000eU3sG\u0016tG/\u001b7f\u0003J\u0014\u0018-_\u000b\u0002]B\u0011qe\\\u0005\u0003a\"\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005s\u0001!\u0005\t\u0015)\u0003o\u0003Y\u0011X\r^;s]B+'oY3oi&dW-\u0011:sCf\u0004\u0003FA9u!\t9S/\u0003\u0002wQ\tIAO]1og&,g\u000e\u001e\u0005\tq\u0002A)\u0019!C\u0005s\u0006Y\u0001/\u001a:dK:$\u0018mZ3t+\u0005Q\bcA>~\u007f6\tAP\u0003\u0002\u001aQ%\u0011a\u0010 \u0002\u0004'\u0016\f\bcA\u0014\u0002\u0002%\u0019\u00111\u0001\u0015\u0003\r\u0011{WO\u00197f\u0011%\t9\u0001\u0001E\u0001B\u0003&!0\u0001\u0007qKJ\u001cWM\u001c;bO\u0016\u001c\b\u0005K\u0002\u0002\u0006QDq!!\u0004\u0001\t\u0003\ny!\u0001\u0005dQ&dGM]3o+\t\t\t\u0002E\u0003\u0002\u0014\u0005\rRG\u0004\u0003\u0002\u0016\u0005}a\u0002BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m\u0001#\u0001\u0004=e>|GOP\u0005\u0002S%\u0019\u0011\u0011\u0005\u0015\u0002\u000fA\f7m[1hK&\u0019a0!\n\u000b\u0007\u0005\u0005\u0002\u0006\u0003\u0004\u0002*\u0001!\t%\\\u0001\t]VdG.\u00192mK\"Q\u0011Q\u0006\u0001\t\u0006\u0004%\t%a\f\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e\t\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY$!\u000e\u0003\u0011\u0011\u000bG/\u0019+za\u0016D!\"a\u0010\u0001\u0011\u0003\u0005\u000b\u0015BA\u0019\u0003%!\u0017\r^1UsB,\u0007\u0005C\u0004\u0002D\u0001!\t%!\u0012\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002HA1\u00111CA\u0012\u0003\u0013\u0002B!a\r\u0002L%!\u0011QJA\u001b\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0004\u0002R\u0001!\t%a\u0015\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005U\u0003\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005mc!\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\ty&!\u0017\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRDq!a\u0019\u0001\t\u0003\n)'A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\ta\u0003C\u0004\u0002j\u0001!\t%a\u001b\u0002\rU\u0004H-\u0019;f)\u0019\ti'a\u001d\u0002xA\u0019q%a\u001c\n\u0007\u0005E\u0004F\u0001\u0003V]&$\bbBA;\u0003O\u0002\rAF\u0001\u0007EV4g-\u001a:\t\u0011\u0005e\u0014q\ra\u0001\u0003w\nQ!\u001b8qkR\u0004B!! \u0002\u00005\ta!C\u0002\u0002\u0002\u001a\u00111\"\u00138uKJt\u0017\r\u001c*po\"9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0015!B7fe\u001e,GCBA7\u0003\u0013\u000bY\tC\u0004\u0002v\u0005\r\u0005\u0019\u0001\f\t\u000f\u00055\u00151\u0011a\u0001-\u0005)q\u000e\u001e5fe\"9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0015\u0001B3wC2$B!!&\u0002\u001cB\u0019q%a&\n\u0007\u0005e\u0005FA\u0002B]fDq!!\u001e\u0002\u0010\u0002\u0007a\u0003C\u0004\u0002 \u0002!I!!)\u0002\u001d\u001d,G\u000fU3sG\u0016tG/\u001b7fgR!\u00111UAS!\u0015\t\u0019\"a\t\u0000\u0011\u001d\t)(!(A\u0002YAq!!+\u0001\t\u0013\tY+\u0001\bhK:,'/\u0019;f\u001fV$\b/\u001e;\u0015\t\u0005U\u0015Q\u0016\u0005\t\u0003_\u000b9\u000b1\u0001\u0002$\u00069!/Z:vYR\u001c\bbBAZ\u0001\u0011%\u0011QW\u0001\u000eO\u0016$\b+\u001a:dK:$\u0018\u000e\\3\u0015\u000by\t9,a1\t\u0011\u0005e\u0016\u0011\u0017a\u0001\u0003w\u000b1\"Y4he\u0016\u001cu.\u001e8ugB1\u00111CA\u0012\u0003{\u0003RaJA`=\u0019J1!!1)\u0005\u0019!V\u000f\u001d7fe!9\u0011QYAY\u0001\u0004y\u0018\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\u0006\t\"-\u001b8bef\u001cV-\u0019:dQ\u000e{WO\u001c;\u0015\u0013\t\u000bi-a6\u0002\\\u0006}\u0007\u0002CAh\u0003\u000f\u0004\r!!5\u0002\u0017\r|WO\u001c;t\u0003J\u0014\u0018-\u001f\t\u0005O\u0005Mg%C\u0002\u0002V\"\u0012Q!\u0011:sCfDq!!7\u0002H\u0002\u0007!)A\u0003ti\u0006\u0014H\u000fC\u0004\u0002^\u0006\u001d\u0007\u0019\u0001\"\u0002\u0007\u0015tG\rC\u0004\u0002b\u0006\u001d\u0007\u0019\u0001\u0014\u0002\u000bY\fG.^3\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002h\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003S\f\t\u0010E\u0003(\u0003'\fY\u000fE\u0002(\u0003[L1!a<)\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005M\u00181\u001da\u0001-\u0005\u0019qN\u00196\t\u000f\u0005]\b\u0001\"\u0011\u0002z\u0006YA-Z:fe&\fG.\u001b>f)\r1\u00121 \u0005\t\u0003{\f)\u00101\u0001\u0002j\u0006)!-\u001f;fg\"I!\u0011\u0001\u0001\u0002\u0002\u0013\u0005!1A\u0001\u0005G>\u0004\u0018\u0010F\u0005O\u0005\u000b\u00119A!\u0003\u0003\f!A1'a@\u0011\u0002\u0003\u0007Q\u0007\u0003\u0005=\u0003\u007f\u0004\n\u00111\u00016\u0011!\u0001\u0015q I\u0001\u0002\u0004\u0011\u0005\u0002\u0003%\u0002\u0000B\u0005\t\u0019\u0001\"\t\u0013\t=\u0001!%A\u0005\u0002\tE\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005'Q3!\u000eB\u000bW\t\u00119\u0002\u0005\u0003\u0003\u001a\t\rRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0011Q\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\"1\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B\u0015\u0001E\u0005I\u0011\u0001B\t\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011B!\f\u0001#\u0003%\tAa\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0007\u0016\u0004\u0005\nU\u0001\"\u0003B\u001b\u0001E\u0005I\u0011\u0001B\u0018\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQB\u0011B!\u000f\u0001\u0003\u0003%\tEa\u000f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011i\u0004E\u0002 \u0005\u007fI!a\u0018\u0011\t\u0011\t\r\u0003!!A\u0005\u0002\u0005\u000bA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011Ba\u0012\u0001\u0003\u0003%\tA!\u0013\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u0013B&\u0011%\u0011iE!\u0012\u0002\u0002\u0003\u0007!)A\u0002yIEB\u0011B!\u0015\u0001\u0003\u0003%\tEa\u0015\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0016\u0011\u000bm\u00149&!&\n\u0007\teCP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0011i\u0006AA\u0001\n\u0003\u0011y&\u0001\u0005dC:,\u0015/^1m)\rq'\u0011\r\u0005\u000b\u0005\u001b\u0012Y&!AA\u0002\u0005U\u0005\"\u0003B3\u0001\u0005\u0005I\u0011\tB4\u0003\u0019)\u0017/^1mgR\u0019aN!\u001b\t\u0015\t5#1MA\u0001\u0002\u0004\t)\nK\u0004\u0001\u0005[\u0012\u0019H!\u001e\u0011\u0007Y\u0012y'C\u0002\u0003r\u0011\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003x\u0005\u0019\u0019D\u0003\u0011!A\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006fY8mY\u0001\u0002XM]2f]R\fw-Z\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!Kb\f7\r\u001e\u0011qKJ\u001cWM\u001c;jY\u0016\u0004c/\u00197vK\u0002zg\r\t8v[\u0016\u0014\u0018n\u0019\u0011d_2,XN\u001c\u0011aG>d\u0007\rI1uAQDWM\u0003\u0011!A\u0001\u0002\u0003eZ5wK:\u0004\u0003/\u001a:dK:$\u0018mZ3/AQCW\r\t<bYV,\u0007e\u001c4!a\u0016\u00148-\u001a8uC\u001e,\u0007%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002dF\u0003\u0006!A\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002XM]2f]R\fw-Z\u0019!72\u0002\u0003/\u001a:dK:$\u0018mZ33;:rc&K\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!Kb\f7\r\u001e\u0011qKJ\u001cWM\u001c;jY\u0016\u0004c/\u00197vK\u0002\n'O]1z\u0015\u0001\u0002\u0003\u0005\t\u0011!_\u001a\u0004c.^7fe&\u001c\u0007eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002XM]2f]R\fw-\u001a\u0015tS9\u0002S)Y2iAY\fG.^3!_\u001a\u0004C\u000f[3!a\u0016\u00148-\u001a8uC\u001e,\u0007%\u0019:sCf\u0004S.^:u\u0015\u0001\u0002\u0003\u0005\t\u0011!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9R\u0001\u0005\t\u0011!\u000f%\u0011YHAA\u0001\u0012\u0003\u0011i(\u0001\u0006QKJ\u001cWM\u001c;jY\u0016\u00042a\u0005B@\r!\t!!!A\t\u0002\t\u00055#\u0002B@\u0005\u0007{\u0003#\u0003BC\u0005\u0017+TG\u0011\"O\u001b\t\u00119IC\u0002\u0003\n\"\nqA];oi&lW-\u0003\u0003\u0003\u000e\n\u001d%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oi!9AJa \u0005\u0002\tEEC\u0001B?\u0011)\u0011)Ja \u0002\u0002\u0013\u0015#qS\u0001\ti>\u001cFO]5oOR\u0011!Q\b\u0005\u000b\u00057\u0013y(!A\u0005\u0002\nu\u0015!B1qa2LH#\u0003(\u0003 \n\u0005&1\u0015BS\u0011\u0019\u0019$\u0011\u0014a\u0001k!1AH!'A\u0002UB\u0001\u0002\u0011BM!\u0003\u0005\rA\u0011\u0005\t\u0011\ne\u0005\u0013!a\u0001\u0005\"Q!\u0011\u0016B@\u0003\u0003%\tIa+\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0016B]!\u00159#q\u0016BZ\u0013\r\u0011\t\f\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\u001d\u0012),N\u001bC\u0005&\u0019!q\u0017\u0015\u0003\rQ+\b\u000f\\35\u0011%\u0011YLa*\u0002\u0002\u0003\u0007a*A\u0002yIAB!Ba0\u0003\u0000E\u0005I\u0011\u0001B\u0018\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!Q!1\u0019B@#\u0003%\tAa\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u00119Ma \u0012\u0002\u0013\u0005!qF\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q!1\u001aB@#\u0003%\tAa\f\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQB!Ba4\u0003\u0000\u0005\u0005I\u0011\u0002Bi\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tM\u0007cA\u0010\u0003V&\u0019!q\u001b\u0011\u0003\r=\u0013'.Z2u\u0001")
public class Percentile
extends TypedImperativeAggregate<OpenHashMap<Number, Object>>
implements Product,
Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient boolean returnPercentileArray;
    private transient Seq<Object> percentages;
    private DataType dataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return Percentile$.MODULE$.apply$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return Percentile$.MODULE$.$lessinit$greater$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Percentile>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    private boolean returnPercentileArray$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.returnPercentileArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Seq percentages$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Seq seq;
                Object num;
                Tuple2 tuple2 = new Tuple2((Object)this.percentageExpression().dataType(), this.percentageExpression().eval(this.percentageExpression().eval$default$1()));
                if (tuple2 != null && (num = tuple2._2()) instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)num);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{d}));
                } else {
                    ArrayType arrayType2;
                    DataType baseType;
                    if (tuple2 == null) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    DataType dataType2 = (DataType)tuple2._1();
                    Object arrayData = tuple2._2();
                    if (!(dataType2 instanceof ArrayType) || !((baseType = (arrayType2 = (ArrayType)dataType2).elementType()) instanceof NumericType)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    NumericType numericType = (NumericType)baseType;
                    if (!(arrayData instanceof ArrayData)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    ArrayData arrayData2 = (ArrayData)arrayData;
                    Object[] numericArray = arrayData2.toObjectArray(numericType);
                    seq = Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps(numericArray).map((Function1)new Serializable(this, numericType){
                        public static final long serialVersionUID = 0L;
                        private final NumericType x7$1;

                        public final double apply(Object x) {
                            return this.x7$1.numeric().toDouble(x);
                        }
                        {
                            this.x7$1 = x7$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSeq();
                }
                this.percentages = seq;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.percentages;
        }
    }

    private DataType dataType$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$0) {
                DataType dataType2 = this.percentageExpression().dataType();
                DataType dataType3 = dataType2 instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
                this.dataType = dataType3;
                this.bitmap$0 = true;
            }
            return this.dataType;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$7 = newMutableAggBufferOffset;
        Expression x$8 = this.copy$default$1();
        Expression x$9 = this.copy$default$2();
        int x$10 = this.copy$default$4();
        return this.copy(x$8, x$9, x$7, x$10);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$11 = newInputAggBufferOffset;
        Expression x$12 = this.copy$default$1();
        Expression x$13 = this.copy$default$2();
        int x$14 = this.copy$default$3();
        return this.copy(x$12, x$13, x$14, x$11);
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private Seq<Object> percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.percentageExpression();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.bitmap$0 ? this.dataType : this.dataType$lzycompute();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        DataType dataType2 = this.percentageExpression().dataType();
        Seq seq = dataType2 instanceof ArrayType ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, ArrayType$.MODULE$})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DoubleType$.MODULE$}));
        return seq;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.percentageExpression().foldable() ? (this.percentages().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double percentage) {
                return this.apply$mcZD$sp(percentage);
            }

            public boolean apply$mcZD$sp(double percentage) {
                return percentage < 0.0 || percentage > 1.0;
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)"Percentage(s) must be between 0.0 and 1.0, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.percentageExpression()}))).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$) : new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)"The percentage(s) must be a constant literal, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.percentageExpression()}))).toString()));
    }

    @Override
    public OpenHashMap<Number, Object> createAggregationBuffer() {
        return new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.apply(Number.class), ClassTag$.MODULE$.Long());
    }

    @Override
    public void update(OpenHashMap<Number, Object> buffer, InternalRow input) {
        Number key = (Number)this.child().eval(input);
        if (key != null) {
            buffer.changeValue$mcJ$sp((Object)key, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 1L;
                }
            }, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(long x$3) {
                    return this.apply$mcJJ$sp(x$3);
                }

                public long apply$mcJJ$sp(long x$3) {
                    return x$3 + 1L;
                }
            });
        }
    }

    @Override
    public void merge(OpenHashMap<Number, Object> buffer, OpenHashMap<Number, Object> other) {
        other.foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final OpenHashMap buffer$1;

            public final long apply(Tuple2<Number, Object> x0$1) {
                Tuple2<Number, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Number key = (Number)tuple2._1();
                    long count = tuple2._2$mcJ$sp();
                    long l = this.buffer$1.changeValue$mcJ$sp((Object)key, (Function0)new Serializable(this, count){
                        public static final long serialVersionUID = 0L;
                        private final long count$1;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.count$1;
                        }
                        {
                            this.count$1 = count$1;
                        }
                    }, (Function1)new Serializable(this, count){
                        public static final long serialVersionUID = 0L;
                        private final long count$1;

                        public final long apply(long x$4) {
                            return this.apply$mcJJ$sp(x$4);
                        }

                        public long apply$mcJJ$sp(long x$4) {
                            return x$4 + this.count$1;
                        }
                        {
                            this.count$1 = count$1;
                        }
                    });
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
    }

    @Override
    public Object eval(OpenHashMap<Number, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private Seq<Object> getPercentiles(OpenHashMap<Number, Object> buffer) {
        if (buffer.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Seq sortedCounts = (Seq)buffer.toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Number apply(Tuple2<Number, Object> x$5) {
                return (Number)x$5._1();
            }
        }, ((NumericType)this.child().dataType()).ordering());
        Seq accumlatedCounts = (Seq)((TraversableLike)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Number, Object> apply(Tuple2<Number, Object> x0$2, Tuple2<Number, Object> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        long count1 = tuple22._2$mcJ$sp();
                        if (tuple23 != null) {
                            Number key2 = (Number)tuple23._1();
                            long count2 = tuple23._2$mcJ$sp();
                            Tuple2 tuple24 = new Tuple2((Object)key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
                            return tuple24;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).tail();
        long maxPosition = ((Tuple2)accumlatedCounts.last())._2$mcJ$sp() - 1L;
        return (Seq)this.percentages().map((Function1)new Serializable(this, accumlatedCounts, maxPosition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Percentile $outer;
            private final Seq accumlatedCounts$1;
            private final long maxPosition$1;

            public final double apply(double percentile) {
                return this.apply$mcDD$sp(percentile);
            }

            public double apply$mcDD$sp(double percentile) {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$Percentile$$getPercentile((Seq<Tuple2<Number, Object>>)this.accumlatedCounts$1, (double)this.maxPosition$1 * percentile).doubleValue();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.accumlatedCounts$1 = accumlatedCounts$1;
                this.maxPosition$1 = maxPosition$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Object generateOutput(Seq<Object> results) {
        return results.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData(results) : results.head());
    }

    public Number org$apache$spark$sql$catalyst$expressions$aggregate$Percentile$$getPercentile(Seq<Tuple2<Number, Object>> aggreCounts, double position2) {
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position2));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position2));
        long[] countsArray = (long[])((TraversableOnce)aggreCounts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Number, Object> x$6) {
                return x$6._2$mcJ$sp();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), higher + 1L);
        Number lowerKey = (Number)((Tuple2)aggreCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return lowerKey;
        }
        Number higherKey = (Number)((Tuple2)aggreCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equalsNumNum((Number)higherKey, (Number)lowerKey)) {
            return lowerKey;
        }
        return Predef$.MODULE$.double2Double(((double)higher - position2) * lowerKey.doubleValue() + (position2 - (double)lower) * higherKey.doubleValue());
    }

    private int binarySearchCount(long[] countsArray, int start, int end, long value2) {
        int n = Arrays.binarySearch(countsArray, 0, end, value2);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    @Override
    public byte[] serialize(OpenHashMap<Number, Object> obj) {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.child().dataType(), LongType$.MODULE$}));
            obj.foreach((Function1)new Serializable(this, buffer, out, projection){
                public static final long serialVersionUID = 0L;
                private final byte[] buffer$2;
                private final DataOutputStream out$1;
                private final UnsafeProjection projection$1;

                public final void apply(Tuple2<Number, Object> x0$3) {
                    Tuple2<Number, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        Number key = (Number)tuple2._1();
                        long count = tuple2._2$mcJ$sp();
                        InternalRow row = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)count)}));
                        UnsafeRow unsafeRow = this.projection$1.apply(row);
                        this.out$1.writeInt(unsafeRow.getSizeInBytes());
                        unsafeRow.writeToStream(this.out$1, this.buffer$2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.buffer$2 = buffer$2;
                    this.out$1 = out$1;
                    this.projection$1 = projection$1;
                }
            });
            out.writeInt(-1);
            out.flush();
            return bos.toByteArray();
        }
        finally {
            out.close();
            bos.close();
        }
    }

    @Override
    public OpenHashMap<Number, Object> deserialize(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            OpenHashMap.mcJ.sp counts = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.apply(Number.class), ClassTag$.MODULE$.Long());
            int sizeOfNextRow = ins.readInt();
            while (sizeOfNextRow >= 0) {
                byte[] bs = new byte[sizeOfNextRow];
                ins.readFully(bs);
                UnsafeRow row = new UnsafeRow(2);
                row.pointTo(bs, sizeOfNextRow);
                Number key = (Number)row.get(0, this.child().dataType());
                long count = BoxesRunTime.unboxToLong((Object)row.get(1, LongType$.MODULE$));
                counts.update$mcJ$sp((Object)key, count);
                sizeOfNextRow = ins.readInt();
            }
            return counts;
        }
        finally {
            ins.close();
            bis.close();
        }
    }

    public Percentile copy(Expression child, Expression percentageExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new Percentile(child, percentageExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public Percentile(Expression child, Expression percentageExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, 0, 0);
    }
}

