/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr[, relativeSD]) - Returns the estimated cardinality by HyperLogLog++.\n      `relativeSD` defines the maximum estimation error allowed.\n  ")
@ScalaSignature(bytes="\u0006\u0001\tug\u0001B\u0001\u0003\u0001F\u00111\u0003S=qKJdun\u001a'pOBcWo\u001d)mkNT!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011b\u0003\b\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tA\u0001\u0011)\u001a!C\u0001C\u0005)1\r[5mIV\t!\u0005\u0005\u0002$I5\tA!\u0003\u0002&\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\t\naa\u00195jY\u0012\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0016\u0002\u0015I,G.\u0019;jm\u0016\u001cF)F\u0001,!\t9B&\u0003\u0002.1\t1Ai\\;cY\u0016D\u0001b\f\u0001\u0003\u0012\u0003\u0006IaK\u0001\fe\u0016d\u0017\r^5wKN#\u0005\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A\u001a\u0011\u0005]!\u0014BA\u001b\u0019\u0005\rIe\u000e\u001e\u0005\to\u0001\u0011\t\u0012)A\u0005g\u00059R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\t\u0005\ts\u0001\u0011)\u001a!C\u0001e\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0001b\u000f\u0001\u0003\u0012\u0003\u0006IaM\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q)q\bQ!C\u0007B\u00111\u0003\u0001\u0005\u0006Aq\u0002\rA\t\u0005\bSq\u0002\n\u00111\u0001,\u0011\u001d\tD\b%AA\u0002MBq!\u000f\u001f\u0011\u0002\u0003\u00071\u0007C\u0003>\u0001\u0011\u0005Q\t\u0006\u0002@\r\")\u0001\u0005\u0012a\u0001E!)Q\b\u0001C\u0001\u0011R\u0019q(\u0013&\t\u000b\u0001:\u0005\u0019\u0001\u0012\t\u000b%:\u0005\u0019\u0001\u0012\t\u000b1\u0003A\u0011I'\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001O!\ty%K\u0004\u0002\u0018!&\u0011\u0011\u000bG\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R1!)a\u000b\u0001C!/\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0002\u00131\")\u0011,\u0016a\u0001g\u0005Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u0015Y\u0006\u0001\"\u0011]\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0011!#\u0018\u0005\u0006=j\u0003\raM\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0011\u0002\u0019\u0001\u0003\u0002\u0003\u0005\u000b\u0011A\u001a\u0002\u0015>\u0014x\rJ1qC\u000eDW\rJ:qCJ\\Ge]9mI\r\fG/\u00197zgR$S\r\u001f9sKN\u001c\u0018n\u001c8tI\u0005<wM]3hCR,G\u0005S=qKJdun\u001a'pOBcWo\u001d)mkN$C\u0005\u001d\u0005\u0007E\u0002\u0001\u000b\u0011B\u001a\u0002\u0011%$\u0007p\u00155jMRDa\u0001\u001a\u0001!\u0002\u0013)\u0017\u0001C<QC\u0012$\u0017N\\4\u0011\u0005]1\u0017BA4\u0019\u0005\u0011auN\\4\t\u0013%\u0004!\u0011!A!\u0002\u0003\u0019\u0014AS8sO\u0012\n\u0007/Y2iK\u0012\u001a\b/\u0019:lIM\fH\u000eJ2bi\u0006d\u0017p\u001d;%Kb\u0004(/Z:tS>t7\u000fJ1hOJ,w-\u0019;fI!K\b/\u001a:M_\u001edun\u001a)mkN\u0004F.^:%I5Daa\u001b\u0001!\u0002\u0013Y\u0013aB1ma\"\fWJ\r\u0005\u0007[\u0002\u0001\u000b\u0011B\u001a\u0002\u00119,XnV8sINDQa\u001c\u0001\u0005BA\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002cB\u0019!O\u001f\u0012\u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<\u0011\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002z1\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005\r\u0019V-\u001d\u0006\u0003sbAQA \u0001\u0005B}\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003\u0003\u00012aFA\u0002\u0013\r\t)\u0001\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\t\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'A\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\f\u0003#\u0011\u0001\u0002R1uCRK\b/\u001a\u0005\b\u00037\u0001A\u0011IA\u000f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003?\u0001BA\u001d>\u0002\"A!\u0011qBA\u0012\u0013\u0011\t)#!\u0005\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007bBA\u0015\u0001\u0011\u0005\u00131F\u0001\u0010C\u001e<')\u001e4gKJ\u001c6\r[3nCV\u0011\u0011Q\u0006\t\u0005\u0003\u001f\ty#\u0003\u0003\u00022\u0005E!AC*ueV\u001cG\u000fV=qK\"I\u0011Q\u0007\u0001C\u0002\u0013\u0005\u0013qG\u0001\u0014C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u0003s\u0001BA\u001d>\u0002<A\u00191%!\u0010\n\u0007\u0005}BA\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0007\u0002CA\"\u0001\u0001\u0006I!!\u000f\u0002)\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:!\u0011%\t9\u0005\u0001b\u0001\n\u0003\n9$\u0001\rj]B,H/Q4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKND\u0001\"a\u0013\u0001A\u0003%\u0011\u0011H\u0001\u001aS:\u0004X\u000f^!hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\b\u0005C\u0004\u0002P\u0001!\t%!\u0015\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0003\u0002T\u0005e\u0003cA\f\u0002V%\u0019\u0011q\u000b\r\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037\ni\u00051\u0001\u0002^\u00051!-\u001e4gKJ\u0004B!a\u0018\u0002b5\ta!C\u0002\u0002d\u0019\u00111\"\u00138uKJt\u0017\r\u001c*po\"9\u0011q\r\u0001\u0005B\u0005%\u0014AB;qI\u0006$X\r\u0006\u0004\u0002T\u0005-\u0014Q\u000e\u0005\t\u00037\n)\u00071\u0001\u0002^!A\u0011qNA3\u0001\u0004\ti&A\u0003j]B,H\u000fC\u0004\u0002t\u0001!\t%!\u001e\u0002\u000b5,'oZ3\u0015\r\u0005M\u0013qOA>\u0011!\tI(!\u001dA\u0002\u0005u\u0013a\u00022vM\u001a,'/\r\u0005\t\u0003{\n\t\b1\u0001\u0002^\u00059!-\u001e4gKJ\u0014\u0004bBAA\u0001\u0011\u0005\u00111Q\u0001\rKN$\u0018.\\1uK\nK\u0017m\u001d\u000b\u0004W\u0005\u0015\u0005bBAD\u0003\u007f\u0002\raK\u0001\u0002K\"9\u00111\u0012\u0001\u0005B\u00055\u0015\u0001B3wC2$B!a$\u0002\u0016B\u0019q#!%\n\u0007\u0005M\u0005DA\u0002B]fD!\"a\u0017\u0002\nB\u0005\t\u0019AA/\u0011\u0019\tI\n\u0001C\u0001U\u00059AO];f%N$\u0007\"CAO\u0001\u0005\u0005I\u0011AAP\u0003\u0011\u0019w\u000e]=\u0015\u0013}\n\t+a)\u0002&\u0006\u001d\u0006\u0002\u0003\u0011\u0002\u001cB\u0005\t\u0019\u0001\u0012\t\u0011%\nY\n%AA\u0002-B\u0001\"MAN!\u0003\u0005\ra\r\u0005\ts\u0005m\u0005\u0013!a\u0001g!I\u00111\u0016\u0001\u0012\u0002\u0013\u0005\u0011QV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyKK\u0002#\u0003c[#!a-\u0011\t\u0005U\u0016qX\u0007\u0003\u0003oSA!!/\u0002<\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{C\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011YA\\\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u000b\u0004\u0011\u0013!C\u0001\u0003\u000f\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002J*\u001a1&!-\t\u0013\u00055\u0007!%A\u0005\u0002\u0005=\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003#T3aMAY\u0011%\t)\u000eAI\u0001\n\u0003\ty-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005e\u0007!!A\u0005B\u0005m\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018\u0001\u00027b]\u001eT!!a:\u0002\t)\fg/Y\u0005\u0004'\u0006\u0005\b\u0002CAw\u0001\u0005\u0005I\u0011\u0001\u001a\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005E\b!!A\u0005\u0002\u0005M\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001f\u000b)\u0010C\u0005\u0002x\u0006=\u0018\u0011!a\u0001g\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005m\b!!A\u0005B\u0005u\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\bC\u0002B\u0001\u0005\u000f\ty)\u0004\u0002\u0003\u0004)\u0019!Q\u0001\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\n\t\r!\u0001C%uKJ\fGo\u001c:\t\u0013\t5\u0001!!A\u0005\u0002\t=\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005!\u0011\u0003\u0005\u000b\u0003o\u0014Y!!AA\u0002\u0005=\u0005\"\u0003B\u000b\u0001\u0005\u0005I\u0011\tB\f\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0001B\r\u0011)\t9Pa\u0005\u0002\u0002\u0003\u0007\u0011q\u0012\u0015\b\u0001\tu!1\u0005B\u0013!\r\u0019#qD\u0005\u0004\u0005C!!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005O\t\u00111\u0007\u0006!A\u0001\u0002sLR+O\u0007~CS\r\u001f9s72\u0002#/\u001a7bi&4Xm\u0015#^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002*7\u000f^5nCR,G\rI2be\u0012Lg.\u00197jif\u0004#-\u001f\u0011IsB,'\u000fT8h\u0019><7f\u000b\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011ae\u0016d\u0017\r^5wKN#\u0005\r\t3fM&tWm\u001d\u0011uQ\u0016\u0004S.\u0019=j[Vl\u0007%Z:uS6\fG/[8oA\u0015\u0014(o\u001c:!C2dwn^3e])\u0001\u0003eB\u0004\u0003,\tA\tA!\f\u0002'!K\b/\u001a:M_\u001edun\u001a)mkN\u0004F.^:\u0011\u0007M\u0011yC\u0002\u0004\u0002\u0005!\u0005!\u0011G\n\u0006\u0005_\u0011\u0019\u0004\b\t\u0004/\tU\u0012b\u0001B\u001c1\t1\u0011I\\=SK\u001aDq!\u0010B\u0018\t\u0003\u0011Y\u0004\u0006\u0002\u0003.!I!q\bB\u0018\u0005\u0004%\tAM\u0001\n/>\u0013FiX*J5\u0016C\u0001Ba\u0011\u00030\u0001\u0006IaM\u0001\u000b/>\u0013FiX*J5\u0016\u0003\u0003\"\u0003B$\u0005_\u0011\r\u0011\"\u00013\u00035\u0011ViR%T)\u0016\u0013vlU%[\u000b\"A!1\nB\u0018A\u0003%1'\u0001\bS\u000b\u001eK5\u000bV#S?NK%,\u0012\u0011\t\u0015\t=#q\u0006b\u0001\n\u0003\u0011\t&\u0001\nS\u000b\u001eK5\u000bV#S?^{%\u000bR0N\u0003N[U#A3\t\u0011\tU#q\u0006Q\u0001\n\u0015\f1CU#H\u0013N#VIU0X\u001fJ#u,T!T\u0017\u0002B\u0011B!\u0017\u00030\t\u0007I\u0011\u0001\u001a\u0002%I+u)S*U\u000bJ\u001bv\fU#S?^{%\u000b\u0012\u0005\t\u0005;\u0012y\u0003)A\u0005g\u0005\u0019\"+R$J'R+%kU0Q\u000bJ{vk\u0014*EA!I!\u0011\rB\u0018\u0005\u0004%\tAM\u0001\u0002\u0017\"A!Q\rB\u0018A\u0003%1'\u0001\u0002LA!Q!\u0011\u000eB\u0018\u0005\u0004%\tAa\u001b\u0002\u0015QC%+R*I\u001f2#5+\u0006\u0002\u0003nA!qCa\u001c,\u0013\r\u0011\t\b\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0005k\u0012y\u0003)A\u0005\u0005[\n1\u0002\u0016%S\u000bNCu\n\u0014#TA!Q!\u0011\u0010B\u0018\u0005\u0004%\tAa\u001f\u0002#I\u000bukX#T)&k\u0015\tV#`\t\u0006#\u0016)\u0006\u0002\u0003~A)qCa\u001c\u0003n!I!\u0011\u0011B\u0018A\u0003%!QP\u0001\u0013%\u0006;v,R*U\u00136\u000bE+R0E\u0003R\u000b\u0005\u0005\u0003\u0006\u0003\u0006\n=\"\u0019!C\u0001\u0005w\n\u0011BQ%B'~#\u0015\tV!\t\u0013\t%%q\u0006Q\u0001\n\tu\u0014A\u0003\"J\u0003N{F)\u0011+BA!A!Q\u0012B\u0018\t\u0013\u0011y)A\u000bwC2LG-\u0019;f\t>,(\r\\3MSR,'/\u00197\u0015\u0007-\u0012\t\nC\u0004\u0003\u0014\n-\u0005\u0019\u0001\u0012\u0002\u0007\u0015D\b\u000f\u0003\u0006\u0003\u0018\n=\u0012\u0011!CA\u00053\u000bQ!\u00199qYf$\u0012b\u0010BN\u0005;\u0013yJ!)\t\r\u0001\u0012)\n1\u0001#\u0011!I#Q\u0013I\u0001\u0002\u0004Y\u0003\u0002C\u0019\u0003\u0016B\u0005\t\u0019A\u001a\t\u0011e\u0012)\n%AA\u0002MB!B!*\u00030\u0005\u0005I\u0011\u0011BT\u0003\u001d)h.\u00199qYf$BA!+\u00036B)qCa+\u00030&\u0019!Q\u0016\r\u0003\r=\u0003H/[8o!\u001d9\"\u0011\u0017\u0012,gMJ1Aa-\u0019\u0005\u0019!V\u000f\u001d7fi!I!q\u0017BR\u0003\u0003\u0005\raP\u0001\u0004q\u0012\u0002\u0004B\u0003B^\u0005_\t\n\u0011\"\u0001\u0002H\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0003@\n=\u0012\u0013!C\u0001\u0003\u001f\fq\"\u00199qYf$C-\u001a4bk2$He\r\u0005\u000b\u0005\u0007\u0014y#%A\u0005\u0002\u0005=\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\t\u0015\t\u001d'qFI\u0001\n\u0003\t9-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r\u0005\u000b\u0005\u0017\u0014y#%A\u0005\u0002\u0005=\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0003P\n=\u0012\u0013!C\u0001\u0003\u001f\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004B\u0003Bj\u0005_\t\t\u0011\"\u0003\u0003V\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u000e\u0005\u0003\u0002`\ne\u0017\u0002\u0002Bn\u0003C\u0014aa\u00142kK\u000e$\b")
public class HyperLogLogPlusPlus
extends ImperativeAggregate
implements Serializable {
    private final Expression child;
    private final double relativeSD;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
    private final int idxShift;
    private final long wPadding;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
    private final double alphaM2;
    private final int numWords;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<AttributeReference> inputAggBufferAttributes;

    public static int $lessinit$greater$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$2();
    }

    public static int apply$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$2();
    }

    public static double[][] BIAS_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.BIAS_DATA();
    }

    public static double[][] RAW_ESTIMATE_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA();
    }

    public static double[] THRESHOLDS() {
        return HyperLogLogPlusPlus$.MODULE$.THRESHOLDS();
    }

    public static int K() {
        return HyperLogLogPlusPlus$.MODULE$.K();
    }

    public static int REGISTERS_PER_WORD() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
    }

    public static long REGISTER_WORD_MASK() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
    }

    public static int REGISTER_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
    }

    public static int WORD_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.WORD_SIZE();
    }

    public Expression child() {
        return this.child;
    }

    public double relativeSD() {
        return this.relativeSD;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "approx_count_distinct";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$2 = newMutableAggBufferOffset;
        Expression x$3 = this.copy$default$1();
        double x$4 = this.copy$default$2();
        int x$5 = this.copy$default$4();
        return this.copy(x$3, x$4, x$2, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$6 = newInputAggBufferOffset;
        Expression x$7 = this.copy$default$1();
        double x$8 = this.copy$default$2();
        int x$9 = this.copy$default$3();
        return this.copy(x$7, x$8, x$9, x$6);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyDataType$[]{AnyDataType$.MODULE$}));
    }

    @Override
    public StructType aggBufferSchema() {
        return StructType$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        for (int word = 0; word < this.numWords; ++word) {
            buffer.setLong(this.mutableAggBufferOffset() + word, 0L);
        }
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        Object v = this.child().eval(input);
        if (v != null) {
            long x = XxHash64Function$.MODULE$.hash(v, this.child().dataType(), 42L);
            int idx = (int)(x >>> this.idxShift);
            long pw = (long)Long.numberOfLeadingZeros(x << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p | this.wPadding) + 1L;
            int wordOffset = idx / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE() * (idx - wordOffset * HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD());
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK() << shift;
            long Midx = (word & mask) >>> shift;
            if (pw > Midx) {
                buffer.setLong(this.mutableAggBufferOffset() + wordOffset, word & (mask ^ 0xFFFFFFFFFFFFFFFFL) | pw << shift);
            }
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word1 = buffer1.getLong(this.mutableAggBufferOffset() + wordOffset);
            long word2 = buffer2.getLong(this.inputAggBufferOffset() + wordOffset);
            long word = 0L;
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                word |= Math.max(word1 & mask, word2 & mask);
                mask <<= HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
            buffer1.setLong(this.mutableAggBufferOffset() + wordOffset, word);
        }
    }

    public double estimateBias(double e) {
        int high;
        double[] estimates = HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        int numEstimates = estimates.length;
        int n = Arrays.binarySearch(estimates, 0, numEstimates, e);
        switch (n) {
            default: 
        }
        int nearestEstimateIndex = n < 0 ? -(n + 1) : n;
        int low = package$.MODULE$.max(nearestEstimateIndex - HyperLogLogPlusPlus$.MODULE$.K() + 1, 0);
        for (high = package$.MODULE$.min(low + HyperLogLogPlusPlus$.MODULE$.K(), numEstimates); high < numEstimates && this.distance$1(high, e, estimates) < this.distance$1(low, e, estimates); ++high) {
            ++low;
        }
        double[] biases = HyperLogLogPlusPlus$.MODULE$.BIAS_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        double biasSum = 0.0;
        for (int i = low; i < high; ++i) {
            biasSum += biases[i];
        }
        return biasSum / (double)(high - low);
    }

    @Override
    public Object eval(InternalRow buffer) {
        double d;
        double zInverse = 0.0;
        double V = 0.0;
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = 0;
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                long Midx = word >>> shift & HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
                zInverse += 1.0 / (double)(1L << (int)Midx);
                if (Midx == 0L) {
                    V += 1.0;
                }
                shift += HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
        }
        double E = this.alphaM2 / zInverse;
        if (V > 0.0) {
            double H = (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * Math.log((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / V);
            d = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && H <= HyperLogLogPlusPlus$.MODULE$.THRESHOLDS()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4] || E <= 2.5 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? H : this.EBiasCorrected$1(E);
        } else {
            d = this.EBiasCorrected$1(E);
        }
        double estimate = d;
        return BoxesRunTime.boxToLong((long)Math.round(estimate));
    }

    public double trueRsd() {
        return 1.04 / package$.MODULE$.sqrt((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m);
    }

    public HyperLogLogPlusPlus copy(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HyperLogLogPlusPlus(child, relativeSD, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public double copy$default$2() {
        return this.relativeSD();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HyperLogLogPlusPlus";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.relativeSD());
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HyperLogLogPlusPlus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HyperLogLogPlusPlus)) return false;
        boolean bl = true;
        if (!bl) return false;
        HyperLogLogPlusPlus hyperLogLogPlusPlus = (HyperLogLogPlusPlus)x$1;
        Expression expression = this.child();
        Expression expression2 = hyperLogLogPlusPlus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.relativeSD() != hyperLogLogPlusPlus.relativeSD()) return false;
        if (this.mutableAggBufferOffset() != hyperLogLogPlusPlus.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hyperLogLogPlusPlus.inputAggBufferOffset()) return false;
        if (!hyperLogLogPlusPlus.canEqual(this)) return false;
        return true;
    }

    private final double distance$1(int i, double e$1, double[] estimates$1) {
        double diff = e$1 - estimates$1[i];
        return diff * diff;
    }

    private final double EBiasCorrected$1(double E$1) {
        double d = E$1;
        double d2 = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && d < 5.0 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? d - this.estimateBias(d) : d;
        return d2;
    }

    public HyperLogLogPlusPlus(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        double d;
        this.child = child;
        this.relativeSD = relativeSD;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p = (int)Math.ceil(2.0 * Math.log(1.106 / relativeSD) / Math.log(2.0));
        Predef$.MODULE$.require(this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p >= 4, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "HLL++ requires at least 4 bits for addressing. Use a lower error, at most 39%.";
            }
        });
        this.idxShift = 64 - this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        this.wPadding = 1L << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 1;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m = 1 << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        int n = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        switch (n) {
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m) * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 6: {
                d = 0.709 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 5: {
                d = 0.697 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 4: {
                d = 0.673 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
            }
        }
        this.alphaM2 = d;
        this.numWords = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD() + 1;
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.tabulate(this.numWords, (Function1)new $anonfun$2(this));
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1)new $anonfun$3(this), Seq$.MODULE$.canBuildFrom());
    }

    public HyperLogLogPlusPlus(Expression child) {
        this(child, 0.05, 0, 0);
    }

    public HyperLogLogPlusPlus(Expression child, Expression relativeSD) {
        this(child, HyperLogLogPlusPlus$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$validateDoubleLiteral(relativeSD), 0, 0);
    }
}

