/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, expr3) - If `expr1` evaluates to true, then returns `expr2`; otherwise returns `expr3`.", extended="\n    Examples:\n      > SELECT _FUNC_(1 < 2, 'a', 'b');\n       a\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u0001>\u0011!!\u00134\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00155A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"a\u0002)s_\u0012,8\r\u001e\t\u0003+mI!\u0001\b\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y\u0001!Q3A\u0005\u0002}\t\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0016\u0003AA\u0001\"\t\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\u000baJ,G-[2bi\u0016\u0004\u0003\u0002C\u0012\u0001\u0005+\u0007I\u0011A\u0010\u0002\u0013Q\u0014X/\u001a,bYV,\u0007\u0002C\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\t\u0002\u0015Q\u0014X/\u001a,bYV,\u0007\u0005\u0003\u0005(\u0001\tU\r\u0011\"\u0001 \u0003)1\u0017\r\\:f-\u0006dW/\u001a\u0005\tS\u0001\u0011\t\u0012)A\u0005!\u0005Ya-\u00197tKZ\u000bG.^3!\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q!QFL\u00181!\t\t\u0002\u0001C\u0003\u001fU\u0001\u0007\u0001\u0003C\u0003$U\u0001\u0007\u0001\u0003C\u0003(U\u0001\u0007\u0001\u0003C\u00033\u0001\u0011\u00053'\u0001\u0005dQ&dGM]3o+\u0005!\u0004cA\u001b>!9\u0011ag\u000f\b\u0003oij\u0011\u0001\u000f\u0006\u0003s9\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0005q2\u0012a\u00029bG.\fw-Z\u0005\u0003}}\u00121aU3r\u0015\tad\u0003C\u0003B\u0001\u0011\u0005#)\u0001\u0005ok2d\u0017M\u00197f+\u0005\u0019\u0005CA\u000bE\u0013\t)eCA\u0004C_>dW-\u00198\t\u000b\u001d\u0003A\u0011\t%\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003%\u0003\"AS'\u000e\u0003-S!\u0001\u0014\u0003\u0002\u0011\u0005t\u0017\r\\=tSNL!AT&\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRDQ\u0001\u0015\u0001\u0005BE\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011QKB\u0001\u0006if\u0004Xm]\u0005\u0003/R\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u00063\u0002!\tEW\u0001\u0005KZ\fG\u000e\u0006\u0002\\=B\u0011Q\u0003X\u0005\u0003;Z\u00111!\u00118z\u0011\u001dy\u0006\f%AA\u0002\u0001\fQ!\u001b8qkR\u0004\"!\u00192\u000e\u0003\u0011I!a\u0019\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006K\u0002!\tEZ\u0001\nI><UM\\\"pI\u0016$2aZ7s!\tA7.D\u0001j\u0015\tQ'!A\u0004d_\u0012,w-\u001a8\n\u00051L'\u0001C#yaJ\u001cu\u000eZ3\t\u000b9$\u0007\u0019A8\u0002\u0007\r$\b\u0010\u0005\u0002ia&\u0011\u0011/\u001b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u0019H\r1\u0001h\u0003\t)g\u000fC\u0003v\u0001\u0011%a/\u0001\u000bde\u0016\fG/Z!oI\u0006#GMR;oGRLwN\u001c\u000b\no\u0006\r\u0011QAA\u0004\u0003\u0013\u0001R!\u0006={ujL!!\u001f\f\u0003\rQ+\b\u000f\\34!\tYhP\u0004\u0002\u0016y&\u0011QPF\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{ZAQA\u001c;A\u0002=DQa\u001d;A\u0002\u001dDQ\u0001\u0015;A\u0002ICa!a\u0003u\u0001\u0004Q\u0018\u0001\u00042bg\u00164UO\\2OC6,\u0007bBA\b\u0001\u0011\u0005\u0013\u0011C\u0001\ti>\u001cFO]5oOR\t!\u0010\u0003\u0004\b\u0001\u0011\u0005\u0013QC\u000b\u0002u\"I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111D\u0001\u0005G>\u0004\u0018\u0010F\u0004.\u0003;\ty\"!\t\t\u0011y\t9\u0002%AA\u0002AA\u0001bIA\f!\u0003\u0005\r\u0001\u0005\u0005\tO\u0005]\u0001\u0013!a\u0001!!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011qE\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tICK\u0002\u0011\u0003WY#!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003o1\u0012AC1o]>$\u0018\r^5p]&!\u00111HA\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u007f\u0001\u0011\u0013!C\u0001\u0003O\tabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002D\u0001\t\n\u0011\"\u0001\u0002(\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA$\u0001\u0005\u0005I\u0011IA%\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\n\t\u0005\u0003\u001b\n9&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0013\u0001\u00026bm\u0006L1a`A(\u0011%\tY\u0006AA\u0001\n\u0003\ti&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`A\u0019Q#!\u0019\n\u0007\u0005\rdCA\u0002J]RD\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191,a\u001b\t\u0015\u00055\u0014QMA\u0001\u0002\u0004\ty&A\u0002yIEB\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001e\u0011\u000b\u0005]\u0014QP.\u000e\u0005\u0005e$bAA>-\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0011QQ\u0001\tG\u0006tW)];bYR\u00191)a\"\t\u0013\u00055\u0014\u0011QA\u0001\u0002\u0004Y\u0006\"CAF\u0001\u0005\u0005I\u0011IAG\u0003\u0019)\u0017/^1mgR\u00191)a$\t\u0013\u00055\u0014\u0011RA\u0001\u0002\u0004Y\u0006f\u0003\u0001\u0002\u0014\u0006e\u00151TAP\u0003C\u00032!EAK\u0013\r\t9J\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti*\u00017`\rVs5i\u0018\u0015fqB\u0014\u0018\u0007\f\u0011fqB\u0014(\u0007\f\u0011fqB\u00148'\u000b\u0011.A%3\u0007\u0005Y3yaJ\f\u0004\rI3wC2,\u0018\r^3tAQ|\u0007\u0005\u001e:vK2\u0002C\u000f[3oAI,G/\u001e:og\u0002\u0002W\r\u001f9se\u0001\\\u0004e\u001c;iKJ<\u0018n]3!e\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:4A:\n\u0001\"\u001a=uK:$W\rZ\u0011\u0003\u0003G\u000b!I\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152Aq\u0002#\u0007\f\u0011(C\u001eb\u0003e\n2(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013M\u0003\u0011!\u000f%\t9KAA\u0001\u0012\u0003\tI+\u0001\u0002JMB\u0019\u0011#a+\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003[\u001bR!a+\u00020j\u0001\u0002\"!-\u00028B\u0001\u0002#L\u0007\u0003\u0003gS1!!.\u0017\u0003\u001d\u0011XO\u001c;j[\u0016LA!!/\u00024\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f-\nY\u000b\"\u0001\u0002>R\u0011\u0011\u0011\u0016\u0005\u000b\u0003\u001f\tY+!A\u0005F\u0005\u0005GCAA&\u0011)\t)-a+\u0002\u0002\u0013\u0005\u0015qY\u0001\u0006CB\u0004H.\u001f\u000b\b[\u0005%\u00171ZAg\u0011\u0019q\u00121\u0019a\u0001!!11%a1A\u0002AAaaJAb\u0001\u0004\u0001\u0002BCAi\u0003W\u000b\t\u0011\"!\u0002T\u00069QO\\1qa2LH\u0003BAk\u0003;\u0004R!FAl\u00037L1!!7\u0017\u0005\u0019y\u0005\u000f^5p]B)Q\u0003\u001f\t\u0011!!I\u0011q\\Ah\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\u0002\u0004BCAr\u0003W\u000b\t\u0011\"\u0003\u0002f\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u000f\u0005\u0003\u0002N\u0005%\u0018\u0002BAv\u0003\u001f\u0012aa\u00142kK\u000e$\b")
public class If
extends Expression
implements Serializable {
    private final Expression predicate;
    private final Expression trueValue;
    private final Expression falseValue;

    public static Function1<Tuple3<Expression, Expression, Expression>, If> tupled() {
        return If$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, If>>> curried() {
        return If$.MODULE$.curried();
    }

    public Expression predicate() {
        return this.predicate;
    }

    public Expression trueValue() {
        return this.trueValue;
    }

    public Expression falseValue() {
        return this.falseValue;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.predicate();
        Expression expression2 = this.trueValue();
        Expression expression3 = this.falseValue();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return this.trueValue().nullable() || this.falseValue().nullable();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType2 = this.predicate().dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType2 != null ? !dataType2.equals(booleanType$) : booleanType$ != null) ? (this.trueValue().dataType().sameType(this.falseValue().dataType()) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"differing types in '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sql()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " and ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.trueValue().dataType().simpleString(), this.falseValue().dataType().simpleString()}))).toString())) : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type of predicate expression in If should be boolean, not ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.predicate().dataType()})));
    }

    @Override
    public DataType dataType() {
        return this.trueValue().dataType();
    }

    @Override
    public Object eval(InternalRow input) {
        return Boolean.TRUE.equals(this.predicate().eval(input)) ? this.trueValue().eval(input) : this.falseValue().eval(input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        ExprCode condEval = this.predicate().genCode(ctx);
        ExprCode trueEval = this.trueValue().genCode(ctx);
        ExprCode falseEval = this.falseValue().genCode(ctx);
        int combinedLength = condEval.code().length() + trueEval.code().length() + falseEval.code().length();
        if (combinedLength > 1024 && ctx.INPUT_ROW() != null && ctx.currentVars() == null) {
            Tuple3 tuple3;
            Tuple3 tuple32;
            Tuple3 tuple33;
            Tuple3<String, String, String> tuple34 = this.createAndAddFunction(ctx, condEval, this.predicate().dataType(), "evalIfCondExpr");
            if (tuple34 == null) throw new MatchError(tuple34);
            String condFuncName = (String)tuple34._1();
            String condGlobalIsNull = (String)tuple34._2();
            String condGlobalValue = (String)tuple34._3();
            Tuple3 tuple35 = tuple33 = new Tuple3((Object)condFuncName, (Object)condGlobalIsNull, (Object)condGlobalValue);
            String condFuncName2 = (String)tuple35._1();
            String condGlobalIsNull2 = (String)tuple35._2();
            String condGlobalValue2 = (String)tuple35._3();
            Tuple3<String, String, String> tuple36 = this.createAndAddFunction(ctx, trueEval, this.trueValue().dataType(), "evalIfTrueExpr");
            if (tuple36 == null) throw new MatchError(tuple36);
            String trueFuncName = (String)tuple36._1();
            String trueGlobalIsNull = (String)tuple36._2();
            String trueGlobalValue = (String)tuple36._3();
            Tuple3 tuple37 = tuple32 = new Tuple3((Object)trueFuncName, (Object)trueGlobalIsNull, (Object)trueGlobalValue);
            String trueFuncName2 = (String)tuple37._1();
            String trueGlobalIsNull2 = (String)tuple37._2();
            String trueGlobalValue2 = (String)tuple37._3();
            Tuple3<String, String, String> tuple38 = this.createAndAddFunction(ctx, falseEval, this.falseValue().dataType(), "evalIfFalseExpr");
            if (tuple38 == null) throw new MatchError(tuple38);
            String falseFuncName = (String)tuple38._1();
            String falseGlobalIsNull = (String)tuple38._2();
            String falseGlobalValue = (String)tuple38._3();
            Tuple3 tuple39 = tuple3 = new Tuple3((Object)falseFuncName, (Object)falseGlobalIsNull, (Object)falseGlobalValue);
            String falseFuncName2 = (String)tuple39._1();
            String falseGlobalIsNull2 = (String)tuple39._2();
            String falseGlobalValue2 = (String)tuple39._3();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "(", ");\n        boolean ", " = false;\n        ", " ", " = ", ";\n        if (!", " && ", ") {\n          ", "(", ");\n          ", " = ", ";\n          ", " = ", ";\n        } else {\n          ", "(", ");\n          ", " = ", ";\n          ", " = ", ";\n        }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condFuncName2, ctx.INPUT_ROW(), ev.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType()), condGlobalIsNull2, condGlobalValue2, trueFuncName2, ctx.INPUT_ROW(), ev.isNull(), trueGlobalIsNull2, ev.value(), trueGlobalValue2, falseFuncName2, ctx.INPUT_ROW(), ev.isNull(), falseGlobalIsNull2, ev.value(), falseGlobalValue2}));
        } else {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        boolean ", " = false;\n        ", " ", " = ", ";\n        if (!", " && ", ") {\n          ", "\n          ", " = ", ";\n          ", " = ", ";\n        } else {\n          ", "\n          ", " = ", ";\n          ", " = ", ";\n        }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condEval.code(), ev.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType()), condEval.isNull(), condEval.value(), trueEval.code(), ev.isNull(), trueEval.isNull(), ev.value(), trueEval.value(), falseEval.code(), ev.isNull(), falseEval.isNull(), ev.value(), falseEval.value()}));
        }
        String generatedCode = string;
        return ev.copy(generatedCode, ev.copy$default$2(), ev.copy$default$3());
    }

    private Tuple3<String, String, String> createAndAddFunction(CodegenContext ctx, ExprCode ev, DataType dataType2, String baseFuncName) {
        String globalIsNull = ctx.freshName("isNull");
        ctx.addMutableState("boolean", globalIsNull, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = false;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{globalIsNull})));
        String globalValue = ctx.freshName("value");
        ctx.addMutableState(ctx.javaType(dataType2), globalValue, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{globalValue, ctx.defaultValue(dataType2)})));
        String funcName = ctx.freshName(baseFuncName);
        String funcBody = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |private void ", "(InternalRow ", ") {\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", ";\n         |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{funcName, ctx.INPUT_ROW(), ev.code().trim(), globalIsNull, ev.isNull(), globalValue, ev.value()})))).stripMargin();
        ctx.addNewFunction(funcName, funcBody);
        return new Tuple3((Object)funcName, (Object)globalIsNull, (Object)globalValue);
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"if (", ") ", " else ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.predicate(), this.trueValue(), this.falseValue()}));
    }

    @Override
    public String sql() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(IF(", ", ", ", ", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.predicate().sql(), this.trueValue().sql(), this.falseValue().sql()}));
    }

    public If copy(Expression predicate, Expression trueValue, Expression falseValue) {
        return new If(predicate, trueValue, falseValue);
    }

    public Expression copy$default$1() {
        return this.predicate();
    }

    public Expression copy$default$2() {
        return this.trueValue();
    }

    public Expression copy$default$3() {
        return this.falseValue();
    }

    @Override
    public String productPrefix() {
        return "If";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.falseValue();
                break;
            }
            case 1: {
                expression = this.trueValue();
                break;
            }
            case 0: {
                expression = this.predicate();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof If;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof If)) return false;
        boolean bl = true;
        if (!bl) return false;
        If if_ = (If)x$1;
        Expression expression = this.predicate();
        Expression expression2 = if_.predicate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.trueValue();
        Expression expression4 = if_.trueValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.falseValue();
        Expression expression6 = if_.falseValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!if_.canEqual(this)) return false;
        return true;
    }

    public If(Expression predicate, Expression trueValue, Expression falseValue) {
        this.predicate = predicate;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }
}

