/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TruncDate$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(date, fmt) - Returns `date` with the time portion of the day truncated to the unit specified by the format model `fmt`.", extended="\n    Examples:\n      > SELECT _FUNC_('2009-02-12', 'MM');\n       2009-02-01\n      > SELECT _FUNC_('2015-10-27', 'YEAR');\n       2015-01-01\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001>\u0011\u0011\u0002\u0016:v]\u000e$\u0015\r^3\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0011\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\t\u0011\fG/Z\u000b\u0002GA\u0011\u0011\u0003J\u0005\u0003K\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!9\u0003A!E!\u0002\u0013\u0019\u0013!\u00023bi\u0016\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\r\u0019|'/\\1u\u0011!Y\u0003A!E!\u0002\u0013\u0019\u0013a\u00024pe6\fG\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!E\u0005!A.\u001a4u\u0011\u0015)\u0004\u0001\"\u0011#\u0003\u0015\u0011\u0018n\u001a5u\u0011\u00159\u0004\u0001\"\u00119\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u000f\u0003\u0019a$o\\8u}%\t!$\u0003\u0002B3\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003f\u0001\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0004\u0002\u000bQL\b/Z:\n\u0005);%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015a\u0005\u0001\"\u0011N\u0003!!\u0017\r^1UsB,W#\u0001(\u0011\u0005\u0019{\u0015B\u0001)H\u0005!!\u0015\r^1UsB,\u0007\"\u0002*\u0001\t\u0003\u001a\u0016\u0001\u00038vY2\f'\r\\3\u0016\u0003Q\u0003\"\u0001G+\n\u0005YK\"a\u0002\"p_2,\u0017M\u001c\u0005\u00061\u0002!\t%W\u0001\u000baJ,G\u000f^=OC6,W#\u0001.\u0011\u0005msfB\u0001\r]\u0013\ti\u0016$\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/\u001a\u0011!\u0011\u0007\u0001#b\u0001\n\u0013\u0019\u0017A\u0003;sk:\u001cG*\u001a<fYV\tA\r\u0005\u0002\u0019K&\u0011a-\u0007\u0002\u0004\u0013:$\b\u0002\u00035\u0001\u0011\u0003\u0005\u000b\u0015\u00023\u0002\u0017Q\u0014XO\\2MKZ,G\u000e\t\u0005\u0006U\u0002!\te[\u0001\u0005KZ\fG\u000e\u0006\u0002m_B\u0011\u0001$\\\u0005\u0003]f\u00111!\u00118z\u0011\u001d\u0001\u0018\u000e%AA\u0002E\fQ!\u001b8qkR\u0004\"A]:\u000e\u0003\u0011I!\u0001\u001e\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006m\u0002!\te^\u0001\nI><UM\\\"pI\u0016$B\u0001\u001f@\u0002\bA\u0011\u0011\u0010`\u0007\u0002u*\u00111PA\u0001\bG>$WmZ3o\u0013\ti(P\u0001\u0005FqB\u00148i\u001c3f\u0011\u0019yX\u000f1\u0001\u0002\u0002\u0005\u00191\r\u001e=\u0011\u0007e\f\u0019!C\u0002\u0002\u0006i\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\nU\u0004\r\u0001_\u0001\u0003KZD\u0011\"!\u0004\u0001\u0003\u0003%\t!a\u0004\u0002\t\r|\u0007/\u001f\u000b\u0006_\u0005E\u00111\u0003\u0005\tC\u0005-\u0001\u0013!a\u0001G!A\u0011&a\u0003\u0011\u0002\u0003\u00071\u0005C\u0005\u0002\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u000eU\r\u0019\u0013QD\u0016\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011F\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0005\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0007\u0001\u0012\u0002\u0013\u0005\u0011\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t)\u0004AA\u0001\n\u0003\n9$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0003mC:<'BAA\"\u0003\u0011Q\u0017M^1\n\u0007}\u000bi\u0004\u0003\u0005\u0002J\u0001\t\t\u0011\"\u0001d\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\ti\u0005AA\u0001\n\u0003\ty%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u00071\f\t\u0006C\u0005\u0002T\u0005-\u0013\u0011!a\u0001I\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005]\u0003!!A\u0005B\u0005e\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0003#BA/\u0003GbWBAA0\u0015\r\t\t'G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA3\u0003?\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003S\u0002\u0011\u0011!C\u0001\u0003W\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004)\u00065\u0004\"CA*\u0003O\n\t\u00111\u0001m\u0011%\t\t\bAA\u0001\n\u0003\n\u0019(\u0001\u0004fcV\fGn\u001d\u000b\u0004)\u0006U\u0004\"CA*\u0003_\n\t\u00111\u0001mQ-\u0001\u0011\u0011PA@\u0003\u0003\u000b))a\"\u0011\u0007E\tY(C\u0002\u0002~\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0004\u0006qxLR+O\u0007~CC-\u0019;fY\u00012W\u000e^\u0015![\u0001\u0012V\r^;s]N\u0004\u0003\rZ1uK\u0002\u0004s/\u001b;iAQDW\r\t;j[\u0016\u0004\u0003o\u001c:uS>t\u0007e\u001c4!i\",\u0007\u0005Z1zAQ\u0014XO\\2bi\u0016$\u0007\u0005^8!i\",\u0007%\u001e8ji\u0002\u001a\b/Z2jM&,G\r\t2zAQDW\r\t4pe6\fG\u000fI7pI\u0016d\u0007\u0005\u00194ni\u0002t\u0013\u0001C3yi\u0016tG-\u001a3\"\u0005\u0005%\u0015!a\u0007\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004\u0007M\u001d.aIj\u0013GM\u0014-A\u001djUjJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0004'O\u00171e5\u0002\u0014G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nT'L\u00191[I:t\u0005\f\u0011(3\u0016\u000b%kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171c5\u0002\u0014G\u0003\u0011!\u000f%\tiIAA\u0001\u0012\u0003\ty)A\u0005UeVt7\rR1uKB\u0019\u0011#!%\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003'\u001bR!!%\u0002\u0016v\u0001r!a&\u0002\u001e\u000e\u001as&\u0004\u0002\u0002\u001a*\u0019\u00111T\r\u0002\u000fI,h\u000e^5nK&!\u0011qTAM\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b[\u0005EE\u0011AAR)\t\ty\t\u0003\u0006\u0002(\u0006E\u0015\u0011!C#\u0003S\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003sA!\"!,\u0002\u0012\u0006\u0005I\u0011QAX\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y\u0013\u0011WAZ\u0011\u0019\t\u00131\u0016a\u0001G!1\u0011&a+A\u0002\rB!\"a.\u0002\u0012\u0006\u0005I\u0011QA]\u0003\u001d)h.\u00199qYf$B!a/\u0002HB)\u0001$!0\u0002B&\u0019\u0011qX\r\u0003\r=\u0003H/[8o!\u0015A\u00121Y\u0012$\u0013\r\t)-\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005%\u0017QWA\u0001\u0002\u0004y\u0013a\u0001=%a!Q\u0011QZAI\u0003\u0003%I!a4\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u0004B!a\u000f\u0002T&!\u0011Q[A\u001f\u0005\u0019y%M[3di\u0002")
public class TruncDate
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression date;
    private final Expression format;
    private int truncLevel;
    private volatile boolean bitmap$0;

    public static Function1<Tuple2<Expression, Expression>, TruncDate> tupled() {
        return TruncDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TruncDate>> curried() {
        return TruncDate$.MODULE$.curried();
    }

    private int truncLevel$lzycompute() {
        TruncDate truncDate = this;
        synchronized (truncDate) {
            if (!this.bitmap$0) {
                this.truncLevel = DateTimeUtils$.MODULE$.parseTruncLevel((UTF8String)this.format().eval(this.format().eval$default$1()));
                this.bitmap$0 = true;
            }
            return this.truncLevel;
        }
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression date() {
        return this.date;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Expression left() {
        return this.date();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "trunc";
    }

    private int truncLevel() {
        return this.bitmap$0 ? this.truncLevel : this.truncLevel$lzycompute();
    }

    @Override
    public Object eval(InternalRow input) {
        Object d;
        int level;
        int n = level = this.format().foldable() ? this.truncLevel() : DateTimeUtils$.MODULE$.parseTruncLevel((UTF8String)this.format().eval(this.format().eval$default$1()));
        Integer n2 = level == -1 ? null : ((d = this.date().eval(input)) == null ? null : BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.truncDate(BoxesRunTime.unboxToInt((Object)d), level)));
        return n2;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        if (this.format().foldable()) {
            if (this.truncLevel() == -1) {
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType())})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                ExprCode d = this.date().genCode(ctx);
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".truncDate(", ", ", ");\n          }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d.code(), ev.isNull(), d.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType()), ev.isNull(), ev.value(), dtu, d.value(), BoxesRunTime.boxToInteger((int)this.truncLevel())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev, dtu){
                public static final long serialVersionUID = 0L;
                private final CodegenContext ctx$3;
                private final ExprCode ev$7;
                private final String dtu$16;

                public final String apply(String dateVal, String fmt) {
                    String form = this.ctx$3.freshName("form");
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          int ", " = ", ".parseTruncLevel(", ");\n          if (", " == -1) {\n            ", " = true;\n          } else {\n            ", " = ", ".truncDate(", ", ", ");\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{form, this.dtu$16, fmt, form, this.ev$7.isNull(), this.ev$7.value(), this.dtu$16, dateVal, form}));
                }
                {
                    this.ctx$3 = ctx$3;
                    this.ev$7 = ev$7;
                    this.dtu$16 = dtu$16;
                }
            });
        }
        return exprCode;
    }

    public TruncDate copy(Expression date, Expression format2) {
        return new TruncDate(date, format2);
    }

    public Expression copy$default$1() {
        return this.date();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "TruncDate";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.format();
                break;
            }
            case 0: {
                expression = this.date();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncDate truncDate = (TruncDate)x$1;
        Expression expression = this.date();
        Expression expression2 = truncDate.date();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = truncDate.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!truncDate.canEqual(this)) return false;
        return true;
    }

    public TruncDate(Expression date, Expression format2) {
        this.date = date;
        this.format = format2;
        ExpectsInputTypes$class.$init$(this);
    }
}

