/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([expr[, pattern]]) - Returns the UNIX timestamp of current or specified time.", extended="\n    Examples:\n      > SELECT _FUNC_();\n       1476884637\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460041200\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001>\u0011Q\"\u00168jqRKW.Z:uC6\u0004(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u0007\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001\"\u00168jqRKW.\u001a\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\b!J|G-^2u!\t)2$\u0003\u0002\u001d-\ta1+\u001a:jC2L'0\u00192mK\"Aa\u0004\u0001BK\u0002\u0013\u0005q$A\u0004uS6,W\t\u001f9\u0016\u0003\u0001\u0002\"!E\u0011\n\u0005\t\u0012!AC#yaJ,7o]5p]\"AA\u0005\u0001B\tB\u0003%\u0001%\u0001\u0005uS6,W\t\u001f9!\u0011!1\u0003A!f\u0001\n\u0003y\u0012A\u00024pe6\fG\u000f\u0003\u0005)\u0001\tE\t\u0015!\u0003!\u0003\u001d1wN]7bi\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017.]A\u0011\u0011\u0003\u0001\u0005\u0006=%\u0002\r\u0001\t\u0005\u0006M%\u0002\r\u0001\t\u0005\u0006a\u0001!\teH\u0001\u0005Y\u00164G\u000fC\u00033\u0001\u0011\u0005s$A\u0003sS\u001eDG\u000fC\u0003+\u0001\u0011\u0005A\u0007\u0006\u0002-k!)ag\ra\u0001A\u0005!A/[7f\u0011\u0015Q\u0003\u0001\"\u00019)\u0005a\u0003\"\u0002\u001e\u0001\t\u0003Z\u0014A\u00039sKR$\u0018PT1nKV\tA\b\u0005\u0002>\u0001:\u0011QCP\u0005\u0003\u007fY\ta\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qH\u0006\u0005\b\t\u0002\t\t\u0011\"\u0001F\u0003\u0011\u0019w\u000e]=\u0015\u000712u\tC\u0004\u001f\u0007B\u0005\t\u0019\u0001\u0011\t\u000f\u0019\u001a\u0005\u0013!a\u0001A!9\u0011\nAI\u0001\n\u0003Q\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002\u0017*\u0012\u0001\u0005T\u0016\u0002\u001bB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u0015\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002U\u001f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fY\u0003\u0011\u0013!C\u0001\u0015\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004b\u0002-\u0001\u0003\u0003%\t%W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\t1\fgn\u001a\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tE\fC\u0004c\u0001\u0005\u0005I\u0011A2\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003\u0011\u0004\"!F3\n\u0005\u00194\"aA%oi\"9\u0001\u000eAA\u0001\n\u0003I\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0003U6\u0004\"!F6\n\u000514\"aA!os\"9anZA\u0001\u0002\u0004!\u0017a\u0001=%c!9\u0001\u000fAA\u0001\n\u0003\n\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003I\u00042a\u001d<k\u001b\u0005!(BA;\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003oR\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\bs\u0002\t\t\u0011\"\u0001{\u0003!\u0019\u0017M\\#rk\u0006dGCA>\u007f!\t)B0\u0003\u0002~-\t9!i\\8mK\u0006t\u0007b\u00028y\u0003\u0003\u0005\rA\u001b\u0005\n\u0003\u0003\u0001\u0011\u0011!C!\u0003\u0007\ta!Z9vC2\u001cHcA>\u0002\u0006!9an`A\u0001\u0002\u0004Q\u0007f\u0003\u0001\u0002\n\u0005=\u0011\u0011CA\u000b\u0003/\u00012!EA\u0006\u0013\r\tiA\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019\"\u0001+`\rVs5i\u0018\u0015\\Kb\u0004(o\u0017\u0017!a\u0006$H/\u001a:o;vK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u0016(J1\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI8gA\r,(O]3oi\u0002z'\u000fI:qK\u000eLg-[3eAQLW.\u001a\u0018\u0002\u0011\u0015DH/\u001a8eK\u0012\f#!!\u0007\u0002\u0003\u0007Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cQ:d\u0007\u000f\u001d5mM:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001b.aa:C\u0006I\u0014zsfLX&T'.I\u0012<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112iY\u0002\u0004\u0007N\u00193aAR\u0001\u0005I\u0004\n\u0003;\u0011\u0011\u0011!E\u0001\u0003?\tQ\"\u00168jqRKW.Z:uC6\u0004\bcA\t\u0002\"\u0019A\u0011AAA\u0001\u0012\u0003\t\u0019cE\u0003\u0002\"\u0005\u0015\"\u0004E\u0004\u0002(\u00055\u0002\u0005\t\u0017\u000e\u0005\u0005%\"bAA\u0016-\u00059!/\u001e8uS6,\u0017\u0002BA\u0018\u0003S\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001dQ\u0013\u0011\u0005C\u0001\u0003g!\"!a\b\t\u0015\u0005]\u0012\u0011EA\u0001\n\u000b\nI$\u0001\u0005u_N#(/\u001b8h)\u0005Q\u0006BCA\u001f\u0003C\t\t\u0011\"!\u0002@\u0005)\u0011\r\u001d9msR)A&!\u0011\u0002D!1a$a\u000fA\u0002\u0001BaAJA\u001e\u0001\u0004\u0001\u0003BCA$\u0003C\t\t\u0011\"!\u0002J\u00059QO\\1qa2LH\u0003BA&\u0003/\u0002R!FA'\u0003#J1!a\u0014\u0017\u0005\u0019y\u0005\u000f^5p]B)Q#a\u0015!A%\u0019\u0011Q\u000b\f\u0003\rQ+\b\u000f\\33\u0011%\tI&!\u0012\u0002\u0002\u0003\u0007A&A\u0002yIAB!\"!\u0018\u0002\"\u0005\u0005I\u0011BA0\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0004cA.\u0002d%\u0019\u0011Q\r/\u0003\r=\u0013'.Z2u\u0001")
public class UnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;

    public static Function1<Tuple2<Expression, Expression>, UnixTimestamp> tupled() {
        return UnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, UnixTimestamp>> curried() {
        return UnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "unix_timestamp";
    }

    public UnixTimestamp copy(Expression timeExp, Expression format2) {
        return new UnixTimestamp(timeExp, format2);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "UnixTimestamp";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.format();
                break;
            }
            case 0: {
                expression = this.timeExp();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnixTimestamp unixTimestamp = (UnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = unixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = unixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!unixTimestamp.canEqual(this)) return false;
        return true;
    }

    public UnixTimestamp(Expression timeExp, Expression format2) {
        this.timeExp = timeExp;
        this.format = format2;
    }

    public UnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply("yyyy-MM-dd HH:mm:ss"));
    }

    public UnixTimestamp() {
        this(new CurrentTimestamp());
    }
}

