/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage) - Returns the exact percentile value of numeric column `col` at the\n      given percentage. The value of percentage must be between 0.0 and 1.0.\n\n      _FUNC_(col, array(percentage1 [, percentage2]...)) - Returns the exact percentile value array\n      of numeric column `col` at the given percentage(s). Each value of the percentage array must\n      be between 0.0 and 1.0.\n    ")
@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001B\u0001\u0003\u0001F\u0011!\u0002U3sG\u0016tG/\u001b7f\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%\u001dR\u0003cA\n\u0015-5\t!!\u0003\u0002\u0016\u0005\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\t]ab\u0004J\u0007\u00021)\u0011\u0011DG\u0001\u000bG>dG.Z2uS>t'BA\u000e\u000b\u0003\u0011)H/\u001b7\n\u0005uA\"aC(qK:D\u0015m\u001d5NCB\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0010&\u0013\t1\u0003E\u0001\u0003M_:<\u0007CA\u0010)\u0013\tI\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005}Y\u0013B\u0001\u0017!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!q\u0003A!f\u0001\n\u0003y\u0013!B2iS2$W#\u0001\u0019\u0011\u0005E\u0012T\"\u0001\u0003\n\u0005M\"!AC#yaJ,7o]5p]\"AQ\u0007\u0001B\tB\u0003%\u0001'\u0001\u0004dQ&dG\r\t\u0005\to\u0001\u0011)\u001a!C\u0001_\u0005!\u0002/\u001a:dK:$\u0018mZ3FqB\u0014Xm]:j_:D\u0001\"\u000f\u0001\u0003\u0012\u0003\u0006I\u0001M\u0001\u0016a\u0016\u00148-\u001a8uC\u001e,W\t\u001f9sKN\u001c\u0018n\u001c8!\u0011!Y\u0004A!f\u0001\n\u0003a\u0014AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003u\u0002\"a\b \n\u0005}\u0002#aA%oi\"A\u0011\t\u0001B\tB\u0003%Q(A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA!A1\t\u0001BK\u0002\u0013\u0005A(\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005{\u0005)\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0003\"B$\u0001\t\u0003A\u0015A\u0002\u001fj]&$h\bF\u0003J\u0015.cU\n\u0005\u0002\u0014\u0001!)aF\u0012a\u0001a!)qG\u0012a\u0001a!91H\u0012I\u0001\u0002\u0004i\u0004bB\"G!\u0003\u0005\r!\u0010\u0005\u0006\u000f\u0002!\ta\u0014\u000b\u0004\u0013B\u000b\u0006\"\u0002\u0018O\u0001\u0004\u0001\u0004\"B\u001cO\u0001\u0004\u0001\u0004\"B*\u0001\t\u0003\"\u0016A\u00039sKR$\u0018PT1nKV\tQ\u000b\u0005\u0002W3:\u0011qdV\u0005\u00031\u0002\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001\f\t\u0005\u0006;\u0002!\tEX\u0001\u001eo&$\bNT3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0011\u0011j\u0018\u0005\u0006Ar\u0003\r!P\u0001\u001a]\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fC\u0003c\u0001\u0011\u00053-A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0003\u0013\u0012DQ!Z1A\u0002u\nqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\u0011\u001d\u0004\u0001R1A\u0005\n!\fQC]3ukJt\u0007+\u001a:dK:$\u0018\u000e\\3BeJ\f\u00170F\u0001j!\ty\".\u0003\u0002lA\t9!i\\8mK\u0006t\u0007\u0002C7\u0001\u0011\u0003\u0005\u000b\u0015B5\u0002-I,G/\u001e:o!\u0016\u00148-\u001a8uS2,\u0017I\u001d:bs\u0002B#\u0001\\8\u0011\u0005}\u0001\u0018BA9!\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005t\u0001!\u0015\r\u0011\"\u0003u\u0003-\u0001XM]2f]R\fw-Z:\u0016\u0003U\u00042A\u001e={\u001b\u00059(BA\r!\u0013\tIxOA\u0002TKF\u0004\"aH>\n\u0005q\u0004#A\u0002#pk\ndW\r\u0003\u0005\u007f\u0001!\u0005\t\u0015)\u0003v\u00031\u0001XM]2f]R\fw-Z:!Q\tix\u000eC\u0004\u0002\u0004\u0001!\t%!\u0002\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"!a\u0002\u0011\u000b\u0005%\u0011\u0011\u0004\u0019\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013bAA\fA\u00059\u0001/Y2lC\u001e,\u0017bA=\u0002\u001c)\u0019\u0011q\u0003\u0011\t\r\u0005}\u0001\u0001\"\u0011i\u0003!qW\u000f\u001c7bE2,\u0007BCA\u0012\u0001!\u0015\r\u0011\"\u0011\u0002&\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.!\tQ\u0001^=qKNLA!!\r\u0002,\tAA)\u0019;b)f\u0004X\r\u0003\u0006\u00026\u0001A\t\u0011)Q\u0005\u0003O\t\u0011\u0002Z1uCRK\b/\u001a\u0011\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005u\u0002CBA\u0005\u00033\ty\u0004\u0005\u0003\u0002*\u0005\u0005\u0013\u0002BA\"\u0003W\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J\u0005\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\u0004\u0002\u0011\u0005t\u0017\r\\=tSNLA!!\u0016\u0002P\tyA+\u001f9f\u0007\",7m\u001b*fgVdG\u000fC\u0004\u0002Z\u0001!I!a\u0017\u0002\u001bQ|Gi\\;cY\u00164\u0016\r\\;f)\rQ\u0018Q\f\u0005\t\u0003?\n9\u00061\u0001\u0002b\u0005\tA\rE\u0002 \u0003GJ1!!\u001a!\u0005\r\te.\u001f\u0005\b\u0003S\u0002A\u0011IA6\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001\u0017\u0011\u001d\ty\u0007\u0001C!\u0003c\na!\u001e9eCR,GCBA:\u0003s\ni\bE\u0002 \u0003kJ1!a\u001e!\u0005\u0011)f.\u001b;\t\u000f\u0005m\u0014Q\u000ea\u0001-\u00051!-\u001e4gKJD\u0001\"a \u0002n\u0001\u0007\u0011\u0011Q\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u0007\u000b))D\u0001\u0007\u0013\r\t9I\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0004\u0002\f\u0002!\t%!$\u0002\u000b5,'oZ3\u0015\r\u0005M\u0014qRAI\u0011\u001d\tY(!#A\u0002YAq!a%\u0002\n\u0002\u0007a#A\u0003pi\",'\u000fC\u0004\u0002\u0018\u0002!\t%!'\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003C\nY\nC\u0004\u0002|\u0005U\u0005\u0019\u0001\f\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\u0006qq-\u001a;QKJ\u001cWM\u001c;jY\u0016\u001cH\u0003BAR\u0003K\u0003R!!\u0003\u0002\u001aiDq!a\u001f\u0002\u001e\u0002\u0007a\u0003C\u0004\u0002*\u0002!I!a+\u0002\u001d\u001d,g.\u001a:bi\u0016|U\u000f\u001e9viR!\u0011\u0011MAW\u0011!\ty+a*A\u0002\u0005\r\u0016a\u0002:fgVdGo\u001d\u0005\b\u0003g\u0003A\u0011BA[\u000359W\r\u001e)fe\u000e,g\u000e^5mKR)!0a.\u0002D\"A\u0011\u0011XAY\u0001\u0004\tY,A\u0006bO\u001e\u0014XmQ8v]R\u001c\bCBA\u0005\u00033\ti\fE\u0003 \u0003\u007fsB%C\u0002\u0002B\u0002\u0012a\u0001V;qY\u0016\u0014\u0004bBAc\u0003c\u0003\rA_\u0001\ta>\u001c\u0018\u000e^5p]\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0017!\u00052j]\u0006\u0014\u0018pU3be\u000eD7i\\;oiRIQ(!4\u0002X\u0006m\u0017q\u001c\u0005\t\u0003\u001f\f9\r1\u0001\u0002R\u0006Y1m\\;oiN\f%O]1z!\u0011y\u00121\u001b\u0013\n\u0007\u0005U\u0007EA\u0003BeJ\f\u0017\u0010C\u0004\u0002Z\u0006\u001d\u0007\u0019A\u001f\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005u\u0017q\u0019a\u0001{\u0005\u0019QM\u001c3\t\u000f\u0005\u0005\u0018q\u0019a\u0001I\u0005)a/\u00197vK\"9\u0011Q\u001d\u0001\u0005B\u0005\u001d\u0018!C:fe&\fG.\u001b>f)\u0011\tI/!=\u0011\u000b}\t\u0019.a;\u0011\u0007}\ti/C\u0002\u0002p\u0002\u0012AAQ=uK\"9\u00111_Ar\u0001\u00041\u0012aA8cU\"9\u0011q\u001f\u0001\u0005B\u0005e\u0018a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2AFA~\u0011!\ti0!>A\u0002\u0005%\u0018!\u00022zi\u0016\u001c\b\"\u0003B\u0001\u0001\u0005\u0005I\u0011\u0001B\u0002\u0003\u0011\u0019w\u000e]=\u0015\u0013%\u0013)Aa\u0002\u0003\n\t-\u0001\u0002\u0003\u0018\u0002\u0000B\u0005\t\u0019\u0001\u0019\t\u0011]\ny\u0010%AA\u0002AB\u0001bOA\u0000!\u0003\u0005\r!\u0010\u0005\t\u0007\u0006}\b\u0013!a\u0001{!I!q\u0002\u0001\u0012\u0002\u0013\u0005!\u0011C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019BK\u00021\u0005+Y#Aa\u0006\u0011\t\te!1E\u0007\u0003\u00057QAA!\b\u0003 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005C\u0001\u0013AC1o]>$\u0018\r^5p]&!!Q\u0005B\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005S\u0001\u0011\u0013!C\u0001\u0005#\tabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0003.\u0001\t\n\u0011\"\u0001\u00030\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0019U\ri$Q\u0003\u0005\n\u0005k\u0001\u0011\u0013!C\u0001\u0005_\tabY8qs\u0012\"WMZ1vYR$C\u0007C\u0005\u0003:\u0001\t\t\u0011\"\u0011\u0003<\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0010\u0011\t\t}\"\u0011J\u0007\u0003\u0005\u0003RAAa\u0011\u0003F\u0005!A.\u00198h\u0015\t\u00119%\u0001\u0003kCZ\f\u0017b\u0001.\u0003B!A!Q\n\u0001\u0002\u0002\u0013\u0005A(\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0003R\u0001\t\t\u0011\"\u0001\u0003T\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA1\u0005+B\u0011Ba\u0016\u0003P\u0005\u0005\t\u0019A\u001f\u0002\u0007a$\u0013\u0007C\u0005\u0003\\\u0001\t\t\u0011\"\u0011\u0003^\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003`A)aO!\u0019\u0002b%\u0019!1M<\u0003\u0011%#XM]1u_JD\u0011Ba\u001a\u0001\u0003\u0003%\tA!\u001b\u0002\u0011\r\fg.R9vC2$2!\u001bB6\u0011)\u00119F!\u001a\u0002\u0002\u0003\u0007\u0011\u0011\r\u0005\n\u0005_\u0002\u0011\u0011!C!\u0005c\na!Z9vC2\u001cHcA5\u0003t!Q!q\u000bB7\u0003\u0003\u0005\r!!\u0019)\u000f\u0001\u00119H! \u0003\u0000A\u0019\u0011G!\u001f\n\u0007\tmDAA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t\u0005\u0015aa\r\u000bA\u0001\u0002\u0003\u0005\t\u0011`\rVs5i\u0018\u0015d_2d\u0003\u0005]3sG\u0016tG/Y4fS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002*\u00070Y2uAA,'oY3oi&dW\r\t<bYV,\u0007e\u001c4!]VlWM]5dA\r|G.^7oA\u0001\u001cw\u000e\u001c1!CR\u0004C\u000f[3\u000bA\u0001\u0002\u0003\u0005\t\u0011hSZ,g\u000e\t9fe\u000e,g\u000e^1hK:\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u0002\u0002XM]2f]R\fw-\u001a\u0011nkN$\bEY3!E\u0016$x/Z3oAAr\u0003\u0007I1oI\u0002\nd\u0006\r\u0018\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!?\u001a+fjQ0)G>dG\u0006I1se\u0006L\b\u0006]3sG\u0016tG/Y4fc\u0001ZF\u0006\t9fe\u000e,g\u000e^1hKJjfF\f\u0018*S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002*\u00070Y2uAA,'oY3oi&dW\r\t<bYV,\u0007%\u0019:sCfT\u0001\u0005\t\u0011!A\u0001zg\r\t8v[\u0016\u0014\u0018n\u0019\u0011d_2,XN\u001c\u0011aG>d\u0007\rI1uAQDW\rI4jm\u0016t\u0007\u0005]3sG\u0016tG/Y4fQMLc\u0006I#bG\"\u0004c/\u00197vK\u0002zg\r\t;iK\u0002\u0002XM]2f]R\fw-\u001a\u0011beJ\f\u0017\u0010I7vgRT\u0001\u0005\t\u0011!A\u0001\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002dF\u0003\u0011!A\u0001:\u0011B!\"\u0003\u0003\u0003E\tAa\"\u0002\u0015A+'oY3oi&dW\rE\u0002\u0014\u0005\u00133\u0001\"\u0001\u0002\u0002\u0002#\u0005!1R\n\u0006\u0005\u0013\u0013iI\u000b\t\n\u0005\u001f\u0013)\n\r\u0019>{%k!A!%\u000b\u0007\tM\u0005%A\u0004sk:$\u0018.\\3\n\t\t]%\u0011\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004bB$\u0003\n\u0012\u0005!1\u0014\u000b\u0003\u0005\u000fC!Ba(\u0003\n\u0006\u0005IQ\tBQ\u0003!!xn\u0015;sS:<GC\u0001B\u001f\u0011)\u0011)K!#\u0002\u0002\u0013\u0005%qU\u0001\u0006CB\u0004H.\u001f\u000b\n\u0013\n%&1\u0016BW\u0005_CaA\fBR\u0001\u0004\u0001\u0004BB\u001c\u0003$\u0002\u0007\u0001\u0007\u0003\u0005<\u0005G\u0003\n\u00111\u0001>\u0011!\u0019%1\u0015I\u0001\u0002\u0004i\u0004B\u0003BZ\u0005\u0013\u000b\t\u0011\"!\u00036\u00069QO\\1qa2LH\u0003\u0002B\\\u0005\u0007\u0004Ra\bB]\u0005{K1Aa/!\u0005\u0019y\u0005\u000f^5p]B9qDa01auj\u0014b\u0001BaA\t1A+\u001e9mKRB\u0011B!2\u00032\u0006\u0005\t\u0019A%\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003J\n%\u0015\u0013!C\u0001\u0005_\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003Bg\u0005\u0013\u000b\n\u0011\"\u0001\u00030\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQB!B!5\u0003\nF\u0005I\u0011\u0001B\u0018\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003Bk\u0005\u0013\u000b\n\u0011\"\u0001\u00030\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0003Z\n%\u0015\u0011!C\u0005\u00057\f1B]3bIJ+7o\u001c7wKR\u0011!Q\u001c\t\u0005\u0005\u007f\u0011y.\u0003\u0003\u0003b\n\u0005#AB(cU\u0016\u001cG\u000f")
public class Percentile
extends TypedImperativeAggregate<OpenHashMap<Object, Object>>
implements Product,
Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient boolean returnPercentileArray;
    private transient Seq<Object> percentages;
    private DataType dataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return Percentile$.MODULE$.apply$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return Percentile$.MODULE$.$lessinit$greater$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Percentile>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    private boolean returnPercentileArray$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.returnPercentileArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Seq percentages$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Seq seq;
                Object num;
                Tuple2 tuple2 = new Tuple2((Object)this.percentageExpression().dataType(), this.percentageExpression().eval(this.percentageExpression().eval$default$1()));
                if (tuple2 != null && (num = tuple2._2()) instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)num);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{d}));
                } else {
                    ArrayType arrayType2;
                    DataType baseType;
                    if (tuple2 == null) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    DataType dataType2 = (DataType)tuple2._1();
                    Object arrayData = tuple2._2();
                    if (!(dataType2 instanceof ArrayType) || !((baseType = (arrayType2 = (ArrayType)dataType2).elementType()) instanceof NumericType)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    NumericType numericType = (NumericType)baseType;
                    if (!(arrayData instanceof ArrayData)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    ArrayData arrayData2 = (ArrayData)arrayData;
                    Object[] numericArray = arrayData2.toObjectArray(numericType);
                    seq = Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps(numericArray).map((Function1)new Serializable(this, numericType){
                        public static final long serialVersionUID = 0L;
                        private final NumericType x7$1;

                        public final double apply(Object x) {
                            return this.x7$1.numeric().toDouble(x);
                        }
                        {
                            this.x7$1 = x7$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSeq();
                }
                this.percentages = seq;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.percentages;
        }
    }

    private DataType dataType$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$0) {
                DataType dataType2 = this.percentageExpression().dataType();
                DataType dataType3 = dataType2 instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
                this.dataType = dataType3;
                this.bitmap$0 = true;
            }
            return this.dataType;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$7 = newMutableAggBufferOffset;
        Expression x$8 = this.copy$default$1();
        Expression x$9 = this.copy$default$2();
        int x$10 = this.copy$default$4();
        return this.copy(x$8, x$9, x$7, x$10);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$11 = newInputAggBufferOffset;
        Expression x$12 = this.copy$default$1();
        Expression x$13 = this.copy$default$2();
        int x$14 = this.copy$default$3();
        return this.copy(x$12, x$13, x$14, x$11);
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private Seq<Object> percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.percentageExpression();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.bitmap$0 ? this.dataType : this.dataType$lzycompute();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        DataType dataType2 = this.percentageExpression().dataType();
        Seq seq = dataType2 instanceof ArrayType ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, ArrayType$.MODULE$})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DoubleType$.MODULE$}));
        return seq;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.percentageExpression().foldable() ? (this.percentages().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double percentage) {
                return this.apply$mcZD$sp(percentage);
            }

            public boolean apply$mcZD$sp(double percentage) {
                return percentage < 0.0 || percentage > 1.0;
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)"Percentage(s) must be between 0.0 and 1.0, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.percentageExpression()}))).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$) : new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)"The percentage(s) must be a constant literal, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.percentageExpression()}))).toString()));
    }

    private double toDoubleValue(Object d) {
        Object object;
        block4: {
            double d2;
            block3: {
                block2: {
                    object = d;
                    if (!(object instanceof Decimal)) break block2;
                    Decimal decimal = (Decimal)object;
                    d2 = decimal.toDouble();
                    break block3;
                }
                if (!(object instanceof Number)) break block4;
                Number number = (Number)object;
                d2 = number.doubleValue();
            }
            return d2;
        }
        throw new MatchError(object);
    }

    @Override
    public OpenHashMap<Object, Object> createAggregationBuffer() {
        return new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
    }

    @Override
    public void update(OpenHashMap<Object, Object> buffer, InternalRow input) {
        Object key = this.child().eval(input);
        if (key != null) {
            buffer.changeValue$mcJ$sp(key, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 1L;
                }
            }, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(long x$3) {
                    return this.apply$mcJJ$sp(x$3);
                }

                public long apply$mcJJ$sp(long x$3) {
                    return x$3 + 1L;
                }
            });
        }
    }

    @Override
    public void merge(OpenHashMap<Object, Object> buffer, OpenHashMap<Object, Object> other) {
        other.foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final OpenHashMap buffer$1;

            public final long apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    long count = tuple2._2$mcJ$sp();
                    long l = this.buffer$1.changeValue$mcJ$sp(key, (Function0)new Serializable(this, count){
                        public static final long serialVersionUID = 0L;
                        private final long count$1;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.count$1;
                        }
                        {
                            this.count$1 = count$1;
                        }
                    }, (Function1)new Serializable(this, count){
                        public static final long serialVersionUID = 0L;
                        private final long count$1;

                        public final long apply(long x$4) {
                            return this.apply$mcJJ$sp(x$4);
                        }

                        public long apply$mcJJ$sp(long x$4) {
                            return x$4 + this.count$1;
                        }
                        {
                            this.count$1 = count$1;
                        }
                    });
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
    }

    @Override
    public Object eval(OpenHashMap<Object, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private Seq<Object> getPercentiles(OpenHashMap<Object, Object> buffer) {
        if (buffer.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Seq sortedCounts = (Seq)buffer.toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Tuple2<Object, Object> x$5) {
                return x$5._1();
            }
        }, ((NumericType)this.child().dataType()).ordering());
        Seq accumlatedCounts = (Seq)((TraversableLike)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$2, Tuple2<Object, Object> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        long count1 = tuple22._2$mcJ$sp();
                        if (tuple23 != null) {
                            Object key2 = tuple23._1();
                            long count2 = tuple23._2$mcJ$sp();
                            Tuple2 tuple24 = new Tuple2(key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
                            return tuple24;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).tail();
        long maxPosition = ((Tuple2)accumlatedCounts.last())._2$mcJ$sp() - 1L;
        return (Seq)this.percentages().map((Function1)new Serializable(this, accumlatedCounts, maxPosition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Percentile $outer;
            private final Seq accumlatedCounts$1;
            private final long maxPosition$1;

            public final double apply(double percentile) {
                return this.apply$mcDD$sp(percentile);
            }

            public double apply$mcDD$sp(double percentile) {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$Percentile$$getPercentile((Seq<Tuple2<Object, Object>>)this.accumlatedCounts$1, (double)this.maxPosition$1 * percentile);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.accumlatedCounts$1 = accumlatedCounts$1;
                this.maxPosition$1 = maxPosition$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Object generateOutput(Seq<Object> results) {
        return results.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData(results) : results.head());
    }

    public double org$apache$spark$sql$catalyst$expressions$aggregate$Percentile$$getPercentile(Seq<Tuple2<Object, Object>> aggreCounts, double position2) {
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position2));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position2));
        long[] countsArray = (long[])((TraversableOnce)aggreCounts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Object> x$6) {
                return x$6._2$mcJ$sp();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), higher + 1L);
        Object lowerKey = ((Tuple2)aggreCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return this.toDoubleValue(lowerKey);
        }
        Object higherKey = ((Tuple2)aggreCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equals((Object)higherKey, (Object)lowerKey)) {
            return this.toDoubleValue(lowerKey);
        }
        return ((double)higher - position2) * this.toDoubleValue(lowerKey) + (position2 - (double)lower) * this.toDoubleValue(higherKey);
    }

    private int binarySearchCount(long[] countsArray, int start, int end, long value2) {
        int n = Arrays.binarySearch(countsArray, 0, end, value2);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    @Override
    public byte[] serialize(OpenHashMap<Object, Object> obj) {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.child().dataType(), LongType$.MODULE$}));
            obj.foreach((Function1)new Serializable(this, buffer, out, projection){
                public static final long serialVersionUID = 0L;
                private final byte[] buffer$2;
                private final DataOutputStream out$1;
                private final UnsafeProjection projection$1;

                public final void apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        long count = tuple2._2$mcJ$sp();
                        InternalRow row = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)count)}));
                        UnsafeRow unsafeRow = this.projection$1.apply(row);
                        this.out$1.writeInt(unsafeRow.getSizeInBytes());
                        unsafeRow.writeToStream(this.out$1, this.buffer$2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.buffer$2 = buffer$2;
                    this.out$1 = out$1;
                    this.projection$1 = projection$1;
                }
            });
            out.writeInt(-1);
            out.flush();
            return bos.toByteArray();
        }
        finally {
            out.close();
            bos.close();
        }
    }

    @Override
    public OpenHashMap<Object, Object> deserialize(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            OpenHashMap.mcJ.sp counts = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
            int sizeOfNextRow = ins.readInt();
            while (sizeOfNextRow >= 0) {
                byte[] bs = new byte[sizeOfNextRow];
                ins.readFully(bs);
                UnsafeRow row = new UnsafeRow(2);
                row.pointTo(bs, sizeOfNextRow);
                Object key = row.get(0, this.child().dataType());
                long count = BoxesRunTime.unboxToLong((Object)row.get(1, LongType$.MODULE$));
                counts.update$mcJ$sp(key, count);
                sizeOfNextRow = ins.readInt();
            }
            return counts;
        }
        finally {
            ins.close();
            bis.close();
        }
    }

    public Percentile copy(Expression child, Expression percentageExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new Percentile(child, percentageExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public Percentile(Expression child, Expression percentageExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, 0, 0);
    }
}

