/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathLong$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a long integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", extended="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001F\u0011\u0011\u0002\u0017)bi\"duN\\4\u000b\u0005\r!\u0011a\u0001=nY*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%Ya\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00051A\u0006+\u0019;i\u000bb$(/Y2u!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u001d\u0001&o\u001c3vGR\u0004\"aF\u000f\n\u0005yA\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0002\u0001\u0005+\u0007I\u0011\u0001\u0011\u0016\u0003\u0005\u0002\"AI\u0012\u000e\u0003\u0011I!\u0001\n\u0003\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005'\u0001\tE\t\u0015!\u0003\"\u0003\u0011AX\u000e\u001c\u0011\t\u0011!\u0002!Q3A\u0005\u0002\u0001\nA\u0001]1uQ\"A!\u0006\u0001B\tB\u0003%\u0011%A\u0003qCRD\u0007\u0005C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004CA\n\u0001\u0011\u0015\u00191\u00061\u0001\"\u0011\u0015A3\u00061\u0001\"\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002iA\u0011Q\u0007\u000f\b\u0003/YJ!a\u000e\r\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003oaAQ\u0001\u0010\u0001\u0005Bu\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tC\u0001\u0006if\u0004Xm]\u0005\u0003\u0007\u0002\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006\u000b\u0002!\tER\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004\u000f*[\u0005CA\fI\u0013\tI\u0005DA\u0002B]fDQa\u0001#A\u0002\u001dCQ\u0001\u000b#A\u0002\u001dCq!\u0014\u0001\u0002\u0002\u0013\u0005a*\u0001\u0003d_BLHc\u0001\u0018P!\"91\u0001\u0014I\u0001\u0002\u0004\t\u0003b\u0002\u0015M!\u0003\u0005\r!\t\u0005\b%\u0002\t\n\u0011\"\u0001T\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u0016\u0016\u0003CU[\u0013A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005mC\u0012AC1o]>$\u0018\r^5p]&\u0011Q\f\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB0\u0001#\u0003%\taU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001d\t\u0007!!A\u0005B\t\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017\u0001\u00027b]\u001eT\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002:K\"91\u000eAA\u0001\n\u0003a\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A7\u0011\u0005]q\u0017BA8\u0019\u0005\rIe\u000e\u001e\u0005\bc\u0002\t\t\u0011\"\u0001s\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"aR:\t\u000fQ\u0004\u0018\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\t\u000fY\u0004\u0011\u0011!C!o\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001y!\rIHpR\u0007\u0002u*\u00111\u0010G\u0001\u000bG>dG.Z2uS>t\u0017BA?{\u0005!IE/\u001a:bi>\u0014\b\u0002C@\u0001\u0003\u0003%\t!!\u0001\u0002\u0011\r\fg.R9vC2$B!a\u0001\u0002\nA\u0019q#!\u0002\n\u0007\u0005\u001d\u0001DA\u0004C_>dW-\u00198\t\u000fQt\u0018\u0011!a\u0001\u000f\"I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0013qB\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0011\u0011\u0003\u0005\ti\u0006-\u0011\u0011!a\u0001\u000f\"Z\u0001!!\u0006\u0002\u001c\u0005u\u0011\u0011EA\u0012!\r\u0011\u0013qC\u0005\u0004\u00033!!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003?\t\u0011\u0011D0G+:\u001bu\f\u000b=nY2\u0002\u0003\u0010]1uQ&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA1|gn\u001a\u0011j]R,w-\u001a:!m\u0006dW/\u001a\u0017!_J\u0004C\u000f[3!m\u0006dW/\u001a\u0011{KJ|\u0007%\u001b4!]>\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$G\u0006I8sA\u0005\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$\u0007EY;uAQDW\r\t<bYV,\u0007%[:!]>tWF\\;nKJL7ML\u0001\tKb$XM\u001c3fI\u0006\u0012\u0011QE\u0001Y\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C(\u0019 =Ez\nDh\f2?y\tt$\u0007P\u0018c}qz\u0013MP\u0014-A\u001d\u001aX/\u001c\u0015b_\tLs%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g)\u0001\u0003eB\u0005\u0002*\t\t\t\u0011#\u0001\u0002,\u0005I\u0001\fU1uQ2{gn\u001a\t\u0004'\u00055b\u0001C\u0001\u0003\u0003\u0003E\t!a\f\u0014\u000b\u00055\u0012\u0011\u0007\u000f\u0011\u000f\u0005M\u0012\u0011H\u0011\"]5\u0011\u0011Q\u0007\u0006\u0004\u0003oA\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003w\t)DA\tBEN$(/Y2u\rVt7\r^5p]JBq\u0001LA\u0017\t\u0003\ty\u0004\u0006\u0002\u0002,!Q\u00111IA\u0017\u0003\u0003%)%!\u0012\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0019\u0005\u000b\u0003\u0013\ni#!A\u0005\u0002\u0006-\u0013!B1qa2LH#\u0002\u0018\u0002N\u0005=\u0003BB\u0002\u0002H\u0001\u0007\u0011\u0005\u0003\u0004)\u0003\u000f\u0002\r!\t\u0005\u000b\u0003'\ni#!A\u0005\u0002\u0006U\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003/\n\u0019\u0007E\u0003\u0018\u00033\ni&C\u0002\u0002\\a\u0011aa\u00149uS>t\u0007#B\f\u0002`\u0005\n\u0013bAA11\t1A+\u001e9mKJB\u0011\"!\u001a\u0002R\u0005\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002j\u00055\u0012\u0011!C\u0005\u0003W\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u000e\t\u0004I\u0006=\u0014bAA9K\n1qJ\u00196fGR\u0004")
public class XPathLong
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Function1<Tuple2<Expression, Expression>, XPathLong> tupled() {
        return XPathLong$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathLong>> curried() {
        return XPathLong$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_long";
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToLong((long)ret.longValue());
    }

    public XPathLong copy(Expression xml, Expression path) {
        return new XPathLong(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathLong";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.path();
                break;
            }
            case 0: {
                expression = this.xml();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathLong)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathLong xPathLong = (XPathLong)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathLong.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathLong.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathLong.canEqual(this)) return false;
        return true;
    }

    public XPathLong(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

