/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CreateDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.CreateDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.CreateFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.CreateFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.CreateTableEvent;
import org.apache.spark.sql.catalyst.catalog.CreateTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.DropDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.DropDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.DropFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.DropFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.DropTableEvent;
import org.apache.spark.sql.catalyst.catalog.DropTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogEvent;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogEventListener;
import org.apache.spark.sql.catalyst.catalog.RenameFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.RenameFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.RenameTableEvent;
import org.apache.spark.sql.catalyst.catalog.RenameTablePreEvent;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ListenerBus;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r=c!B\u0001\u0003\u0003\u0003y!aD#yi\u0016\u0014h.\u00197DCR\fGn\\4\u000b\u0005\r!\u0011aB2bi\u0006dwn\u001a\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0003\u00185q\u0001S\"\u0001\r\u000b\u0005eA\u0011\u0001B;uS2L!a\u0007\r\u0003\u00171K7\u000f^3oKJ\u0014Uo\u001d\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011A$\u0012=uKJt\u0017\r\\\"bi\u0006dwnZ#wK:$H*[:uK:,'\u000f\u0005\u0002\u001eC%\u0011!E\u0001\u0002\u0015\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pO\u00163XM\u001c;\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\u00051\u0003CA\u000f\u0001\u0011\u0015A\u0003\u0001\"\u0005*\u0003=\u0011X-];je\u0016$%-\u0012=jgR\u001cHC\u0001\u0016.!\t\t2&\u0003\u0002-%\t!QK\\5u\u0011\u0015qs\u00051\u00010\u0003\t!'\r\u0005\u00021g9\u0011\u0011#M\u0005\u0003eI\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!G\u0005\u0005\u0006o\u0001!\t\u0002O\u0001\u0013e\u0016\fX/\u001b:f)\u0006\u0014G.Z#ySN$8\u000fF\u0002+siBQA\f\u001cA\u0002=BQa\u000f\u001cA\u0002=\nQ\u0001^1cY\u0016DQ!\u0010\u0001\u0005\u0012y\nQC]3rk&\u0014XMR;oGRLwN\\#ySN$8\u000fF\u0002+\u007f\u0001CQA\f\u001fA\u0002=BQ!\u0011\u001fA\u0002=\n\u0001BZ;oG:\u000bW.\u001a\u0005\u0006\u0007\u0002!\t\u0002R\u0001\u0019e\u0016\fX/\u001b:f\rVt7\r^5p]:{G/\u0012=jgR\u001cHc\u0001\u0016F\r\")aF\u0011a\u0001_!)\u0011I\u0011a\u0001_!)\u0001\n\u0001C\u0003\u0013\u0006q1M]3bi\u0016$\u0015\r^1cCN,Gc\u0001\u0016K\u001f\")1j\u0012a\u0001\u0019\u0006aAM\u0019#fM&t\u0017\u000e^5p]B\u0011Q$T\u0005\u0003\u001d\n\u0011qbQ1uC2|w\rR1uC\n\f7/\u001a\u0005\u0006!\u001e\u0003\r!U\u0001\u000fS\u001etwN]3JM\u0016C\u0018n\u001d;t!\t\t\"+\u0003\u0002T%\t9!i\\8mK\u0006t\u0007\"B+\u0001\r#1\u0016\u0001\u00053p\u0007J,\u0017\r^3ECR\f'-Y:f)\rQs\u000b\u0017\u0005\u0006\u0017R\u0003\r\u0001\u0014\u0005\u0006!R\u0003\r!\u0015\u0005\u00065\u0002!)aW\u0001\rIJ|\u0007\u000fR1uC\n\f7/\u001a\u000b\u0005Uqkv\fC\u0003/3\u0002\u0007q\u0006C\u0003_3\u0002\u0007\u0011+A\tjO:|'/Z%g\u001d>$X\t_5tiNDQ\u0001Y-A\u0002E\u000bqaY1tG\u0006$W\rC\u0003c\u0001\u0019E1-\u0001\be_\u0012\u0013x\u000e\u001d#bi\u0006\u0014\u0017m]3\u0015\t)\"WM\u001a\u0005\u0006]\u0005\u0004\ra\f\u0005\u0006=\u0006\u0004\r!\u0015\u0005\u0006A\u0006\u0004\r!\u0015\u0005\u0006Q\u00021\t![\u0001\u000eC2$XM\u001d#bi\u0006\u0014\u0017m]3\u0015\u0005)R\u0007\"B&h\u0001\u0004a\u0005\"\u00027\u0001\r\u0003i\u0017aC4fi\u0012\u000bG/\u00192bg\u0016$\"\u0001\u00148\t\u000b9Z\u0007\u0019A\u0018\t\u000bA\u0004a\u0011A9\u0002\u001d\u0011\fG/\u00192bg\u0016,\u00050[:ugR\u0011\u0011K\u001d\u0005\u0006]=\u0004\ra\f\u0005\u0006i\u00021\t!^\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0003Y\u00042a^@0\u001d\tAXP\u0004\u0002zy6\t!P\u0003\u0002|\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003}J\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0005\r!aA*fc*\u0011aP\u0005\u0005\u0007i\u00021\t!a\u0002\u0015\u0007Y\fI\u0001C\u0004\u0002\f\u0005\u0015\u0001\u0019A\u0018\u0002\u000fA\fG\u000f^3s]\"9\u0011q\u0002\u0001\u0007\u0002\u0005E\u0011AE:fi\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016$2AKA\n\u0011\u0019q\u0013Q\u0002a\u0001_!9\u0011q\u0003\u0001\u0005\u0006\u0005e\u0011aC2sK\u0006$X\rV1cY\u0016$RAKA\u000e\u0003KA\u0001\"!\b\u0002\u0016\u0001\u0007\u0011qD\u0001\u0010i\u0006\u0014G.\u001a#fM&t\u0017\u000e^5p]B\u0019Q$!\t\n\u0007\u0005\r\"A\u0001\u0007DCR\fGn\\4UC\ndW\r\u0003\u0004Q\u0003+\u0001\r!\u0015\u0005\b\u0003S\u0001a\u0011CA\u0016\u00035!wn\u0011:fCR,G+\u00192mKR)!&!\f\u00020!A\u0011QDA\u0014\u0001\u0004\ty\u0002\u0003\u0004Q\u0003O\u0001\r!\u0015\u0005\b\u0003g\u0001AQAA\u001b\u0003%!'o\u001c9UC\ndW\rF\u0005+\u0003o\tI$a\u000f\u0002>!1a&!\rA\u0002=BaaOA\u0019\u0001\u0004y\u0003B\u00020\u00022\u0001\u0007\u0011\u000bC\u0004\u0002@\u0005E\u0002\u0019A)\u0002\u000bA,(oZ3\t\u000f\u0005\r\u0003A\"\u0005\u0002F\u0005YAm\u001c#s_B$\u0016M\u00197f)%Q\u0013qIA%\u0003\u0017\ni\u0005\u0003\u0004/\u0003\u0003\u0002\ra\f\u0005\u0007w\u0005\u0005\u0003\u0019A\u0018\t\ry\u000b\t\u00051\u0001R\u0011\u001d\ty$!\u0011A\u0002ECq!!\u0015\u0001\t\u000b\t\u0019&A\u0006sK:\fW.\u001a+bE2,Gc\u0002\u0016\u0002V\u0005]\u00131\f\u0005\u0007]\u0005=\u0003\u0019A\u0018\t\u000f\u0005e\u0013q\na\u0001_\u00059q\u000e\u001c3OC6,\u0007bBA/\u0003\u001f\u0002\raL\u0001\b]\u0016<h*Y7f\u0011\u001d\t\t\u0007\u0001D\t\u0003G\nQ\u0002Z8SK:\fW.\u001a+bE2,Gc\u0002\u0016\u0002f\u0005\u001d\u0014\u0011\u000e\u0005\u0007]\u0005}\u0003\u0019A\u0018\t\u000f\u0005e\u0013q\fa\u0001_!9\u0011QLA0\u0001\u0004y\u0003bBA7\u0001\u0019\u0005\u0011qN\u0001\u000bC2$XM\u001d+bE2,Gc\u0001\u0016\u0002r!A\u0011QDA6\u0001\u0004\ty\u0002C\u0004\u0002v\u00011\t!a\u001e\u0002!\u0005dG/\u001a:UC\ndWmU2iK6\fGc\u0002\u0016\u0002z\u0005m\u0014Q\u0010\u0005\u0007]\u0005M\u0004\u0019A\u0018\t\rm\n\u0019\b1\u00010\u0011!\ty(a\u001dA\u0002\u0005\u0005\u0015AB:dQ\u0016l\u0017\r\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9IB\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u0017\u000b)I\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!a$\u0001\r\u0003\t\t*\u0001\u0005hKR$\u0016M\u00197f)\u0019\ty\"a%\u0002\u0016\"1a&!$A\u0002=BaaOAG\u0001\u0004y\u0003bBAM\u0001\u0019\u0005\u00111T\u0001\u000fO\u0016$H+\u00192mK>\u0003H/[8o)\u0019\ti*a)\u0002&B)\u0011#a(\u0002 %\u0019\u0011\u0011\u0015\n\u0003\r=\u0003H/[8o\u0011\u0019q\u0013q\u0013a\u0001_!11(a&A\u0002=Bq!!+\u0001\r\u0003\tY+A\u0006uC\ndW-\u0012=jgR\u001cH#B)\u0002.\u0006=\u0006B\u0002\u0018\u0002(\u0002\u0007q\u0006\u0003\u0004<\u0003O\u0003\ra\f\u0005\b\u0003g\u0003a\u0011AA[\u0003)a\u0017n\u001d;UC\ndWm\u001d\u000b\u0004m\u0006]\u0006B\u0002\u0018\u00022\u0002\u0007q\u0006C\u0004\u00024\u00021\t!a/\u0015\u000bY\fi,a0\t\r9\nI\f1\u00010\u0011\u001d\tY!!/A\u0002=Bq!a1\u0001\r\u0003\t)-A\u0005m_\u0006$G+\u00192mKRY!&a2\u0002J\u0006-\u0017qZAj\u0011\u0019q\u0013\u0011\u0019a\u0001_!11(!1A\u0002=Bq!!4\u0002B\u0002\u0007q&\u0001\u0005m_\u0006$\u0007+\u0019;i\u0011\u001d\t\t.!1A\u0002E\u000b1\"[:Pm\u0016\u0014xO]5uK\"9\u0011Q[Aa\u0001\u0004\t\u0016AC5t'J\u001cGj\\2bY\"9\u0011\u0011\u001c\u0001\u0007\u0002\u0005m\u0017!\u00047pC\u0012\u0004\u0016M\u001d;ji&|g\u000eF\b+\u0003;\fy.!9\u0002d\u0006U\u0018q_A~\u0011\u0019q\u0013q\u001ba\u0001_!11(a6A\u0002=Bq!!4\u0002X\u0002\u0007q\u0006\u0003\u0005\u0002f\u0006]\u0007\u0019AAt\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002j\u0006=hbA\u000f\u0002l&\u0019\u0011Q\u001e\u0002\u0002\u0019\r\u000bG/\u00197pORK\b/Z:\n\t\u0005E\u00181\u001f\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7MC\u0002\u0002n\nAq!!5\u0002X\u0002\u0007\u0011\u000bC\u0004\u0002z\u0006]\u0007\u0019A)\u0002#%t\u0007.\u001a:jiR\u000b'\r\\3Ta\u0016\u001c7\u000fC\u0004\u0002V\u0006]\u0007\u0019A)\t\u000f\u0005}\bA\"\u0001\u0003\u0002\u0005)Bn\\1e\tft\u0017-\\5d!\u0006\u0014H/\u001b;j_:\u001cH#\u0004\u0016\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017\u0011y\u0001\u0003\u0004/\u0003{\u0004\ra\f\u0005\u0007w\u0005u\b\u0019A\u0018\t\u000f\u00055\u0017Q a\u0001_!A\u0011Q]A\u007f\u0001\u0004\t9\u000fC\u0004\u0003\u000e\u0005u\b\u0019A)\u0002\u000fI,\u0007\u000f\\1dK\"A!\u0011CA\u007f\u0001\u0004\u0011\u0019\"A\u0003ok6$\u0005\u000bE\u0002\u0012\u0005+I1Aa\u0006\u0013\u0005\rIe\u000e\u001e\u0005\b\u00057\u0001a\u0011\u0001B\u000f\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000fF\u0005+\u0005?\u0011\tCa\t\u00030!1aF!\u0007A\u0002=Baa\u000fB\r\u0001\u0004y\u0003\u0002\u0003B\u0013\u00053\u0001\rAa\n\u0002\u000bA\f'\u000f^:\u0011\t]|(\u0011\u0006\t\u0004;\t-\u0012b\u0001B\u0017\u0005\t)2)\u0019;bY><G+\u00192mKB\u000b'\u000f^5uS>t\u0007B\u0002)\u0003\u001a\u0001\u0007\u0011\u000bC\u0004\u00034\u00011\tA!\u000e\u0002\u001d\u0011\u0014x\u000e\u001d)beRLG/[8ogRi!Fa\u000e\u0003:\tm\"q\bB!\u0005\u0007BaA\fB\u0019\u0001\u0004y\u0003BB\u001e\u00032\u0001\u0007q\u0006\u0003\u0005\u0003&\tE\u0002\u0019\u0001B\u001f!\u00119x0a:\t\ry\u0013\t\u00041\u0001R\u0011\u001d\tyD!\rA\u0002ECqA!\u0012\u00032\u0001\u0007\u0011+\u0001\u0006sKR\f\u0017N\u001c#bi\u0006DqA!\u0013\u0001\r\u0003\u0011Y%\u0001\tsK:\fW.\u001a)beRLG/[8ogRI!F!\u0014\u0003P\tE#Q\u000b\u0005\u0007]\t\u001d\u0003\u0019A\u0018\t\rm\u00129\u00051\u00010\u0011!\u0011\u0019Fa\u0012A\u0002\tu\u0012!B:qK\u000e\u001c\b\u0002\u0003B,\u0005\u000f\u0002\rA!\u0010\u0002\u00119,wo\u00159fGNDqAa\u0017\u0001\r\u0003\u0011i&A\bbYR,'\u000fU1si&$\u0018n\u001c8t)\u001dQ#q\fB1\u0005GBaA\fB-\u0001\u0004y\u0003BB\u001e\u0003Z\u0001\u0007q\u0006\u0003\u0005\u0003&\te\u0003\u0019\u0001B\u0014\u0011\u001d\u00119\u0007\u0001D\u0001\u0005S\nAbZ3u!\u0006\u0014H/\u001b;j_:$\u0002B!\u000b\u0003l\t5$q\u000e\u0005\u0007]\t\u0015\u0004\u0019A\u0018\t\rm\u0012)\u00071\u00010\u0011!\u0011\tH!\u001aA\u0002\u0005\u001d\u0018\u0001B:qK\u000eDqA!\u001e\u0001\r\u0003\u00119(\u0001\nhKR\u0004\u0016M\u001d;ji&|gn\u00149uS>tG\u0003\u0003B=\u0005w\u0012iHa \u0011\u000bE\tyJ!\u000b\t\r9\u0012\u0019\b1\u00010\u0011\u0019Y$1\u000fa\u0001_!A!\u0011\u000fB:\u0001\u0004\t9\u000fC\u0004\u0003\u0004\u00021\tA!\"\u0002%1L7\u000f\u001e)beRLG/[8o\u001d\u0006lWm\u001d\u000b\bm\n\u001d%\u0011\u0012BF\u0011\u0019q#\u0011\u0011a\u0001_!11H!!A\u0002=B!B!$\u0003\u0002B\u0005\t\u0019\u0001BH\u0003-\u0001\u0018M\u001d;jC2\u001c\u0006/Z2\u0011\u000bE\ty*a:\t\u000f\tM\u0005A\"\u0001\u0003\u0016\u0006qA.[:u!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0003B\u0014\u0005/\u0013IJa'\t\r9\u0012\t\n1\u00010\u0011\u0019Y$\u0011\u0013a\u0001_!Q!Q\u0012BI!\u0003\u0005\rAa$\t\u000f\t}\u0005A\"\u0001\u0003\"\u00061B.[:u!\u0006\u0014H/\u001b;j_:\u001c()\u001f$jYR,'\u000f\u0006\u0006\u0003(\t\r&Q\u0015BT\u0005sCaA\fBO\u0001\u0004y\u0003BB\u001e\u0003\u001e\u0002\u0007q\u0006\u0003\u0005\u0003*\nu\u0005\u0019\u0001BV\u0003)\u0001(/\u001a3jG\u0006$Xm\u001d\t\u0005o~\u0014i\u000b\u0005\u0003\u00030\nUVB\u0001BY\u0015\r\u0011\u0019\fB\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u00038\nE&AC#yaJ,7o]5p]\"9!1\u0018BO\u0001\u0004y\u0013!\u00053fM\u0006,H\u000e\u001e+j[\u0016TvN\\3JI\"9!q\u0018\u0001\u0005\u0006\t\u0005\u0017AD2sK\u0006$XMR;oGRLwN\u001c\u000b\u0006U\t\r'Q\u0019\u0005\u0007]\tu\u0006\u0019A\u0018\t\u0011\t\u001d'Q\u0018a\u0001\u0005\u0013\faBZ;oG\u0012+g-\u001b8ji&|g\u000eE\u0002\u001e\u0005\u0017L1A!4\u0003\u0005=\u0019\u0015\r^1m_\u001e4UO\\2uS>t\u0007b\u0002Bi\u0001\u0019E!1[\u0001\u0011I>\u001c%/Z1uK\u001a+hn\u0019;j_:$RA\u000bBk\u0005/DaA\fBh\u0001\u0004y\u0003\u0002\u0003Bd\u0005\u001f\u0004\rA!3\t\u000f\tm\u0007\u0001\"\u0002\u0003^\u0006aAM]8q\rVt7\r^5p]R)!Fa8\u0003b\"1aF!7A\u0002=Ba!\u0011Bm\u0001\u0004y\u0003b\u0002Bs\u0001\u0019E!q]\u0001\u000fI>$%o\u001c9Gk:\u001cG/[8o)\u0015Q#\u0011\u001eBv\u0011\u0019q#1\u001da\u0001_!1\u0011Ia9A\u0002=BqAa<\u0001\t\u000b\u0011\t0\u0001\bsK:\fW.\u001a$v]\u000e$\u0018n\u001c8\u0015\u000f)\u0012\u0019P!>\u0003x\"1aF!<A\u0002=Bq!!\u0017\u0003n\u0002\u0007q\u0006C\u0004\u0002^\t5\b\u0019A\u0018\t\u000f\tm\bA\"\u0005\u0003~\u0006\u0001Bm\u001c*f]\u0006lWMR;oGRLwN\u001c\u000b\bU\t}8\u0011AB\u0002\u0011\u0019q#\u0011 a\u0001_!9\u0011\u0011\fB}\u0001\u0004y\u0003bBA/\u0005s\u0004\ra\f\u0005\b\u0007\u000f\u0001a\u0011AB\u0005\u0003-9W\r\u001e$v]\u000e$\u0018n\u001c8\u0015\r\t%71BB\u0007\u0011\u0019q3Q\u0001a\u0001_!1\u0011i!\u0002A\u0002=Bqa!\u0005\u0001\r\u0003\u0019\u0019\"\u0001\bgk:\u001cG/[8o\u000bbL7\u000f^:\u0015\u000bE\u001b)ba\u0006\t\r9\u001ay\u00011\u00010\u0011\u0019\t5q\u0002a\u0001_!911\u0004\u0001\u0007\u0002\ru\u0011!\u00047jgR4UO\\2uS>t7\u000fF\u0003w\u0007?\u0019\t\u0003\u0003\u0004/\u00073\u0001\ra\f\u0005\b\u0003\u0017\u0019I\u00021\u00010\u0011\u001d\u0019)\u0003\u0001C)\u0007O\t1\u0002Z8Q_N$XI^3oiR)!f!\u000b\u0004.!911FB\u0012\u0001\u0004a\u0012\u0001\u00037jgR,g.\u001a:\t\u000f\r=21\u0005a\u0001A\u0005)QM^3oi\"I11\u0007\u0001\u0012\u0002\u0013\u00051QG\u0001\u001dY&\u001cH\u000fU1si&$\u0018n\u001c8OC6,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u00199D\u000b\u0003\u0003\u0010\u000ee2FAB\u001e!\u0011\u0019ida\u0012\u000e\u0005\r}\"\u0002BB!\u0007\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\u0015##\u0001\u0006b]:|G/\u0019;j_:LAa!\u0013\u0004@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\r5\u0003!%A\u0005\u0002\rU\u0012\u0001\u00077jgR\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public abstract class ExternalCatalog
implements ListenerBus<ExternalCatalogEventListener, ExternalCatalogEvent> {
    private final CopyOnWriteArrayList<Object> listeners;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public CopyOnWriteArrayList<ExternalCatalogEventListener> listeners() {
        return this.listeners;
    }

    public void org$apache$spark$util$ListenerBus$_setter_$listeners_$eq(CopyOnWriteArrayList x$1) {
        this.listeners = x$1;
    }

    public final void addListener(Object listener) {
        ListenerBus.class.addListener((ListenerBus)this, (Object)listener);
    }

    public final void removeListener(Object listener) {
        ListenerBus.class.removeListener((ListenerBus)this, (Object)listener);
    }

    public void postToAll(Object event) {
        ListenerBus.class.postToAll((ListenerBus)this, (Object)event);
    }

    public <T extends ExternalCatalogEventListener> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.class.findListenersByClass((ListenerBus)this, evidence$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public void requireDbExists(String db) {
        if (this.databaseExists(db)) {
            return;
        }
        throw new NoSuchDatabaseException(db);
    }

    public void requireTableExists(String db, String table) {
        if (this.tableExists(db, table)) {
            return;
        }
        throw new NoSuchTableException(db, table);
    }

    public void requireFunctionExists(String db, String funcName) {
        if (this.functionExists(db, funcName)) {
            return;
        }
        throw new NoSuchFunctionException(db, funcName);
    }

    public void requireFunctionNotExists(String db, String funcName) {
        if (this.functionExists(db, funcName)) {
            throw new FunctionAlreadyExistsException(db, funcName);
        }
    }

    public final void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        String db = dbDefinition.name();
        this.postToAll(new CreateDatabasePreEvent(db));
        this.doCreateDatabase(dbDefinition, ignoreIfExists);
        this.postToAll(new CreateDatabaseEvent(db));
    }

    public abstract void doCreateDatabase(CatalogDatabase var1, boolean var2);

    public final void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        this.postToAll(new DropDatabasePreEvent(db));
        this.doDropDatabase(db, ignoreIfNotExists, cascade);
        this.postToAll(new DropDatabaseEvent(db));
    }

    public abstract void doDropDatabase(String var1, boolean var2, boolean var3);

    public abstract void alterDatabase(CatalogDatabase var1);

    public abstract CatalogDatabase getDatabase(String var1);

    public abstract boolean databaseExists(String var1);

    public abstract Seq<String> listDatabases();

    public abstract Seq<String> listDatabases(String var1);

    public abstract void setCurrentDatabase(String var1);

    public final void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        String db = tableDefinition.database();
        String name2 = tableDefinition.identifier().table();
        this.postToAll(new CreateTablePreEvent(db, name2));
        this.doCreateTable(tableDefinition, ignoreIfExists);
        this.postToAll(new CreateTableEvent(db, name2));
    }

    public abstract void doCreateTable(CatalogTable var1, boolean var2);

    public final void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        this.postToAll(new DropTablePreEvent(db, table));
        this.doDropTable(db, table, ignoreIfNotExists, purge);
        this.postToAll(new DropTableEvent(db, table));
    }

    public abstract void doDropTable(String var1, String var2, boolean var3, boolean var4);

    public final void renameTable(String db, String oldName, String newName) {
        this.postToAll(new RenameTablePreEvent(db, oldName, newName));
        this.doRenameTable(db, oldName, newName);
        this.postToAll(new RenameTableEvent(db, oldName, newName));
    }

    public abstract void doRenameTable(String var1, String var2, String var3);

    public abstract void alterTable(CatalogTable var1);

    public abstract void alterTableSchema(String var1, String var2, StructType var3);

    public abstract CatalogTable getTable(String var1, String var2);

    public abstract Option<CatalogTable> getTableOption(String var1, String var2);

    public abstract boolean tableExists(String var1, String var2);

    public abstract Seq<String> listTables(String var1);

    public abstract Seq<String> listTables(String var1, String var2);

    public abstract void loadTable(String var1, String var2, String var3, boolean var4, boolean var5);

    public abstract void loadPartition(String var1, String var2, String var3, Map<String, String> var4, boolean var5, boolean var6, boolean var7);

    public abstract void loadDynamicPartitions(String var1, String var2, String var3, Map<String, String> var4, boolean var5, int var6);

    public abstract void createPartitions(String var1, String var2, Seq<CatalogTablePartition> var3, boolean var4);

    public abstract void dropPartitions(String var1, String var2, Seq<Map<String, String>> var3, boolean var4, boolean var5, boolean var6);

    public abstract void renamePartitions(String var1, String var2, Seq<Map<String, String>> var3, Seq<Map<String, String>> var4);

    public abstract void alterPartitions(String var1, String var2, Seq<CatalogTablePartition> var3);

    public abstract CatalogTablePartition getPartition(String var1, String var2, Map<String, String> var3);

    public abstract Option<CatalogTablePartition> getPartitionOption(String var1, String var2, Map<String, String> var3);

    public abstract Seq<String> listPartitionNames(String var1, String var2, Option<Map<String, String>> var3);

    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    public abstract Seq<CatalogTablePartition> listPartitions(String var1, String var2, Option<Map<String, String>> var3);

    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    public abstract Seq<CatalogTablePartition> listPartitionsByFilter(String var1, String var2, Seq<Expression> var3, String var4);

    public final void createFunction(String db, CatalogFunction funcDefinition) {
        String name2 = funcDefinition.identifier().funcName();
        this.postToAll(new CreateFunctionPreEvent(db, name2));
        this.doCreateFunction(db, funcDefinition);
        this.postToAll(new CreateFunctionEvent(db, name2));
    }

    public abstract void doCreateFunction(String var1, CatalogFunction var2);

    public final void dropFunction(String db, String funcName) {
        this.postToAll(new DropFunctionPreEvent(db, funcName));
        this.doDropFunction(db, funcName);
        this.postToAll(new DropFunctionEvent(db, funcName));
    }

    public abstract void doDropFunction(String var1, String var2);

    public final void renameFunction(String db, String oldName, String newName) {
        this.postToAll(new RenameFunctionPreEvent(db, oldName, newName));
        this.doRenameFunction(db, oldName, newName);
        this.postToAll(new RenameFunctionEvent(db, oldName, newName));
    }

    public abstract void doRenameFunction(String var1, String var2, String var3);

    public abstract CatalogFunction getFunction(String var1, String var2);

    public abstract boolean functionExists(String var1, String var2);

    public abstract Seq<String> listFunctions(String var1, String var2);

    public void doPostEvent(ExternalCatalogEventListener listener, ExternalCatalogEvent event) {
        listener.onEvent(event);
    }

    public ExternalCatalog() {
        Logging.class.$init$((Logging)this);
        ListenerBus.class.$init$((ListenerBus)this);
    }
}

