/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hour$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp) - Returns the hour component of the string/timestamp.", extended="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 12:58:59');\n       12\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001>\u0011A\u0001S8ve*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001!Q9\"\u0004\t\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA\t\u0019\u0013\tI\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001d\u0001&o\u001c3vGR\u0004\"aG\u0011\n\u0005\tb\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0013\u0001\u0005+\u0007I\u0011A\u0013\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u0019\u0002\"!E\u0014\n\u0005!\u0012!AC#yaJ,7o]5p]\"A!\u0006\u0001B\tB\u0003%a%\u0001\u0004dQ&dG\r\t\u0005\tY\u0001\u0011)\u001a!C\u0001[\u0005QA/[7f5>tW-\u00133\u0016\u00039\u00022aG\u00182\u0013\t\u0001DD\u0001\u0004PaRLwN\u001c\t\u0003eUr!aG\u001a\n\u0005Qb\u0012A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001\u000e\u000f\t\u0011e\u0002!\u0011#Q\u0001\n9\n1\u0002^5nKj{g.Z%eA!)1\b\u0001C\u0001y\u00051A(\u001b8jiz\"2!\u0010 @!\t\t\u0002\u0001C\u0003%u\u0001\u0007a\u0005C\u0004-uA\u0005\t\u0019\u0001\u0018\t\u000bm\u0002A\u0011A!\u0015\u0005u\u0012\u0005\"\u0002\u0013A\u0001\u00041\u0003\"\u0002#\u0001\t\u0003*\u0015AC5oaV$H+\u001f9fgV\ta\tE\u0002H\u001fJs!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-s\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tqE$A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&aA*fc*\u0011a\n\b\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u001a\tQ\u0001^=qKNL!a\u0016+\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007\"B-\u0001\t\u0003R\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003m\u0003\"a\u0015/\n\u0005u#&\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000b}\u0003A\u0011\t1\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0005Q\t\u0007\"\u0002\u0017_\u0001\u0004\t\u0004\"B2\u0001\t#\"\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCA3i!\tYb-\u0003\u0002h9\t\u0019\u0011I\\=\t\u000b%\u0014\u0007\u0019A3\u0002\u0013QLW.Z:uC6\u0004\b\"B6\u0001\t\u0003b\u0017!\u00033p\u000f\u0016t7i\u001c3f)\ri7\u000f\u001f\t\u0003]Fl\u0011a\u001c\u0006\u0003a\n\tqaY8eK\u001e,g.\u0003\u0002s_\nAQ\t\u001f9s\u0007>$W\rC\u0003uU\u0002\u0007Q/A\u0002dib\u0004\"A\u001c<\n\u0005]|'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006s*\u0004\r!\\\u0001\u0003KZDqa\u001f\u0001\u0002\u0002\u0013\u0005A0\u0001\u0003d_BLHcA\u001f~}\"9AE\u001fI\u0001\u0002\u00041\u0003b\u0002\u0017{!\u0003\u0005\rA\f\u0005\n\u0003\u0003\u0001\u0011\u0013!C\u0001\u0003\u0007\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0006)\u001aa%a\u0002,\u0005\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0005\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\tiAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0007\u0001#\u0003%\t!!\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0004\u0016\u0004]\u0005\u001d\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0005\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006L1ANA\u0016\u0011%\t9\u0004AA\u0001\n\u0003\tI$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002<A\u00191$!\u0010\n\u0007\u0005}BDA\u0002J]RD\u0011\"a\u0011\u0001\u0003\u0003%\t!!\u0012\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q-a\u0012\t\u0015\u0005%\u0013\u0011IA\u0001\u0002\u0004\tY$A\u0002yIEB\u0011\"!\u0014\u0001\u0003\u0003%\t%a\u0014\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0015\u0011\u000b\u0005M\u0013\u0011L3\u000e\u0005\u0005U#bAA,9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0013Q\u000b\u0002\t\u0013R,'/\u0019;pe\"I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0011\u0011M\u0001\tG\u0006tW)];bYR!\u00111MA5!\rY\u0012QM\u0005\u0004\u0003Ob\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0013\ni&!AA\u0002\u0015D\u0011\"!\u001c\u0001\u0003\u0003%\t%a\u001c\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019'!\u001d\t\u0013\u0005%\u00131NA\u0001\u0002\u0004)\u0007f\u0003\u0001\u0002v\u0005m\u0014QPAA\u0003\u0007\u00032!EA<\u0013\r\tIH\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty(A$`\rVs5i\u0018\u0015uS6,7\u000f^1na&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0003n\\;sA\r|W\u000e]8oK:$\be\u001c4!i\",\u0007e\u001d;sS:<w\u0006^5nKN$\u0018-\u001c9/\u0003!)\u0007\u0010^3oI\u0016$\u0017EAAC\u0003%S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1aej\u0003gN\u00174a\u0001\n$GO\u001b9uUJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cIR\u0001\u0005I\u0004\n\u0003\u0013\u0013\u0011\u0011!E\u0001\u0003\u0017\u000bA\u0001S8veB\u0019\u0011#!$\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u001f\u001bR!!$\u0002\u0012\u0002\u0002r!a%\u0002\u001a\u001arS(\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013\u000f\u0002\u000fI,h\u000e^5nK&!\u00111TAK\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bw\u00055E\u0011AAP)\t\tY\t\u0003\u0006\u0002$\u00065\u0015\u0011!C#\u0003K\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003OA!\"!+\u0002\u000e\u0006\u0005I\u0011QAV\u0003\u0015\t\u0007\u000f\u001d7z)\u0015i\u0014QVAX\u0011\u0019!\u0013q\u0015a\u0001M!AA&a*\u0011\u0002\u0003\u0007a\u0006\u0003\u0006\u00024\u00065\u0015\u0011!CA\u0003k\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00028\u0006}\u0006\u0003B\u000e0\u0003s\u0003RaGA^M9J1!!0\u001d\u0005\u0019!V\u000f\u001d7fe!I\u0011\u0011YAY\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\u0002\u0004BCAc\u0003\u001b\u000b\n\u0011\"\u0001\u0002\u001e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIIB!\"!3\u0002\u000eF\u0005I\u0011AA\u000f\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0004BCAg\u0003\u001b\u000b\t\u0011\"\u0003\u0002P\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\u000e\u0005\u0003\u0002*\u0005M\u0017\u0002BAk\u0003W\u0011aa\u00142kK\u000e$\b")
public class Hour
extends UnaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final Option<String> timeZoneId;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$2() {
        return Hour$.MODULE$.apply$default$2();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return Hour$.MODULE$.$lessinit$greater$default$2();
    }

    public static Function1<Tuple2<Expression, Option<String>>, Hour> tupled() {
        return Hour$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<String>, Hour>> curried() {
        return Hour$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    private boolean resolved$lzycompute() {
        Hour hour = this;
        synchronized (hour) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        Hour hour = this;
        synchronized (hour) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = true;
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return this.bitmap$trans$0 ? this.timeZone : this.timeZone$lzycompute();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType$[]{TimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$4 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$5 = this.copy$default$1();
        return this.copy(x$5, (Option<String>)x$4);
    }

    @Override
    public Object nullSafeEval(Object timestamp) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(BoxesRunTime.unboxToLong((Object)timestamp), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceMinorObj(this.timeZone(), ctx.addReferenceMinorObj$default$2());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)new Serializable(this, tz, dtu){
            public static final long serialVersionUID = 0L;
            private final String tz$1;
            private final String dtu$1;

            public final String apply(String c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getHours(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$1, c, this.tz$1}));
            }
            {
                this.tz$1 = tz$1;
                this.dtu$1 = dtu$1;
            }
        });
    }

    public Hour copy(Expression child, Option<String> timeZoneId) {
        return new Hour(child, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<String> copy$default$2() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Hour";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.timeZoneId();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hour)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hour hour = (Hour)x$1;
        Expression expression = this.child();
        Expression expression2 = hour.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = hour.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hour.canEqual(this)) return false;
        return true;
    }

    public Hour(Expression child, Option<String> timeZoneId) {
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public Hour(Expression child) {
        this(child, (Option<String>)None$.MODULE$);
    }
}

