/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ pattern - Returns true if str matches pattern, null if any arguments are null, false otherwise.", extended="\n    Arguments:\n      str - a string expression\n      pattern - a string expression. The pattern is a string which is matched literally, with\n        exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n        The escape character is '\\'. If an escape character precedes a special symbol or another\n        escape character, the following character is matched literally. It is invalid to escape\n        any other character.\n\n        Since Spark 2.0, string literals are unescaped in our SQL parser. For example, in order\n        to match \"\\abc\", the pattern should be \"\\\\abc\".\n\n        When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it fallbacks\n        to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n        enabled, the pattern to match \"\\abc\" should be \"\\abc\".\n\n    Examples:\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%'\n      true\n\n    See also:\n      Use RLIKE to match with standard regular expressions.\n")
@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001>\u0011A\u0001T5lK*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!QQ\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005U\u0019FO]5oOJ+w-\u001a=FqB\u0014Xm]:j_:\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t=\u0001\u0011)\u001a!C\u0001?\u0005!A.\u001a4u+\u0005\u0001\u0003CA\t\"\u0013\t\u0011#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001\u0002\n\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0006Y\u00164G\u000f\t\u0005\tM\u0001\u0011)\u001a!C\u0001?\u0005)!/[4ii\"A\u0001\u0006\u0001B\tB\u0003%\u0001%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071jc\u0006\u0005\u0002\u0012\u0001!)a$\u000ba\u0001A!)a%\u000ba\u0001A!)\u0001\u0007\u0001C!c\u00051Qm]2ba\u0016$\"AM\u001d\u0011\u0005M2dBA\u000b5\u0013\t)d#\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u0017\u0011\u0015Qt\u00061\u00013\u0003\u00051\b\"\u0002\u001f\u0001\t\u0003j\u0014aB7bi\u000eDWm\u001d\u000b\u0004}\u0005c\u0005CA\u000b@\u0013\t\u0001eCA\u0004C_>dW-\u00198\t\u000b\t[\u0004\u0019A\"\u0002\u000bI,w-\u001a=\u0011\u0005\u0011SU\"A#\u000b\u0005\t3%BA$I\u0003\u0011)H/\u001b7\u000b\u0003%\u000bAA[1wC&\u00111*\u0012\u0002\b!\u0006$H/\u001a:o\u0011\u0015i5\b1\u00013\u0003\r\u0019HO\u001d\u0005\u0006\u001f\u0002!\t\u0005U\u0001\ti>\u001cFO]5oOR\t!\u0007C\u0003S\u0001\u0011E3+A\u0005e_\u001e+gnQ8eKR\u0019AKW0\u0011\u0005UCV\"\u0001,\u000b\u0005]\u0013\u0011aB2pI\u0016<WM\\\u0005\u00033Z\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u00067F\u0003\r\u0001X\u0001\u0004GRD\bCA+^\u0013\tqfK\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000b\u0001\f\u0006\u0019\u0001+\u0002\u0005\u00154\bb\u00022\u0001\u0003\u0003%\taY\u0001\u0005G>\u0004\u0018\u0010F\u0002-I\u0016DqAH1\u0011\u0002\u0003\u0007\u0001\u0005C\u0004'CB\u0005\t\u0019\u0001\u0011\t\u000f\u001d\u0004\u0011\u0013!C\u0001Q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A5+\u0005\u0001R7&A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017!C;oG\",7m[3e\u0015\t\u0001h#\u0001\u0006b]:|G/\u0019;j_:L!A]7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004u\u0001E\u0005I\u0011\u00015\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!9a\u000fAA\u0001\n\u0003:\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001y!\tIH0D\u0001{\u0015\tY\b*\u0001\u0003mC:<\u0017BA\u001c{\u0011\u001dq\b!!A\u0005\u0002}\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0001\u0011\u0007U\t\u0019!C\u0002\u0002\u0006Y\u00111!\u00138u\u0011%\tI\u0001AA\u0001\n\u0003\tY!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00111\u0003\t\u0004+\u0005=\u0011bAA\t-\t\u0019\u0011I\\=\t\u0015\u0005U\u0011qAA\u0001\u0002\u0004\t\t!A\u0002yIEB\u0011\"!\u0007\u0001\u0003\u0003%\t%a\u0007\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\b\u0011\r\u0005}\u0011QEA\u0007\u001b\t\t\tCC\u0002\u0002$Y\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9#!\t\u0003\u0011%#XM]1u_JD\u0011\"a\u000b\u0001\u0003\u0003%\t!!\f\u0002\u0011\r\fg.R9vC2$2APA\u0018\u0011)\t)\"!\u000b\u0002\u0002\u0003\u0007\u0011Q\u0002\u0005\n\u0003g\u0001\u0011\u0011!C!\u0003k\ta!Z9vC2\u001cHc\u0001 \u00028!Q\u0011QCA\u0019\u0003\u0003\u0005\r!!\u0004)\u0017\u0001\tY$!\u0011\u0002D\u0005\u001d\u0013\u0011\n\t\u0004#\u0005u\u0012bAA \u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA#\u0003)\u001cHO\u001d\u0011`\rVs5i\u0018\u0011qCR$XM\u001d8![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007e\u001d;sA5\fGo\u00195fg\u0002\u0002\u0018\r\u001e;fe:d\u0003E\\;mY\u0002Jg\rI1os\u0002\n'oZ;nK:$8\u000fI1sK\u0002rW\u000f\u001c7-A\u0019\fGn]3!_RDWM]<jg\u0016t\u0013\u0001C3yi\u0016tG-\u001a3\"\u0005\u0005-\u0013!c\u001a\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003\u0005]1ui\u0016\u0014h\u000eI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007\u0005]1ui\u0016\u0014h\u000eI5tA\u0005\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002J7\u000fI7bi\u000eDW\r\u001a\u0011mSR,'/\u00197ms2\u0002s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001*\u0007pY3qi&|g\u000e\t;pAQDW\r\t4pY2|w/\u001b8hAM\u0004XmY5bY\u0002\u001a\u00180\u001c2pYNT$B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A}\u0003S.\u0019;dQ\u0016\u001c\b%\u00198zA=tW\rI2iCJ\f7\r^3sA%t\u0007\u0005\u001e5fA%t\u0007/\u001e;!QMLW.\u001b7be\u0002\"x\u000e\t\u0018!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tS)Q\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011&A5\fGo\u00195fg\u0002RXM]8!_J\u0004Sn\u001c:fA\rD\u0017M]1di\u0016\u00148\u000fI5oAQDW\rI5oaV$\b\u0005K:j[&d\u0017M\u001d\u0011u_\u0002r#\u0006I5oAA|7/\u001b=!e\u0016<W\u000f\\1s\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=qe\u0016\u001c8/[8og&R!\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t+iK\u0002*7oY1qK\u0002\u001a\u0007.\u0019:bGR,'\u000fI5tA\u001dbvE\f\u0011JM\u0002\ng\u000eI3tG\u0006\u0004X\rI2iCJ\f7\r^3sAA\u0014XmY3eKN\u0004\u0013\rI:qK\u000eL\u0017\r\u001c\u0011ts6\u0014w\u000e\u001c\u0011pe\u0002\ngn\u001c;iKJT\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Z:dCB,\u0007e\u00195be\u0006\u001cG/\u001a:-AQDW\r\t4pY2|w/\u001b8hA\rD\u0017M]1di\u0016\u0014\b%[:![\u0006$8\r[3eA1LG/\u001a:bY2Lh\u0006I%uA%\u001c\b%\u001b8wC2LG\r\t;pA\u0015\u001c8-\u00199f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\ng.\u001f\u0011pi\",'\u000fI2iCJ\f7\r^3s])Q\u0001\u0005\t\u0011!A\u0001\u0002\u0003eU5oG\u0016\u00043\u000b]1sW\u0002\u0012d\u0006\r\u0017!gR\u0014\u0018N\\4!Y&$XM]1mg\u0002\n'/\u001a\u0011v]\u0016\u001c8-\u00199fI\u0002Jg\u000eI8ve\u0002\u001a\u0016\u000b\u0014\u0011qCJ\u001cXM\u001d\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011j]\u0002z'\u000fZ3s\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006\t;iK\u0002\u0002\u0018\r\u001e;fe:\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011#9r\u000b'm\u0019\u0012/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002s\u000b[3oAM\u000bF\nI2p]\u001aLw\rI\u0014ta\u0006\u00148NL:rY:\u0002\u0018M]:fe:*7oY1qK\u0012\u001cFO]5oO2KG/\u001a:bYN<\u0003%[:!K:\f'\r\\3eY\u0001JG\u000f\t4bY2\u0014\u0017mY6t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"x\u000eI*qCJ\\\u0007%\r\u00187A\t,\u0007.\u0019<j_J\u0004#/Z4be\u0012Lgn\u001a\u0011tiJLgn\u001a\u0011mSR,'/\u00197!a\u0006\u00148/\u001b8h]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-A%4\u0007\u0005\u001e5fA\r|gNZ5hA%\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005I3oC\ndW\r\u001a\u0017!i\",\u0007\u0005]1ui\u0016\u0014h\u000e\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012!g\"|W\u000f\u001c3!E\u0016\u0004#\u0005X1cG\nr#B\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011(KMK8\u000f^3n\tJLg/Z\u0013]+N,'o\u001d/K_\"tw\u0005I0G+:\u001bu\fI\u0014]KMK8\u000f^3n\tJLg/\u001a/&9r+6/\u001a:tK\u001dR\u0001\u0005\t\u0011!A\u0001\"(/^3\u000b\u0015\u0001\u0002\u0003\u0005I*fK\u0002\nGn]8;\u0015\u0001\u0002\u0003\u0005\t\u0011!+N,\u0007E\u0015'J\u0017\u0016\u0003Co\u001c\u0011nCR\u001c\u0007\u000eI<ji\"\u00043\u000f^1oI\u0006\u0014H\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:\u001chFC\u0004\n\u0003\u001f\u0012\u0011\u0011!E\u0001\u0003#\nA\u0001T5lKB\u0019\u0011#a\u0015\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003+\u001aR!a\u0015\u0002Xi\u0001r!!\u0017\u0002`\u0001\u0002C&\u0004\u0002\u0002\\)\u0019\u0011Q\f\f\u0002\u000fI,h\u000e^5nK&!\u0011\u0011MA.\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bU\u0005MC\u0011AA3)\t\t\t\u0006C\u0005P\u0003'\n\t\u0011\"\u0012\u0002jQ\t\u0001\u0010\u0003\u0006\u0002n\u0005M\u0013\u0011!CA\u0003_\nQ!\u00199qYf$R\u0001LA9\u0003gBaAHA6\u0001\u0004\u0001\u0003B\u0002\u0014\u0002l\u0001\u0007\u0001\u0005\u0003\u0006\u0002x\u0005M\u0013\u0011!CA\u0003s\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002|\u0005\u001d\u0005#B\u000b\u0002~\u0005\u0005\u0015bAA@-\t1q\n\u001d;j_:\u0004R!FABA\u0001J1!!\"\u0017\u0005\u0019!V\u000f\u001d7fe!I\u0011\u0011RA;\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\u0002\u0004BCAG\u0003'\n\t\u0011\"\u0003\u0002\u0010\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\nE\u0002z\u0003'K1!!&{\u0005\u0019y%M[3di\u0002")
public class Like
extends StringRegexExpression
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Function1<Tuple2<Expression, Expression>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Like>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v);
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left(), this.right()}));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$")).append((Object)".escapeLikeRegex").toString();
        String pattern = ctx.freshName("pattern");
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal == null) {
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType())})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                ctx.addMutableState(patternClass, pattern, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".compile(\"", "\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern, patternClass, regexStr})));
                ExprCode eval2 = this.left().genCode(ctx);
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), eval2.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType()), ev.isNull(), ev.value(), pattern, eval2.value()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, patternClass, escapeFunc, pattern, rightStr){
                public static final long serialVersionUID = 0L;
                private final ExprCode ev$1;
                private final String patternClass$1;
                private final String escapeFunc$1;
                private final String pattern$1;
                private final String rightStr$1;

                public final String apply(String eval1, String eval2) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          String ", " = ", ".toString();\n          ", " ", " = ", ".compile(", "(", "));\n          ", " = ", ".matcher(", ".toString()).matches();\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rightStr$1, eval2, this.patternClass$1, this.pattern$1, this.patternClass$1, this.escapeFunc$1, this.rightStr$1, this.ev$1.value(), this.pattern$1, eval1}));
                }
                {
                    this.ev$1 = ev$1;
                    this.patternClass$1 = patternClass$1;
                    this.escapeFunc$1 = escapeFunc$1;
                    this.pattern$1 = pattern$1;
                    this.rightStr$1 = rightStr$1;
                }
            });
        }
        return exprCode;
    }

    public Like copy(Expression left, Expression right) {
        return new Like(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

