/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.HiveHasher;
import org.apache.spark.sql.catalyst.expressions.InterpretedHashFunction;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HiveHashFunction$
extends InterpretedHashFunction {
    public static final HiveHashFunction$ MODULE$;
    private final int HIVE_DECIMAL_MAX_PRECISION;
    private final int HIVE_DECIMAL_MAX_SCALE;

    static {
        new HiveHashFunction$();
    }

    @Override
    public long hashInt(int i, long seed) {
        return HiveHasher.hashInt((int)i);
    }

    @Override
    public long hashLong(long l, long seed) {
        return HiveHasher.hashLong((long)l);
    }

    @Override
    public long hashUnsafeBytes(Object base, long offset, int len, long seed) {
        return HiveHasher.hashUnsafeBytes((Object)base, (long)offset, (int)len);
    }

    private int HIVE_DECIMAL_MAX_PRECISION() {
        return this.HIVE_DECIMAL_MAX_PRECISION;
    }

    private int HIVE_DECIMAL_MAX_SCALE() {
        return this.HIVE_DECIMAL_MAX_SCALE;
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal normalizeDecimal(BigDecimal input) {
        void var2_2;
        if (input == null) {
            return null;
        }
        BigDecimal result = this.trimDecimal$1(input);
        int intDigits = result.precision() - result.scale();
        if (intDigits > this.HIVE_DECIMAL_MAX_PRECISION()) {
            return null;
        }
        int maxScale = Math.min(this.HIVE_DECIMAL_MAX_SCALE(), Math.min(this.HIVE_DECIMAL_MAX_PRECISION() - intDigits, result.scale()));
        if (result.scale() > maxScale) {
            result = result.setScale(maxScale, RoundingMode.HALF_UP);
            result = this.trimDecimal$1(result);
        }
        return var2_2;
    }

    public long hashTimestamp(long timestamp) {
        long timestampInSeconds = timestamp / 1000000L;
        long nanoSecondsPortion = timestamp % 1000000L * 1000L;
        long result = timestampInSeconds;
        result <<= 30;
        return (int)((result |= nanoSecondsPortion) >>> 32 ^ result);
    }

    public long hashCalendarInterval(CalendarInterval calendarInterval) {
        long totalSeconds = calendarInterval.microseconds / (long)((int)1000000L);
        int result = 629 + (int)(totalSeconds ^ totalSeconds >> 32);
        int nanoSeconds = (int)(calendarInterval.microseconds - totalSeconds * (long)((int)1000000L)) * 1000;
        return result * 37 + nanoSeconds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long hash(Object value2, DataType dataType2, long seed) {
        Object object = value2;
        if (object == null) {
            return 0L;
        }
        if (object instanceof ArrayData) {
            DataType dataType3;
            ArrayData arrayData = (ArrayData)object;
            DataType dataType4 = dataType2;
            if (dataType4 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType4;
                dataType3 = ((ArrayType)userDefinedType.sqlType()).elementType();
            } else {
                DataType et;
                if (!(dataType4 instanceof ArrayType)) throw new MatchError((Object)dataType4);
                ArrayType arrayType2 = (ArrayType)dataType4;
                dataType3 = et = arrayType2.elementType();
            }
            DataType elementType = dataType3;
            int result = 0;
            int i = 0;
            int length = arrayData.numElements();
            while (i < length) {
                result = 31 * result + (int)this.hash(arrayData.get(i, elementType), elementType, 0L);
                ++i;
            }
            return result;
        }
        if (object instanceof MapData) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            MapData mapData = (MapData)object;
            DataType dataType5 = dataType2;
            if (dataType5 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType5;
                MapType mapType2 = (MapType)userDefinedType.sqlType();
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)mapType2.keyType()), (Object)mapType2.valueType());
            } else {
                if (!(dataType5 instanceof MapType)) throw new MatchError((Object)dataType5);
                MapType mapType3 = (MapType)dataType5;
                DataType _kt = mapType3.keyType();
                DataType _vt = mapType3.valueType();
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)_kt), (Object)_vt);
            }
            Tuple2 tuple23 = tuple22;
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            DataType kt = (DataType)tuple23._1();
            DataType vt = (DataType)tuple23._2();
            Tuple2 tuple24 = tuple2 = new Tuple2((Object)kt, (Object)vt);
            DataType kt2 = (DataType)tuple24._1();
            DataType vt2 = (DataType)tuple24._2();
            ArrayData keys2 = mapData.keyArray();
            ArrayData values2 = mapData.valueArray();
            int result = 0;
            int i = 0;
            int length = mapData.numElements();
            while (i < length) {
                result += (int)this.hash(keys2.get(i, kt2), kt2, 0L) ^ (int)this.hash(values2.get(i, vt2), vt2, 0L);
                ++i;
            }
            return result;
        }
        if (object instanceof InternalRow) {
            DataType[] dataTypeArray;
            InternalRow internalRow = (InternalRow)object;
            DataType dataType6 = dataType2;
            if (dataType6 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType6;
                dataTypeArray = (DataType[])((TraversableOnce)((StructType)userDefinedType.sqlType()).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(StructField x$6) {
                        return x$6.dataType();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
            } else {
                if (!(dataType6 instanceof StructType)) throw new MatchError((Object)dataType6);
                StructType structType2 = (StructType)dataType6;
                StructField[] fields = structType2.fields();
                dataTypeArray = (DataType[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(StructField x$7) {
                        return x$7.dataType();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
            }
            DataType[] types = dataTypeArray;
            int result = 0;
            int i = 0;
            int length = internalRow.numFields();
            while (i < length) {
                result = 31 * result + (int)this.hash(internalRow.get(i, types[i]), types[i], 0L);
                ++i;
            }
            return result;
        }
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            return this.normalizeDecimal(decimal.toJavaBigDecimal()).hashCode();
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            if (dataType2 instanceof TimestampType) {
                return this.hashTimestamp(l);
            }
        }
        if (!(object instanceof CalendarInterval)) return super.hash(value2, dataType2, 0L);
        CalendarInterval calendarInterval = (CalendarInterval)object;
        return this.hashCalendarInterval(calendarInterval);
    }

    /*
     * WARNING - void declaration
     */
    private final BigDecimal trimDecimal$1(BigDecimal input) {
        void var2_2;
        BigDecimal result = input;
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            result = BigDecimal.ZERO;
        } else if ((result = result.stripTrailingZeros()).scale() < 0) {
            result = result.setScale(0);
        }
        return var2_2;
    }

    private HiveHashFunction$() {
        MODULE$ = this;
        this.HIVE_DECIMAL_MAX_PRECISION = 38;
        this.HIVE_DECIMAL_MAX_SCALE = 38;
    }
}

