/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonExprUtils$;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", extended="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1, \"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"2015-08-26 00:00:00.0\"}\n  ")
@ScalaSignature(bytes="\u0006\u0001\tmd\u0001B\u0001\u0003\u0001>\u0011QBS:p]R{7\u000b\u001e:vGR\u001c(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0001BcF\u000f!MA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005aYR\"A\r\u000b\u0005i\u0011\u0011aB2pI\u0016<WM\\\u0005\u00039e\u0011qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003#yI!a\b\u0002\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005:\u0013B\u0001\u0015#\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Q\u0003A!f\u0001\n\u0003Y\u0013AB:dQ\u0016l\u0017-F\u0001-!\ti\u0003'D\u0001/\u0015\tyc!A\u0003usB,7/\u0003\u00022]\tAA)\u0019;b)f\u0004X\r\u0003\u00054\u0001\tE\t\u0015!\u0003-\u0003\u001d\u00198\r[3nC\u0002B\u0001\"\u000e\u0001\u0003\u0016\u0004%\tAN\u0001\b_B$\u0018n\u001c8t+\u00059\u0004\u0003\u0002\u001d<}yr!!I\u001d\n\u0005i\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0002={\t\u0019Q*\u00199\u000b\u0005i\u0012\u0003C\u0001\u001d@\u0013\t\u0001UH\u0001\u0004TiJLgn\u001a\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005o\u0005Aq\u000e\u001d;j_:\u001c\b\u0005\u0003\u0005E\u0001\tU\r\u0011\"\u0001F\u0003\u0015\u0019\u0007.\u001b7e+\u00051\u0005CA\tH\u0013\tA%A\u0001\u0006FqB\u0014Xm]:j_:D\u0001B\u0013\u0001\u0003\u0012\u0003\u0006IAR\u0001\u0007G\"LG\u000e\u001a\u0011\t\u00111\u0003!Q3A\u0005\u00025\u000b!\u0002^5nKj{g.Z%e+\u0005q\u0005cA\u0011P}%\u0011\u0001K\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011I\u0003!\u0011#Q\u0001\n9\u000b1\u0002^5nKj{g.Z%eA!)A\u000b\u0001C\u0001+\u00061A(\u001b8jiz\"RAV,Y3j\u0003\"!\u0005\u0001\t\u000b)\u001a\u0006\u0019\u0001\u0017\t\u000bU\u001a\u0006\u0019A\u001c\t\u000b\u0011\u001b\u0006\u0019\u0001$\t\u000f1\u001b\u0006\u0013!a\u0001\u001d\")A\f\u0001C!;\u0006Aa.\u001e7mC\ndW-F\u0001_!\t\ts,\u0003\u0002aE\t9!i\\8mK\u0006t\u0007\"\u0002+\u0001\t\u0003\u0011G\u0003\u0002,dI\u0016DQAK1A\u00021BQ!N1A\u0002]BQ\u0001R1A\u0002\u0019CQ\u0001\u0016\u0001\u0005\u0002\u001d$2A\u00165j\u0011\u0015!e\r1\u0001G\u0011\u0015Qc\r1\u0001G\u0011\u0015!\u0006\u0001\"\u0001l)\u00111F.\u001c8\t\u000b\u0011S\u0007\u0019\u0001$\t\u000b)R\u0007\u0019\u0001$\t\u000bUR\u0007\u0019\u0001$\t\u000bA\u0004A\u0011I9\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003I\u0004\"a\u001d<\u000e\u0003QT!!\u001e\u0003\u0002\u0011\u0005t\u0017\r\\=tSNL!a\u001e;\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRD\u0001\"\u001f\u0001\t\u0006\u0004%\tA_\u0001\ne><8k\u00195f[\u0006,\u0012a\u001f\t\u0003[qL!! \u0018\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005\u0000\u0001!\u0005\t\u0015)\u0003|\u0003)\u0011xn^*dQ\u0016l\u0017\r\t\u0015\u0004}\u0006\r\u0001cA\u0011\u0002\u0006%\u0019\u0011q\u0001\u0012\u0003\u0013Q\u0014\u0018M\\:jK:$\bBCA\u0006\u0001!\u0015\r\u0011\"\u0001\u0002\u000e\u0005I1m\u001c8wKJ$XM]\u000b\u0003\u0003\u001f\u0001r!IA\t\u0003+\t)$C\u0002\u0002\u0014\t\u0012\u0011BR;oGRLwN\\\u0019\u0011\r\u0005]\u0011qEA\u0017\u001d\u0011\tI\"a\t\u000f\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b\u000f\u0003\u0019a$o\\8u}%\t1%C\u0002\u0002&\t\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002*\u0005-\"aA*fc*\u0019\u0011Q\u0005\u0012\u0011\t\u0005=\u0012\u0011G\u0007\u0002\t%\u0019\u00111\u0007\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\n\u0006\u0003o1\u00131\b\u0004\u0007\u0003s\u0001\u0001!!\u000e\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007E\ti$C\u0002\u0002@\t\u0011!c\u00159fG&\fG.\u001b>fI\u001e+G\u000f^3sg\"Q\u00111\t\u0001\t\u0002\u0003\u0006K!a\u0004\u0002\u0015\r|gN^3si\u0016\u0014\b\u0005\u000b\u0003\u0002B\u0005\r\u0001BCA%\u0001!\u0015\r\u0011\"\u0001\u0002L\u00051\u0001/\u0019:tKJ,\"!!\u0014\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u0005\u0003\u0011Q7o\u001c8\n\t\u0005]\u0013\u0011\u000b\u0002\u000e\u0015\u0006\u001c7n]8o!\u0006\u00148/\u001a:\t\u0015\u0005m\u0003\u0001#A!B\u0013\ti%A\u0004qCJ\u001cXM\u001d\u0011)\t\u0005e\u00131\u0001\u0005\u0007\u0003C\u0002A\u0011I\u0016\u0002\u0011\u0011\fG/\u0019+za\u0016Dq!!\u001a\u0001\t\u0003\n9'\u0001\u0007xSRDG+[7f5>tW\rF\u0002\u0015\u0003SBa\u0001TA2\u0001\u0004q\u0004bBA7\u0001\u0011\u0005\u0013qN\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u0003c\n9\bE\u0002\"\u0003gJ1!!\u001e#\u0005\r\te.\u001f\u0005\t\u0003'\nY\u00071\u0001\u0002r!9\u00111\u0010\u0001\u0005B\u0005u\u0014AC5oaV$H+\u001f9fgV\u0011\u0011q\u0010\t\u0007\u0003/\t9#!!\u0011\u00075\n\u0019)C\u0002\u0002\u0006:\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u0013\u0005%\u0005!!A\u0005\u0002\u0005-\u0015\u0001B2paf$\u0012BVAG\u0003\u001f\u000b\t*a%\t\u0011)\n9\t%AA\u00021B\u0001\"NAD!\u0003\u0005\ra\u000e\u0005\t\t\u0006\u001d\u0005\u0013!a\u0001\r\"AA*a\"\u0011\u0002\u0003\u0007a\nC\u0005\u0002\u0018\u0002\t\n\u0011\"\u0001\u0002\u001a\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAANU\ra\u0013QT\u0016\u0003\u0003?\u0003B!!)\u0002,6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0016\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0006\r&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0017\u0001\u0012\u0002\u0013\u0005\u00111W\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)LK\u00028\u0003;C\u0011\"!/\u0001#\u0003%\t!a/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0018\u0016\u0004\r\u0006u\u0005\"CAa\u0001E\u0005I\u0011AAb\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!2+\u00079\u000bi\nC\u0005\u0002J\u0002\t\t\u0011\"\u0011\u0002L\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!4\u0011\t\u0005=\u0017\u0011\\\u0007\u0003\u0003#TA!a5\u0002V\u0006!A.\u00198h\u0015\t\t9.\u0001\u0003kCZ\f\u0017b\u0001!\u0002R\"I\u0011Q\u001c\u0001\u0002\u0002\u0013\u0005\u0011q\\\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003C\u00042!IAr\u0013\r\t)O\t\u0002\u0004\u0013:$\b\"CAu\u0001\u0005\u0005I\u0011AAv\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u001d\u0002n\"Q\u0011q^At\u0003\u0003\u0005\r!!9\u0002\u0007a$\u0013\u0007C\u0005\u0002t\u0002\t\t\u0011\"\u0011\u0002v\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002xB1\u0011\u0011`A\u0000\u0003cj!!a?\u000b\u0007\u0005u(%\u0001\u0006d_2dWm\u0019;j_:LAA!\u0001\u0002|\nA\u0011\n^3sCR|'\u000fC\u0005\u0003\u0006\u0001\t\t\u0011\"\u0001\u0003\b\u0005A1-\u00198FcV\fG\u000eF\u0002_\u0005\u0013A!\"a<\u0003\u0004\u0005\u0005\t\u0019AA9\u0011%\u0011i\u0001AA\u0001\n\u0003\u0012y!\u0001\u0004fcV\fGn\u001d\u000b\u0004=\nE\u0001BCAx\u0005\u0017\t\t\u00111\u0001\u0002r!Z\u0001A!\u0006\u0003\u001c\tu!\u0011\u0005B\u0012!\r\t\"qC\u0005\u0004\u00053\u0011!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005?\t!m\u0018$V\u001d\u000e{\u0006F[:p]N#(\u000f\f\u0011tG\",W.Y.-A=\u0004H/[8ogvK\u0003%\f\u0011SKR,(O\\:!C\u0002\u001aHO];di\u00022\u0018\r\\;fA]LG\u000f\u001b\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002'n]8o'R\u0014\b\rI1oI\u0002\u00027o\u00195f[\u0006\u0004g&\u0001\u0005fqR,g\u000eZ3eC\t\u0011)#AAx\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3PI1#uEb\u0003E\t2#uAr\u0003(`\u0014-A\u001d\n\u0007%\u0013(UY\u0001\u0012\u0007\u0005R(V\u00052+u%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'EO\u0019-A\t\u0012'E\u000f\u0019/quT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#i&lWM\t\u001e#eYz\u0003\u0007O\u00183aE*$%`\u0014-A\u001d\"\u0018.\\3!)&lWm\u001d;b[B<C\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(\u0005^5nK\nR$E\r\u00192k5\u0002\u0004(\f\u001a7AA\u0002$\b\r\u0019;aAr\u0003GI?\u000bA\u0001:\u0011B!\u000b\u0003\u0003\u0003E\tAa\u000b\u0002\u001b)\u001bxN\u001c+p'R\u0014Xo\u0019;t!\r\t\"Q\u0006\u0004\t\u0003\t\t\t\u0011#\u0001\u00030M)!Q\u0006B\u0019MAI!1\u0007B\u001dY]2eJV\u0007\u0003\u0005kQ1Aa\u000e#\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u000f\u00036\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\t\u000fQ\u0013i\u0003\"\u0001\u0003@Q\u0011!1\u0006\u0005\u000b\u0005\u0007\u0012i#!A\u0005F\t\u0015\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0007B\u0003B%\u0005[\t\t\u0011\"!\u0003L\u0005)\u0011\r\u001d9msRIaK!\u0014\u0003P\tE#1\u000b\u0005\u0007U\t\u001d\u0003\u0019\u0001\u0017\t\rU\u00129\u00051\u00018\u0011\u0019!%q\ta\u0001\r\"AAJa\u0012\u0011\u0002\u0003\u0007a\n\u0003\u0006\u0003X\t5\u0012\u0011!CA\u00053\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\\\t\r\u0004\u0003B\u0011P\u0005;\u0002r!\tB0Y]2e*C\u0002\u0003b\t\u0012a\u0001V;qY\u0016$\u0004\"\u0003B3\u0005+\n\t\u00111\u0001W\u0003\rAH\u0005\r\u0005\u000b\u0005S\u0012i#%A\u0005\u0002\u0005\r\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0003n\t5\u0012\u0013!C\u0001\u0003\u0007\fq\"\u00199qYf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0005c\u0012i#!A\u0005\n\tM\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u001e\u0011\t\u0005='qO\u0005\u0005\u0005s\n\tN\u0001\u0004PE*,7\r\u001e")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private transient StructType rowSchema;
    private transient Function1<Seq<InternalRow>, Serializable> converter;
    private transient JacksonParser parser;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    private StructType rowSchema$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                StructType structType2;
                DataType dataType2 = this.schema();
                if (dataType2 instanceof StructType) {
                    StructType structType3;
                    structType2 = structType3 = (StructType)dataType2;
                } else {
                    StructType structType4;
                    ArrayType arrayType2;
                    DataType st;
                    if (!(dataType2 instanceof ArrayType) || !((st = (arrayType2 = (ArrayType)dataType2).elementType()) instanceof StructType)) {
                        throw new MatchError((Object)dataType2);
                    }
                    structType2 = structType4 = (StructType)st;
                }
                this.rowSchema = structType2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.rowSchema;
        }
    }

    private Function1 converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Object object;
                DataType dataType2 = this.schema();
                if (dataType2 instanceof StructType) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final InternalRow apply(Seq<InternalRow> rows) {
                            return rows.length() == 1 ? (InternalRow)rows.head() : null;
                        }
                    };
                } else {
                    ArrayType arrayType2;
                    if (!(dataType2 instanceof ArrayType) || !((arrayType2 = (ArrayType)dataType2).elementType() instanceof StructType)) {
                        throw new MatchError((Object)dataType2);
                    }
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final GenericArrayData apply(Seq<InternalRow> rows) {
                            return new GenericArrayData(rows);
                        }
                    };
                }
                this.converter = object;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.converter;
        }
    }

    private JacksonParser parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.parser = new JacksonParser(this.rowSchema(), new JSONOptions((Map<String, String>)this.options().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"mode"), (Object)FailFastMode$.MODULE$.name())), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.parser;
        }
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType2;
        DataType dataType2 = this.schema();
        boolean bl = dataType2 instanceof StructType ? true : dataType2 instanceof ArrayType && (arrayType2 = (ArrayType)dataType2).elementType() instanceof StructType;
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes$class.checkInputDataTypes(this) : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input schema ", " must be a struct or an array of structs."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema().simpleString()})));
        return typeCheckResult;
    }

    public StructType rowSchema() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.rowSchema$lzycompute() : this.rowSchema;
    }

    public Function1<Seq<InternalRow>, Serializable> converter() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public JacksonParser parser() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.schema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$11 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$12 = this.copy$default$1();
        Map<String, String> x$13 = this.copy$default$2();
        Expression x$14 = this.copy$default$3();
        return this.copy(x$12, x$13, x$14, (Option<String>)x$11);
    }

    @Override
    public Object nullSafeEval(Object json) {
        Object object;
        if (json.toString().trim().isEmpty()) {
            return null;
        }
        try {
            object = this.converter().apply(this.parser().parse((UTF8String)json, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonParser apply(JsonFactory jsonFactory, UTF8String record) {
                    return CreateJacksonParser$.MODULE$.utf8String(jsonFactory, record);
                }
            }, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final UTF8String apply(UTF8String x) {
                    return (UTF8String)Predef$.MODULE$.identity((Object)x);
                }
            }));
        }
        catch (BadRecordException badRecordException) {
            object = null;
        }
        return object;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 0: {
                object = this.schema();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType2 = this.schema();
        DataType dataType3 = jsonToStructs.schema();
        if (dataType2 == null) {
            if (dataType3 != null) {
                return false;
            }
        } else if (!dataType2.equals(dataType3)) return false;
        Map<String, String> map2 = this.options();
        Map<String, String> map3 = jsonToStructs.options();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
        CodegenFallback$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child) {
        this(schema, options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(JsonExprUtils$.MODULE$.validateSchemaLiteral(schema), (Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(JsonExprUtils$.MODULE$.validateSchemaLiteral(schema), JsonExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

